/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.design;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.design.GameCanvas;
import edu.cornell.gdiac.design.GameController;
import edu.cornell.gdiac.design.LoadingMode;
import edu.cornell.gdiac.util.ScreenListener;

public class GDXRoot
extends Game
implements ScreenListener {
    AssetDirectory directory;
    private GameCanvas canvas;
    private LoadingMode loading;
    private GameController controller;

    @Override
    public void create() {
        this.canvas = new GameCanvas();
        this.loading = new LoadingMode("jsons/assets.json", this.canvas, 1);
        this.controller = new GameController();
        this.loading.setScreenListener(this);
        this.setScreen(this.loading);
    }

    @Override
    public void dispose() {
        this.setScreen(null);
        this.controller.dispose();
        this.canvas.dispose();
        this.canvas = null;
        if (this.directory != null) {
            this.directory.unloadAssets();
            this.directory.dispose();
            this.directory = null;
        }
        super.dispose();
    }

    @Override
    public void resize(int width, int height) {
        this.canvas.resize();
        super.resize(width, height);
    }

    @Override
    public void exitScreen(Screen screen, int exitCode) {
        if (screen == this.loading) {
            this.directory = this.loading.getAssets();
            this.controller.gatherAssets(this.directory);
            this.controller.setScreenListener(this);
            this.controller.setCanvas(this.canvas);
            this.controller.reset();
            this.setScreen(this.controller);
            this.loading.dispose();
            this.loading = null;
        } else if (exitCode == 0) {
            Gdx.app.exit();
        }
    }
}

