/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.math.Path2;
import edu.cornell.gdiac.math.PathExtruder;
import edu.cornell.gdiac.math.Poly2;
import edu.cornell.gdiac.math.PolyFactory;
import edu.cornell.gdiac.scene2.Button;
import edu.cornell.gdiac.scene2.PathNode;
import edu.cornell.gdiac.scene2.PolygonNode;
import edu.cornell.gdiac.scene2.SceneNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Slider
extends SceneNode {
    private static final float DEFAULT_MIN = 0.0f;
    private static final float DEFAULT_MAX = 100.0f;
    private static final float DEFAULT_RADIUS = 20.0f;
    private static final float LINE_WEIGHT = 2.0f;
    private static final int KNOB_SEGS = 32;
    private float value;
    private Vector2 range;
    private Button knob;
    private SceneNode path;
    private Rectangle bounds;
    private String knobChild;
    private String pathChild;
    private float tick;
    private boolean snap;
    private boolean active;
    private boolean mouse;
    private Vector2 dragpos = new Vector2();
    private int inputKey;
    private int nextKey;
    private Map<Integer, Listener> listeners = new HashMap<Integer, Listener>();
    private final Vector2 vectorCache1 = new Vector2();
    private final Vector2 vectorCache2 = new Vector2();
    private final Vector2 vectorCache3 = new Vector2();
    private final Vector2 vectorCache4 = new Vector2();
    private final Vector2 vectorCache5 = new Vector2();

    private Slider() {
        this.range = new Vector2(0.0f, 100.0f);
        this.bounds = new Rectangle(0.0f, 20.0f, 100.0f, 0.0f);
        this.tick = 0.0f;
        this.value = 0.0f;
        this.snap = false;
        this.active = false;
        this.mouse = false;
        this.knob = null;
        this.path = null;
        this.inputKey = 0;
        this.nextKey = 1;
        this.knobChild = "";
        this.pathChild = "";
        this.classname = "Slider";
    }

    public Slider(Vector2 range, Rectangle bounds) {
        this();
        this.range = range;
        this.bounds = bounds;
        this.setPath(null);
        this.placeKnob(null);
        this.value = (range.y + range.x) / 2.0f;
        this.reconfigure();
    }

    public Slider(Vector2 range, Rectangle bounds, SceneNode path, Button knob) {
        this.range = range;
        this.bounds = bounds;
        this.setPath(path);
        this.placeKnob(knob);
        this.value = (range.y + range.x) / 2.0f;
        this.reconfigure();
    }

    public Slider(AssetDirectory manager, JsonValue data) {
        super(manager, data);
        float[] bound;
        this.range = new Vector2(0.0f, 100.0f);
        this.bounds = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
        this.tick = 0.0f;
        this.value = 0.0f;
        this.snap = false;
        this.active = false;
        this.mouse = false;
        this.knob = null;
        this.path = null;
        this.inputKey = 0;
        this.nextKey = 1;
        this.knobChild = "";
        this.pathChild = "";
        this.classname = "Slider";
        if (data.has("bounds")) {
            bound = data.get("bounds").asFloatArray();
            if (bound.length != 4) {
                throw new IllegalArgumentException("Attribute 'bounds' must be a four-element array");
            }
        } else {
            throw new IllegalArgumentException("JSON is missing a required 'bounds' rectangle");
        }
        this.bounds = new Rectangle(bound[0], bound[1], bound[2], bound[3]);
        if (data.has("path")) {
            this.pathChild = data.get("path").asString();
        }
        if (data.has("knob")) {
            this.knobChild = data.get("knob").asString();
        }
        if (data.has("range")) {
            float[] rangeArray = data.get("range").asFloatArray();
            if (rangeArray.length != 2) {
                throw new IllegalArgumentException("Attribute 'range' must be a two-element array");
            }
            this.range = new Vector2(rangeArray[0], rangeArray[1]);
        }
        this.value = data.getFloat("value", (this.range.y + this.range.x) / 2.0f);
        this.tick = data.getFloat("tick", 0.0f);
        this.snap = data.getBoolean("snap", false);
    }

    public float getMinValue() {
        return this.range.x;
    }

    public void setMinValue(float value) {
        this.range.x = value;
        this.reposition();
    }

    public float getMaxValue() {
        return this.range.y;
    }

    public void setMaxValue(float value) {
        this.range.y = value;
        this.reposition();
    }

    public Vector2 getRange() {
        return this.range;
    }

    public void setRange(Vector2 range) {
        this.range = range;
        this.reposition();
    }

    public void setRange(float min, float max) {
        this.range.set(min, max);
        this.reposition();
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = this.validate(value);
        this.reposition();
    }

    public Button getKnob() {
        return this.knob;
    }

    public void setKnob(Button knob) {
        this.placeKnob(knob);
        this.reconfigure();
    }

    public SceneNode getPath() {
        return this.path;
    }

    public void setPath(SceneNode path) {
        if (this.knob != null) {
            this.removeChild(this.knob);
        }
        if (this.path != null) {
            this.removeChild(this.path);
        }
        if (path == null) {
            Vector2 psize = new Vector2((this.bounds.width > 0.0f ? this.bounds.width : -this.bounds.width) + this.bounds.x, (this.bounds.height > 0.0f ? this.bounds.height : -this.bounds.height) + this.bounds.y);
            float radius = Math.max(this.bounds.x, this.bounds.y);
            this.path = new SceneNode();
            this.path.set(psize.x, psize.y);
            Path2 pathTrack = new Path2();
            pathTrack.push(this.bounds.x, this.bounds.y, true);
            pathTrack.push(this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height, true);
            PathNode track = new PathNode(pathTrack, 2.0f * radius, PathExtruder.Joint.SQUARE, PathExtruder.EndCap.ROUND);
            track.setColor(new Color(1.0f, 1.0f, 1.0f, 0.1254902f));
            track.setAnchor(new Vector2(0.0f, 0.0f));
            track.setPosition(this.bounds.x, this.bounds.y);
            this.path.addChild(track);
            PathNode line = new PathNode(pathTrack, 2.0f, PathExtruder.Joint.SQUARE, PathExtruder.EndCap.ROUND);
            line.setColor(Color.BLACK);
            line.setAnchor(new Vector2(0.0f, 0.0f));
            line.setPosition(this.bounds.x, this.bounds.y);
            this.path.addChild(line);
        } else {
            this.path = path;
        }
        this.addChild(this.path);
        if (this.knob != null) {
            this.addChild(this.knob);
        }
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle value) {
        this.bounds = value;
        this.reposition();
    }

    public float getTick() {
        return this.tick;
    }

    public void setTick(float value) {
        this.tick = value;
        this.reposition();
    }

    public boolean hasSnap() {
        return this.snap;
    }

    public void snapTick(boolean value) {
        this.snap = value;
        this.reposition();
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (this.active && this.knob.inContentBounds(this.vectorCache1.set((float)screenX, (float)screenY))) {
            this.dragpos.set(this.screenToNodeCoords(this.vectorCache1.set((float)screenX, (float)screenY), this.vectorCache2));
            this.knob.setDown(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (this.active && this.knob.isDown()) {
            this.knob.setDown(false);
            return true;
        }
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        if (this.active && this.knob.isDown()) {
            this.dragKnob(this.vectorCache1.set((float)screenX, (float)screenY));
            return true;
        }
        return false;
    }

    public boolean activate() {
        if (this.active) {
            return false;
        }
        this.active = true;
        return true;
    }

    public boolean deactivate() {
        if (!this.active) {
            return false;
        }
        this.active = false;
        this.mouse = false;
        return true;
    }

    public boolean isActive() {
        return this.active;
    }

    public Listener getListener(int key) {
        return this.listeners.get(key);
    }

    public List<Listener> getListeners() {
        return new ArrayList<Listener>(this.listeners.values());
    }

    public int addListener(Listener listener) {
        if (this.nextKey == Integer.MAX_VALUE) {
            throw new IllegalStateException("No more available listener slots");
        }
        int key = this.nextKey++;
        this.listeners.put(key, listener);
        return key;
    }

    public boolean removeListener(int key) {
        return this.listeners.remove(key) != null;
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    protected float validate(float value) {
        float result = value;
        if (this.snap && this.tick > 0.0f) {
            float actual = (result - this.range.x) / this.tick;
            actual = Math.round(actual);
            result = actual * this.tick + this.range.x;
        }
        return Math.max(Math.min(result, this.range.y), this.range.x);
    }

    protected void reconfigure() {
        Vector2 knobSize = this.knob.getSize();
        this.vectorCache3.set(0.0f, 0.0f);
        this.vectorCache4.set(0.0f, 0.0f);
        if (knobSize.x / 2.0f > this.bounds.x) {
            this.vectorCache3.x = knobSize.y / 2.0f - this.bounds.x;
        }
        if (knobSize.y / 2.0f > this.bounds.y) {
            this.vectorCache3.y = knobSize.y / 2.0f - this.bounds.y;
        }
        if (knobSize.x / 2.0f > this.contentSize.x - this.bounds.width - this.bounds.x) {
            this.vectorCache4.x = knobSize.x / 2.0f - this.contentSize.x + this.bounds.width + this.bounds.x;
        }
        if (knobSize.y / 2.0f > this.contentSize.y - this.bounds.height - this.bounds.y) {
            this.vectorCache4.y = knobSize.y / 2.0f - this.contentSize.y + this.bounds.height + this.bounds.y;
        }
        Vector2 newSize = this.vectorCache2.set(this.contentSize).add(this.vectorCache3).add(this.vectorCache4);
        this.setContentSize(newSize);
        this.bounds.x += this.vectorCache3.x;
        this.bounds.y += this.vectorCache3.y;
        this.path.setPosition(this.vectorCache5.set(this.path.getPosition()).add(this.vectorCache3));
        this.reposition();
    }

    private void reposition() {
        Vector2 pos = this.vectorCache2.set(this.bounds.x, this.bounds.y).add(this.vectorCache1.set(this.bounds.width, this.bounds.height).scl((this.value - this.range.x) / (this.range.y - this.range.x)));
        this.knob.setAnchor(0.5f, 0.5f);
        this.knob.setPosition(pos);
        for (Listener listener : this.listeners.values()) {
            listener.onValueChanged(this.getName(), this.value);
        }
    }

    public void dragKnob(Vector2 pos) {
        float param;
        Vector2 offset = this.screenToNodeCoords(pos, this.vectorCache2);
        Vector2 line = this.vectorCache3.set(this.bounds.width, this.bounds.height);
        Vector2 drag = offset.sub(this.dragpos);
        Vector2 projection = this.vectorCache4.set(line).scl(drag.dot(line) / line.dot(line));
        float f = param = line.x != 0.0f ? projection.x / line.x : projection.y / line.y;
        if (param == 0.0f) {
            return;
        }
        float result = this.validate(this.value + param * (this.range.y - this.range.x));
        double remain = (result - this.value) / (this.range.y - this.range.x);
        drag.scl((float)(remain / (double)param));
        this.dragpos.add(drag);
        this.value = result;
        this.reposition();
    }

    private void placeKnob(Button knob) {
        if (this.knob != null) {
            this.removeChild(this.knob);
        }
        if (knob == null) {
            float radius = Math.max(this.bounds.x, this.bounds.y);
            PolyFactory factory = new PolyFactory();
            Poly2 poly = factory.makeEllipse(new Vector2(radius, radius), new Vector2(2.0f * radius, 2.0f * radius));
            PolygonNode circ = new PolygonNode(poly);
            circ.setColor(Color.GRAY);
            circ.setContentSize(new Vector2(2.0f * radius, 2.0f * radius));
            this.knob = new Button(circ);
        } else {
            this.knob = knob;
        }
        this.addChild(this.knob);
    }

    @Override
    public void doLayout() {
        if (this.knob == null) {
            SceneNode node;
            if (!this.knobChild.isEmpty() && (node = this.getChildByName(this.knobChild)) != null) {
                if (node instanceof Button) {
                    this.knob = (Button)node;
                } else {
                    this.removeChild(node);
                    this.knob = new Button(node);
                    this.addChild(this.knob);
                }
            }
            if (!this.pathChild.isEmpty()) {
                this.path = this.getChildByName(this.pathChild);
            } else {
                this.setPath(null);
            }
            if (this.knob == null) {
                this.placeKnob(null);
            }
            this.reconfigure();
        }
        super.doLayout();
    }

    @FunctionalInterface
    public static interface Listener {
        public void onValueChanged(String var1, float var2);
    }
}

