/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics.obj;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectSet;
import edu.cornell.gdiac.graphics.GLDebug;
import edu.cornell.gdiac.graphics.VertexBuffer;
import edu.cornell.gdiac.graphics.obj.Material;
import edu.cornell.gdiac.graphics.obj.MaterialInfo;
import edu.cornell.gdiac.graphics.obj.MaterialLib;
import edu.cornell.gdiac.graphics.obj.ModelInfo;
import edu.cornell.gdiac.graphics.obj.ObjMesh;
import edu.cornell.gdiac.graphics.obj.ObjPipeline;
import edu.cornell.gdiac.graphics.shaders.ObjShader;

public class Model {
    GL20 gl;
    private String name;
    private Array<Surface> surfaces;

    public Model() {
        this.surfaces = new Array();
    }

    public Model(ModelInfo info) {
        this(info, 3);
    }

    public Model(ModelInfo info, int depth) {
        if (info == null) {
            throw new NullPointerException();
        }
        this.gl = Gdx.gl30;
        if (this.gl == null) {
            this.gl = Gdx.gl20;
        }
        this.name = info.name;
        ObjectMap materials = new ObjectMap();
        this.surfaces = new Array();
        for (ObjectMap.Entry ee : info.libraries.entries()) {
            if (ee.value == null) continue;
            for (ObjectMap.Entry ff : ((MaterialLib)ee.value).infos.entries()) {
                if (((MaterialLib)ee.value).materials.containsKey((Object)((String)ff.key))) {
                    materials.put((Object)((String)ff.key), (Object)((MaterialLib)ee.value).getMaterial((String)ff.key));
                    continue;
                }
                if (depth < 2) continue;
                Material m = new Material((MaterialInfo)ff.value, depth >= 3);
                materials.put((Object)((String)ff.key), (Object)m);
                ((MaterialLib)ee.value).setMaterial((String)ff.key, m);
            }
        }
        for (int ii = 0; ii < info.groups.size; ++ii) {
            ModelInfo.Group group = (ModelInfo.Group)info.groups.get(ii);
            Surface surface = new Surface(info, group, depth > 0);
            if (materials.containsKey((Object)group.material)) {
                surface.setMaterial((Material)materials.get((Object)group.material));
            }
            surface.setMaterialName(group.material);
            this.surfaces.add((Object)surface);
        }
    }

    public String getName() {
        return this.name;
    }

    public Array<Surface> getSurfaces() {
        return this.surfaces;
    }

    public Surface getSurface(int index) {
        return (Surface)this.surfaces.get(index);
    }

    public Model getSubModel(String tag) {
        Model result = new Model();
        result.name = tag;
        for (int ii = 0; ii < this.surfaces.size; ++ii) {
            Surface surf = (Surface)this.surfaces.get(ii);
            if (!surf.hasTag(tag)) continue;
            result.surfaces.add((Object)surf);
        }
        return result;
    }

    public void createBuffer() {
        for (int ii = 0; ii < this.surfaces.size; ++ii) {
            Surface surf = (Surface)this.surfaces.get(ii);
            surf.createBuffer();
        }
    }

    public class Surface {
        private int index;
        private String object;
        private ObjectSet<String> tags;
        private ObjMesh mesh;
        private VertexBuffer vertbuff;
        private Material material;
        private String matname;
        private ObjPipeline pipeline;

        private void computeTangents() {
            int ii;
            int start = 0;
            int step = 0;
            if (this.mesh.command == 4) {
                start = 0;
                step = 3;
            } else if (this.mesh.command == 5 || this.mesh.command == 6) {
                start = 2;
                step = 1;
            } else {
                return;
            }
            Vector3 p0 = new Vector3();
            Vector3 p1 = new Vector3();
            Vector3 p2 = new Vector3();
            Vector3 t0 = new Vector3();
            Vector3 t1 = new Vector3();
            Vector3 t2 = new Vector3();
            Vector2 x0 = new Vector2();
            Vector2 x1 = new Vector2();
            Vector2 x2 = new Vector2();
            for (ii = start; ii < this.mesh.indices.size; ii += step) {
                if (this.mesh.command == 4) {
                    this.mesh.getPosition(this.mesh.indices.items[ii], p0);
                    this.mesh.getPosition(this.mesh.indices.items[ii + 1], p1);
                    this.mesh.getPosition(this.mesh.indices.items[ii + 2], p2);
                    this.mesh.getTangent(this.mesh.indices.items[ii], t0);
                    this.mesh.getTangent(this.mesh.indices.items[ii + 1], t1);
                    this.mesh.getTangent(this.mesh.indices.items[ii + 2], t2);
                    this.mesh.getTexCoord(this.mesh.indices.items[ii], x0);
                    this.mesh.getTexCoord(this.mesh.indices.items[ii + 1], x1);
                    this.mesh.getTexCoord(this.mesh.indices.items[ii + 2], x2);
                } else if (this.mesh.command == 5) {
                    this.mesh.getPosition(this.mesh.indices.items[ii - 2], p0);
                    this.mesh.getPosition(this.mesh.indices.items[ii - 1], p1);
                    this.mesh.getPosition(this.mesh.indices.items[ii], p2);
                    this.mesh.getTangent(this.mesh.indices.items[ii - 2], t0);
                    this.mesh.getTangent(this.mesh.indices.items[ii - 1], t1);
                    this.mesh.getTangent(this.mesh.indices.items[ii], t2);
                    this.mesh.getTexCoord(this.mesh.indices.items[ii - 2], x0);
                    this.mesh.getTexCoord(this.mesh.indices.items[ii - 1], x1);
                    this.mesh.getTexCoord(this.mesh.indices.items[ii], x2);
                } else {
                    this.mesh.getPosition(this.mesh.indices.items[0], p0);
                    this.mesh.getPosition(this.mesh.indices.items[ii - 1], p1);
                    this.mesh.getPosition(this.mesh.indices.items[ii], p2);
                    this.mesh.getTangent(this.mesh.indices.items[0], t0);
                    this.mesh.getTangent(this.mesh.indices.items[ii - 1], t1);
                    this.mesh.getTangent(this.mesh.indices.items[ii], t2);
                    this.mesh.getTexCoord(this.mesh.indices.items[0], x0);
                    this.mesh.getTexCoord(this.mesh.indices.items[ii - 1], x1);
                    this.mesh.getTexCoord(this.mesh.indices.items[ii], x2);
                }
                p1.sub(p0);
                p2.sub(p0);
                float dt1 = x1.y - x0.y;
                float dt2 = x2.y - x1.y;
                p1.scl(dt2);
                p2.scl(dt1);
                p1.sub(p2);
                p1.nor();
                t0.add(p1);
                t1.add(p1);
                t2.add(p1);
                if (this.mesh.command == 4) {
                    this.mesh.setTangent(this.mesh.indices.items[ii], t0);
                    this.mesh.setTangent(this.mesh.indices.items[ii + 1], t1);
                    this.mesh.setTangent(this.mesh.indices.items[ii + 2], t2);
                    continue;
                }
                if (this.mesh.command == 5) {
                    this.mesh.setTangent(this.mesh.indices.items[ii - 2], t0);
                    this.mesh.setTangent(this.mesh.indices.items[ii - 1], t1);
                    this.mesh.setTangent(this.mesh.indices.items[ii], t2);
                    continue;
                }
                this.mesh.setTangent(this.mesh.indices.items[0], t0);
                this.mesh.setTangent(this.mesh.indices.items[ii - 1], t1);
                this.mesh.setTangent(this.mesh.indices.items[ii], t2);
            }
            for (ii = 0; ii < this.mesh.vertexCount(); ++ii) {
                this.mesh.getNormal(ii, p0);
                this.mesh.getTangent(ii, t0);
                p1.set(p0);
                p1.crs(t0);
                p1.crs(p0);
                p1.nor();
                this.mesh.setTangent(ii, p1);
            }
        }

        public Surface(ModelInfo root, ModelInfo.Group info) {
            this(root, info, false);
        }

        public Surface(ModelInfo root, ModelInfo.Group info, boolean buffer) {
            if (root == null || info == null) {
                throw new NullPointerException();
            }
            Vector3 position = new Vector3();
            Vector3 normal = new Vector3();
            Vector2 texcoord = new Vector2();
            this.mesh = new ObjMesh();
            for (int ii = 0; ii < info.vertices.size; ++ii) {
                ModelInfo.Vertex ref = (ModelInfo.Vertex)info.vertices.get(ii);
                position.x = root.positions.items[3 * ref.pindex];
                position.y = root.positions.items[3 * ref.pindex + 1];
                position.z = root.positions.items[3 * ref.pindex + 2];
                if (ref.tindex != -1) {
                    texcoord.x = root.texcoords.items[2 * ref.tindex];
                    texcoord.y = root.texcoords.items[2 * ref.tindex + 1];
                } else {
                    texcoord.set(0.0f, 0.0f);
                }
                if (ref.nindex != -1) {
                    normal.x = root.normals.items[3 * ref.nindex];
                    normal.y = root.normals.items[3 * ref.nindex + 1];
                    normal.z = root.normals.items[3 * ref.nindex + 2];
                }
                this.mesh.push(position, normal, texcoord);
            }
            this.mesh.indices.addAll(info.indices);
            this.mesh.command = info.command;
            this.tags = new ObjectSet();
            this.tags.addAll(info.tags);
            this.index = info.index;
            this.object = info.object;
            this.computeTangents();
            if (buffer && this.mesh.vertexCount() > 0) {
                this.createBuffer();
            }
        }

        public boolean createBuffer() {
            if (this.vertbuff != null) {
                return true;
            }
            this.vertbuff = new VertexBuffer(this.mesh.STRIDE * 4, this.mesh.vertexCount(), this.mesh.indices.size);
            GL20 cfr_ignored_0 = Model.this.gl;
            this.vertbuff.setupAttribute("a_position", 3, 5126, false, ObjShader.ATTRIBUTE_OFFSET[0]);
            GL20 cfr_ignored_1 = Model.this.gl;
            this.vertbuff.setupAttribute("a_normal", 3, 5126, false, ObjShader.ATTRIBUTE_OFFSET[1]);
            GL20 cfr_ignored_2 = Model.this.gl;
            this.vertbuff.setupAttribute("a_tangent", 3, 5126, false, ObjShader.ATTRIBUTE_OFFSET[2]);
            GL20 cfr_ignored_3 = Model.this.gl;
            this.vertbuff.setupAttribute("a_texCoord", 2, 5126, false, ObjShader.ATTRIBUTE_OFFSET[3]);
            this.vertbuff.bind();
            GL20 cfr_ignored_4 = Model.this.gl;
            this.vertbuff.loadVertexData(this.mesh.vertices.items, this.mesh.vertices.size, 35040);
            GL20 cfr_ignored_5 = Model.this.gl;
            this.vertbuff.loadIndexData(this.mesh.indices.items, this.mesh.indices.size, 35040);
            this.vertbuff.unbind();
            int error = Model.this.gl.glGetError();
            if (!$assertionsDisabled) {
                GL20 cfr_ignored_6 = Model.this.gl;
                if (error != 0) {
                    throw new AssertionError((Object)("VertexBuffer: " + GLDebug.errorName(error)));
                }
            }
            return true;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int value) {
            this.index = value;
        }

        public String getObject() {
            return this.object;
        }

        public void getObject(String value) {
            this.object = value;
        }

        public ObjectSet<String> getTags() {
            return this.tags;
        }

        public boolean hasTag(String tag) {
            return this.tags.contains((Object)tag);
        }

        public ObjMesh getMesh() {
            return this.mesh;
        }

        public VertexBuffer getBuffer() {
            return this.vertbuff;
        }

        public String getMaterialName() {
            return this.matname;
        }

        public void setMaterialName(String name) {
            this.matname = name;
        }

        public Material getMaterial() {
            return this.material;
        }

        public void setMaterial(Material material) {
            this.material = material;
        }
    }
}

