/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics.obj;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import edu.cornell.gdiac.graphics.Texture2D;
import edu.cornell.gdiac.graphics.obj.MaterialInfo;

public class Material {
    public static final int DIFFUSE_BIND = 0;
    public static final int AMBIENT_BIND = 1;
    public static final int SPECULAR_BIND = 2;
    public static final int NORMAL_BIND = 3;
    private String name;
    private int illum;
    private float shininess;
    private Color ambient;
    private Color diffuse;
    private Color specular;
    private Texture ambientMap;
    private Texture diffuseMap;
    private Texture specularMap;
    private Texture normalMap;

    public Material() {
        this.name = "";
        this.illum = 0;
        this.shininess = 1.0f;
        this.ambient = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        this.diffuse = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.specular = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Material(Texture texture) {
        this.name = texture.toString();
        this.illum = 0;
        this.shininess = 1.0f;
        this.ambient = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        this.diffuse = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.specular = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        this.diffuseMap = texture;
    }

    public Material(MaterialInfo info, boolean texture) {
        if (info == null) {
            throw new NullPointerException();
        }
        this.name = info.name;
        this.illum = info.illum;
        this.shininess = info.Ns;
        this.ambient = new Color(info.Ka);
        this.diffuse = new Color(info.Kd);
        this.specular = new Color(info.Ks);
        if (texture) {
            if (info.map_Ka != null) {
                this.ambientMap = new Texture2D(info.map_Ka.path);
                this.ambientMap.setWrap(info.map_Ka.wrapU, info.map_Ka.wrapV);
            }
            if (info.map_Kd != null) {
                this.diffuseMap = new Texture2D(info.map_Kd.path);
                this.diffuseMap.setWrap(info.map_Kd.wrapU, info.map_Kd.wrapV);
            }
            if (info.map_Ks != null) {
                this.specularMap = new Texture2D(info.map_Ks.path);
                this.diffuseMap.setWrap(info.map_Ks.wrapU, info.map_Ks.wrapV);
            }
            if (info.map_Kn != null) {
                this.normalMap = new Texture2D(info.map_Kn.path);
                this.diffuseMap.setWrap(info.map_Kn.wrapU, info.map_Kn.wrapV);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public int getIllum() {
        return this.illum;
    }

    public void setIllum(int value) {
        assert (0 <= value && value < 3);
        this.illum = value;
    }

    public float getShininess() {
        return this.shininess;
    }

    public void setShininess(float value) {
        assert (value >= 0.0f);
        this.shininess = value;
    }

    public Color getAmbientTint() {
        return this.ambient;
    }

    public void setAmbientTint(Color value) {
        this.ambient.set(value);
    }

    public Color getDiffuseTint() {
        return this.diffuse;
    }

    public void setDiffuseTint(Color value) {
        this.diffuse.set(value);
    }

    public Color getSpecularTint() {
        return this.specular;
    }

    public void setSpecularTint(Color value) {
        this.specular = value;
    }

    public Texture getAmbientMap() {
        return this.ambientMap;
    }

    public void setAmbientMap(Texture value) {
        this.ambientMap = value;
    }

    public Texture getDiffuseMap() {
        return this.diffuseMap;
    }

    public void setDiffuseMap(Texture value) {
        this.diffuseMap = value;
    }

    public Texture getSpecularMap() {
        return this.specularMap;
    }

    public void setSpecularMap(Texture value) {
        this.specularMap = value;
    }

    public Texture getBumpMap() {
        return this.normalMap;
    }

    public void setBumpMap(Texture value) {
        this.normalMap = value;
    }
}

