/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import edu.cornell.gdiac.audio.AudioEngine;
import edu.cornell.gdiac.audio.AudioSource;
import edu.cornell.gdiac.audio.SoundEffect;

public class SoundEffectLoader
extends AsynchronousAssetLoader<SoundEffect, SoundEffectParameters> {
    protected FileHandleResolver resolver;
    private SoundEffect cachedBuffer;

    public SoundEffectLoader() {
        this((FileHandleResolver)new InternalFileHandleResolver());
    }

    public SoundEffectLoader(FileHandleResolver resolver) {
        super(resolver);
        this.resolver = resolver;
    }

    protected SoundEffect getLoadedSound() {
        return this.cachedBuffer;
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, SoundEffectParameters params) {
        AudioSource source = (AudioSource)manager.get((String)manager.getDependencies(fileName).first(), AudioSource.class);
        this.cachedBuffer = ((AudioEngine)Gdx.audio).newSoundEffect(source);
    }

    public SoundEffect loadSync(AssetManager manager, String fileName, FileHandle file, SoundEffectParameters params) {
        SoundEffect sound = this.cachedBuffer;
        this.cachedBuffer = null;
        return sound;
    }

    public FileHandle resolve(String fileName) {
        int suffix = fileName.lastIndexOf(58);
        if (suffix == -1) {
            throw new GdxRuntimeException("Sound buffer file name must end in ':alias'.");
        }
        String prefix = fileName.substring(0, suffix);
        return this.resolver.resolve(prefix);
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, SoundEffectParameters params) {
        if (params == null) {
            int suffix = fileName.lastIndexOf(58);
            String prefix = suffix == -1 ? fileName : fileName.substring(0, suffix);
            params = new SoundEffectParameters(prefix);
        }
        Array deps = new Array(1);
        deps.add((Object)new AssetDescriptor(params.source, AudioSource.class));
        return deps;
    }

    public static class SoundEffectParameters
    extends AssetLoaderParameters<SoundEffect> {
        public String source;

        public SoundEffectParameters(String fileName) {
            this.source = fileName;
        }
    }
}

