/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.physics2;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.JointDef;
import com.badlogic.gdx.physics.box2d.QueryCallback;
import com.badlogic.gdx.physics.box2d.Shape;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.physics.box2d.joints.MouseJoint;
import com.badlogic.gdx.physics.box2d.joints.MouseJointDef;
import edu.cornell.gdiac.physics2.Obstacle;

public class ObstacleSelector
implements QueryCallback {
    private static float DEFAULT_MSIZE = 0.2f;
    private static float DEFAULT_FREQUENCY = 10.0f;
    private static float DEFAULT_DAMPING = 0.7f;
    private static float DEFAULT_FORCE = 1000.0f;
    private World world;
    private Fixture selection;
    private Body ground;
    private Vector2 dimension;
    private TextureRegion texture;
    private Vector2 origin;
    private Vector2 drawScale;
    private MouseJointDef mouseJointDef;
    private MouseJoint mouseJoint;
    private Rectangle pointer;
    private float force;
    private Vector2 position = new Vector2();
    private float units;

    public float getFrequency() {
        return this.mouseJointDef.frequencyHz;
    }

    public void setFrequency(float speed) {
        this.mouseJointDef.frequencyHz = speed;
    }

    public float getDamping() {
        return this.mouseJointDef.dampingRatio;
    }

    public void setDamping(float ratio) {
        this.mouseJointDef.dampingRatio = ratio;
    }

    public float getForce() {
        return this.force;
    }

    public void setForce(float force) {
        this.force = force;
    }

    public Vector2 getMouseSize() {
        this.dimension.set(this.pointer.width, this.pointer.height);
        return this.dimension;
    }

    public void setMouseSize(float width, float height) {
        this.pointer.width = width;
        this.pointer.height = height;
    }

    public ObstacleSelector(World world) {
        this(world, DEFAULT_MSIZE, DEFAULT_MSIZE);
    }

    public ObstacleSelector(World world, float width, float height) {
        this.world = world;
        this.pointer = new Rectangle();
        this.pointer.width = width;
        this.pointer.height = height;
        this.mouseJointDef = new MouseJointDef();
        this.mouseJointDef.frequencyHz = DEFAULT_FREQUENCY;
        this.mouseJointDef.dampingRatio = DEFAULT_DAMPING;
        this.force = DEFAULT_FORCE;
        BodyDef groundDef = new BodyDef();
        groundDef.type = BodyDef.BodyType.StaticBody;
        CircleShape groundShape = new CircleShape();
        groundShape.setRadius(this.pointer.width);
        this.ground = world.createBody(groundDef);
        this.ground.createFixture((Shape)groundShape, 0.0f);
        if (this.ground != null) {
            FixtureDef groundFixture = new FixtureDef();
            groundFixture.shape = groundShape;
            this.ground.createFixture(groundFixture);
        }
        this.units = Obstacle.DEFAULT_UNITS;
    }

    public boolean isSelected() {
        return this.selection != null;
    }

    public Obstacle getObstacle() {
        if (this.selection != null) {
            Object data = this.selection.getBody().getUserData();
            try {
                return (Obstacle)data;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean select(float x, float y) {
        this.pointer.x = x - this.pointer.width / 2.0f;
        this.pointer.y = y - this.pointer.height / 2.0f;
        this.world.QueryAABB((QueryCallback)this, this.pointer.x, this.pointer.y, this.pointer.x + this.pointer.width, this.pointer.y + this.pointer.height);
        if (this.selection != null) {
            Body body = this.selection.getBody();
            this.mouseJointDef.bodyA = this.ground;
            this.mouseJointDef.bodyB = body;
            this.mouseJointDef.target.set(x, y);
            this.mouseJointDef.frequencyHz = 5.0f;
            this.mouseJointDef.dampingRatio = 0.7f;
            this.mouseJointDef.maxForce = 1000.0f * body.getMass();
            this.mouseJoint = (MouseJoint)this.world.createJoint((JointDef)this.mouseJointDef);
            body.setAwake(true);
        }
        return this.selection != null;
    }

    public void moveTo(float x, float y) {
        this.position.set(x, y);
        if (this.mouseJoint != null) {
            this.mouseJoint.setTarget(this.position);
        }
    }

    public void deselect() {
        if (this.selection != null) {
            this.world.destroyJoint((Joint)this.mouseJoint);
            this.selection = null;
            this.mouseJoint = null;
        }
    }

    public boolean reportFixture(Fixture fixture) {
        this.selection = fixture;
        return this.selection == null;
    }

    public void setTexture(TextureRegion region) {
        this.texture = region;
        this.origin = new Vector2((float)this.texture.getRegionWidth() / 2.0f, (float)this.texture.getRegionHeight() / 2.0f);
    }

    public TextureRegion getTexture() {
        return this.texture;
    }

    public float getPhysicsUnits() {
        return this.units;
    }

    public void setPhysicsUnits(float units) {
        this.units = units;
    }
}

