/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.physics2;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.MassData;
import com.badlogic.gdx.physics.box2d.World;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.math.Path2;

public abstract class Obstacle {
    public static float DEFAULT_UNITS = 10.0f;
    private String nametag;
    protected BodyDef bodyinfo;
    protected FixtureDef fixture;
    protected MassData massdata;
    protected boolean masseffect;
    protected Body body;
    protected float units;
    protected Path2 outline;
    protected Affine2 transform = new Affine2();
    private boolean toRemove = false;
    private boolean isDirty;
    protected Vector2 positionCache = new Vector2();
    protected Vector2 velocityCache = new Vector2();
    protected Vector2 centroidCache = new Vector2();

    public Body getBody() {
        return this.body;
    }

    public BodyDef.BodyType getBodyType() {
        return this.body != null ? this.body.getType() : this.bodyinfo.type;
    }

    public void setBodyType(BodyDef.BodyType value) {
        if (this.body != null) {
            this.body.setType(value);
        } else {
            this.bodyinfo.type = value;
        }
    }

    public Vector2 getPosition() {
        return this.body != null ? this.body.getPosition() : this.positionCache.set(this.bodyinfo.position);
    }

    public void setPosition(Vector2 value) {
        if (this.body != null) {
            this.body.setTransform(value, this.body.getAngle());
        } else {
            this.bodyinfo.position.set(value);
        }
    }

    public void setPosition(float x, float y) {
        if (this.body != null) {
            this.positionCache.set(x, y);
            this.body.setTransform(this.positionCache, this.body.getAngle());
        } else {
            this.bodyinfo.position.set(x, y);
        }
    }

    public float getX() {
        return this.body != null ? this.body.getPosition().x : this.bodyinfo.position.x;
    }

    public void setX(float value) {
        if (this.body != null) {
            this.positionCache.set(value, this.body.getPosition().y);
            this.body.setTransform(this.positionCache, this.body.getAngle());
        } else {
            this.bodyinfo.position.x = value;
        }
    }

    public float getY() {
        return this.body != null ? this.body.getPosition().y : this.bodyinfo.position.y;
    }

    public void setY(float value) {
        if (this.body != null) {
            this.positionCache.set(this.body.getPosition().x, value);
            this.body.setTransform(this.positionCache, this.body.getAngle());
        } else {
            this.bodyinfo.position.y = value;
        }
    }

    public float getAngle() {
        return this.body != null ? this.body.getAngle() : this.bodyinfo.angle;
    }

    public void setAngle(float value) {
        if (this.body != null) {
            this.body.setTransform(this.body.getPosition(), value);
        } else {
            this.bodyinfo.angle = value;
        }
    }

    public Vector2 getLinearVelocity() {
        return this.body != null ? this.body.getLinearVelocity() : this.velocityCache.set(this.bodyinfo.linearVelocity);
    }

    public void setLinearVelocity(Vector2 value) {
        if (this.body != null) {
            this.body.setLinearVelocity(value);
        } else {
            this.bodyinfo.linearVelocity.set(value);
        }
    }

    public float getVX() {
        return this.body != null ? this.body.getLinearVelocity().x : this.bodyinfo.linearVelocity.x;
    }

    public void setVX(float value) {
        if (this.body != null) {
            this.velocityCache.set(value, this.body.getLinearVelocity().y);
            this.body.setLinearVelocity(this.velocityCache);
        } else {
            this.bodyinfo.linearVelocity.x = value;
        }
    }

    public float getVY() {
        return this.body != null ? this.body.getLinearVelocity().y : this.bodyinfo.linearVelocity.y;
    }

    public void setVY(float value) {
        if (this.body != null) {
            this.velocityCache.set(this.body.getLinearVelocity().y, value);
            this.body.setLinearVelocity(this.velocityCache);
        } else {
            this.bodyinfo.linearVelocity.y = value;
        }
    }

    public float getAngularVelocity() {
        return this.body != null ? this.body.getAngularVelocity() : this.bodyinfo.angularVelocity;
    }

    public void setAngularVelocity(float value) {
        if (this.body != null) {
            this.body.setAngularVelocity(value);
        } else {
            this.bodyinfo.angularVelocity = value;
        }
    }

    public boolean isActive() {
        return this.body != null ? this.body.isActive() : this.bodyinfo.active;
    }

    public void setActive(boolean value) {
        if (this.body != null) {
            this.body.setActive(value);
        } else {
            this.bodyinfo.active = value;
        }
    }

    public boolean isAwake() {
        return this.body != null ? this.body.isAwake() : this.bodyinfo.awake;
    }

    public void setAwake(boolean value) {
        if (this.body != null) {
            this.body.setAwake(value);
        } else {
            this.bodyinfo.awake = value;
        }
    }

    public boolean isSleepingAllowed() {
        return this.body != null ? this.body.isSleepingAllowed() : this.bodyinfo.allowSleep;
    }

    public void setSleepingAllowed(boolean value) {
        if (this.body != null) {
            this.body.setSleepingAllowed(value);
        } else {
            this.bodyinfo.allowSleep = value;
        }
    }

    public boolean isBullet() {
        return this.body != null ? this.body.isBullet() : this.bodyinfo.bullet;
    }

    public void setBullet(boolean value) {
        if (this.body != null) {
            this.body.setBullet(value);
        } else {
            this.bodyinfo.bullet = value;
        }
    }

    public boolean isFixedRotation() {
        return this.body != null ? this.body.isFixedRotation() : this.bodyinfo.fixedRotation;
    }

    public void setFixedRotation(boolean value) {
        if (this.body != null) {
            this.body.setFixedRotation(value);
        } else {
            this.bodyinfo.fixedRotation = value;
        }
    }

    public float getGravityScale() {
        return this.body != null ? this.body.getGravityScale() : this.bodyinfo.gravityScale;
    }

    public void setGravityScale(float value) {
        if (this.body != null) {
            this.body.setGravityScale(value);
        } else {
            this.bodyinfo.gravityScale = value;
        }
    }

    public float getLinearDamping() {
        return this.body != null ? this.body.getLinearDamping() : this.bodyinfo.linearDamping;
    }

    public void setLinearDamping(float value) {
        if (this.body != null) {
            this.body.setLinearDamping(value);
        } else {
            this.bodyinfo.linearDamping = value;
        }
    }

    public float getAngularDamping() {
        return this.body != null ? this.body.getAngularDamping() : this.bodyinfo.angularDamping;
    }

    public void setAngularDamping(float value) {
        if (this.body != null) {
            this.body.setAngularDamping(value);
        } else {
            this.bodyinfo.angularDamping = value;
        }
    }

    protected void setBodyState(Body body) {
        this.bodyinfo.type = body.getType();
        this.bodyinfo.angle = body.getAngle();
        this.bodyinfo.active = body.isActive();
        this.bodyinfo.awake = body.isAwake();
        this.bodyinfo.bullet = body.isBullet();
        this.bodyinfo.position.set(body.getPosition());
        this.bodyinfo.linearVelocity.set(body.getLinearVelocity());
        this.bodyinfo.allowSleep = body.isSleepingAllowed();
        this.bodyinfo.fixedRotation = body.isFixedRotation();
        this.bodyinfo.gravityScale = body.getGravityScale();
        this.bodyinfo.angularDamping = body.getAngularDamping();
        this.bodyinfo.linearDamping = body.getLinearDamping();
    }

    public float getDensity() {
        return this.fixture.density;
    }

    public void setDensity(float value) {
        this.fixture.density = value;
        if (this.body != null) {
            for (Fixture f : this.body.getFixtureList()) {
                f.setDensity(value);
            }
        }
    }

    public float getFriction() {
        return this.fixture.friction;
    }

    public void setFriction(float value) {
        this.fixture.friction = value;
        if (this.body != null) {
            for (Fixture f : this.body.getFixtureList()) {
                f.setFriction(value);
            }
        }
    }

    public float getRestitution() {
        return this.fixture.restitution;
    }

    public void setRestitution(float value) {
        this.fixture.restitution = value;
        if (this.body != null) {
            for (Fixture f : this.body.getFixtureList()) {
                f.setRestitution(value);
            }
        }
    }

    public boolean isSensor() {
        return this.fixture.isSensor;
    }

    public void setSensor(boolean value) {
        this.fixture.isSensor = value;
        if (this.body != null) {
            for (Fixture f : this.body.getFixtureList()) {
                f.setSensor(value);
            }
        }
    }

    public Filter getFilterData() {
        return this.fixture.filter;
    }

    public void setFilterData(Filter value) {
        if (value != null) {
            this.fixture.filter.categoryBits = value.categoryBits;
            this.fixture.filter.groupIndex = value.groupIndex;
            this.fixture.filter.maskBits = value.maskBits;
        } else {
            this.fixture.filter.categoryBits = 1;
            this.fixture.filter.groupIndex = 0;
            this.fixture.filter.maskBits = (short)-1;
        }
        if (this.body != null) {
            for (Fixture f : this.body.getFixtureList()) {
                f.setFilterData(this.fixture.filter);
            }
        }
    }

    public Vector2 getCentroid() {
        return this.body != null ? this.body.getLocalCenter() : this.centroidCache.set(this.massdata.center);
    }

    public void setCentroid(Vector2 value) {
        if (!this.masseffect) {
            this.masseffect = true;
            this.massdata.I = this.getInertia();
            this.massdata.mass = this.getMass();
        }
        this.massdata.center.set(value);
        if (this.body != null) {
            this.body.setMassData(this.massdata);
        }
    }

    public float getInertia() {
        return this.body != null ? this.body.getInertia() : this.massdata.I;
    }

    public void setInertia(float value) {
        if (!this.masseffect) {
            this.masseffect = true;
            this.massdata.center.set(this.getCentroid());
            this.massdata.mass = this.getMass();
        }
        this.massdata.I = value;
        if (this.body != null) {
            this.body.setMassData(this.massdata);
        }
    }

    public float getMass() {
        return this.body != null ? this.body.getMass() : this.massdata.mass;
    }

    public void setMass(float value) {
        if (!this.masseffect) {
            this.masseffect = true;
            this.massdata.center.set(this.getCentroid());
            this.massdata.I = this.getInertia();
        }
        this.massdata.mass = value;
        if (this.body != null) {
            this.body.setMassData(this.massdata);
        }
    }

    public void resetMass() {
        this.masseffect = false;
        if (this.body != null) {
            this.body.resetMassData();
        }
    }

    public boolean isRemoved() {
        return this.toRemove;
    }

    public void markRemoved(boolean value) {
        this.toRemove = value;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void markDirty(boolean value) {
        this.isDirty = value;
    }

    public float getPhysicsUnits() {
        return this.units;
    }

    public void setPhysicsUnits(float units) {
        this.units = units;
    }

    public void draw(SpriteBatch batch) {
        this.draw(batch, Color.WHITE);
    }

    public void draw(SpriteBatch batch, Color color) {
        Vector2 p = this.getPosition();
        this.transform.idt();
        this.transform.preScale(this.units, this.units);
        this.transform.preRotate((float)((double)(this.getAngle() * 180.0f) / Math.PI));
        this.transform.preTranslate(p.x * this.units, p.y * this.units);
        Color c = batch.getColor();
        batch.setColor(color);
        batch.outline(this.outline, this.transform);
        batch.setColor(c);
    }

    public void draw(SpriteBatch batch, Affine2 affine) {
        this.draw(batch, Color.WHITE, affine);
    }

    public void draw(SpriteBatch batch, Color color, Affine2 affine) {
        Vector2 p = this.getPosition();
        this.transform.set(affine);
        this.transform.preScale(this.units, this.units);
        this.transform.preRotate((float)((double)(this.getAngle() * 180.0f) / Math.PI));
        this.transform.preTranslate(p.x * this.units, p.y * this.units);
        Color c = batch.getColor();
        batch.setColor(color);
        batch.outline(this.outline, this.transform);
        batch.setColor(c);
    }

    public String getName() {
        return this.nametag;
    }

    public void setName(String value) {
        this.nametag = value;
    }

    protected Obstacle() {
        this(0.0f, 0.0f);
    }

    protected Obstacle(float x, float y) {
        this.bodyinfo = new BodyDef();
        this.bodyinfo.awake = true;
        this.bodyinfo.allowSleep = true;
        this.bodyinfo.gravityScale = 1.0f;
        this.bodyinfo.position.set(x, y);
        this.bodyinfo.fixedRotation = false;
        this.bodyinfo.type = BodyDef.BodyType.DynamicBody;
        this.fixture = new FixtureDef();
        this.masseffect = false;
        this.massdata = new MassData();
        this.units = DEFAULT_UNITS;
        this.outline = new Path2();
    }

    public boolean activatePhysics(World world) {
        this.bodyinfo.active = true;
        this.body = world.createBody(this.bodyinfo);
        this.body.setUserData((Object)this);
        if (this.body != null) {
            this.createFixtures();
            return true;
        }
        this.bodyinfo.active = false;
        return false;
    }

    public void deactivatePhysics(World world) {
        if (this.body != null) {
            this.setBodyState(this.body);
            world.destroyBody(this.body);
            this.body = null;
            this.bodyinfo.active = false;
        }
    }

    protected abstract void createFixtures();

    protected abstract void releaseFixtures();

    public void update(float delta) {
        if (this.isDirty()) {
            this.createFixtures();
        }
    }
}

