/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.physics2;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import edu.cornell.gdiac.math.Capsule;
import edu.cornell.gdiac.math.PathFactory;
import edu.cornell.gdiac.physics2.Obstacle;

public class CapsuleObstacle
extends Obstacle {
    private static final float DEFAULT_EPSILON = 0.01f;
    protected PolygonShape shape;
    protected CircleShape end1;
    protected CircleShape end2;
    protected Rectangle center;
    private Vector2 dimension;
    private Vector2 sizeCache;
    private Fixture core = null;
    private Fixture cap1 = null;
    private Fixture cap2 = null;
    private Capsule style;
    private float[] vertices;
    private Vector2 posCache = new Vector2();
    private float seamEpsilon;

    public Vector2 getDimension() {
        return this.sizeCache.set(this.dimension);
    }

    public void setDimension(Vector2 value) {
        this.setDimension(value.x, value.y);
    }

    public void setDimension(float width, float height) {
        this.dimension.set(width, height);
        this.markDirty(true);
        this.resize(width, height);
    }

    public float getWidth() {
        return this.dimension.x;
    }

    public void setWidth(float value) {
        this.sizeCache.set(value, this.dimension.y);
        this.setDimension(this.sizeCache);
    }

    public float getHeight() {
        return this.dimension.y;
    }

    public void setHeight(float value) {
        this.sizeCache.set(this.dimension.x, value);
        this.setDimension(this.sizeCache);
    }

    public Capsule getStyle() {
        return this.style;
    }

    public void setOrientation(Capsule value) {
        this.style = this.style;
        this.resize(this.dimension.x, this.dimension.y);
        this.markDirty(true);
    }

    public float getSeamOffset() {
        return this.seamEpsilon;
    }

    public void setSeamOffset(float value) {
        this.seamEpsilon = value;
        this.markDirty(true);
    }

    public CapsuleObstacle(float width, float height) {
        this(0.0f, 0.0f, width, height, Capsule.FULL);
    }

    public CapsuleObstacle(float x, float y, float width, float height) {
        this(x, y, width, height, Capsule.FULL);
    }

    public CapsuleObstacle(float x, float y, float width, float height, Capsule style) {
        super(x, y);
        this.dimension = new Vector2();
        this.sizeCache = new Vector2();
        this.shape = new PolygonShape();
        this.end1 = new CircleShape();
        this.end2 = new CircleShape();
        this.center = new Rectangle();
        this.vertices = new float[8];
        this.style = style;
        this.seamEpsilon = 0.01f;
        this.resize(width, height);
    }

    private void resize(float width, float height) {
        this.dimension.set(width, height);
        if (width == 0.0f || height == 0.0f) {
            return;
        }
        if (width == height) {
            this.style = Capsule.DEGENERATE;
        }
        this.center.x = -width / 2.0f;
        this.center.y = -height / 2.0f;
        this.center.width = width;
        this.center.height = height;
        boolean vertical = height > width;
        float r = 0.0f;
        switch (this.style) {
            case DEGENERATE: {
                r = width / 2.0f;
                break;
            }
            case FULL: {
                if (vertical) {
                    r = width / 2.0f;
                    this.center.y += r;
                    this.center.height -= 2.0f * r;
                    this.center.x += this.seamEpsilon;
                    this.center.width -= 2.0f * this.seamEpsilon;
                    break;
                }
                r = height / 2.0f;
                this.center.x += r;
                this.center.width -= 2.0f * r;
                this.center.y += this.seamEpsilon;
                this.center.height -= 2.0f * this.seamEpsilon;
                break;
            }
            case HALF: {
                if (vertical) {
                    r = width / 2.0f;
                    this.center.y += r;
                    this.center.height -= r;
                    this.center.x += this.seamEpsilon;
                    this.center.width -= 2.0f * this.seamEpsilon;
                    break;
                }
                r = height / 2.0f;
                this.center.width -= r;
                this.center.y += this.seamEpsilon;
                this.center.height -= 2.0f * this.seamEpsilon;
                break;
            }
            case HALF_REVERSE: {
                if (vertical) {
                    r = width / 2.0f;
                    this.center.height -= r;
                    this.center.x += this.seamEpsilon;
                    this.center.width -= 2.0f * this.seamEpsilon;
                    break;
                }
                r = height / 2.0f;
                this.center.x += r;
                this.center.width -= r;
                this.center.y += this.seamEpsilon;
                this.center.height -= 2.0f * this.seamEpsilon;
            }
        }
        this.vertices[0] = this.center.x;
        this.vertices[1] = this.center.y;
        this.vertices[2] = this.center.x;
        this.vertices[3] = this.center.y + this.center.height;
        this.vertices[4] = this.center.x + this.center.width;
        this.vertices[5] = this.center.y + this.center.height;
        this.vertices[6] = this.center.x + this.center.width;
        this.vertices[7] = this.center.y;
        this.shape.set(this.vertices);
        this.end1.setRadius(r);
        this.end2.setRadius(r);
        PathFactory pather = new PathFactory();
        pather.makeCapsule(this.style, -width / 2.0f, -height / 2.0f, width, height, this.outline);
    }

    @Override
    public void setDensity(float value) {
        this.fixture.density = value;
        if (this.body != null) {
            this.core.setDensity(value);
            this.cap1.setDensity(value / 2.0f);
            this.cap2.setDensity(value / 2.0f);
            if (!this.masseffect) {
                this.body.resetMassData();
            }
        }
    }

    @Override
    protected void createFixtures() {
        if (this.body == null) {
            return;
        }
        this.releaseFixtures();
        this.fixture.density /= 2.0f;
        this.posCache.set(0.0f, 0.0f);
        boolean vertical = this.dimension.y > this.dimension.x;
        switch (this.style) {
            case DEGENERATE: {
                this.end1.setPosition(this.posCache);
                this.fixture.shape = this.end1;
                this.cap1 = this.body.createFixture(this.fixture);
                this.cap2 = null;
                this.core = null;
                break;
            }
            case FULL: {
                this.fixture.shape = this.shape;
                this.core = this.body.createFixture(this.fixture);
                if (vertical) {
                    this.posCache.y = this.center.y + this.center.height;
                    this.end1.setPosition(this.posCache);
                    this.fixture.shape = this.end1;
                    this.cap1 = this.body.createFixture(this.fixture);
                    this.posCache.y = this.center.y;
                    this.end2.setPosition(this.posCache);
                    this.fixture.shape = this.end2;
                    this.cap2 = this.body.createFixture(this.fixture);
                    break;
                }
                this.posCache.x = this.center.x;
                this.end1.setPosition(this.posCache);
                this.fixture.shape = this.end1;
                this.cap1 = this.body.createFixture(this.fixture);
                this.posCache.x = this.center.x + this.center.width;
                this.end2.setPosition(this.posCache);
                this.fixture.shape = this.end2;
                this.cap2 = this.body.createFixture(this.fixture);
                break;
            }
            case HALF: {
                this.fixture.shape = this.shape;
                this.core = this.body.createFixture(this.fixture);
                if (vertical) {
                    this.cap1 = null;
                    this.posCache.y = this.center.y;
                    this.end2.setPosition(this.posCache);
                    this.fixture.shape = this.end2;
                    this.cap2 = this.body.createFixture(this.fixture);
                    break;
                }
                this.posCache.x = this.center.x;
                this.end1.setPosition(this.posCache);
                this.fixture.shape = this.end1;
                this.cap1 = this.body.createFixture(this.fixture);
                this.cap2 = null;
                break;
            }
            case HALF_REVERSE: {
                this.fixture.shape = this.shape;
                this.core = this.body.createFixture(this.fixture);
                if (vertical) {
                    this.posCache.y = this.center.y + this.center.height;
                    this.end1.setPosition(this.posCache);
                    this.fixture.shape = this.end1;
                    this.cap1 = this.body.createFixture(this.fixture);
                    this.cap2 = null;
                    break;
                }
                this.cap1 = null;
                this.posCache.x = this.center.x + this.center.width;
                this.end2.setPosition(this.posCache);
                this.fixture.shape = this.end2;
                this.cap2 = this.body.createFixture(this.fixture);
            }
        }
        this.markDirty(false);
    }

    @Override
    protected void releaseFixtures() {
        if (this.core != null) {
            this.body.destroyFixture(this.core);
            this.core = null;
        }
        if (this.cap1 != null) {
            this.body.destroyFixture(this.cap1);
            this.cap1 = null;
        }
        if (this.cap2 != null) {
            this.body.destroyFixture(this.cap2);
            this.cap2 = null;
        }
    }
}

