/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.math;

import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.ShortArray;
import edu.cornell.gdiac.math.Path2;
import edu.cornell.gdiac.math.Poly2;

public class PathExtruder {
    private final float TOLERANCE = 0.25f;
    private final float MITER_LIMIT = 10.0f;
    private final float EPSILON = 1.0E-6f;
    private final float SCALE_LIMIT = 600.0f;
    private final float LEFT_MK = 1.0f;
    private final float RGHT_MK = 1.0f;
    private final float HEAD_MK = -1.0f;
    private final float TAIL_MK = 1.0f;
    private final int FLAG_CORNER = 1;
    private final int FLAG_LEFT = 2;
    private final int FLAG_BEVEL = 4;
    private final int FLAG_INNER = 8;
    private Joint joint = Joint.SQUARE;
    private EndCap endCap = EndCap.BUTT;
    private float tolerance = 0.25f;
    private float mitreLimit = 10.0f;
    private boolean closed;
    private boolean convex;
    private boolean calculated = false;
    private Point points;
    private int pSize;
    private FloatArray verts;
    private FloatArray sides;
    private FloatArray lefts;
    private FloatArray rghts;
    private int vSize;
    private ShortArray indxs;
    private int iback2;
    private int iback1;

    public PathExtruder() {
        this.closed = false;
        this.convex = true;
        this.points = null;
        this.verts = null;
        this.sides = null;
        this.indxs = null;
        this.pSize = 0;
        this.vSize = 0;
    }

    public PathExtruder(float[] points, boolean closed) {
        this.convex = true;
        this.points = null;
        this.verts = null;
        this.sides = null;
        this.indxs = null;
        this.pSize = 0;
        this.vSize = 0;
        this.set(points, closed);
    }

    public PathExtruder(Path2 path) {
        this.closed = false;
        this.convex = true;
        this.points = null;
        this.verts = null;
        this.sides = null;
        this.indxs = null;
        this.pSize = 0;
        this.vSize = 0;
        this.set(path);
    }

    public void set(float[] points, boolean closed) {
        Point prevHead;
        this.clear();
        this.closed = closed;
        this.pSize = points.length / 2;
        this.points = prevHead = new Point();
        for (int i = 0; i < points.length - 2; i += 2) {
            Point p = new Point();
            p.x = points[i];
            p.y = points[i + 1];
            p.flags = 1;
            p.dx = points[i + 2] - p.x;
            p.dy = points[i + 3] - p.y;
            p.len = (float)Math.sqrt(p.dx * p.dx + p.dy * p.dy);
            if ((double)p.len > 1.0E-6) {
                p.dx /= p.len;
                p.dy /= p.len;
            }
            p.prev = this.points;
            this.points = this.points.next = p;
        }
        Point p = new Point();
        p.x = points[points.length - 2];
        p.y = points[points.length - 1];
        p.flags = 1;
        p.dx = points[0] - p.x;
        p.dy = points[1] - p.y;
        p.len = (float)Math.sqrt(p.dx * p.dx + p.dy * p.dy);
        if ((double)p.len > 1.0E-6) {
            p.dx /= p.len;
            p.dy /= p.len;
        }
        p.prev = this.points;
        p.next = prevHead.next;
        this.points.next = p;
        this.points = prevHead.next;
        this.points.prev = p;
    }

    public void set(Path2 path) {
        Point prevHead;
        this.clear();
        this.closed = path.closed;
        this.pSize = path.vertices.size / 2;
        this.points = prevHead = new Point();
        for (int i = 0; i < path.vertices.size - 2; i += 2) {
            Point p = new Point();
            p.x = path.vertices.items[i];
            p.y = path.vertices.items[i + 1];
            p.flags = path.isCorner(i) ? 1 : 0;
            p.dx = path.vertices.items[i + 2] - p.x;
            p.dy = path.vertices.items[i + 3] - p.y;
            p.len = (float)Math.sqrt(p.dx * p.dx + p.dy * p.dy);
            if ((double)p.len > 1.0E-6) {
                p.dx /= p.len;
                p.dy /= p.len;
            }
            p.prev = this.points;
            this.points = this.points.next = p;
        }
        Point p = new Point();
        p.x = path.vertices.items[path.vertices.size - 2];
        p.y = path.vertices.items[path.vertices.size - 1];
        p.flags = path.isCorner(this.pSize - 1) ? 1 : 0;
        p.dx = path.vertices.items[0] - p.x;
        p.dy = path.vertices.items[1] - p.y;
        p.len = (float)Math.sqrt(p.dx * p.dx + p.dy * p.dy);
        if ((double)p.len > 1.0E-6) {
            p.dx /= p.len;
            p.dy /= p.len;
        }
        p.prev = this.points;
        p.next = prevHead.next;
        this.points.next = p;
        this.points = prevHead.next;
        this.points.prev = p;
    }

    public void reset() {
        this.vSize = 0;
        this.iback1 = 0;
        this.iback2 = 0;
        this.calculated = false;
    }

    public void clear() {
        this.reset();
        this.pSize = 0;
        this.closed = false;
        this.convex = true;
    }

    public void calculate(float lWidth, float rWidth) {
        int i;
        float mag;
        float dy;
        int e;
        int s;
        Point p1;
        Point p0;
        if (this.calculated) {
            return;
        }
        float leftmark = lWidth > 0.0f ? 1.0f : 0.0f;
        float rghtmark = rWidth > 0.0f ? 1.0f : 0.0f;
        float width = lWidth + rWidth;
        int nCap = this.curveSegs(width, (float)Math.PI, this.tolerance);
        int nBevel = this.analyze(width);
        int cverts = 0;
        cverts = this.joint == Joint.ROUND ? (cverts += (this.pSize + nBevel * (nCap + 2) + 1) * 2) : (cverts += (this.pSize + nBevel * 5 + 1) * 2);
        if (!this.closed) {
            cverts = this.endCap == EndCap.ROUND ? (cverts += (nCap * 2 + 2) * 2) : (cverts += 12);
        }
        if (cverts <= 0 || this.pSize <= 0) {
            return;
        }
        this.preAlloc(cverts);
        if (this.closed) {
            p0 = this.points.prev;
            p1 = this.points;
            s = 0;
            e = this.pSize;
        } else {
            p0 = this.points;
            p1 = this.points.next;
            s = 1;
            e = this.pSize - 1;
            float dx = p1.x - p0.x;
            dy = p1.y - p0.y;
            mag = (float)Math.sqrt(dx * dx + dy * dy);
            if (mag > 1.0E-6f) {
                dx /= mag;
                dy /= mag;
            }
            switch (this.endCap) {
                case BUTT: {
                    this.startButt(p0, dx, dy, lWidth, rWidth);
                    break;
                }
                case SQUARE: {
                    this.startSquare(p0, dx, dy, lWidth, rWidth, width);
                    break;
                }
                case ROUND: {
                    this.startRound(p0, dx, dy, lWidth, rWidth, nCap);
                }
            }
        }
        for (i = s; i < e; ++i) {
            if ((p1.flags & 0xC) != 0) {
                if (this.joint == Joint.ROUND) {
                    this.joinRound(p0, p1, lWidth, rWidth, nCap, this.closed && i == s);
                } else {
                    this.joinBevel(p0, p1, lWidth, rWidth, this.closed && i == s);
                }
            } else if (this.closed && i == s) {
                this.iback2 = this.addPoint(p1.x - p1.dmx * lWidth, p1.y - p1.dmy * lWidth, leftmark, 0.0f);
                this.iback1 = this.addPoint(p1.x + p1.dmx * rWidth, p1.y + p1.dmy * rWidth, rghtmark, 0.0f);
                this.addLeft(this.iback2);
                this.addRight(this.iback1);
            } else {
                int ind = this.addPoint(p1.x - p1.dmx * lWidth, p1.y - p1.dmy * lWidth, leftmark, 0.0f);
                this.addLeft(ind);
                this.triLeft(ind);
                ind = this.addPoint(p1.x + p1.dmx * rWidth, p1.y + p1.dmy * rWidth, rghtmark, 0.0f);
                this.addRight(ind);
                this.triRight(ind);
            }
            p0 = p0.next;
            p1 = p1.next;
        }
        if (this.closed) {
            this.addLeft(0);
            this.triLeft(0);
            this.addRight(1);
            this.triRight(1);
        } else {
            p1 = this.points;
            for (i = 0; i < e; ++i) {
                p1 = p1.next;
            }
            float dx = p1.x - p0.x;
            dy = p1.y - p0.y;
            mag = (float)Math.sqrt(dx * dx + dy * dy);
            if (mag > 1.0E-6f) {
                dx /= mag;
                dy /= mag;
            }
            switch (this.endCap) {
                case BUTT: {
                    this.endButt(p1, dx, dy, lWidth, rWidth);
                    break;
                }
                case SQUARE: {
                    this.endSquare(p1, dx, dy, lWidth, rWidth, width);
                    break;
                }
                case ROUND: {
                    this.endRound(p1, dx, dy, lWidth, rWidth, nCap);
                }
            }
        }
        this.calculated = true;
    }

    public void calculate(float width) {
        this.calculate(width / 2.0f, width / 2.0f);
    }

    public void setJoint(Joint joint) {
        this.reset();
        this.joint = joint;
    }

    public Joint getJoint() {
        return this.joint;
    }

    public void setEndCap(EndCap endCap) {
        this.endCap = endCap;
    }

    public EndCap getEndCap() {
        return this.endCap;
    }

    public void setTolerance(float tolerance) {
        this.tolerance = tolerance;
    }

    public float getTolerance() {
        return this.tolerance;
    }

    public void setMitreLimit(float limit) {
        this.mitreLimit = limit;
    }

    public float getMitreLimit() {
        return this.mitreLimit;
    }

    private int analyze(float width) {
        float iWidth = width > 0.0f ? 1.0f / width : 0.0f;
        int nLeft = 0;
        int nBevel = 0;
        Point v0 = this.points.prev;
        Point v1 = this.points;
        for (int i = 0; i < this.pSize; ++i) {
            float limit;
            float dlx0 = v0.dy;
            float dly0 = -v0.dx;
            float dlx1 = v1.dy;
            float dly1 = -v1.dx;
            v1.dmx = (dlx0 + dlx1) * 0.5f;
            v1.dmy = (dly0 + dly1) * 0.5f;
            float dmr2 = v1.dmx * v1.dmx + v1.dmy * v1.dmy;
            if (dmr2 > 1.0E-6f) {
                float scale = 1.0f / dmr2;
                if (scale > 600.0f) {
                    scale = 600.0f;
                }
                v1.dmx *= scale;
                v1.dmy *= scale;
            }
            v1.flags = (v1.flags & 1) == 1 ? 1 : 0;
            float cross = v1.dx * v0.dy - v0.dx * v1.dy;
            if ((double)cross < 0.0) {
                ++nLeft;
                v1.flags |= 2;
            }
            if (dmr2 * (limit = Math.max(1.01f, Math.min(v0.len, v1.len) * iWidth)) * limit < 1.0f) {
                v1.flags |= 8;
            }
            if ((v1.flags & 1) != 0 && ((double)(dmr2 * this.mitreLimit * this.mitreLimit) < 1.0 || this.joint == Joint.SQUARE || this.joint == Joint.ROUND)) {
                v1.flags |= 4;
            }
            if ((v1.flags & 0xC) != 0) {
                ++nBevel;
            }
            v0 = v0.next;
            v1 = v1.next;
        }
        this.convex = nLeft == this.pSize;
        return nBevel;
    }

    private void preAlloc(int size) {
        this.verts = new FloatArray();
        this.lefts = new FloatArray();
        this.rghts = new FloatArray();
        this.sides = new FloatArray();
        this.indxs = new ShortArray();
    }

    private float[] chooseBevel(boolean inner, Point p0, Point p1, float w) {
        float[] res = new float[4];
        if (inner) {
            res[0] = p1.x + p0.dy * w;
            res[1] = p1.y - p0.dx * w;
            res[2] = p1.x + p1.dy * w;
            res[3] = p1.y - p1.dx * w;
        } else {
            res[0] = p1.x + p1.dmx * w;
            res[1] = p1.y + p1.dmy * w;
            res[2] = p1.x + p1.dmx * w;
            res[3] = p1.y + p1.dmy * w;
        }
        return res;
    }

    private void joinRound(Point p0, Point p1, float lw, float rw, int nCap, boolean start) {
        float rghtmark;
        float dlx0 = p0.dy;
        float dly0 = -p0.dx;
        float dlx1 = p1.dy;
        float dly1 = -p1.dx;
        int ind = 0;
        float leftmark = lw > 0.0f ? 1.0f : 0.0f;
        float f = rghtmark = rw > 0.0f ? 1.0f : 0.0f;
        if ((p1.flags & 2) != 0) {
            float[] res = this.chooseBevel((p1.flags & 8) != 0, p0, p1, -lw);
            float lx0 = res[0];
            float ly0 = res[1];
            float lx1 = res[2];
            float ly1 = res[3];
            float a0 = (float)Math.atan2(dly0, dlx0);
            float a1 = (float)Math.atan2(dly1, dlx1);
            if (a1 < a0) {
                a1 = (float)((double)a1 + Math.PI * 2);
            }
            if (start) {
                this.iback2 = this.addPoint(lx0, ly0, leftmark, 0.0f);
                this.addLeft(this.iback2);
                this.iback1 = this.addPoint(p1.x + dlx0 * rw, p1.y + dly0 * rw, rghtmark, 0.0f);
                this.addRight(this.iback1);
            } else {
                ind = this.addPoint(lx0, ly0, leftmark, 0.0f);
                this.addLeft(ind);
                this.triLeft(ind);
                ind = this.addPoint(p1.x + dlx0 * rw, p1.y + dly0 * rw, rghtmark, 0.0f);
                this.addRight(ind);
                this.triRight(ind);
            }
            int n = this.clampi((int)Math.ceil((double)(a1 - a0) / Math.PI * (double)nCap), 2, nCap);
            int center = this.addPoint(p1.x, p1.y, 0.0f, 0.0f);
            this.triLeft(center);
            for (int i = 0; i < n; ++i) {
                float u = (float)i / (float)(n - 1);
                float a = a0 + u * (a1 - a0);
                float rx = (float)((double)p1.x + Math.cos(a) * (double)rw);
                float ry = (float)((double)p1.y + Math.sin(a) * (double)rw);
                ind = this.addPoint(rx, ry, rghtmark, 0.0f);
                this.addRight(ind);
                this.triRight(ind);
                this.iback2 = ind;
                this.iback1 = center;
            }
            this.iback1 = this.iback2;
            this.iback2 = center;
            ind = this.addPoint(lx1, ly1, leftmark, 0.0f);
            this.addLeft(ind);
            this.triLeft(ind);
            ind = this.addPoint(p1.x + dlx1 * rw, p1.y + dly1 * rw, rghtmark, 0.0f);
            this.addRight(ind);
            this.triRight(ind);
        } else {
            float[] res = this.chooseBevel((p1.flags & 8) != 0, p0, p1, rw);
            float rx0 = res[0];
            float ry0 = res[1];
            float rx1 = res[2];
            float ry1 = res[3];
            float a0 = (float)Math.atan2(-dly0, -dlx0);
            float a1 = (float)Math.atan2(-dly1, -dlx1);
            if (a1 > a0) {
                a1 = (float)((double)a1 - Math.PI * 2);
            }
            if (start) {
                this.iback1 = this.addPoint(p1.x - dlx0 * lw, p1.y - dly0 * lw, leftmark, 0.0f);
                this.iback2 = this.addPoint(rx0, ry0, rghtmark, 0.0f);
            } else {
                ind = this.addPoint(p1.x - dlx0 * lw, p1.y - dly0 * lw, leftmark, 0.0f);
                this.addLeft(ind);
                this.triLeft(ind);
                ind = this.addPoint(rx0, ry0, rghtmark, 0.0f);
                this.addRight(ind);
                this.triRight(ind);
                float lx = (float)((double)p1.x + Math.cos(a0) * (double)lw);
                float ly = (float)((double)p1.y + Math.sin(a0) * (double)lw);
                ind = this.addPoint(lx, ly, leftmark, 0.0f);
                this.addLeft(ind);
                this.triLeft(ind);
            }
            int n = this.clampi((int)Math.ceil((double)(a0 - a1) / Math.PI * (double)nCap), 2, nCap);
            int center = this.addPoint(p1.x, p1.y, 0.0f, 0.0f);
            this.triRight(center);
            for (int i = 0; i < n; ++i) {
                float u = (float)i / (float)(n - 1);
                float a = a0 + u * (a1 - a0);
                float lx = (float)((double)p1.x + Math.cos(a) * (double)lw);
                float ly = (float)((double)p1.y + Math.sin(a) * (double)lw);
                ind = this.addPoint(lx, ly, leftmark, 0.0f);
                this.iback1 = center;
                this.addLeft(ind);
                this.triLeft(ind);
                this.iback2 = ind;
            }
            this.iback1 = center;
            ind = this.addPoint(p1.x - dlx1 * lw, p1.y - dly1 * lw, leftmark, 0.0f);
            this.addLeft(ind);
            this.triLeft(ind);
            ind = this.addPoint(rx1, ry1, rghtmark, 0.0f);
            this.addRight(ind);
            this.triRight(ind);
        }
    }

    private void joinBevel(Point p0, Point p1, float lw, float rw, boolean start) {
        float rghtmark;
        float dlx0 = p0.dy;
        float dly0 = -p0.dx;
        float dlx1 = p1.dy;
        float dly1 = -p1.dx;
        float leftmark = lw > 0.0f ? 1.0f : 0.0f;
        float f = rghtmark = rw > 0.0f ? 1.0f : 0.0f;
        if ((p1.flags & 2) != 0) {
            int ind;
            float[] res = this.chooseBevel((p1.flags & 8) != 0, p0, p1, -lw);
            float lx0 = res[0];
            float ly0 = res[1];
            float lx1 = res[2];
            float ly1 = res[3];
            if (start) {
                this.iback2 = this.addPoint(lx0, ly0, leftmark, 0.0f);
                this.iback1 = this.addPoint(p1.x + dlx0 * rw, p1.y + dly0 * rw, rghtmark, 0.0f);
            } else {
                ind = this.addPoint(lx0, ly0, leftmark, 0.0f);
                this.addLeft(ind);
                this.triLeft(ind);
                ind = this.addPoint(p1.x + dlx0 * rw, p1.y + dly0 * rw, rghtmark, 0.0f);
                this.addRight(ind);
                this.triRight(ind);
            }
            if ((p1.flags & 4) != 0) {
                ind = this.addPoint(lx1, ly1, leftmark, 0.0f);
                this.triLeft(ind);
                ind = this.addPoint(p1.x + dlx1 * rw, p1.y + dly1 * rw, rghtmark, 0.0f);
                this.triRight(ind);
            } else {
                float rx0 = p1.x + p1.dmx * rw;
                float ry0 = p1.y + p1.dmy * rw;
                ind = this.addPoint(p1.x, p1.y, 0.0f, 0.0f);
                this.triLeft(ind);
                ind = this.addPoint(p1.x + dlx0 * rw, p1.y + dly0 * rw, rghtmark, 0.0f);
                this.addRight(ind);
                this.triRight(ind);
                ind = this.addPoint(rx0, ry0, rghtmark, 0.0f);
                this.addRight(ind);
                this.triLeft(ind);
                this.iback2 = ind;
                this.iback1 = this.addPoint(p1.x, p1.y, 0.0f, 0.0f);
                ind = this.addPoint(p1.x + dlx1 * rw, p1.y + dly1 * rw, rghtmark, 0.0f);
                this.addRight(ind);
                this.triRight(ind);
            }
            ind = this.addPoint(lx1, ly1, leftmark, 0.0f);
            this.addLeft(ind);
            this.triLeft(ind);
            ind = this.addPoint(p1.x + dlx1 * rw, p1.y + dly1 * rw, rghtmark, 0.0f);
            this.addRight(ind);
            this.triRight(ind);
        } else {
            int ind;
            float[] res = this.chooseBevel((p1.flags & 8) != 0, p0, p1, rw);
            float rx0 = res[0];
            float ry0 = res[1];
            float rx1 = res[2];
            float ry1 = res[3];
            if (start) {
                this.iback2 = this.addPoint(p1.x - dlx0 * lw, p1.y - dly0 * lw, leftmark, 0.0f);
                this.iback1 = this.addPoint(rx0, ry0, rghtmark, 0.0f);
            } else {
                ind = this.addPoint(p1.x - dlx0 * lw, p1.y - dly0 * lw, leftmark, 0.0f);
                this.addLeft(ind);
                this.triLeft(ind);
                ind = this.addPoint(rx0, ry0, rghtmark, 0.0f);
                this.addRight(ind);
                this.triRight(ind);
            }
            if ((p1.flags & 4) != 0) {
                ind = this.addPoint(p1.x - dlx1 * lw, p1.y - dly1 * lw, leftmark, 0.0f);
                this.addLeft(ind);
                this.triLeft(ind);
                ind = this.addPoint(rx1, ry1, rghtmark, 0.0f);
                this.addRight(ind);
                this.triRight(ind);
            } else {
                float lx0 = p1.x - p1.dmx * lw;
                float ly0 = p1.y - p1.dmy * lw;
                ind = this.addPoint(p1.x - dlx0 * lw, p1.y - dly0 * lw, leftmark, 0.0f);
                this.addLeft(ind);
                this.triLeft(ind);
                ind = this.addPoint(p1.x, p1.y, 0.0f, 0.0f);
                this.triRight(ind);
                ind = this.addPoint(lx0, ly0, leftmark, 0.0f);
                this.addLeft(ind);
                this.triLeft(ind);
                this.iback2 = ind;
                this.iback1 = this.addPoint(p1.x - dlx1 * lw, p1.y - dly1 * lw, leftmark, 0.0f);
                ind = this.addPoint(p1.x, p1.y, 0.0f, 0.0f);
                this.addLeft(this.iback1);
                this.triRight(ind);
            }
            ind = this.addPoint(p1.x - dlx1 * lw, p1.y - dly1 * lw, leftmark, 0.0f);
            this.addLeft(ind);
            this.triLeft(ind);
            ind = this.addPoint(rx1, ry1, rghtmark, 0.0f);
            this.addRight(ind);
            this.triRight(ind);
        }
    }

    private void startButt(Point p, float dx, float dy, float lw, float rw) {
        float dlx = dy;
        float dly = -dx;
        this.iback2 = this.addPoint(p.x - dlx * lw, p.y - dly * lw, lw > 0.0f ? 1.0f : 0.0f, 0.0f);
        this.addLeft(this.iback2);
        this.iback1 = this.addPoint(p.x + dlx * rw, p.y + dly * rw, rw > 0.0f ? 1.0f : 0.0f, 0.0f);
        this.addRight(this.iback1);
    }

    private void endButt(Point p, float dx, float dy, float lw, float rw) {
        float dlx = dy;
        float dly = -dx;
        int ind = this.addPoint(p.x - dlx * lw, p.y - dly * lw, lw > 0.0f ? 1.0f : 0.0f, 0.0f);
        this.addLeft(ind);
        this.triLeft(ind);
        ind = this.addPoint(p.x + dlx * rw, p.y + dly * rw, rw > 0.0f ? 1.0f : 0.0f, 0.0f);
        this.addRight(ind);
        this.triRight(ind);
    }

    private void startSquare(Point p, float dx, float dy, float lw, float rw, float d) {
        float px = p.x - dx * d;
        float py = p.y - dy * d;
        float dlx = dy;
        float dly = -dx;
        float leftmark = lw > 0.0f ? 1.0f : 0.0f;
        float rghtmark = rw > 0.0f ? 1.0f : 0.0f;
        this.iback2 = this.addPoint(px - dlx * lw, py - dly * lw, leftmark, -1.0f);
        this.addLeft(this.iback2);
        this.iback1 = this.addPoint(px + dlx * rw, py + dly * rw, rghtmark, -1.0f);
        this.addRight(this.iback1);
        px = p.x;
        py = p.y;
        int ind = this.addPoint(px - dlx * lw, py - dly * lw, leftmark, 0.0f);
        this.addLeft(ind);
        this.triLeft(ind);
        ind = this.addPoint(px + dlx * rw, py + dly * rw, rghtmark, 0.0f);
        this.addRight(ind);
        this.triRight(ind);
    }

    private void endSquare(Point p, float dx, float dy, float lw, float rw, float d) {
        float px = p.x;
        float py = p.y;
        float dlx = dy;
        float dly = -dx;
        float leftmark = lw > 0.0f ? 1.0f : 0.0f;
        float rghtmark = rw > 0.0f ? 1.0f : 0.0f;
        int ind = this.addPoint(px - dlx * lw, py - dly * lw, leftmark, 0.0f);
        this.triLeft(ind);
        ind = this.addPoint(px + dlx * rw, py + dly * rw, rghtmark, 0.0f);
        this.triRight(ind);
        px = p.x + dx * d;
        py = p.y + dy * d;
        ind = this.addPoint(px - dlx * lw, py - dly * lw, leftmark, 1.0f);
        this.addLeft(ind);
        this.triLeft(ind);
        ind = this.addPoint(px + dlx * rw, py + dly * rw, rghtmark, 1.0f);
        this.addRight(ind);
        this.triRight(ind);
    }

    private void startRound(Point p, float dx, float dy, float lw, float rw, int nCap) {
        float dlx = dy;
        float dly = -dx;
        float w = (lw + rw) / 2.0f;
        float px = p.x + (dlx * rw - dlx * lw) / 2.0f;
        float py = p.y + (dly * rw - dly * lw) / 2.0f;
        float leftmark = lw > 0.0f ? 1.0f : 0.0f;
        float rghtmark = rw > 0.0f ? 1.0f : 0.0f;
        int center = this.addPoint(px, py, 0.0f, 0.0f);
        int first = this.addPoint(px - dlx * w, py - dly * w, leftmark, 0.0f);
        this.iback1 = center;
        this.iback2 = first;
        this.addLeft(first);
        int ind = first;
        for (int i = 0; i < nCap; ++i) {
            float a = (float)((double)i * Math.PI / (double)(nCap - 1));
            float cx = (float)Math.cos(a);
            float ax = cx * w;
            float ay = (float)(Math.sin(a) * (double)w);
            ind = this.addPoint(px - dlx * ax - dx * ay, py - dly * ax - dy * ay, leftmark * (1.0f + cx) / 2.0f + rghtmark * (1.0f - cx) / 2.0f, -1.0f * ay / w);
            this.addRight(ind);
            this.triRight(ind);
            this.iback2 = this.iback1;
            this.iback1 = center;
        }
        this.iback1 = ind;
        this.iback2 = first;
    }

    private void endRound(Point p, float dx, float dy, float lw, float rw, int nCap) {
        int center;
        float dlx = dy;
        float dly = -dx;
        float w = (lw + rw) / 2.0f;
        float px = p.x + (dlx * rw - dlx * lw) / 2.0f;
        float py = p.y + (dly * rw - dly * lw) / 2.0f;
        float leftmark = lw > 0.0f ? 1.0f : 0.0f;
        float rghtmark = rw > 0.0f ? 1.0f : 0.0f;
        int first = this.addPoint(px - dlx * w, py - dly * w, leftmark, 0.0f);
        int last = this.addPoint(px + dlx * w, py + dly * w, rghtmark, 0.0f);
        this.addLeft(first);
        this.triLeft(first);
        this.addRight(last);
        this.triRight(last);
        this.iback1 = center = this.addPoint(px, py, 0.0f, 0.0f);
        for (int i = 1; i < nCap - 1; ++i) {
            float a = (float)((double)i * Math.PI / (double)(nCap - 1));
            float cx = (float)Math.cos(a);
            float ax = cx * w;
            float ay = (float)(Math.sin(a) * (double)w);
            int ind = this.addPoint(px - dlx * ax + dx * ay, py - dly * ax + dy * ay, leftmark * (1.0f + cx) / 2.0f + rghtmark * (1.0f - cx) / 2.0f, 1.0f * ay / w);
            this.addLeft(ind);
            this.triLeft(ind);
            this.iback2 = this.iback1;
            this.iback1 = center;
        }
        this.triLeft(last);
        this.iback1 = center;
    }

    public Poly2 getPolygon() {
        if (this.calculated) {
            Poly2 result = new Poly2();
            result.vertices.addAll(this.verts);
            result.indices.addAll(this.indxs);
            return result;
        }
        return new Poly2();
    }

    public Poly2 getPolygon(Poly2 buffer) {
        if (buffer == null) {
            buffer = new Poly2();
        }
        if (this.calculated) {
            int voff = buffer.vertices.size;
            buffer.vertices.ensureCapacity(this.verts.size);
            buffer.vertices.addAll(this.verts);
            int ioff = buffer.indices.size;
            buffer.indices.ensureCapacity(this.indxs.size);
            for (int ii = 0; ii < this.indxs.size; ++ii) {
                buffer.indices.items[ioff + ii] = (short)(this.indxs.items[ii] + voff);
            }
            buffer.indices.size += this.indxs.size;
        }
        return buffer;
    }

    public Path2[] getBorder() {
        return this.getBorder(new Path2[0]);
    }

    public Path2[] getBorder(Path2[] buffer) {
        if (this.calculated) {
            int size;
            int n = size = this.closed ? 2 : 1;
            if (buffer == null || buffer.length < size) {
                buffer = new Path2[size];
            }
            if (this.closed) {
                Path2 path = new Path2();
                path.closed = true;
                path.vertices.addAll(this.rghts);
                buffer[0] = path;
                path = new Path2();
                path.closed = true;
                path.vertices.addAll(this.lefts);
                buffer[1] = path;
            } else {
                Path2 path = new Path2();
                path.closed = true;
                path.vertices.ensureCapacity(this.rghts.size + this.lefts.size);
                path.vertices.addAll(this.rghts);
                path.vertices.addAll(this.lefts);
                buffer[0] = path;
            }
            return buffer;
        }
        return buffer;
    }

    private int addPoint(float x, float y, float u, float v) {
        int index = this.vSize++;
        this.verts.add(x);
        this.verts.add(y);
        this.sides.add(u);
        this.sides.add(v);
        return index;
    }

    private void addLeft(int index) {
        this.lefts.add(this.verts.get(2 * index));
        this.lefts.add(this.verts.get(2 * index + 1));
    }

    private void addRight(int index) {
        this.rghts.add(this.verts.get(2 * index));
        this.rghts.add(this.verts.get(2 * index + 1));
    }

    private void triLeft(int index) {
        if (PathExtruder.validTri(this.verts.get(this.iback1 * 2), this.verts.get(this.iback1 * 2 + 1), this.verts.get(this.iback2 * 2), this.verts.get(this.iback2 * 2 + 1), this.verts.get(2 * index), this.verts.get(2 * index + 1))) {
            this.indxs.add((short)this.iback2);
            this.indxs.add((short)this.iback1);
            this.indxs.add((short)index);
        }
        this.iback2 = this.iback1;
        this.iback1 = index;
    }

    private void triRight(int index) {
        if (PathExtruder.validTri(this.verts.get(this.iback1 * 2), this.verts.get(this.iback1 * 2 + 1), this.verts.get(this.iback2 * 2), this.verts.get(this.iback2 * 2 + 1), this.verts.get(2 * index), this.verts.get(2 * index + 1))) {
            this.indxs.add((short)this.iback1);
            this.indxs.add((short)this.iback2);
            this.indxs.add((short)index);
        }
        this.iback2 = this.iback1;
        this.iback1 = index;
    }

    private static boolean validTri(float px, float py, float qx, float qy, float rx, float ry) {
        return px * (qy - ry) + qx * (ry - py) + rx * (py - qy) != 0.0f;
    }

    private int curveSegs(float rad, float arc, float tol) {
        float da = (float)(Math.acos(rad / (rad + tol)) * 2.0);
        return Math.max(2, (int)Math.ceil(arc / da));
    }

    private int clampi(int value, int min, int max) {
        return value < min ? min : (value < max ? value : max);
    }

    public static enum Joint {
        MITRE,
        SQUARE,
        ROUND;

    }

    public static enum EndCap {
        BUTT,
        SQUARE,
        ROUND;

    }

    private class Point {
        float x;
        float y;
        float dx;
        float dy;
        float len;
        float dmx;
        float dmy;
        int flags;
        Point next;
        Point prev;

        private Point() {
        }
    }
}

