/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ShortArray;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.math.Poly2;
import edu.cornell.gdiac.math.PolyTriangulator;
import edu.cornell.gdiac.scene2.SceneNode;
import edu.cornell.gdiac.scene2.TexturedNode;

public class PolygonNode
extends TexturedNode {
    protected Poly2 polygon = new Poly2();
    protected float fringe;
    private final Vector2 vectorCache = new Vector2();

    public PolygonNode() {
        this.classname = "PolygonNode";
        this.fringe = 0.0f;
    }

    public PolygonNode(float[] vertices) {
        this((TextureRegion)null, vertices);
    }

    public PolygonNode(Poly2 poly) {
        this((TextureRegion)null, poly);
    }

    public PolygonNode(Rectangle rect) {
        this((TextureRegion)null, rect);
    }

    public PolygonNode(String filename) {
        super(filename);
        int width = this.texture == null ? 0 : this.texture.getRegionWidth();
        int height = this.texture == null ? 0 : this.texture.getRegionHeight();
        this.setPolygon(new Rectangle(0.0f, 0.0f, (float)width, (float)height));
    }

    public PolygonNode(String filename, float[] vertices) {
        this(filename);
        this.setPolygon(vertices);
    }

    public PolygonNode(String filename, Poly2 poly) {
        this(filename);
        this.setPolygon(poly);
    }

    public PolygonNode(String filename, Rectangle rect) {
        this(filename);
        this.setPolygon(rect);
    }

    public PolygonNode(TextureRegion textureregion) {
        super(textureregion);
        this.classname = "Polygon Node";
        int width = this.texture == null ? 0 : this.texture.getRegionWidth();
        int height = this.texture == null ? 0 : this.texture.getRegionHeight();
        this.setPolygon(new Rectangle(0.0f, 0.0f, (float)width, (float)height));
    }

    public PolygonNode(Texture texture) {
        this(new TextureRegion(texture));
    }

    public PolygonNode(TextureRegion textureRegion, float[] vertices) {
        this(textureRegion);
        this.setPolygon(vertices);
    }

    public PolygonNode(Texture texture, float[] vertices) {
        this(new TextureRegion(texture));
        this.setPolygon(vertices);
    }

    public PolygonNode(TextureRegion textureRegion, Poly2 poly) {
        this(textureRegion);
        this.setPolygon(poly);
    }

    public PolygonNode(Texture texture, Poly2 poly) {
        this(new TextureRegion(texture));
        this.setPolygon(poly);
    }

    public PolygonNode(TextureRegion textureRegion, Rectangle rect) {
        this(textureRegion);
        this.setPolygon(rect);
    }

    public PolygonNode(Texture texture, Rectangle rect) {
        this(new TextureRegion(texture));
        this.setPolygon(rect);
    }

    public PolygonNode(AssetDirectory manager, JsonValue data) {
        super(manager, data);
        this.classname = "PolygonNode";
        Vector2 coord = new Vector2(this.getPosition());
        boolean sizeFit = data.has("size");
        Vector2 size = this.getSize();
        if (!data.has("polygon")) {
            Rectangle bounds = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
            if (this.texture != null) {
                bounds.setSize((float)this.texture.getRegionWidth(), (float)this.texture.getRegionHeight());
            } else {
                bounds.setSize(this.getContentWidth(), this.getContentHeight());
            }
            this.polygon.set(bounds);
        }
        Vector2 tmpSize = new Vector2();
        this.setContentSize(this.polygon.getBounds().getSize(tmpSize));
        if (sizeFit) {
            this.setContentSize(size);
        }
        this.setPosition(coord.x, coord.y);
    }

    @Override
    public SceneNode copy(SceneNode dst) {
        super.copy(dst);
        PolygonNode node = (PolygonNode)dst;
        node.polygon = this.polygon;
        node.fringe = this.fringe;
        return dst;
    }

    public void setPolygon(float[] vertices) {
        PolyTriangulator triangulator = new PolyTriangulator();
        this.polygon.set(vertices);
        this.polygon.indices = new ShortArray(new short[0]);
        triangulator.set(vertices);
        triangulator.calculate();
        triangulator.getTriangulation(this.polygon.indices);
        Vector2 size = new Vector2();
        this.setContentSize(this.polygon.getBounds().getSize(size));
        this.updateTextureCoords();
    }

    public void setPolygon(Poly2 poly) {
        this.polygon.set(poly);
        Vector2 size = new Vector2();
        this.setContentSize(this.polygon.getBounds().getSize(size));
        this.updateTextureCoords();
    }

    public void setPolygon(Rectangle rect) {
        this.polygon.set(rect);
        Vector2 size = new Vector2();
        this.setContentSize(this.polygon.getBounds().getSize(size));
        this.updateTextureCoords();
    }

    @Override
    public void draw(SpriteBatch batch, Affine2 transform, Color tint) {
        if (!this.rendered) {
            this.generateRenderData();
        }
        batch.setColor(tint);
        batch.setTexture(this.texture.getTexture());
        batch.setBlendEquation(this.blendEquation);
        batch.setBlendSrcFunc(this.srcFactor);
        batch.setBlendDstFunc(this.dstFactor);
        batch.drawMesh(this.mesh, transform, true);
        if (this.gradient != null) {
            batch.setGradient(null);
        }
    }

    public float getFringe() {
        return this.fringe;
    }

    public void setFringe(float fringe) {
        this.fringe = fringe;
        this.clearRenderData();
    }

    public Poly2 getPolygon() {
        return this.polygon;
    }

    public Rectangle getBoundingRect() {
        return this.polygon.getBounds();
    }

    @Override
    protected void generateRenderData() {
        assert (!this.rendered) : "Render data is already present";
        if (this.texture == null) {
            return;
        }
        this.mesh.set(this.polygon, (float)this.texture.getRegionWidth(), (float)this.texture.getRegionHeight());
        Vector2 nsize = this.getContentSize();
        Vector2 bsize = this.polygon.getBounds().getSize(this.vectorCache);
        Matrix4 shift = new Matrix4();
        boolean adjust = false;
        if (!nsize.equals((Object)bsize)) {
            adjust = true;
            shift.scale(bsize.x > 0.0f ? nsize.x / bsize.x : 0.0f, bsize.y > 0.0f ? nsize.y / bsize.y : 0.0f, 1.0f);
        }
        Vector2 offset = this.polygon.getBounds().getPosition(this.vectorCache);
        if (!this.absolute && !offset.isZero()) {
            adjust = true;
            shift.translate(-offset.x, -offset.y, 0.0f);
        }
        this.rendered = true;
        this.updateTextureCoords();
        if (adjust) {
            this.mesh.mul(shift);
        }
    }

    @Override
    protected void updateTextureCoords() {
        if (!this.rendered) {
            return;
        }
        float width = this.texture.getRegionWidth();
        float height = this.texture.getRegionHeight();
        Vector2 off = this.offset.add(this.polygon.getBounds().x, this.polygon.getBounds().y);
        for (int i = 0; i < this.mesh.vertexCount(); ++i) {
            float s = (this.mesh.getPositionX(i) + off.x) / width;
            float t = (this.mesh.getPositionY(i) + off.y) / height;
            if (this.flipHorizontal) {
                s = 1.0f - s;
            }
            if (!this.flipVertical) {
                t = 1.0f - t;
            }
            this.mesh.setTextureCoord(i, s, t);
            this.mesh.setTextureCoord(i, s * this.texture.getU2() + (1.0f - s) * this.texture.getU(), t * this.texture.getV2() + (1.0f - t) * this.texture.getV());
            if (this.gradient == null) continue;
            s = (this.mesh.getPositionX(i) + off.x) / this.polygon.getBounds().width;
            t = (this.mesh.getPositionY(i) + off.y) / this.polygon.getBounds().height;
            if (this.flipHorizontal) {
                s = 1.0f - s;
            }
            if (!this.flipVertical) {
                t = 1.0f - t;
            }
            this.mesh.setGradientCoord(i, s, t);
        }
    }
}

