/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.math;

import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.ShortArray;
import edu.cornell.gdiac.math.Path2;
import edu.cornell.gdiac.math.Poly2;

public class PolyTriangulator {
    private Vertex[] vertices;
    private int vertsize = 0;
    private int exterior = 0;
    private FloatArray input = new FloatArray();
    private IntArray holes = new IntArray();
    private ShortArray output = new ShortArray();
    private boolean calculated = false;

    public PolyTriangulator() {
    }

    public PolyTriangulator(float[] points) {
        this.set(points);
    }

    public PolyTriangulator(FloatArray points) {
        this.set(points);
    }

    public PolyTriangulator(Path2 path) {
        this.set(path);
    }

    public void set(float[] points) {
        this.set(points, 0, points.length);
    }

    public void set(float[] points, int offset, int length) {
        if (Path2.orientation(points, offset, length) >= 0) {
            throw new IllegalArgumentException("Path orientiation is not CCW");
        }
        this.reset();
        this.exterior = length / 2;
        this.input.addAll(points, offset, length);
    }

    public void set(FloatArray points) {
        this.set(points.items, 0, points.size);
    }

    public void set(Path2 path) {
        if (path.orientation() >= 0) {
            throw new IllegalArgumentException("Path orientiation is not CCW");
        }
        this.reset();
        this.exterior = path.size();
        this.input.addAll(path.vertices);
    }

    public void addHole(float[] points) {
        this.addHole(points, 0, points.length);
    }

    public void addHole(float[] points, int offset, int length) {
        if (Path2.orientation(points, offset, length) <= 0) {
            throw new IllegalArgumentException("Hole orientiation is not CW");
        }
        int size = this.input.size;
        this.holes.add(size);
        this.holes.add(length);
        this.input.addAll(points, offset, length);
    }

    public void addHole(FloatArray points) {
        this.addHole(points.items, 0, points.size);
    }

    public void addHole(Path2 path) {
        if (path.orientation() <= 0) {
            throw new IllegalArgumentException("Path orientiation is not CW");
        }
        int size = this.input.size;
        this.holes.add(size);
        this.holes.add(path.vertices.size);
        this.input.addAll(path.vertices);
    }

    public void reset() {
        this.vertsize = 0;
        this.output.clear();
        this.calculated = false;
    }

    public void clear() {
        this.reset();
        this.input.clear();
        this.holes.clear();
    }

    public void calculate() {
        this.reset();
        if (this.exterior > 0) {
            this.allocateVertices();
            this.removeHoles();
            this.computeTriangles();
        }
        this.calculated = true;
    }

    public short[] getTriangulation() {
        short[] result = new short[this.output.size];
        System.arraycopy(this.output.items, 0, result, 0, this.output.size);
        return result;
    }

    public int getTriangulation(ShortArray buffer) {
        buffer.addAll(this.output);
        return this.output.size;
    }

    public Poly2 getPolygon() {
        Poly2 poly = new Poly2();
        if (this.calculated) {
            poly.vertices.ensureCapacity(this.input.size);
            System.arraycopy(this.input.items, 0, poly.vertices.items, 0, this.input.size);
            poly.vertices.size = this.input.size;
            poly.indices.ensureCapacity(this.output.size);
            System.arraycopy(this.output.items, 0, poly.indices.items, 0, this.output.size);
            poly.indices.size = this.output.size;
        }
        return poly;
    }

    public Poly2 getPolygon(Poly2 buffer) {
        if (this.calculated) {
            int offset = buffer.vertices.size;
            buffer.vertices.ensureCapacity(this.input.size);
            System.arraycopy(this.input.items, 0, buffer.vertices.items, offset, this.input.size);
            buffer.vertices.size += this.input.size;
            offset = buffer.indices.size;
            buffer.indices.ensureCapacity(this.output.size);
            System.arraycopy(this.output.items, 0, buffer.indices.items, offset, this.output.size);
            buffer.indices.size = this.output.size;
        }
        return buffer;
    }

    private void allocateVertices() {
        int holepos = -1;
        int needed = this.input.size / 2 + 2 * this.holes.size;
        if (this.vertices == null || needed > this.vertices.length) {
            this.vertices = new Vertex[needed];
            for (int ii = 0; ii < needed; ++ii) {
                this.vertices[ii] = new Vertex();
            }
        }
        this.vertsize = 0;
        for (int pos = 0; pos < this.input.size / 2; ++pos) {
            this.vertices[pos].set(this.input, pos);
            int start = holepos == -1 ? 0 : this.holes.items[2 * holepos] / 2;
            int end = holepos == -1 ? this.exterior : (this.holes.items[2 * holepos] + this.holes.items[2 * holepos + 1]) / 2;
            this.vertices[pos].prev = pos == start ? this.vertices[end - 1] : this.vertices[pos - 1];
            if (pos == end - 1) {
                ++holepos;
                this.vertices[pos].next = this.vertices[start];
                continue;
            }
            this.vertices[pos].next = this.vertices[pos + 1];
        }
        this.vertsize = this.input.size / 2;
    }

    private void removeHoles() {
        int holessize;
        if (this.holes.size == 0) {
            return;
        }
        int[] holesleft = new int[2 * holessize];
        System.arraycopy(this.holes.items, 0, holesleft, 0, 2 * holessize);
        for (holessize = this.holes.size / 2; holessize > 0; --holessize) {
            boolean hasholes = false;
            int holepart = 0;
            int holeindx = 0;
            for (int ii = 0; ii < holessize; ++ii) {
                if (!hasholes) {
                    hasholes = true;
                    holepart = ii;
                    holeindx = holesleft[2 * ii];
                }
                for (int jj = 0; jj < holesleft[2 * ii + 1]; ++jj) {
                    int index = (holesleft[2 * ii] + jj) / 2;
                    if (!(this.vertices[index].xcoord > this.vertices[holeindx / 2].xcoord)) continue;
                    holepart = ii;
                    holeindx = holesleft[2 * ii] + jj;
                }
            }
            Vertex holepoint = this.vertices[holeindx / 2];
            Vertex bestpoint = null;
            boolean repeat = true;
            Vertex curr = this.vertices[0];
            while (repeat || curr != this.vertices[0]) {
                if (curr.xcoord > holepoint.xcoord && curr.incone(holepoint.xcoord, holepoint.ycoord)) {
                    boolean checkit = true;
                    if (bestpoint != null) {
                        float v2y;
                        float v2x;
                        float v2n;
                        float v1x = curr.xcoord - holepoint.xcoord;
                        float v1y = curr.ycoord - holepoint.ycoord;
                        float v1n = (float)Math.sqrt(v1x * v1x + v1y * v1y);
                        if (v1n != 0.0f) {
                            v1x /= v1n;
                        }
                        if ((v2n = (float)Math.sqrt((v2x = bestpoint.xcoord - holepoint.xcoord) * v2x + (v2y = bestpoint.ycoord - holepoint.ycoord) * v2y)) != 0.0f) {
                            v2x /= v2n;
                        }
                        if (v2x > v1x) {
                            checkit = false;
                        }
                    }
                    if (checkit) {
                        boolean pointvisible = true;
                        for (int ii = 0; pointvisible && ii < holessize; ++ii) {
                            for (int jj = 0; pointvisible && jj < holesleft[2 * ii + 1]; ++jj) {
                                int checkindx = (holesleft[2 * ii] + jj) / 2;
                                Vertex checkpt = this.vertices[checkindx];
                                Vertex nextpt = checkpt.next;
                                if (!PolyTriangulator.intersects(holepoint.xcoord, holepoint.ycoord, curr.xcoord, curr.ycoord, checkpt.xcoord, checkpt.ycoord, nextpt.xcoord, nextpt.ycoord)) continue;
                                pointvisible = false;
                            }
                        }
                        if (pointvisible) {
                            bestpoint = curr;
                        }
                    }
                }
                repeat = false;
                curr = curr.next;
            }
            if (bestpoint == null) {
                return;
            }
            Vertex holecopy = this.vertices[this.vertsize];
            Vertex bestcopy = this.vertices[this.vertsize + 1];
            this.vertsize += 2;
            holepoint.copy(holecopy);
            bestpoint.copy(bestcopy);
            bestpoint.prev.next = bestcopy;
            holepoint.prev.next = holecopy;
            bestpoint.prev = holecopy;
            holecopy.next = bestpoint;
            bestcopy.next = holepoint;
            holepoint.prev = bestcopy;
            holesleft[2 * holepart] = holesleft[2 * holessize - 2];
            holesleft[2 * holepart + 1] = holesleft[2 * holessize - 1];
        }
    }

    private void computeTriangles() {
        int ii;
        if (this.vertsize == 3) {
            this.output.add(0);
            this.output.add(1);
            this.output.add(2);
            return;
        }
        for (ii = 0; ii < this.vertsize; ++ii) {
            this.vertices[ii].update();
        }
        this.output.ensureCapacity(3 * (this.vertsize - 3));
        for (ii = 0; ii < this.vertsize - 3; ++ii) {
            Vertex bestear = null;
            for (int jj = 0; jj < this.vertsize; ++jj) {
                Vertex v = this.vertices[jj];
                if (!v.active || !v.eartip) continue;
                if (bestear == null) {
                    bestear = v;
                    continue;
                }
                if (!(v.angle > bestear.angle)) continue;
                bestear = v;
            }
            if (bestear == null) {
                System.err.println("Could not find a suitable ear");
                return;
            }
            this.output.add(bestear.prev.index);
            this.output.add(bestear.index);
            this.output.add(bestear.next.index);
            bestear.active = false;
            bestear.prev.next = bestear.next;
            bestear.next.prev = bestear.prev;
            if (ii == this.vertsize - 4) continue;
            bestear.prev.update();
            bestear.next.update();
        }
        boolean open = true;
        for (int ii2 = 0; open && ii2 < this.vertsize; ++ii2) {
            if (!this.vertices[ii2].active) continue;
            this.output.add(this.vertices[ii2].prev.index);
            this.output.add(this.vertices[ii2].index);
            this.output.add(this.vertices[ii2].next.index);
            open = false;
        }
    }

    private static boolean intersects(float p11x, float p11y, float p12x, float p12y, float p21x, float p21y, float p22x, float p22y) {
        if (p11x == p21x && p11y == p21y || p11x == p22x && p11y == p22y || p12x == p21x && p12y == p21y || p12x == p22x && p12y == p22y) {
            return false;
        }
        float v1ortx = p12y - p11y;
        float v1orty = p11x - p12x;
        float v2ortx = p22y - p21y;
        float v2orty = p21x - p22x;
        float dot21 = v1ortx * (p21x - p11x) + v1orty * (p21y - p11y);
        float dot22 = v1ortx * (p22x - p11x) + v1orty * (p22y - p11y);
        float dot11 = v2ortx * (p11x - p21x) + v2orty * (p11y - p21y);
        float dot12 = v2ortx * (p12x - p21x) + v2orty * (p12y - p21y);
        return !(dot11 * dot12 > 0.0f) && !(dot21 * dot22 > 0.0f);
    }

    private class Vertex {
        public int index = 0;
        public float xcoord = 0.0f;
        public float ycoord = 0.0f;
        public float angle = 0.0f;
        public boolean eartip = false;
        public boolean active = true;
        public Vertex next;
        public Vertex prev;

        public Vertex() {
        }

        public Vertex(float[] input, int pos) {
            this.index = pos;
            this.xcoord = input[2 * pos];
            this.ycoord = input[2 * pos + 1];
        }

        public Vertex(FloatArray input, int pos) {
            this.index = pos;
            this.xcoord = input.items[2 * pos];
            this.ycoord = input.items[2 * pos + 1];
        }

        public void set(float[] input, int pos) {
            this.index = pos;
            this.xcoord = input[2 * pos];
            this.ycoord = input[2 * pos + 1];
            this.angle = 0.0f;
            this.eartip = false;
            this.active = true;
            this.next = null;
            this.prev = null;
        }

        public void set(FloatArray input, int pos) {
            this.index = pos;
            this.xcoord = input.items[2 * pos];
            this.ycoord = input.items[2 * pos + 1];
            this.angle = 0.0f;
            this.eartip = false;
            this.active = true;
            this.next = null;
            this.prev = null;
        }

        public void copy(Vertex dst) {
            dst.index = this.index;
            dst.xcoord = this.xcoord;
            dst.ycoord = this.ycoord;
            dst.angle = this.angle;
            dst.eartip = this.eartip;
            dst.active = this.active;
            dst.next = this.next;
            dst.prev = this.prev;
        }

        public boolean convex() {
            return this.convex(this.prev.xcoord, this.prev.ycoord, this.xcoord, this.ycoord, this.next.xcoord, this.next.ycoord);
        }

        public boolean convex(float p1x, float p1y, float p2x, float p2y, float p3x, float p3y) {
            float tmp = (p3y - p1y) * (p2x - p1x) - (p3x - p1x) * (p2y - p1y);
            return tmp > 0.0f;
        }

        public boolean inside(float px, float py) {
            if (this.convex(this.prev.xcoord, this.prev.ycoord, px, py, this.xcoord, this.ycoord)) {
                return false;
            }
            if (this.convex(this.xcoord, this.ycoord, px, py, this.next.xcoord, this.next.ycoord)) {
                return false;
            }
            return !this.convex(this.next.xcoord, this.next.ycoord, px, py, this.prev.xcoord, this.prev.ycoord);
        }

        public boolean incone(float px, float py) {
            if (this.convex()) {
                return this.convex(this.prev.xcoord, this.prev.ycoord, this.xcoord, this.ycoord, px, py) && this.convex(this.xcoord, this.ycoord, this.next.xcoord, this.next.ycoord, px, py);
            }
            return this.convex(this.prev.xcoord, this.prev.ycoord, this.xcoord, this.ycoord, px, py) || this.convex(this.xcoord, this.ycoord, this.next.xcoord, this.next.ycoord, px, py);
        }

        public void update() {
            float v3len2;
            float v1x = this.prev.xcoord - this.xcoord;
            float v1y = this.prev.ycoord - this.ycoord;
            float v3x = this.next.xcoord - this.xcoord;
            float v3y = this.next.ycoord - this.ycoord;
            float v1len2 = (float)Math.sqrt(v1x * v1x + v1y * v1y);
            if (v1len2 != 0.0f) {
                v1x /= v1len2;
                v1y /= v1len2;
            }
            if ((v3len2 = (float)Math.sqrt(v3x * v3x + v3y * v3y)) != 0.0f) {
                v3x /= v3len2;
                v3y /= v3len2;
            }
            this.angle = v1x * v3x + v1y * v3y;
            if (this.convex()) {
                this.eartip = true;
                Vertex curr = this.next.next;
                while (curr != this.prev) {
                    boolean test;
                    boolean bl = test = curr.index != this.index && curr.index != this.prev.index && curr.index != this.next.index;
                    if (test && this.inside(curr.xcoord, curr.ycoord)) {
                        this.eartip = false;
                    }
                    curr = curr.next;
                }
            } else {
                this.eartip = false;
            }
        }
    }
}

