/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntIntMap;
import com.badlogic.gdx.utils.Pool;
import edu.cornell.gdiac.graphics.Gradient;
import edu.cornell.gdiac.graphics.Scissor;
import edu.cornell.gdiac.graphics.Shader;
import edu.cornell.gdiac.graphics.SpriteMesh;
import edu.cornell.gdiac.graphics.Stencil;
import edu.cornell.gdiac.graphics.TextLayout;
import edu.cornell.gdiac.graphics.TexturedMesh;
import edu.cornell.gdiac.graphics.UniformBuffer;
import edu.cornell.gdiac.graphics.VertexBuffer;
import edu.cornell.gdiac.graphics.shaders.SpriteShader;
import edu.cornell.gdiac.math.Path2;
import edu.cornell.gdiac.math.Poly2;
import java.util.Iterator;
import java.util.LinkedList;

public class SpriteBatch
implements Batch {
    private GL20 gl;
    private final float[] vertices;
    final int vertStride;
    private int vertSize;
    private final short[] indices;
    private int indxSize;
    boolean drawing = false;
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private float packedColor = Color.WHITE_FLOAT_BITS;
    private int vertTotal;
    private int renderCalls = 0;
    private int totalRenderCalls = 0;
    private ShaderProgram shader;
    private boolean ownsShader;
    private UniformBuffer unifBuff;
    private VertexBuffer vertBuff;
    private Context context;
    private boolean inflight;
    private ContextPool memory;
    private LinkedList<Context> history;
    private LinkedList<TextLayout> textList;
    private LayoutPool textPool;
    private Gradient gradient;
    private Scissor scissor;
    private final Matrix4 projectionCache;
    private final Matrix4 transformCache;
    private final Affine2 affineCache;
    private final Vector2 vectorCache;
    private final Color colorCache;
    private final float[] uniformBlockData;
    private final IntIntMap offsets;
    public static final int DEFAULT_CAPACITY = 8192;
    private static final int TYPE_TEXTURE = 1;
    private static final int TYPE_GRADIENT = 2;
    private static final int TYPE_SCISSOR = 4;
    private static final int TYPE_GAUSSBLUR = 8;
    private static final int DIRTY_COMMAND = 1;
    private static final int DIRTY_BLENDSTATE = 2;
    private static final int DIRTY_BLENDFACTOR = 4;
    private static final int DIRTY_DRAWTYPE = 8;
    private static final int DIRTY_MATRIX = 16;
    private static final int DIRTY_STENCIL_EFFECT = 32;
    private static final int DIRTY_STENCIL_CLEAR = 64;
    private static final int DIRTY_TEXTURE = 128;
    private static final int DIRTY_UNIBLOCK = 256;
    private static final int DIRTY_BLURSTEP = 512;
    private static final int DIRTY_ALL_VALS = 1023;

    public SpriteBatch() {
        this(1000, null);
    }

    public SpriteBatch(int size) {
        this(size, null);
    }

    public SpriteBatch(int size, Shader shader) {
        if (size > 10000) {
            throw new IllegalArgumentException("Can't have more than 10000 vertices per batch: " + size);
        }
        this.gl = Gdx.gl30;
        boolean is30 = true;
        if (this.gl == null) {
            this.gl = Gdx.gl20;
            is30 = false;
        }
        int n = this.vertStride = is30 ? 7 : 5;
        if (shader == null) {
            this.shader = SpriteShader.createShader(is30);
            this.ownsShader = true;
        } else {
            this.shader = shader;
            this.ownsShader = false;
        }
        this.shader.bind();
        this.vertices = new float[size * this.vertStride];
        this.indices = new short[size * 3];
        if (is30) {
            this.vertBuff = new VertexBuffer(SpriteShader.ATTRIBUTE_OFFSET[4], size, size * 3);
            this.vertBuff.setupAttribute("a_gradCoords", 2, 5126, false, SpriteShader.ATTRIBUTE_OFFSET[3]);
        } else {
            this.vertBuff = new VertexBuffer(SpriteShader.ATTRIBUTE_OFFSET[3], size, size * 3);
        }
        this.vertBuff.setupAttribute("a_position", 2, 5126, false, SpriteShader.ATTRIBUTE_OFFSET[0]);
        this.vertBuff.setupAttribute("a_color", 4, 5121, true, SpriteShader.ATTRIBUTE_OFFSET[1]);
        this.vertBuff.setupAttribute("a_texCoord", 2, 5126, false, SpriteShader.ATTRIBUTE_OFFSET[2]);
        this.vertBuff.attach(this.shader);
        if (is30) {
            this.unifBuff = new UniformBuffer(1280, size / 3);
            this.unifBuff.setOffset("scMatrix", 0);
            this.unifBuff.setOffset("scExtent", 48);
            this.unifBuff.setOffset("scScale", 56);
            this.unifBuff.setOffset("gdMatrix", 64);
            this.unifBuff.setOffset("gdInner", 112);
            this.unifBuff.setOffset("gdOuter", 128);
            this.unifBuff.setOffset("gdExtent", 144);
            this.unifBuff.setOffset("gdRadius", 152);
            this.unifBuff.setOffset("gdFeathr", 156);
            ((Shader)this.shader).setUniformBlock("u_context", this.unifBuff);
            this.uniformBlockData = new float[40];
        } else {
            this.uniformBlockData = null;
        }
        this.scissor = null;
        this.gradient = null;
        this.memory = new ContextPool();
        this.context = this.memory.obtain();
        this.context.dirty = 1023;
        this.history = new LinkedList();
        this.textList = new LinkedList();
        this.textPool = new LayoutPool();
        this.transformCache = new Matrix4();
        this.projectionCache = new Matrix4();
        this.affineCache = new Affine2();
        this.vectorCache = new Vector2();
        this.colorCache = new Color();
        this.offsets = new IntIntMap();
        this.drawing = false;
        this.projectionCache.setToOrtho2D(0.0f, 0.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
    }

    public void dispose() {
        if (this.ownsShader && this.shader != null) {
            this.shader.dispose();
        }
        if (this.vertBuff != null) {
            this.vertBuff.dispose();
        }
        if (this.unifBuff != null) {
            this.unifBuff.dispose();
        }
    }

    public boolean isDrawing() {
        return this.drawing;
    }

    public void setShader(Shader shader) {
        if (this.drawing) {
            throw new IllegalStateException("Attempt to reassign shader while drawing is active");
        }
        if (shader == null) {
            throw new NullPointerException("Shader cannot be null");
        }
        this.vertBuff.detach();
        this.shader = shader;
        this.vertBuff.attach(this.shader);
        if (Gdx.gl30 != null) {
            ((Shader)this.shader).setUniformBlock("u_context", this.unifBuff);
        }
    }

    public void setShader(ShaderProgram shader) {
        Shader glShader;
        if (this.shader == shader) {
            return;
        }
        try {
            glShader = (Shader)shader;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Shader " + shader + " is not a GL30 compliant shader");
        }
        this.setShader(glShader);
    }

    public ShaderProgram getShader() {
        return this.shader;
    }

    public void setColor(Color tint) {
        this.color.set(tint);
        this.packedColor = tint.toFloatBits();
    }

    public void setColor(float r, float g, float b, float a) {
        this.color.set(r, g, b, a);
        this.packedColor = this.color.toFloatBits();
    }

    public Color getColor() {
        return this.color;
    }

    public void setPackedColor(float packed) {
        Color.abgr8888ToColor((Color)this.color, (float)packed);
        this.packedColor = packed;
    }

    public float getPackedColor() {
        return this.packedColor;
    }

    public boolean isBlendingEnabled() {
        return this.context.blending;
    }

    public void enableBlending() {
        if (!this.context.blending) {
            if (this.inflight) {
                this.record();
            }
            this.context.blending = true;
            this.context.dirty |= 2;
        }
    }

    public void disableBlending() {
        if (this.context.blending) {
            if (this.inflight) {
                this.record();
            }
            this.context.blending = false;
            this.context.dirty |= 2;
        }
    }

    public void setBlendMode(BlendMode mode) {
        switch (mode) {
            case PREMULT: {
                this.enableBlending();
                this.setBlendFunction(770, 771);
                break;
            }
            case ALPHA_BLEND: {
                this.enableBlending();
                this.setBlendFunction(770, 771);
                break;
            }
            case ADDITIVE: {
                this.enableBlending();
                this.setBlendFunction(770, 1);
                break;
            }
            case OPAQUE: {
                this.disableBlending();
                this.setBlendFunction(1, 0);
            }
        }
    }

    public void setBlendFunction(int srcFactor, int dstFactor) {
        if (this.context.srcFactor != srcFactor || this.context.dstFactor != dstFactor) {
            if (this.inflight) {
                this.record();
            }
            this.context.srcFactor = srcFactor;
            this.context.dstFactor = dstFactor;
            this.context.dirty |= 4;
        }
    }

    public void setBlendFunctionSeparate(int srcFactorColor, int dstFactorColor, int srcFactorAlpha, int dstFactorAlpha) {
        if (this.context.srcFactor != srcFactorColor || this.context.dstFactor != dstFactorColor || this.context.srcFactor != srcFactorAlpha || this.context.dstFactorAlpha != dstFactorAlpha) {
            if (this.inflight) {
                this.record();
            }
            this.context.srcFactor = srcFactorColor;
            this.context.dstFactor = dstFactorColor;
            this.context.srcFactorAlpha = srcFactorAlpha;
            this.context.dstFactorAlpha = dstFactorAlpha;
            this.context.dirty |= 4;
        }
    }

    public void setBlendSrcFunc(int func) {
        this.setBlendSrcFunc(func, func);
    }

    public void setBlendSrcFunc(int rgb, int alpha) {
        if (this.context.srcFactor != rgb || this.context.srcFactor != alpha) {
            if (this.inflight) {
                this.record();
            }
            this.context.srcFactor = rgb;
            this.context.srcFactorAlpha = alpha;
            this.context.dirty |= 4;
        }
    }

    public int getBlendSrcFunc() {
        return this.context.srcFactor;
    }

    public int getBlendSrcFuncAlpha() {
        if (this.context.srcFactorAlpha != -1) {
            return this.context.srcFactorAlpha;
        }
        return this.context.srcFactor;
    }

    public void setBlendDstFunc(int func) {
        this.setBlendDstFunc(func, func);
    }

    public void setBlendDstFunc(int rgb, int alpha) {
        if (this.context.dstFactor != rgb || this.context.dstFactor != alpha) {
            if (this.inflight) {
                this.record();
            }
            this.context.dstFactor = rgb;
            this.context.dstFactorAlpha = alpha;
            this.context.dirty |= 4;
        }
    }

    public int getBlendDstFunc() {
        return this.context.dstFactor;
    }

    public int getBlendDstFuncAlpha() {
        if (this.context.dstFactorAlpha != -1) {
            return this.context.dstFactorAlpha;
        }
        return this.context.dstFactor;
    }

    public void setBlendEquation(int equation) {
        if (this.context.blendEquation != equation) {
            if (this.inflight) {
                this.record();
            }
            this.context.blendEquation = equation;
            this.context.dirty |= 2;
        }
    }

    public int getBlendEquation() {
        return this.context.blendEquation;
    }

    public void setBlur(float radius) {
        if (this.context.blurstep == radius) {
            return;
        }
        if (this.inflight) {
            this.record();
        }
        if (radius == 0.0f) {
            this.context.dirty = this.context.dirty | 0x200 | 8;
            this.context.type &= 0xFFFFFFF7;
        } else if (this.context.blurstep == 0.0f) {
            this.context.dirty = this.context.dirty | 0x200 | 8;
            this.context.type |= 8;
        } else {
            this.context.dirty |= 0x200;
        }
        this.context.blurstep = radius;
    }

    public float getBlur() {
        return this.context.blurstep;
    }

    public Matrix4 getProjectionMatrix() {
        return new Matrix4(this.context.perspective);
    }

    public Matrix4 getTransformMatrix() {
        return new Matrix4(this.transformCache);
    }

    public void setProjectionMatrix(Matrix4 projection) {
        if (projection == null) {
            projection = this.projectionCache;
        }
        if (!this.context.perspective.equals(projection)) {
            if (this.inflight) {
                this.record();
            }
            this.context.perspective.set(projection);
            this.context.dirty |= 0x10;
        }
    }

    public void setTransformMatrix(Matrix4 transform) {
        if (transform == null) {
            this.transformCache.idt();
        } else {
            this.transformCache.set(transform);
        }
        if (this.inflight) {
            this.record();
        }
        this.context.dirty |= 0x10;
    }

    public Gradient getGradient() {
        if (this.gradient != null) {
            return new Gradient(this.gradient);
        }
        return null;
    }

    public void setGradient(Gradient gradient) {
        if (Gdx.gl30 == null) {
            throw new UnsupportedOperationException("Gradient support requires OpenGL 3.0");
        }
        if (gradient == this.gradient) {
            return;
        }
        if (this.inflight) {
            this.record();
        }
        if (gradient == null) {
            this.context.dirty = this.context.dirty | 0x100 | 8;
            this.context.type &= 0xFFFFFFFD;
            this.gradient = null;
        } else {
            this.context.dirty = this.context.dirty | 0x100 | 8;
            this.context.type |= 2;
            this.gradient = new Gradient(gradient);
        }
    }

    public Scissor getScissor() {
        if (this.scissor != null) {
            return new Scissor(this.scissor);
        }
        return null;
    }

    public void setScissor(Scissor scissor) {
        if (scissor == this.scissor) {
            return;
        }
        if (this.inflight) {
            this.record();
        }
        if (scissor == null) {
            this.context.dirty = this.context.dirty | 0x100 | 8;
            this.context.type &= 0xFFFFFFFB;
            this.scissor = null;
        } else {
            this.context.dirty = this.context.dirty | 0x100 | 8;
            this.context.type |= 4;
            this.scissor = new Scissor(scissor);
        }
    }

    public void setCommand(int command) {
        if (this.context.command != command) {
            if (this.inflight) {
                this.record();
            }
            this.context.command = command;
            this.context.dirty |= 1;
        }
    }

    public int getCommand() {
        return this.context.command;
    }

    public void setTexture(Texture texture) {
        if (texture == null) {
            if (this.context.texture.getTexture() == null) {
                return;
            }
            if (this.inflight) {
                this.record();
            }
            this.context.dirty |= 8;
            this.context.texture.setTexture(null);
            this.context.type &= 0xFFFFFFFE;
        } else if (texture == this.context.texture.getTexture()) {
            this.context.texture.setRegion(texture);
        } else {
            if (this.inflight) {
                this.record();
            }
            if (this.context.texture.getTexture() == null) {
                this.context.dirty = this.context.dirty | 8 | 0x80;
                this.context.texture.setRegion(texture);
                this.context.type |= 1;
            } else {
                this.context.dirty |= 0x80;
                this.context.texture.setRegion(texture);
            }
        }
    }

    public void setTextureRegion(TextureRegion region) {
        if (region == null || region.getTexture() == null) {
            if (this.context.texture.getTexture() == null) {
                return;
            }
            if (this.inflight) {
                this.record();
            }
            this.context.dirty |= 8;
            this.context.texture.setTexture(null);
            this.context.type &= 0xFFFFFFFE;
        } else if (region.getTexture() == this.context.texture.getTexture()) {
            this.context.texture.setRegion(region);
        } else {
            if (this.inflight) {
                this.record();
            }
            if (this.context.texture.getTexture() == null) {
                this.context.dirty = this.context.dirty | 8 | 0x80;
                this.context.texture.setRegion(region);
                this.context.type |= 1;
            } else {
                this.context.dirty |= 0x80;
                this.context.texture.setRegion(region);
            }
        }
    }

    public void setStencilEffect(Stencil.Effect effect) {
        if (this.context.stencil != effect) {
            if (this.inflight) {
                this.record();
            }
            this.context.stencil = effect;
            this.context.dirty |= 0x20;
        }
    }

    public Stencil.Effect getStencilEffect() {
        return this.context.stencil;
    }

    public void clearStencil() {
        if (this.context.cleared != 3) {
            if (this.inflight) {
                this.record();
            }
            this.context.cleared = 3;
            this.context.dirty |= 0x40;
        }
    }

    public void clearHalfStencil(boolean lower) {
        int state;
        int n = state = lower ? 1 : 2;
        if (this.context.cleared != state) {
            if (this.inflight) {
                this.record();
            }
            this.context.cleared |= state;
            this.context.dirty |= 0x40;
        }
    }

    public static Affine2 computeTransform(Vector2 origin, Vector2 position, float angle, Vector2 scale) {
        Affine2 mat = new Affine2();
        return SpriteBatch.computeTransform(mat, origin.x, origin.y, position.x, position.y, angle, scale.x, scale.y);
    }

    public static Affine2 computeTransform(Affine2 mat, Vector2 origin, Vector2 position, float angle, Vector2 scale) {
        return SpriteBatch.computeTransform(mat, origin.x, origin.y, position.x, position.y, angle, scale.x, scale.y);
    }

    public static Affine2 computeTransform(float ox, float oy, float x, float y, float angle, float sx, float sy) {
        Affine2 mat = new Affine2();
        return SpriteBatch.computeTransform(mat, ox, oy, x, y, angle, sx, sy);
    }

    public static Affine2 computeTransform(Affine2 mat, float ox, float oy, float x, float y, float angle, float sx, float sy) {
        mat.idt();
        mat.translate(x, y);
        mat.rotate(angle);
        mat.scale(sx, sy);
        mat.translate(-ox, -oy);
        return mat;
    }

    public void begin() {
        if (this.drawing) {
            throw new IllegalStateException("SpriteBatch.end must be called before begin.");
        }
        this.renderCalls = 0;
        this.vertTotal = 0;
        this.gl.glDepthMask(false);
        this.gl.glDisable(2929);
        this.shader.bind();
        this.vertBuff.bind();
        if (Gdx.gl30 != null) {
            this.unifBuff.bind(false);
            this.unifBuff.deactivate();
        }
        this.context.dirty = 1023;
        this.drawing = true;
    }

    public void begin(Camera camera) {
        this.begin();
        this.setProjectionMatrix(camera.combined);
    }

    public void end() {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before end.");
        }
        if (this.indxSize > 0) {
            this.flush();
        }
        this.drawing = false;
        Stencil.applyEffect(Stencil.Effect.NONE);
        this.gl.glDepthMask(true);
        if (this.isBlendingEnabled()) {
            this.gl.glDisable(3042);
        }
        this.vertBuff.unbind();
    }

    public void flush() {
        boolean is30;
        if (this.indxSize == 0) {
            return;
        }
        if (this.context.first != this.indxSize) {
            this.record();
        }
        this.vertBuff.loadVertexData(this.vertices, this.vertSize * this.vertStride);
        this.vertBuff.loadIndexData(this.indices, this.indxSize);
        boolean bl = is30 = Gdx.gl30 != null;
        if (is30) {
            this.unifBuff.activate();
            this.unifBuff.flush();
        }
        Texture previous = this.context.texture.getTexture();
        Iterator iter = this.history.iterator();
        Context next = null;
        while (iter.hasNext()) {
            next = (Context)iter.next();
            if ((next.dirty & 2) == 2) {
                if (next.blending) {
                    this.gl.glEnable(3042);
                    this.gl.glBlendEquation(next.blendEquation);
                } else {
                    this.gl.glDisable(3042);
                }
            }
            if ((next.dirty & 4) == 4) {
                if (next.srcFactorAlpha != -1 && next.dstFactorAlpha != -1) {
                    this.gl.glBlendFuncSeparate(next.srcFactor, next.dstFactor, next.srcFactorAlpha, next.dstFactorAlpha);
                } else {
                    this.gl.glBlendFunc(next.srcFactor, next.dstFactor);
                }
            }
            if ((next.dirty & 8) == 8) {
                this.shader.setUniformi("u_drawtype", next.type);
            }
            if ((next.dirty & 0x10) == 16) {
                next.perspective.mul(this.transformCache);
                this.shader.setUniformMatrix("u_projTrans", next.perspective);
            }
            if ((next.dirty & 0x80) == 128 && (previous = next.texture.getTexture()) != null) {
                this.gl.glActiveTexture(33984);
                previous.bind();
            }
            if ((next.dirty & 0x100) == 256 && is30) {
                this.unifBuff.setBlock(next.blockptr);
            }
            if ((next.dirty & 0x200) == 512 || (next.dirty & 0x80) == 128) {
                this.blurTexture(next.texture.getTexture(), next.blurstep);
            }
            if ((next.dirty & 0x40) == 64) {
                Stencil.clearBuffer(next.cleared);
            }
            if ((next.dirty & 0x20) == 32) {
                Stencil.applyEffect(next.stencil);
            }
            int amt = next.last - next.first;
            this.vertBuff.draw(next.command, amt, next.first);
            ++this.renderCalls;
            ++this.totalRenderCalls;
        }
        this.vertTotal += this.indxSize;
        this.indxSize = 0;
        this.vertSize = 0;
        if (is30) {
            this.unifBuff.deactivate();
        }
        this.unwind();
        this.context.first = 0;
        this.context.last = 0;
        this.context.blockptr = -1;
    }

    public void fill(Rectangle rect) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.setCommand(4);
        this.prepare(rect.x, rect.y, rect.width, rect.height);
    }

    public void fill(float x, float y, float width, float height) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.setCommand(4);
        this.prepare(x, y, width, height);
    }

    public void fill(Rectangle rect, Vector2 offset) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.affineCache.preTranslate(offset.x, offset.y);
        this.setCommand(4);
        this.prepare(rect.x, rect.y, rect.width, rect.height);
    }

    public void fill(Rectangle rect, float x, float y) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.affineCache.preTranslate(x, y);
        this.setCommand(4);
        this.prepare(rect.x, rect.y, rect.width, rect.height);
    }

    public void fill(Rectangle rect, Vector2 origin, Vector2 scale, float angle, Vector2 offset) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.affineCache.preTranslate(-origin.x, -origin.y);
        this.affineCache.preScale(scale.x, scale.y);
        this.affineCache.preRotate(angle);
        this.affineCache.preTranslate(origin.x + offset.x, origin.y + offset.y);
        this.setCommand(4);
        this.prepare(rect.x, rect.y, rect.width, rect.height);
    }

    public void fill(Rectangle rect, Affine2 transform) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.affineCache.preMul(transform);
        this.setCommand(4);
        this.prepare(rect.x, rect.y, rect.width, rect.height);
    }

    public void fill(Poly2 poly) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.setCommand(4);
        this.prepare(poly);
    }

    public void fill(Poly2 poly, Vector2 offset) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.affineCache.preTranslate(offset.x, offset.y);
        this.setCommand(4);
        this.prepare(poly);
    }

    public void fill(Poly2 poly, float x, float y) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.affineCache.preTranslate(x, y);
        this.setCommand(4);
        this.prepare(poly);
    }

    public void fill(Poly2 poly, Vector2 origin, Vector2 scale, float angle, Vector2 offset) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.affineCache.preTranslate(-origin.x, -origin.y);
        this.affineCache.preScale(scale.x, scale.y);
        this.affineCache.preRotate(angle);
        this.affineCache.preTranslate(offset.x, offset.y);
        this.setCommand(4);
        this.prepare(poly);
    }

    public void fill(Poly2 poly, Affine2 transform) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.set(transform);
        this.setCommand(4);
        this.prepare(poly);
    }

    public void outline(Rectangle rect) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.setCommand(1);
        this.prepare(rect.x, rect.y, rect.width, rect.height);
    }

    public void outline(float x, float y, float width, float height) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.setCommand(1);
        this.prepare(x, y, width, height);
    }

    public void outline(Rectangle rect, Vector2 offset) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.affineCache.translate(offset.x, offset.y);
        this.setCommand(1);
        this.prepare(rect.x, rect.y, rect.width, rect.height);
    }

    public void outline(Rectangle rect, float x, float y) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.affineCache.translate(x, y);
        this.setCommand(1);
        this.prepare(rect.x, rect.y, rect.width, rect.height);
    }

    public void outline(Rectangle rect, Vector2 origin, Vector2 scale, float angle, Vector2 offset) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.affineCache.preTranslate(-origin.x, -origin.y);
        this.affineCache.preScale(scale.x, scale.y);
        this.affineCache.preRotate(angle);
        this.affineCache.preTranslate(origin.x + offset.x, origin.y + offset.y);
        this.setCommand(1);
        this.prepare(rect.x, rect.y, rect.width, rect.height);
    }

    public void outline(Rectangle rect, Affine2 transform) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.set(transform);
        this.setCommand(1);
        this.prepare(rect.x, rect.y, rect.width, rect.height);
    }

    public void outline(Path2 path) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.setCommand(1);
        this.prepare(path);
    }

    public void outline(Path2 path, Vector2 offset) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.affineCache.preTranslate(offset.x, offset.y);
        this.setCommand(1);
        this.prepare(path);
    }

    public void outline(Path2 path, float x, float y) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.affineCache.preTranslate(x, y);
        this.setCommand(1);
        this.prepare(path);
    }

    public void outline(Path2 path, Vector2 origin, Vector2 scale, float angle, Vector2 offset) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.idt();
        this.affineCache.preTranslate(-origin.x, -origin.y);
        this.affineCache.preScale(scale.x, scale.y);
        this.affineCache.preRotate(angle);
        this.affineCache.preTranslate(offset.x, offset.y);
        this.setCommand(1);
        this.prepare(path);
    }

    public void outline(Path2 path, Affine2 transform) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before drawing.");
        }
        this.affineCache.set(transform);
        this.setCommand(1);
        this.prepare(path);
    }

    public void drawMesh(SpriteMesh mesh, Vector2 offset, boolean tint) {
        if (mesh.indices.size > 0) {
            this.setCommand(mesh.command);
            this.affineCache.idt();
            this.affineCache.translate(offset.x, offset.y);
            this.prepare(mesh, tint);
        }
    }

    public void drawMesh(SpriteMesh mesh, float x, float y, boolean tint) {
        if (mesh.indices.size > 0) {
            this.setCommand(mesh.command);
            this.affineCache.idt();
            this.affineCache.translate(x, y);
            this.prepare(mesh, tint);
        }
    }

    public void drawMesh(SpriteMesh mesh, Affine2 transform, boolean tint) {
        if (mesh.indices.size > 0) {
            this.setCommand(mesh.command);
            this.affineCache.set(transform);
            this.prepare(mesh, tint);
        }
    }

    public void drawText(String text, BitmapFont font) {
        TextLayout layout = this.textPool.obtain();
        layout.setText(text);
        layout.setFont(font);
        layout.setColor(this.color);
        layout.setAlignment(72);
        this.textList.add(layout);
        this.drawText(layout);
    }

    public void drawText(String text, BitmapFont font, float x, float y) {
        TextLayout layout = this.textPool.obtain();
        layout.setText(text);
        layout.setFont(font);
        layout.setColor(this.color);
        layout.setAlignment(72);
        this.textList.add(layout);
        this.drawText(layout, x, y);
    }

    public void drawText(String text, BitmapFont font, Vector2 pos) {
        TextLayout layout = this.textPool.obtain();
        layout.setText(text);
        layout.setFont(font);
        layout.setColor(this.color);
        layout.setAlignment(72);
        this.textList.add(layout);
        this.drawText(layout, pos);
    }

    public void drawText(String text, BitmapFont font, Affine2 transform) {
        TextLayout layout = this.textPool.obtain();
        layout.setText(text);
        layout.setFont(font);
        layout.setColor(this.color);
        layout.setAlignment(72);
        this.textList.add(layout);
        this.drawText(layout, transform);
    }

    public void drawText(TextLayout layout) {
        Array<TexturedMesh> meshes = layout.getMeshes();
        this.affineCache.idt();
        for (int ii = 0; ii < meshes.size; ++ii) {
            TexturedMesh m = (TexturedMesh)meshes.get(ii);
            this.setCommand(m.command);
            this.setTextureRegion(m.getTextureRegion());
            this.prepare(m, false);
        }
        this.record();
        this.setTextureRegion(null);
    }

    public void drawText(TextLayout layout, float x, float y) {
        Array<TexturedMesh> meshes = layout.getMeshes();
        this.affineCache.idt();
        this.affineCache.preTranslate(x, y);
        for (int ii = 0; ii < meshes.size; ++ii) {
            TexturedMesh m = (TexturedMesh)meshes.get(ii);
            this.setCommand(m.command);
            this.setTextureRegion(m.getTextureRegion());
            this.prepare(m, false);
        }
    }

    public void drawText(TextLayout layout, Vector2 pos) {
        Array<TexturedMesh> meshes = layout.getMeshes();
        this.affineCache.idt();
        this.affineCache.preTranslate(pos.x, pos.y);
        for (int ii = 0; ii < meshes.size; ++ii) {
            TexturedMesh m = (TexturedMesh)meshes.get(ii);
            this.setCommand(m.command);
            this.setTextureRegion(m.getTextureRegion());
            this.prepare(m, false);
        }
        this.setTextureRegion(null);
    }

    public void drawText(TextLayout layout, Affine2 transform) {
        Array<TexturedMesh> meshes = layout.getMeshes();
        this.affineCache.set(transform);
        for (int ii = 0; ii < meshes.size; ++ii) {
            TexturedMesh m = (TexturedMesh)meshes.get(ii);
            this.setCommand(m.command);
            this.setTextureRegion(m.getTextureRegion());
            this.prepare(m, false);
        }
    }

    public void draw(Texture texture, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation, int srcX, int srcY, int srcWidth, int srcHeight, boolean flipX, boolean flipY) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        this.setTexture(texture);
        if (this.context.texture.getTexture() != null) {
            this.context.texture.setRegionX(srcX);
            this.context.texture.setRegionY(srcY);
            this.context.texture.setRegionWidth(srcWidth);
            this.context.texture.setRegionHeight(srcHeight);
            this.context.texture.flip(flipX, flipY);
        }
        this.affineCache.idt();
        this.affineCache.preTranslate(-originX, -originY);
        this.affineCache.preScale(scaleX, scaleY);
        this.affineCache.preRotate(rotation);
        this.affineCache.preTranslate(originX, originY);
        this.setCommand(4);
        this.prepare(x, y, width, height);
    }

    public void draw(Texture texture, float x, float y, float width, float height, int srcX, int srcY, int srcWidth, int srcHeight, boolean flipX, boolean flipY) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        this.setTexture(texture);
        if (this.context.texture.getTexture() != null) {
            this.context.texture.setRegionX(srcX);
            this.context.texture.setRegionY(srcY);
            this.context.texture.setRegionWidth(srcWidth);
            this.context.texture.setRegionHeight(srcHeight);
            this.context.texture.flip(flipX, flipY);
        }
        this.affineCache.idt();
        this.setCommand(4);
        this.prepare(x, y, width, height);
    }

    public void draw(Texture texture, float x, float y, int srcX, int srcY, int srcWidth, int srcHeight) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        this.setTexture(texture);
        if (this.context.texture.getTexture() != null) {
            this.context.texture.setRegionX(srcX);
            this.context.texture.setRegionY(srcY);
            this.context.texture.setRegionWidth(srcWidth);
            this.context.texture.setRegionHeight(srcHeight);
        }
        this.affineCache.idt();
        this.setCommand(4);
        this.prepare(x, y, srcWidth, srcHeight);
    }

    public void draw(Texture texture, float x, float y, float width, float height, float u, float v, float u2, float v2) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        this.setTexture(texture);
        if (this.context.texture.getTexture() != null) {
            this.context.texture.setU(u);
            this.context.texture.setV(v);
            this.context.texture.setU2(u2);
            this.context.texture.setV2(v2);
        }
        this.affineCache.idt();
        this.setCommand(4);
        this.prepare(x, y, width, height);
    }

    public void draw(Texture texture, float x, float y) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        this.setTexture(texture);
        if (texture != null) {
            this.fill(x, y, texture.getWidth(), texture.getHeight());
        }
    }

    public void draw(Texture texture, float x, float y, float width, float height) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        this.setTexture(texture);
        this.fill(x, y, width, height);
    }

    public void draw(Texture texture, float[] spriteVertices, int offset, int count) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        this.setTexture(texture);
        this.setCommand(4);
        int vcount = count / 5;
        vcount -= vcount % 4;
        if (!this.hasCapacity(vcount, 6 * vcount / 4)) {
            this.flush();
        }
        int gdxstride = 5;
        while (vcount > 0) {
            int vertMax = this.vertices.length / this.vertStride;
            int thisPass = vcount < vertMax - this.vertSize ? vcount : vertMax - this.vertSize;
            thisPass -= thisPass % 4;
            vcount -= thisPass;
            if (this.vertStride == gdxstride) {
                System.arraycopy(spriteVertices, offset, this.vertices, this.vertSize * this.vertStride, thisPass * gdxstride);
            } else {
                for (int ii = 0; ii < thisPass; ++ii) {
                    int pos0 = (this.vertSize + ii) * this.vertStride;
                    int pos1 = offset + gdxstride * ii;
                    this.vertices[pos0] = spriteVertices[pos1];
                    this.vertices[pos0 + 1] = spriteVertices[pos1 + 1];
                    this.vertices[pos0 + 2] = spriteVertices[pos1 + 2];
                    this.vertices[pos0 + 3] = spriteVertices[pos1 + 3];
                    this.vertices[pos0 + 4] = spriteVertices[pos1 + 4];
                    this.vertices[pos0 + 5] = spriteVertices[pos1 + 3];
                    this.vertices[pos0 + 6] = spriteVertices[pos1 + 4];
                }
            }
            int jj = this.vertSize;
            int icount = 6 * thisPass / 4;
            int ii = this.indxSize;
            while (ii < this.indxSize + icount) {
                this.indices[ii] = (short)jj;
                this.indices[ii + 1] = (short)(jj + 1);
                this.indices[ii + 2] = (short)(jj + 2);
                this.indices[ii + 3] = (short)(jj + 2);
                this.indices[ii + 4] = (short)(jj + 3);
                this.indices[ii + 5] = (short)jj;
                ii += 6;
                jj += 4;
            }
            this.indxSize += icount;
            this.vertSize += thisPass;
            if (vcount <= 0) continue;
            this.flush();
        }
        this.inflight = true;
    }

    public void draw(TextureRegion region, float x, float y) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        this.setTextureRegion(region);
        if (region != null) {
            this.fill(x, y, region.getRegionWidth(), region.getRegionHeight());
        }
    }

    public void draw(TextureRegion region, float x, float y, float width, float height) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        this.setTextureRegion(region);
        this.fill(x, y, width, height);
    }

    public void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        this.setTextureRegion(region);
        this.affineCache.idt();
        this.affineCache.preTranslate(-originX, -originY);
        this.affineCache.preScale(scaleX, scaleY);
        this.affineCache.preRotate(rotation);
        this.affineCache.preTranslate(originX, originY);
        this.setCommand(4);
        this.prepare(x, y, width, height);
    }

    public void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation, boolean clockwise) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        this.setTextureRegion(region);
        this.affineCache.idt();
        this.affineCache.preTranslate(-originX, -originY);
        this.affineCache.preScale(scaleX, scaleY);
        this.affineCache.preRotate(clockwise ? -rotation : rotation);
        this.affineCache.preTranslate(originX, originY);
        this.setCommand(4);
        this.prepare(x, y, width, height);
    }

    public void draw(TextureRegion region, float width, float height, Affine2 transform) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        this.setTextureRegion(region);
        this.affineCache.set(transform);
        this.setCommand(4);
        this.prepare(0.0f, 0.0f, width, height);
    }

    public void draw(Texture texture, Poly2 poly, Vector2 offset) {
        this.setTexture(texture);
        this.fill(poly, offset);
    }

    public void draw(TextureRegion region, Poly2 poly, Vector2 offset) {
        this.setTextureRegion(region);
        this.fill(poly, offset);
    }

    public void draw(Texture texture, Poly2 poly, float x, float y) {
        this.setTexture(texture);
        this.fill(poly, x, y);
    }

    public void draw(TextureRegion region, Poly2 poly, float x, float y) {
        this.setTextureRegion(region);
        this.fill(poly, x, y);
    }

    public void draw(Texture texture, Poly2 poly, Affine2 transform) {
        this.setTexture(texture);
        this.fill(poly, transform);
    }

    public void draw(TextureRegion region, Poly2 poly, Affine2 transform) {
        this.setTextureRegion(region);
        this.fill(poly, transform);
    }

    public void draw(Texture texture, Affine2 transform) {
        this.setTexture(texture);
        if (texture != null) {
            this.affineCache.set(transform);
            this.setCommand(4);
            this.prepare(0.0f, 0.0f, texture.getWidth(), texture.getHeight());
        }
    }

    public void draw(TextureRegion region, Affine2 transform) {
        this.setTextureRegion(region);
        if (region != null) {
            this.affineCache.set(transform);
            this.setCommand(4);
            this.prepare(0.0f, 0.0f, region.getRegionWidth(), region.getRegionHeight());
        }
    }

    private boolean hasCapacity(int verts, int indxs) {
        return (this.vertSize + verts) * this.vertStride < this.vertices.length && this.indxSize + indxs < this.indices.length;
    }

    private void record() {
        Context next = this.memory.obtain();
        next.set(this.context);
        this.context.last = this.indxSize;
        next.first = this.indxSize;
        this.history.add(this.context);
        this.context = next;
        this.inflight = false;
    }

    private void unwind() {
        for (Context c : this.history) {
            this.memory.free(c);
        }
        if (this.history.getLast() == this.context) {
            this.context = this.memory.obtain();
        }
        this.history.clear();
        for (TextLayout t : this.textList) {
            this.textPool.free(t);
        }
        this.textList.clear();
    }

    private void setUniformBlock(Context c) {
        if (Gdx.gl30 == null) {
            return;
        }
        if (c.pushed || (c.dirty & 0x100) != 256) {
            return;
        }
        if (c.blockptr + 1 >= this.unifBuff.getBlockCount()) {
            this.flush();
        }
        float[] data = this.uniformBlockData;
        if (this.scissor != null) {
            data = this.scissor.getData(data, 0);
        }
        if (this.gradient != null) {
            data = this.gradient.getData(data, 16);
        }
        ++c.blockptr;
        this.unifBuff.setUniformfv(c.blockptr, 0, 40, data);
        c.pushed = true;
    }

    private void blurTexture(Texture texture, float step) {
        if (texture == null) {
            this.shader.setUniformf("u_blurstep", 0.0f, 0.0f);
            return;
        }
        float width = step / (float)texture.getWidth();
        float height = step / (float)texture.getHeight();
        this.shader.setUniformf("u_blurstep", width, height);
    }

    private int makeRect(float x, float y, float width, float height, boolean solid) {
        int ii = this.vertSize * this.vertStride;
        int jj = this.indxSize;
        this.vertices[ii] = x;
        this.vertices[ii + 1] = y;
        this.vertices[ii + this.vertStride] = x + width;
        this.vertices[ii + this.vertStride + 1] = y;
        this.vertices[ii + this.vertStride * 2] = x + width;
        this.vertices[ii + this.vertStride * 2 + 1] = y + height;
        this.vertices[ii + this.vertStride * 3] = x;
        this.vertices[ii + this.vertStride * 3 + 1] = y + height;
        if (solid) {
            this.indices[jj] = (short)this.vertSize;
            this.indices[jj + 1] = (short)(this.vertSize + 1);
            this.indices[jj + 2] = (short)(this.vertSize + 2);
            this.indices[jj + 3] = (short)(this.vertSize + 2);
            this.indices[jj + 4] = (short)(this.vertSize + 3);
            this.indices[jj + 5] = (short)this.vertSize;
            this.indxSize += 6;
            return 6;
        }
        this.indices[jj] = (short)this.vertSize;
        this.indices[jj + 1] = (short)(this.vertSize + 1);
        this.indices[jj + 2] = (short)(this.vertSize + 1);
        this.indices[jj + 3] = (short)(this.vertSize + 2);
        this.indices[jj + 4] = (short)(this.vertSize + 2);
        this.indices[jj + 5] = (short)(this.vertSize + 3);
        this.indices[jj + 6] = (short)(this.vertSize + 3);
        this.indices[jj + 7] = (short)this.vertSize;
        this.indxSize += 8;
        return 8;
    }

    private void prepare(float x, float y, float width, float height) {
        if (!this.hasCapacity(4, 6)) {
            this.flush();
        }
        float clr = this.packedColor;
        int offset = this.vertSize * this.vertStride;
        this.makeRect(x, y, width, height, this.context.command == 4);
        boolean solid = this.context.texture.getTexture() == null;
        float u1 = solid ? 0.0f : this.context.texture.getU();
        float v1 = solid ? 0.0f : this.context.texture.getV();
        float u2 = solid ? 0.0f : this.context.texture.getU2();
        float v2 = solid ? 0.0f : this.context.texture.getV2();
        for (int ii = 0; ii < 4; ++ii) {
            this.vectorCache.set(this.vertices[offset + ii * this.vertStride], this.vertices[offset + ii * this.vertStride + 1]);
            float s = (this.vectorCache.x - x) / width;
            float t = 1.0f - (this.vectorCache.y - y) / height;
            this.affineCache.applyTo(this.vectorCache);
            this.vertices[offset + ii * this.vertStride] = this.vectorCache.x;
            this.vertices[offset + ii * this.vertStride + 1] = this.vectorCache.y;
            this.vertices[offset + ii * this.vertStride + 2] = clr;
            this.vertices[offset + ii * this.vertStride + 3] = u1 + s * (u2 - u1);
            this.vertices[offset + ii * this.vertStride + 4] = v1 + t * (v2 - v1);
            if (this.vertStride != 7) continue;
            this.vertices[offset + ii * this.vertStride + 5] = this.vertices[offset + ii * this.vertStride + 3];
            this.vertices[offset + ii * this.vertStride + 6] = this.vertices[offset + ii * this.vertStride + 4];
        }
        this.vertSize += 4;
        this.setUniformBlock(this.context);
        this.inflight = true;
    }

    private void prepare(Poly2 poly) {
        if (!this.hasCapacity(poly.size(), poly.indexSize())) {
            this.flush();
        }
        if (!this.hasCapacity(poly.size(), poly.indexSize())) {
            this.chunkify(poly);
            return;
        }
        float clr = this.packedColor;
        int offset = this.vertSize * this.vertStride;
        boolean solid = this.context.texture.getTexture() == null;
        float u1 = solid ? 0.0f : this.context.texture.getU();
        float v1 = solid ? 0.0f : this.context.texture.getV();
        float u2 = solid ? 0.0f : this.context.texture.getU2();
        float v2 = solid ? 0.0f : this.context.texture.getV2();
        float twidth = solid ? 1.0f : (float)this.context.texture.getRegionWidth();
        float theight = solid ? 1.0f : (float)this.context.texture.getRegionHeight();
        for (int ii = 0; ii < poly.size(); ++ii) {
            this.vectorCache.set(poly.vertices.items[2 * ii], poly.vertices.items[2 * ii + 1]);
            float s = this.vectorCache.x / twidth;
            float t = 1.0f - this.vectorCache.y / theight;
            this.affineCache.applyTo(this.vectorCache);
            this.vertices[offset + ii * this.vertStride] = this.vectorCache.x;
            this.vertices[offset + ii * this.vertStride + 1] = this.vectorCache.y;
            this.vertices[offset + ii * this.vertStride + 2] = clr;
            this.vertices[offset + ii * this.vertStride + 3] = u1 + s * (u2 - u1);
            this.vertices[offset + ii * this.vertStride + 4] = v1 + t * (v2 - v1);
            if (this.vertStride != 7) continue;
            this.vertices[offset + ii * this.vertStride + 5] = this.vertices[offset + ii * this.vertStride + 3];
            this.vertices[offset + ii * this.vertStride + 6] = this.vertices[offset + ii * this.vertStride + 4];
        }
        int ioffset = this.indxSize;
        for (int jj = 0; jj < poly.indices.size; ++jj) {
            this.indices[ioffset + jj] = (short)(this.vertSize + poly.indices.items[jj]);
        }
        this.vertSize += poly.size();
        this.indxSize += poly.indexSize();
        this.setUniformBlock(this.context);
        this.inflight = true;
    }

    private void prepare(Path2 path) {
        if (!this.hasCapacity(path.size(), path.indexSize())) {
            this.flush();
        }
        if (!this.hasCapacity(path.size(), path.indexSize())) {
            this.chunkify(path);
            return;
        }
        float clr = this.packedColor;
        int offset = this.vertSize * this.vertStride;
        boolean solid = this.context.texture.getTexture() == null;
        float u1 = solid ? 0.0f : this.context.texture.getU();
        float v1 = solid ? 0.0f : this.context.texture.getV();
        float u2 = solid ? 0.0f : this.context.texture.getU2();
        float v2 = solid ? 0.0f : this.context.texture.getV2();
        float twidth = solid ? 1.0f : (float)this.context.texture.getRegionWidth();
        float theight = solid ? 1.0f : (float)this.context.texture.getRegionHeight();
        for (int ii = 0; ii < path.size(); ++ii) {
            this.vectorCache.set(path.vertices.items[2 * ii], path.vertices.items[2 * ii + 1]);
            float s = this.vectorCache.x / twidth;
            float t = 1.0f - this.vectorCache.y / theight;
            this.affineCache.applyTo(this.vectorCache);
            this.vertices[offset + ii * this.vertStride] = this.vectorCache.x;
            this.vertices[offset + ii * this.vertStride + 1] = this.vectorCache.y;
            this.vertices[offset + ii * this.vertStride + 2] = clr;
            this.vertices[offset + ii * this.vertStride + 3] = u1 + s * (u2 - u1);
            this.vertices[offset + ii * this.vertStride + 4] = v1 + t * (v2 - v1);
            if (this.vertStride != 7) continue;
            this.vertices[offset + ii * this.vertStride + 5] = this.vertices[offset + ii * this.vertStride + 3];
            this.vertices[offset + ii * this.vertStride + 6] = this.vertices[offset + ii * this.vertStride + 4];
        }
        int ioffset = this.indxSize;
        for (int jj = 0; jj < path.size() - 1; ++jj) {
            this.indices[ioffset + 2 * jj] = (short)(this.vertSize + jj);
            this.indices[ioffset + 2 * jj + 1] = (short)(this.vertSize + jj + 1);
        }
        if (path.closed) {
            this.indices[ioffset + 2 * (path.size() - 1)] = (short)(this.vertSize + (path.size() - 1));
            this.indices[ioffset + 2 * (path.size() - 1) + 1] = (short)this.vertSize;
        }
        this.vertSize += path.size();
        this.indxSize += path.indexSize();
        this.setUniformBlock(this.context);
        this.inflight = true;
    }

    private void prepare(SpriteMesh mesh, boolean tint) {
        if (this.inflight && !mesh.isComposable()) {
            this.record();
        }
        if (!this.hasCapacity(mesh.vertexCount(), mesh.indices.size)) {
            this.flush();
        }
        if (!this.hasCapacity(mesh.vertexCount(), mesh.indices.size)) {
            this.chunkify(mesh, tint);
            return;
        }
        tint = tint && !this.color.equals((Object)Color.WHITE);
        boolean solid = this.context.texture.getTexture() == null;
        float u1 = solid ? 0.0f : this.context.texture.getU();
        float v1 = solid ? 0.0f : this.context.texture.getV();
        float u2 = solid ? 0.0f : this.context.texture.getU2();
        float v2 = solid ? 0.0f : this.context.texture.getV2();
        int offset = this.vertSize * this.vertStride;
        for (int ii = 0; ii < mesh.vertexCount(); ++ii) {
            mesh.getPosition(ii, this.vectorCache);
            this.affineCache.applyTo(this.vectorCache);
            this.vertices[offset + ii * this.vertStride] = this.vectorCache.x;
            this.vertices[offset + ii * this.vertStride + 1] = this.vectorCache.y;
            if (tint) {
                mesh.getColor(ii, this.colorCache);
                this.colorCache.mul(this.color);
                this.vertices[offset + ii * this.vertStride + 2] = this.colorCache.toFloatBits();
            } else {
                this.vertices[offset + ii * this.vertStride + 2] = mesh.getPackedColor(ii);
            }
            float s = mesh.getTextureX(ii);
            float t = mesh.getTextureY(ii);
            this.vertices[offset + ii * this.vertStride + 3] = u1 + s * (u2 - u1);
            this.vertices[offset + ii * this.vertStride + 4] = v1 + t * (v2 - v1);
            if (this.vertStride != 7) continue;
            this.vertices[offset + ii * this.vertStride + 5] = mesh.getGradientX(ii);
            this.vertices[offset + ii * this.vertStride + 6] = mesh.getGradientY(ii);
        }
        int ioffset = this.indxSize;
        for (int jj = 0; jj < mesh.indices.size; ++jj) {
            this.indices[ioffset + jj] = (short)(this.vertSize + mesh.indices.items[jj]);
        }
        this.vertSize += mesh.vertexCount();
        this.indxSize += mesh.indices.size;
        this.setUniformBlock(this.context);
        this.inflight = true;
    }

    private void chunkify(Poly2 poly) {
        int chunksize = 3;
        float clr = this.packedColor;
        int offset = this.vertSize * this.vertStride;
        boolean solid = this.context.texture.getTexture() == null;
        float u1 = solid ? 0.0f : this.context.texture.getU();
        float v1 = solid ? 0.0f : this.context.texture.getV();
        float u2 = solid ? 0.0f : this.context.texture.getU2();
        float v2 = solid ? 0.0f : this.context.texture.getV2();
        float twidth = solid ? 1.0f : (float)this.context.texture.getRegionWidth();
        float theight = solid ? 1.0f : (float)this.context.texture.getRegionHeight();
        for (int ii = 0; ii < poly.indices.size; ii += chunksize) {
            if (!this.hasCapacity(chunksize, chunksize)) {
                this.flush();
                this.offsets.clear();
            }
            for (int jj = 0; jj < chunksize; ++jj) {
                short id = poly.indices.items[ii + jj];
                int search = this.offsets.get((int)id, -1);
                if (search != -1) {
                    this.indices[this.indxSize] = (short)search;
                } else {
                    float x = poly.vertices.items[2 * id];
                    float y = poly.vertices.items[2 * id + 1];
                    this.vectorCache.set(x, y);
                    float s = this.vectorCache.x / twidth;
                    float t = 1.0f - this.vectorCache.y / theight;
                    this.affineCache.applyTo(this.vectorCache);
                    int idx = this.vertSize * this.vertStride;
                    this.vertices[idx] = this.vectorCache.x;
                    this.vertices[idx + 1] = this.vectorCache.y;
                    this.vertices[idx + 2] = clr;
                    this.vertices[idx + 3] = u1 + s * (u2 - u1);
                    this.vertices[idx + 4] = v1 + t * (v2 - v1);
                    if (this.vertStride == 7) {
                        this.vertices[idx + 5] = this.vertices[idx + 3];
                        this.vertices[idx + 6] = this.vertices[idx + 4];
                    }
                    this.indices[this.indxSize] = (short)this.vertSize;
                    this.offsets.put((int)id, this.vertSize);
                    ++this.vertSize;
                }
                ++this.indxSize;
            }
        }
        this.setUniformBlock(this.context);
        this.offsets.clear();
        this.inflight = true;
    }

    private void chunkify(Path2 path) {
        int chunksize = 2;
        float clr = this.packedColor;
        int offset = this.vertSize * this.vertStride;
        boolean solid = this.context.texture.getTexture() == null;
        float u1 = solid ? 0.0f : this.context.texture.getU();
        float v1 = solid ? 0.0f : this.context.texture.getV();
        float u2 = solid ? 0.0f : this.context.texture.getU2();
        float v2 = solid ? 0.0f : this.context.texture.getV2();
        float twidth = solid ? 1.0f : (float)this.context.texture.getRegionWidth();
        float theight = solid ? 1.0f : (float)this.context.texture.getRegionHeight();
        for (int ii = 0; ii < path.indexSize(); ii += chunksize) {
            if (!this.hasCapacity(chunksize, chunksize)) {
                this.flush();
                this.offsets.clear();
            }
            for (int jj = 0; jj < chunksize; ++jj) {
                int search;
                int id = ii + jj;
                if (id == path.size() - 1) {
                    int n = id = jj == 0 ? path.size() - 1 : 0;
                }
                if ((search = this.offsets.get(id, -1)) != -1) {
                    this.indices[this.indxSize] = (short)search;
                } else {
                    float x = path.vertices.items[2 * id];
                    float y = path.vertices.items[2 * id + 1];
                    this.vectorCache.set(x, y);
                    float s = this.vectorCache.x / twidth;
                    float t = 1.0f - this.vectorCache.y / theight;
                    this.affineCache.applyTo(this.vectorCache);
                    int indx = this.vertSize * this.vertStride;
                    this.vertices[indx] = this.vectorCache.x;
                    this.vertices[indx + 1] = this.vectorCache.y;
                    this.vertices[indx + 2] = clr;
                    this.vertices[indx + 3] = u1 + s * (u2 - u1);
                    this.vertices[indx + 4] = v1 + t * (v2 - v1);
                    if (this.vertStride == 7) {
                        this.vertices[indx + 5] = this.vertices[indx + 3];
                        this.vertices[indx + 6] = this.vertices[indx + 4];
                    }
                    this.indices[this.indxSize] = (short)this.vertSize;
                    this.offsets.put(id, this.vertSize);
                    ++this.vertSize;
                }
                ++this.indxSize;
            }
        }
        this.setUniformBlock(this.context);
        this.offsets.clear();
        this.inflight = true;
    }

    private void chunkify(SpriteMesh mesh, boolean tint) {
        if (this.inflight && !mesh.isComposable()) {
            this.record();
        }
        int chunksize = this.context.command == 4 ? 3 : 2;
        int start = this.vertSize;
        for (int ii = 0; ii < mesh.indices.size; ii += chunksize) {
            if (!this.hasCapacity(chunksize, chunksize)) {
                this.flush();
                this.offsets.clear();
            }
            for (int jj = 0; jj < chunksize; ++jj) {
                int id = ii + jj;
                int search = this.offsets.get(id, -1);
                if (search != -1) {
                    this.indices[this.indxSize] = (short)search;
                } else {
                    int indx = this.vertSize * this.vertStride;
                    mesh.getPosition(id, this.vectorCache);
                    this.affineCache.applyTo(this.vectorCache);
                    float clr = mesh.getPackedColor(id);
                    if (tint) {
                        mesh.getColor(id, this.colorCache);
                        this.colorCache.mul(this.color);
                        clr = this.colorCache.toFloatBits();
                    }
                    this.vertices[indx] = this.vectorCache.x;
                    this.vertices[indx + 1] = this.vectorCache.y;
                    this.vertices[indx + 2] = clr;
                    this.vertices[indx + 3] = mesh.getTextureX(id);
                    this.vertices[indx + 4] = mesh.getTextureY(id);
                    if (this.vertStride == 7) {
                        this.vertices[indx + 5] = mesh.getGradientX(id);
                        this.vertices[indx + 6] = mesh.getGradientY(id);
                    }
                    this.indices[this.indxSize] = (short)this.vertSize;
                    this.offsets.put(id, this.vertSize);
                    ++this.vertSize;
                }
                ++this.indxSize;
            }
        }
        this.setUniformBlock(this.context);
        this.offsets.clear();
        this.inflight = true;
    }

    private class ContextPool {
        public static final int INITIAL_CAPACITY = 8;
        private LinkedList<Context> freeList;

        public ContextPool() {
            this(8);
        }

        public ContextPool(int capacity) {
            assert (capacity > 0);
            this.freeList = new LinkedList();
            for (int ii = 0; ii < capacity; ++ii) {
                Context c = new Context();
                this.freeList.addLast(c);
            }
        }

        public Context obtain() {
            return this.freeList.isEmpty() ? new Context() : this.freeList.removeLast();
        }

        public void free(Context object) {
            if (object == null) {
                throw new IllegalArgumentException("object cannot be null.");
            }
            object.reset();
            this.freeList.addLast(object);
        }

        public int getFree() {
            return this.freeList.size();
        }
    }

    private static class Context
    implements Pool.Poolable {
        public int first;
        public int last;
        public int type;
        public int command;
        public boolean blending;
        public int blendEquation;
        public int srcFactor;
        public int dstFactor;
        public int srcFactorAlpha;
        public int dstFactorAlpha;
        public Stencil.Effect stencil;
        public int cleared;
        public Matrix4 perspective = new Matrix4();
        public TextureRegion texture = new TextureRegion();
        public int blockptr;
        public float blurstep;
        public int dirty;
        public boolean pushed;

        public Context() {
            this.reset();
        }

        public Context(Context copy) {
            this.set(copy);
        }

        public void set(Context copy) {
            this.first = copy.first;
            this.last = copy.last;
            this.type = copy.type;
            this.command = copy.command;
            this.blending = copy.blending;
            this.blendEquation = copy.blendEquation;
            this.srcFactor = copy.srcFactor;
            this.dstFactor = copy.dstFactor;
            this.srcFactorAlpha = copy.srcFactorAlpha;
            this.dstFactorAlpha = copy.dstFactorAlpha;
            this.perspective.set(copy.perspective);
            this.stencil = copy.stencil;
            this.cleared = 0;
            this.blockptr = copy.blockptr;
            this.blurstep = copy.blurstep;
            this.pushed = false;
            this.dirty = 0;
            if (copy.texture.getTexture() == null) {
                this.texture.setTexture(null);
            } else {
                this.texture.setRegion(copy.texture);
            }
        }

        public void dispose() {
            this.first = 0;
            this.last = 0;
            this.command = 0;
            this.blending = false;
            this.blendEquation = 0;
            this.srcFactor = 0;
            this.dstFactor = 0;
            this.srcFactorAlpha = 0;
            this.dstFactorAlpha = 0;
            this.perspective = null;
            this.texture = new TextureRegion();
            this.stencil = Stencil.Effect.NATIVE;
            this.cleared = 0;
            this.blockptr = -1;
            this.blurstep = 0.0f;
            this.type = 0;
            this.dirty = 0;
            this.pushed = false;
        }

        public void reset() {
            GL30 gl = Gdx.gl30;
            if (gl == null) {
                gl = Gdx.gl20;
            }
            this.first = 0;
            this.last = 0;
            this.command = 4;
            this.blending = true;
            this.blendEquation = 32774;
            this.srcFactor = 770;
            this.dstFactor = 771;
            this.srcFactorAlpha = -1;
            this.dstFactorAlpha = -1;
            this.perspective.setToOrtho2D(0.0f, 0.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
            this.texture.setTexture(null);
            this.stencil = Stencil.Effect.NATIVE;
            this.cleared = 0;
            this.blockptr = -1;
            this.blurstep = 0.0f;
            this.type = 0;
            this.dirty = 0;
            this.pushed = false;
        }
    }

    public class LayoutPool {
        public static final int INITIAL_CAPACITY = 8;
        private LinkedList<TextLayout> freeList;

        public LayoutPool() {
            this(8);
        }

        public LayoutPool(int capacity) {
            assert (capacity > 0);
            this.freeList = new LinkedList();
            for (int ii = 0; ii < capacity; ++ii) {
                TextLayout c = new TextLayout();
                this.freeList.addLast(c);
            }
        }

        public TextLayout obtain() {
            return this.freeList.isEmpty() ? new TextLayout() : this.freeList.removeLast();
        }

        public void free(TextLayout object) {
            if (object == null) {
                throw new IllegalArgumentException("object cannot be null.");
            }
            object.reset();
            this.freeList.addLast(object);
        }

        public int getFree() {
            return this.freeList.size();
        }
    }

    public static enum BlendMode {
        ALPHA_BLEND,
        PREMULT,
        ADDITIVE,
        OPAQUE;

    }
}

