/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.graphics.SpriteMesh;
import edu.cornell.gdiac.graphics.Texture2D;
import edu.cornell.gdiac.scene2.SceneNode;

public class NinePatch
extends SceneNode {
    private TextureRegion texture = null;
    private Rectangle interior;
    private boolean rendered = false;
    private SpriteMesh mesh = new SpriteMesh();
    private int blendEquation = 32774;
    private int srcFactor = 770;
    private int dstFactor = 771;

    public NinePatch() {
        this.classname = "NinePatch";
    }

    public NinePatch(String filename) {
        this();
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("Invalid filename for sprite");
        }
        this.texture = new TextureRegion(new Texture(filename));
        Rectangle bounds = new Rectangle((float)this.texture.getRegionWidth() / 2.0f, (float)this.texture.getRegionHeight() / 2.0f, 1.0f, 1.0f);
        this.initWithTexture(this.texture, bounds);
    }

    public NinePatch(String filename, Rectangle interior) {
        this();
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("Invalid filename for sprite");
        }
        this.texture = new TextureRegion(new Texture(filename));
        this.initWithTexture(this.texture, interior);
    }

    public NinePatch(TextureRegion texture) {
        this();
        if (texture == null) {
            throw new IllegalArgumentException("Invalid texture for sprite");
        }
        Rectangle bounds = new Rectangle((float)texture.getRegionWidth() / 2.0f, (float)texture.getRegionHeight() / 2.0f, 1.0f, 1.0f);
        this.initWithTexture(texture, bounds);
    }

    public NinePatch(Texture texture) {
        this();
        if (texture == null) {
            throw new IllegalArgumentException("Invalid texture for sprite");
        }
        TextureRegion t = new TextureRegion(texture);
        Rectangle bounds = new Rectangle((float)texture.getWidth() / 2.0f, (float)texture.getHeight() / 2.0f, 1.0f, 1.0f);
        this.initWithTexture(t, bounds);
    }

    private void initWithTexture(TextureRegion texture, Rectangle interior) {
        if (this.texture != null) {
            throw new IllegalStateException("NinePatch is already initialized");
        }
        this.setAnchor(new Vector2(0.5f, 0.5f));
        this.setTexture(texture);
        this.setInterior(interior);
        this.setContentSize(texture.getRegionWidth(), texture.getRegionHeight());
    }

    public NinePatch(TextureRegion textureRegion, Rectangle interior) {
        this();
        this.initWithTexture(textureRegion, interior);
    }

    public NinePatch(Texture texture, Rectangle interior) {
        this();
        TextureRegion textRegion = new TextureRegion(texture);
        this.initWithTexture(textRegion, interior);
    }

    public NinePatch(AssetDirectory manager, JsonValue data) {
        super(manager, data);
        this.classname = "NinePatch";
        String textureName = data.getString("texture", "<unknown>");
        this.setTexture(manager.getEntry(textureName, Texture.class));
        if (data.has("interior")) {
            JsonValue rect = data.get("interior");
            if (rect.size != 4) {
                throw new IllegalArgumentException("'interior' must be a 4-element list of numbers");
            }
            float x = rect.getFloat(0);
            float y = rect.getFloat(1);
            float width = rect.getFloat(2);
            float height = rect.getFloat(3);
            this.interior = new Rectangle(x, y, width, height);
        } else {
            this.interior = new Rectangle((float)this.texture.getRegionWidth() / 2.0f, (float)this.texture.getRegionHeight() / 2.0f, 1.0f, 1.0f);
        }
        if (!data.has("size")) {
            this.setContentSize(this.texture.getRegionWidth(), this.texture.getRegionHeight());
        }
    }

    @Override
    public void setContentSize(float width, float height) {
        float actualWidth = Math.max(width, (float)this.texture.getRegionWidth() - this.interior.getWidth());
        float actualHeight = Math.max(height, (float)this.texture.getRegionHeight() - this.interior.getHeight());
        if (actualWidth != width || actualHeight != height) {
            System.err.println("Dimensions for NinePatch '" + this.getName() + "' are too small");
        }
        super.setContentSize(actualWidth, actualHeight);
        this.clearRenderData();
    }

    public void setTexture(TextureRegion texture) {
        TextureRegion temp;
        TextureRegion textureRegion = temp = texture == null ? new TextureRegion((Texture)Texture2D.getBlank()) : texture;
        if (this.texture != temp) {
            this.texture = temp;
            this.clearRenderData();
        }
    }

    public void setTexture(Texture texture) {
        TextureRegion temp;
        TextureRegion textureRegion = temp = texture == null ? new TextureRegion((Texture)Texture2D.getBlank()) : new TextureRegion(texture);
        if (this.texture != temp) {
            this.texture = temp;
            this.clearRenderData();
        }
    }

    public void setTexture(String filename) {
        Texture texture = new Texture(filename);
        this.setTexture(texture);
    }

    public void setInterior(Rectangle interior) {
        this.interior = interior;
        this.clearRenderData();
    }

    public void setBlendFunc(int srcFactor, int dstFactor) {
        this.srcFactor = srcFactor;
        this.dstFactor = dstFactor;
    }

    public int getSourceBlendFactor() {
        return this.srcFactor;
    }

    public int getDestinationBlendFactor() {
        return this.dstFactor;
    }

    public void setBlendEquation(int equation) {
        this.blendEquation = equation;
    }

    public int getBlendEquation() {
        return this.blendEquation;
    }

    @Override
    public String toString(boolean verbose) {
        StringBuilder sb = new StringBuilder();
        if (verbose) {
            sb.append("NinePatch");
        }
        sb.append("(tag:").append(this.getTag());
        sb.append(", name:").append(this.getName());
        sb.append(", texture:").append(this.texture.getTexture().toString()).append(")");
        if (verbose) {
            sb.append("\n");
            for (SceneNode child : this.getChildren()) {
                sb.append("  ").append(child.toString(verbose)).append("\n");
            }
        }
        return sb.toString();
    }

    private void clearRenderData() {
        if (this.mesh != null) {
            this.mesh.clear();
        }
        this.rendered = false;
    }

    private void generateRenderData() {
        if (this.rendered) {
            throw new IllegalStateException("Render data is already present");
        }
        if (this.texture == null) {
            return;
        }
        Vector2 corner = new Vector2();
        corner.x = this.contentSize.x - ((float)this.texture.getRegionWidth() - this.interior.getWidth() - this.interior.x);
        corner.y = this.contentSize.y - ((float)this.texture.getRegionHeight() - this.interior.getHeight() - this.interior.y);
        Rectangle dst = new Rectangle();
        Rectangle src = new Rectangle();
        this.mesh.command = 4;
        int index = 0;
        dst.set(0.0f, 0.0f, this.interior.x, this.interior.y);
        src.set(dst);
        index = this.generatePatch(src, dst, index);
        index = this.generatePatch(src.set(0.0f, this.interior.y, this.interior.x, this.interior.getHeight()), dst.set(0.0f, this.interior.y, this.interior.x, corner.y - this.interior.y), index);
        dst.x = 0.0f;
        dst.y = corner.y;
        dst.width = this.interior.x;
        dst.height = this.contentSize.y - dst.y;
        src.x = 0.0f;
        src.y = this.interior.y + this.interior.getHeight();
        src.width = this.interior.x;
        src.height = (float)this.texture.getRegionHeight() - src.y;
        index = this.generatePatch(src, dst, index);
        dst.x = this.interior.x;
        dst.y = 0.0f;
        dst.width = corner.x - this.interior.x;
        dst.height = this.interior.y;
        src.x = dst.x;
        src.y = dst.y;
        src.width = this.interior.getWidth();
        src.height = this.interior.y;
        index = this.generatePatch(src, dst, index);
        dst.x = this.interior.x;
        dst.y = this.interior.y;
        dst.width = corner.x - this.interior.x;
        dst.height = corner.y - this.interior.y;
        src.x = dst.x;
        src.y = dst.y;
        src.width = this.interior.getWidth();
        src.height = this.interior.getHeight();
        index = this.generatePatch(src, dst, index);
        dst.x = this.interior.x;
        dst.y = corner.y;
        dst.width = corner.x - this.interior.x;
        dst.height = this.contentSize.y - dst.y;
        src.x = this.interior.x;
        src.y = this.interior.y + this.interior.getHeight();
        src.width = this.interior.getWidth();
        src.height = (float)this.texture.getRegionHeight() - src.y;
        index = this.generatePatch(src, dst, index);
        dst.x = corner.x;
        dst.y = 0.0f;
        dst.width = this.contentSize.x - dst.x;
        dst.height = this.interior.y;
        src.x = this.interior.x + this.interior.getWidth();
        src.y = 0.0f;
        src.width = (float)this.texture.getRegionWidth() - src.x;
        src.height = this.interior.y;
        index = this.generatePatch(src, dst, index);
        dst.x = corner.x;
        dst.y = this.interior.y;
        dst.width = this.contentSize.x - dst.x;
        dst.height = corner.y - this.interior.y;
        src.x = this.interior.x + this.interior.getWidth();
        src.y = this.interior.y;
        src.width = (float)this.texture.getRegionWidth() - src.x;
        src.height = this.interior.getHeight();
        index = this.generatePatch(src, dst, index);
        dst.x = corner.x;
        dst.y = corner.y;
        dst.width = this.contentSize.x - corner.x;
        dst.height = this.contentSize.y - corner.y;
        src.x = this.interior.x + this.interior.getWidth();
        src.y = this.interior.y + this.interior.getHeight();
        src.width = (float)this.texture.getRegionWidth() - src.x;
        src.height = (float)this.texture.getRegionHeight() - src.y;
        this.generatePatch(src, dst, index);
        this.rendered = true;
    }

    private int generatePatch(Rectangle src, Rectangle dst, int offset) {
        int twidth = this.texture.getRegionWidth();
        int theight = this.texture.getRegionHeight();
        Color tempColor = Color.WHITE;
        this.mesh.indices.ensureCapacity(6);
        float posx = dst.x;
        float posy = dst.y;
        float textx = src.x / (float)twidth;
        float texty = 1.0f - src.y / (float)theight;
        this.mesh.push(posx, posy, tempColor, textx, texty, 0.0f, 0.0f);
        this.mesh.indices.add(offset);
        posx = dst.x;
        posy = dst.y + dst.getHeight();
        textx = src.x / (float)twidth;
        texty = 1.0f - (src.y + src.getHeight()) / (float)theight;
        this.mesh.push(posx, posy, tempColor, textx, texty, 0.0f, 0.0f);
        this.mesh.indices.add(offset + 1);
        posx = dst.x + dst.getWidth();
        posy = dst.y + dst.getHeight();
        textx = (src.x + src.getWidth()) / (float)twidth;
        texty = 1.0f - (src.y + src.getHeight()) / (float)theight;
        this.mesh.push(posx, posy, tempColor, textx, texty, 0.0f, 0.0f);
        this.mesh.indices.add(offset + 2);
        this.mesh.indices.add(offset);
        this.mesh.indices.add(offset + 2);
        posx = dst.x + dst.getWidth();
        posy = dst.y;
        textx = (src.x + src.getWidth()) / (float)twidth;
        texty = 1.0f - src.y / (float)theight;
        this.mesh.push(posx, posy, tempColor, textx, texty, 0.0f, 0.0f);
        this.mesh.indices.add(offset + 3);
        return offset + 4;
    }

    @Override
    public void draw(SpriteBatch batch, Affine2 transform, Color tint) {
        if (!this.rendered) {
            this.generateRenderData();
        }
        batch.setColor(tint);
        batch.setTextureRegion(this.texture);
        batch.setBlendEquation(this.blendEquation);
        batch.setBlendSrcFunc(this.srcFactor);
        batch.setBlendDstFunc(this.dstFactor);
        batch.drawMesh(this.mesh, transform, true);
    }
}

