/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.math;

import edu.cornell.gdiac.math.Path2;
import java.util.ArrayList;

public class PathSmoother {
    private ArrayList<Float> input;
    private ArrayList<Float> output;
    private float epsilon;
    private boolean calculated;
    private float DEFAULT_EPSILON = 1.0f;

    public PathSmoother() {
        this.clear();
        this.epsilon = this.DEFAULT_EPSILON;
    }

    public PathSmoother(float[] points) {
        this.reset();
        this.epsilon = this.DEFAULT_EPSILON;
        this.set(points);
    }

    public void set(float[] points) {
        this.clear();
        for (float i : points) {
            this.input.add(Float.valueOf(i));
        }
    }

    public void set(Path2 path) {
        this.clear();
        for (float i : path.vertices.items) {
            this.input.add(Float.valueOf(i));
        }
    }

    public void setEpsilon(float epsilon) {
        this.epsilon = epsilon;
    }

    public float getEpsilon() {
        return this.epsilon;
    }

    public void reset() {
        this.output = new ArrayList();
        this.calculated = false;
    }

    public void clear() {
        this.reset();
        this.input = new ArrayList();
    }

    public void calculate() {
        if (!this.calculated) {
            this.douglasPeucker(0, this.input.size() / 2 - 1);
            this.calculated = true;
        }
    }

    private int douglasPeucker(int start, int end) {
        int over = -1;
        float sx = this.input.get(start * 2).floatValue();
        float sy = this.input.get(start * 2 + 1).floatValue();
        float ex = (end == over ? this.input.get(0) : this.input.get(end * 2)).floatValue();
        float ey = (end == over ? this.input.get(1) : this.input.get(end * 2 + 1)).floatValue();
        if (end - start <= 1 || end == over && start == this.input.size() / 2 - 1) {
            this.output.add(Float.valueOf(sx));
            this.output.add(Float.valueOf(sy));
            this.output.add(Float.valueOf(ex));
            this.output.add(Float.valueOf(ey));
            return 2;
        }
        if (sx == ex && sy == ey) {
            this.output.add(Float.valueOf(sx));
            this.output.add(Float.valueOf(sy));
            int index = over;
            for (int i = start + 1; index == over && i < end; ++i) {
                float vx = this.input.get(i * 2).floatValue();
                float vy = this.input.get(i * 2 + 1).floatValue();
                if (vx == sx && vy == sy) continue;
                index = i;
            }
            if (index != over) {
                return this.douglasPeucker(index, end) + 1;
            }
            this.output.add(Float.valueOf(ex));
            this.output.add(Float.valueOf(ey));
            return 2;
        }
        float dMax = 0.0f;
        int index = 0;
        for (int i = start + 1; i < end; ++i) {
            float vy;
            float ux;
            float uy = ey - sy;
            float vx = this.input.get(i * 2).floatValue();
            float dist = (float)Math.abs((double)(uy * vx - (ux = ex - sx) * (vy = this.input.get(i * 2 + 1).floatValue()) + ex * sy - ey * sx) / Math.sqrt(ux * ux + uy * uy));
            if (!(dist > dMax)) continue;
            index = i;
            dMax = dist;
        }
        if (dMax > this.epsilon) {
            int result = 0;
            result += this.douglasPeucker(start, index);
            this.output.remove(this.output.size() - 1);
            this.output.remove(this.output.size() - 1);
            return result += this.douglasPeucker(index, end);
        }
        this.output.add(Float.valueOf(sx));
        this.output.add(Float.valueOf(sy));
        this.output.add(Float.valueOf(ex));
        this.output.add(Float.valueOf(ey));
        return 0;
    }

    public float[] getPoints() {
        float[] res = new float[this.output.size()];
        for (int i = 0; i < this.output.size(); ++i) {
            res[i] = this.output.get(i).floatValue();
        }
        return res;
    }

    public Path2 getPath() {
        float[] res = new float[this.output.size()];
        for (int i = 0; i < this.output.size(); ++i) {
            res[i] = this.output.get(i).floatValue();
        }
        return new Path2(res);
    }
}

