/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.assets.WidgetValue;
import edu.cornell.gdiac.scene2.Button;
import edu.cornell.gdiac.scene2.Label;
import edu.cornell.gdiac.scene2.NinePatch;
import edu.cornell.gdiac.scene2.PathNode;
import edu.cornell.gdiac.scene2.PolygonNode;
import edu.cornell.gdiac.scene2.ProgressBar;
import edu.cornell.gdiac.scene2.SceneNode;
import edu.cornell.gdiac.scene2.ScrollPane;
import edu.cornell.gdiac.scene2.Slider;
import edu.cornell.gdiac.scene2.SpriteNode;
import edu.cornell.gdiac.scene2.WireNode;
import edu.cornell.gdiac.scene2.layout.AnchoredLayout;
import edu.cornell.gdiac.scene2.layout.FloatLayout;
import edu.cornell.gdiac.scene2.layout.GridLayout;
import edu.cornell.gdiac.scene2.layout.Layout;
import java.util.function.BiFunction;
import java.util.function.Function;

public class SceneLoader
extends AsynchronousAssetLoader<SceneNode, SceneParameters> {
    private final ObjectMap<Widget, BiFunction<AssetDirectory, JsonValue, SceneNode>> sceneNodeCreators = new ObjectMap();
    private final ObjectMap<Form, Function<JsonValue, Layout>> formCreators;
    private static final String UNKNOWN_STR = "<unknown>";
    private SceneNode cachedSceneNode;

    public SceneLoader() {
        this((FileHandleResolver)new InternalFileHandleResolver());
    }

    public SceneLoader(FileHandleResolver resolver) {
        super(resolver);
        this.sceneNodeCreators.put((Object)Widget.NODE, SceneNode::new);
        this.sceneNodeCreators.put((Object)Widget.IMAGE, PolygonNode::new);
        this.sceneNodeCreators.put((Object)Widget.SOLID, PolygonNode::new);
        this.sceneNodeCreators.put((Object)Widget.POLY, PolygonNode::new);
        this.sceneNodeCreators.put((Object)Widget.PATH, PathNode::new);
        this.sceneNodeCreators.put((Object)Widget.WIRE, WireNode::new);
        this.sceneNodeCreators.put((Object)Widget.ANIMATE, SpriteNode::new);
        this.sceneNodeCreators.put((Object)Widget.NINE, NinePatch::new);
        this.sceneNodeCreators.put((Object)Widget.LABEL, Label::new);
        this.sceneNodeCreators.put((Object)Widget.BUTTON, Button::new);
        this.sceneNodeCreators.put((Object)Widget.PROGRESS, ProgressBar::new);
        this.sceneNodeCreators.put((Object)Widget.SLIDER, Slider::new);
        this.sceneNodeCreators.put((Object)Widget.SCROLL, ScrollPane::new);
        this.sceneNodeCreators.put((Object)Widget.EXTERNAL_IMPORT, (manager, json) -> {
            JsonValue widgetJson = this.getWidgetJson((AssetDirectory)((Object)manager), (JsonValue)json);
            return this.build((AssetDirectory)((Object)manager), widgetJson);
        });
        this.formCreators = new ObjectMap();
        this.formCreators.put((Object)Form.ANCHORED, AnchoredLayout::new);
        this.formCreators.put((Object)Form.FLOAT, FloatLayout::new);
        this.formCreators.put((Object)Form.GRID, GridLayout::new);
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, SceneParameters parameter) {
        assert (manager instanceof AssetDirectory) : "Expected manager to be an instance of AssetDirectory, but got " + manager.getClass().getName();
        this.cachedSceneNode = this.build((AssetDirectory)manager, parameter.jsonData);
        if (this.cachedSceneNode != null) {
            this.cachedSceneNode.doLayout();
        }
    }

    private SceneNode build(AssetDirectory manager, JsonValue json) {
        JsonValue form;
        String typeStr = json.getString("type", UNKNOWN_STR);
        Widget type = Widget.fromString(typeStr);
        boolean nonRelative = false;
        JsonValue data = json.get("data");
        SceneNode sceneNode = null;
        if (this.sceneNodeCreators.containsKey((Object)type)) {
            ((BiFunction)this.sceneNodeCreators.get((Object)type)).apply(manager, data);
        }
        if (type == Widget.SOLID) {
            nonRelative = true;
        }
        if (sceneNode == null) {
            return null;
        }
        if (Vector2.Zero.equals((Object)sceneNode.getContentSize())) {
            sceneNode.setAnchor(Layout.ANCHOR_BOTTOM_LEFT);
            sceneNode.setContentSize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        }
        String ftypeStr = (form = json.get("format")) == null ? UNKNOWN_STR : form.getString("type", UNKNOWN_STR);
        Form formatType = Form.fromString(ftypeStr);
        Layout layout = null;
        if (this.formCreators.containsKey((Object)formatType)) {
            layout = (Layout)((Function)this.formCreators.get((Object)formatType)).apply(form);
        }
        sceneNode.setLayout(layout);
        JsonValue children = json.get("children");
        if (children != null) {
            for (JsonValue item : children) {
                String key = item.name;
                if ("comment".equals(key)) continue;
                if (item.has("type") && "Widget".equals(item.getString("type"))) {
                    item = this.getWidgetJson(manager, item);
                }
                SceneNode kid = this.build(manager, item);
                if (nonRelative) {
                    kid.setRelativeColor(false);
                }
                sceneNode.addChild(kid);
                if (layout == null || !item.has("layout")) continue;
                JsonValue posit = item.get("layout");
                layout.add(key, posit);
            }
        }
        sceneNode.setName(json.name);
        return sceneNode;
    }

    private JsonValue getWidgetJson(AssetDirectory manager, JsonValue json) {
        String name = json.name;
        JsonValue data = json.get("data");
        JsonValue widgetVars = data.get("variables");
        JsonValue layout = json.get("layout");
        WidgetValue widget = manager.getEntry(data.getString("key"), WidgetValue.class);
        assert (widget != null) : "No widget found with name" + data.getString("key");
        JsonValue contentCopy = widget.substitute(widgetVars);
        contentCopy.setName(name);
        if (layout != null) {
            if (contentCopy.has("layout")) {
                contentCopy.remove("layout");
            }
            contentCopy.addChild("layout", layout);
        }
        if (contentCopy.has("type") && "Widget".equals(contentCopy.getString("type"))) {
            return this.getWidgetJson(manager, contentCopy);
        }
        return contentCopy;
    }

    public SceneNode loadSync(AssetManager manager, String fileName, FileHandle file, SceneParameters parameter) {
        SceneNode sceneNode = this.cachedSceneNode;
        this.cachedSceneNode = null;
        this.attach((AssetDirectory)manager, sceneNode.getName(), sceneNode);
        return sceneNode;
    }

    private void attach(AssetDirectory manager, String key, SceneNode node) {
        for (SceneNode child : node.getChildren()) {
            String local = key + "." + child.getName();
            manager.addEntry(local, SceneNode.class, child);
            this.attach(manager, local, child);
        }
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, SceneParameters params) {
        JsonValue widgets;
        JsonValue fonts;
        Array dependencies = new Array();
        JsonValue textures = params.entireDirectory.get("textures");
        if (textures != null) {
            for (JsonValue texture : textures) {
                String textureFile = texture.isString() ? texture.asString() : texture.getString("file");
                dependencies.add((Object)new AssetDescriptor(textureFile, Texture.class));
            }
        }
        if ((fonts = params.entireDirectory.get("fonts")) != null) {
            for (JsonValue font : fonts) {
                Object fontFile;
                Object object = fontFile = font.isString() ? font.asString() : font.getString("file");
                if (((String)fontFile).toLowerCase().endsWith(".ttf")) {
                    fontFile = ((String)fontFile).substring(0, ((String)fontFile).length() - 4) + ":" + font.getInt("size", 16) + ".ttf";
                }
                dependencies.add((Object)new AssetDescriptor((String)fontFile, BitmapFont.class));
            }
        }
        if ((widgets = params.entireDirectory.get("widgets")) != null) {
            for (JsonValue widget : widgets) {
                String widgetFile = widget.asString();
                dependencies.add((Object)new AssetDescriptor(widgetFile, WidgetValue.class));
            }
        }
        return dependencies;
    }

    public static enum Widget {
        NODE("node"),
        IMAGE("image"),
        SOLID("solid"),
        POLY("polygon"),
        PATH("path"),
        WIRE("wireframe", "wire frame"),
        ORDER("order"),
        CANVAS("canvas"),
        ANIMATE("sprite"),
        NINE("ninepatch"),
        LABEL("label"),
        BUTTON("button"),
        BUTTONGROUP("buttongroup"),
        PROGRESS("progress"),
        SLIDER("slider"),
        SCROLL("scroll", "scroll pane"),
        TEXTFIELD("textfield", "text field"),
        EXTERNAL_IMPORT("widget"),
        UNKNOWN(new String[0]);

        private static final ObjectMap<String, Widget> lookupTable;
        private final String[] aliases;

        private Widget(String ... aliases) {
            this.aliases = aliases;
        }

        public static Widget fromString(String name) {
            return lookupTable.containsKey((Object)name) ? (Widget)((Object)lookupTable.get((Object)name.toLowerCase())) : UNKNOWN;
        }

        static {
            lookupTable = new ObjectMap();
            for (Widget widget : Widget.values()) {
                for (String alias : widget.aliases) {
                    lookupTable.put((Object)alias.toLowerCase(), (Object)widget);
                }
            }
        }
    }

    public static enum Form {
        NONE("none", "absolute"),
        ANCHORED("anchored"),
        FLOAT("float"),
        GRID("grid"),
        UNKNOWN("unknown");

        private static final ObjectMap<String, Form> lookupTable;
        private final String[] aliases;

        private Form(String ... aliases) {
            this.aliases = aliases;
        }

        public static Form fromString(String name) {
            return lookupTable.containsKey((Object)name) ? (Form)((Object)lookupTable.get((Object)name.toLowerCase())) : UNKNOWN;
        }

        static {
            lookupTable = new ObjectMap();
            for (Form form : Form.values()) {
                for (String alias : form.aliases) {
                    lookupTable.put((Object)alias.toLowerCase(), (Object)form);
                }
            }
        }
    }

    public static class SceneParameters
    extends AssetLoaderParameters<SceneNode> {
        public JsonValue entireDirectory;
        public JsonValue jsonData;
    }
}

