/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.ApplicationLogger;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.lwjgl3.DefaultLwjgl3Input;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationBase;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationLogger;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Clipboard;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Cursor;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3FileHandle;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Files;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Input;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3NativesLoader;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Net;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Preferences;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Window;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3WindowConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Sync;
import com.badlogic.gdx.backends.lwjgl3.audio.Lwjgl3Audio;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALLwjgl3Audio;
import com.badlogic.gdx.backends.lwjgl3.audio.mock.MockAudio;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.glutils.GLVersion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLUtil;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.system.Callback;
import org.lwjgl.system.Configuration;

public class Lwjgl3AppShiv
implements Lwjgl3ApplicationBase {
    private final Lwjgl3ApplicationConfiguration config;
    final Array<Lwjgl3Window> windows = new Array();
    private volatile Lwjgl3Window currentWindow;
    public Lwjgl3Audio audio;
    private final Files files;
    private final Net net;
    private final ObjectMap<String, Preferences> preferences = new ObjectMap();
    private final Lwjgl3Clipboard clipboard;
    private int logLevel = 2;
    private ApplicationLogger applicationLogger;
    private volatile boolean running = true;
    private final Array<Runnable> runnables = new Array();
    private final Array<Runnable> executedRunnables = new Array();
    private final Array<LifecycleListener> lifecycleListeners = new Array();
    private static GLFWErrorCallback errorCallback;
    private static GLVersion glVersion;
    private static Callback glDebugCallback;
    private final Sync sync;
    ApplicationListener listener;

    static void initializeGlfw() {
        if (errorCallback == null) {
            if (SharedLibraryLoader.isMac) {
                Lwjgl3AppShiv.loadGlfwAwtMacos();
            }
            Lwjgl3NativesLoader.load();
            errorCallback = GLFWErrorCallback.createPrint((PrintStream)Lwjgl3ApplicationConfiguration.errorStream);
            GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)errorCallback);
            if (SharedLibraryLoader.isMac) {
                GLFW.glfwInitHint((int)327682, (int)225288);
            }
            GLFW.glfwInitHint((int)327681, (int)0);
            if (!GLFW.glfwInit()) {
                throw new GdxRuntimeException("Unable to initialize GLFW");
            }
        }
    }

    static void loadANGLE() {
        try {
            Class<?> angleLoader = Class.forName("com.badlogic.gdx.backends.lwjgl3.angle.ANGLELoader");
            Method load = angleLoader.getMethod("load", new Class[0]);
            load.invoke(angleLoader, new Object[0]);
        }
        catch (ClassNotFoundException t) {
            return;
        }
        catch (Throwable t) {
            throw new GdxRuntimeException("Couldn't load ANGLE.", t);
        }
    }

    static void postLoadANGLE() {
        try {
            Class<?> angleLoader = Class.forName("com.badlogic.gdx.backends.lwjgl3.angle.ANGLELoader");
            Method load = angleLoader.getMethod("postGlfwInit", new Class[0]);
            load.invoke(angleLoader, new Object[0]);
        }
        catch (ClassNotFoundException t) {
            return;
        }
        catch (Throwable t) {
            throw new GdxRuntimeException("Couldn't load ANGLE.", t);
        }
    }

    static void loadGlfwAwtMacos() {
        try {
            Class<?> loader = Class.forName("com.badlogic.gdx.backends.lwjgl3.awt.GlfwAWTLoader");
            Method load = loader.getMethod("load", new Class[0]);
            File sharedLib = (File)load.invoke(loader, new Object[0]);
            Configuration.GLFW_LIBRARY_NAME.set((Object)sharedLib.getAbsolutePath());
            Configuration.GLFW_CHECK_THREAD0.set((Object)false);
        }
        catch (ClassNotFoundException t) {
            return;
        }
        catch (Throwable t) {
            throw new GdxRuntimeException("Couldn't load GLFW AWT for macOS.", t);
        }
    }

    public Lwjgl3AppShiv(ApplicationListener listener) {
        this(listener, new Lwjgl3ApplicationConfiguration());
    }

    public Lwjgl3AppShiv(ApplicationListener listener, Lwjgl3ApplicationConfiguration config) {
        if (config.glEmulation == Lwjgl3ApplicationConfiguration.GLEmulation.ANGLE_GLES20) {
            Lwjgl3AppShiv.loadANGLE();
        }
        Lwjgl3AppShiv.initializeGlfw();
        this.setApplicationLogger((ApplicationLogger)new Lwjgl3ApplicationLogger());
        this.config = config = Lwjgl3ApplicationConfiguration.copy((Lwjgl3ApplicationConfiguration)config);
        if (config.title == null) {
            config.title = listener.getClass().getSimpleName();
        }
        Gdx.app = this;
        if (!config.disableAudio) {
            try {
                this.audio = this.createAudio(config);
            }
            catch (Throwable t) {
                this.log("Lwjgl3Application", "Couldn't initialize audio, disabling audio", t);
                this.audio = new MockAudio();
            }
        } else {
            this.audio = new MockAudio();
        }
        Gdx.audio = this.audio;
        this.files = Gdx.files = this.createFiles();
        this.net = Gdx.net = new Lwjgl3Net(config);
        this.clipboard = new Lwjgl3Clipboard();
        this.sync = new Sync();
        this.listener = listener;
    }

    public void start() {
        Lwjgl3Window window = this.createWindow(this.config, this.listener, 0L);
        if (this.config.glEmulation == Lwjgl3ApplicationConfiguration.GLEmulation.ANGLE_GLES20) {
            Lwjgl3AppShiv.postLoadANGLE();
        }
        this.windows.add((Object)window);
        try {
            this.loop();
            this.cleanupWindows();
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new GdxRuntimeException(t);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loop() {
        Array closedWindows = new Array();
        while (this.running && this.windows.size > 0) {
            boolean shouldRequestRendering;
            this.audio.update();
            boolean haveWindowsRendered = false;
            closedWindows.clear();
            int targetFramerate = -2;
            for (Lwjgl3Window window : this.windows) {
                window.makeCurrent();
                this.currentWindow = window;
                if (targetFramerate == -2) {
                    targetFramerate = window.getConfig().foregroundFPS;
                }
                Array<LifecycleListener> array = this.lifecycleListeners;
                synchronized (array) {
                    haveWindowsRendered |= window.update();
                }
                if (!window.shouldClose()) continue;
                closedWindows.add((Object)window);
            }
            GLFW.glfwPollEvents();
            Array.ArrayIterator arrayIterator = this.runnables;
            synchronized (arrayIterator) {
                shouldRequestRendering = this.runnables.size > 0;
                this.executedRunnables.clear();
                this.executedRunnables.addAll(this.runnables);
                this.runnables.clear();
            }
            for (Runnable runnable : this.executedRunnables) {
                runnable.run();
            }
            if (shouldRequestRendering) {
                for (Lwjgl3Window window : this.windows) {
                    if (window.getGraphics().isContinuousRendering()) continue;
                    window.requestRendering();
                }
            }
            for (Lwjgl3Window closedWindow : closedWindows) {
                if (this.windows.size == 1) {
                    for (int i = this.lifecycleListeners.size - 1; i >= 0; --i) {
                        LifecycleListener l = (LifecycleListener)this.lifecycleListeners.get(i);
                        l.pause();
                        l.dispose();
                    }
                    this.lifecycleListeners.clear();
                }
                closedWindow.dispose();
                this.windows.removeValue((Object)closedWindow, false);
            }
            if (!haveWindowsRendered) {
                try {
                    Thread.sleep(1000 / this.config.idleFPS);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (targetFramerate <= 0) continue;
            this.sync.sync(targetFramerate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupWindows() {
        Array.ArrayIterator arrayIterator = this.lifecycleListeners;
        synchronized (arrayIterator) {
            for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.pause();
                lifecycleListener.dispose();
            }
        }
        for (Lwjgl3Window window : this.windows) {
            window.dispose();
        }
        this.windows.clear();
    }

    protected void cleanup() {
        Lwjgl3Cursor.disposeSystemCursors();
        this.audio.dispose();
        errorCallback.free();
        errorCallback = null;
        if (glDebugCallback != null) {
            glDebugCallback.free();
            glDebugCallback = null;
        }
        GLFW.glfwTerminate();
    }

    public ApplicationListener getApplicationListener() {
        return this.currentWindow.getListener();
    }

    public Graphics getGraphics() {
        return this.currentWindow.getGraphics();
    }

    public Audio getAudio() {
        return this.audio;
    }

    public Input getInput() {
        return this.currentWindow.getInput();
    }

    public Files getFiles() {
        return this.files;
    }

    public Net getNet() {
        return this.net;
    }

    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            this.getApplicationLogger().debug(tag, message);
        }
    }

    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            this.getApplicationLogger().debug(tag, message, exception);
        }
    }

    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            this.getApplicationLogger().log(tag, message);
        }
    }

    public void log(String tag, String message, Throwable exception) {
        if (this.logLevel >= 2) {
            this.getApplicationLogger().log(tag, message, exception);
        }
    }

    public void error(String tag, String message) {
        if (this.logLevel >= 1) {
            this.getApplicationLogger().error(tag, message);
        }
    }

    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel >= 1) {
            this.getApplicationLogger().error(tag, message, exception);
        }
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setApplicationLogger(ApplicationLogger applicationLogger) {
        this.applicationLogger = applicationLogger;
    }

    public ApplicationLogger getApplicationLogger() {
        return this.applicationLogger;
    }

    public Application.ApplicationType getType() {
        return Application.ApplicationType.Desktop;
    }

    public int getVersion() {
        return 0;
    }

    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public long getNativeHeap() {
        return this.getJavaHeap();
    }

    public Preferences getPreferences(String name) {
        if (this.preferences.containsKey((Object)name)) {
            return (Preferences)this.preferences.get((Object)name);
        }
        Lwjgl3Preferences prefs = new Lwjgl3Preferences((FileHandle)new Lwjgl3FileHandle(new File(this.config.preferencesDirectory, name), this.config.preferencesFileType));
        this.preferences.put((Object)name, (Object)prefs);
        return prefs;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add((Object)runnable);
        }
    }

    public void exit() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.removeValue((Object)listener, true);
        }
    }

    public Lwjgl3Audio createAudio(Lwjgl3ApplicationConfiguration config) {
        return new OpenALLwjgl3Audio(config.audioDeviceSimultaneousSources, config.audioDeviceBufferCount, config.audioDeviceBufferSize);
    }

    public Lwjgl3Input createInput(Lwjgl3Window window) {
        return new DefaultLwjgl3Input(window);
    }

    protected Files createFiles() {
        return new Lwjgl3Files();
    }

    public Lwjgl3Window newWindow(ApplicationListener listener, Lwjgl3WindowConfiguration config) {
        Lwjgl3ApplicationConfiguration appConfig = Lwjgl3ApplicationConfiguration.copy((Lwjgl3ApplicationConfiguration)this.config);
        appConfig.setWindowConfiguration(config);
        if (appConfig.title == null) {
            appConfig.title = listener.getClass().getSimpleName();
        }
        return this.createWindow(appConfig, listener, ((Lwjgl3Window)this.windows.get(0)).getWindowHandle());
    }

    private Lwjgl3Window createWindow(final Lwjgl3ApplicationConfiguration config, ApplicationListener listener, final long sharedContext) {
        final Lwjgl3Window window = new Lwjgl3Window(listener, config, (Lwjgl3ApplicationBase)this);
        if (sharedContext == 0L) {
            this.createWindow(window, config, sharedContext);
        } else {
            this.postRunnable(new Runnable(){

                @Override
                public void run() {
                    Lwjgl3AppShiv.this.createWindow(window, config, sharedContext);
                    Lwjgl3AppShiv.this.windows.add((Object)window);
                }
            });
        }
        return window;
    }

    void createWindow(Lwjgl3Window window, Lwjgl3ApplicationConfiguration config, long sharedContext) {
        long windowHandle = Lwjgl3AppShiv.createGlfwWindow(config, sharedContext);
        window.create(windowHandle);
        window.setVisible(config.initialVisible);
        for (int i = 0; i < 2; ++i) {
            GL11.glClearColor((float)config.initialBackgroundColor.r, (float)config.initialBackgroundColor.g, (float)config.initialBackgroundColor.b, (float)config.initialBackgroundColor.a);
            GL11.glClear((int)16384);
            GLFW.glfwSwapBuffers((long)windowHandle);
        }
    }

    static long createGlfwWindow(Lwjgl3ApplicationConfiguration config, long sharedContextWindow) {
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131075, (int)(config.windowResizable ? 1 : 0));
        GLFW.glfwWindowHint((int)131080, (int)(config.windowMaximized ? 1 : 0));
        GLFW.glfwWindowHint((int)131078, (int)(config.autoIconify ? 1 : 0));
        GLFW.glfwWindowHint((int)135169, (int)config.r);
        GLFW.glfwWindowHint((int)135170, (int)config.g);
        GLFW.glfwWindowHint((int)135171, (int)config.b);
        GLFW.glfwWindowHint((int)135172, (int)config.a);
        GLFW.glfwWindowHint((int)135174, (int)config.stencil);
        GLFW.glfwWindowHint((int)135173, (int)config.depth);
        GLFW.glfwWindowHint((int)135181, (int)config.samples);
        if (config.glEmulation == Lwjgl3ApplicationConfiguration.GLEmulation.GL30) {
            GLFW.glfwWindowHint((int)139266, (int)config.gles30ContextMajorVersion);
            GLFW.glfwWindowHint((int)139267, (int)config.gles30ContextMinorVersion);
            if (SharedLibraryLoader.isMac) {
                GLFW.glfwWindowHint((int)139270, (int)1);
                GLFW.glfwWindowHint((int)139272, (int)204801);
            }
        } else if (config.glEmulation == Lwjgl3ApplicationConfiguration.GLEmulation.ANGLE_GLES20) {
            GLFW.glfwWindowHint((int)139275, (int)221186);
            GLFW.glfwWindowHint((int)139265, (int)196610);
            GLFW.glfwWindowHint((int)139266, (int)2);
            GLFW.glfwWindowHint((int)139267, (int)0);
        }
        if (config.transparentFramebuffer) {
            GLFW.glfwWindowHint((int)131082, (int)1);
        }
        if (config.debug) {
            GLFW.glfwWindowHint((int)139271, (int)1);
        }
        long windowHandle = 0L;
        if (config.fullscreenMode != null) {
            GLFW.glfwWindowHint((int)135183, (int)config.fullscreenMode.refreshRate);
            windowHandle = GLFW.glfwCreateWindow((int)config.fullscreenMode.width, (int)config.fullscreenMode.height, (CharSequence)config.title, (long)config.fullscreenMode.getMonitor(), (long)sharedContextWindow);
        } else {
            GLFW.glfwWindowHint((int)131077, (int)(config.windowDecorated ? 1 : 0));
            windowHandle = GLFW.glfwCreateWindow((int)config.windowWidth, (int)config.windowHeight, (CharSequence)config.title, (long)0L, (long)sharedContextWindow);
        }
        if (windowHandle == 0L) {
            throw new GdxRuntimeException("Couldn't create window");
        }
        Lwjgl3Window.setSizeLimits((long)windowHandle, (int)config.windowMinWidth, (int)config.windowMinHeight, (int)config.windowMaxWidth, (int)config.windowMaxHeight);
        if (config.fullscreenMode == null) {
            if (config.windowX == -1 && config.windowY == -1) {
                int windowWidth = Math.max(config.windowWidth, config.windowMinWidth);
                int windowHeight = Math.max(config.windowHeight, config.windowMinHeight);
                if (config.windowMaxWidth > -1) {
                    windowWidth = Math.min(windowWidth, config.windowMaxWidth);
                }
                if (config.windowMaxHeight > -1) {
                    windowHeight = Math.min(windowHeight, config.windowMaxHeight);
                }
                long monitorHandle = GLFW.glfwGetPrimaryMonitor();
                if (config.windowMaximized && config.maximizedMonitor != null) {
                    monitorHandle = config.maximizedMonitor.monitorHandle;
                }
                IntBuffer areaXPos = BufferUtils.createIntBuffer((int)1);
                IntBuffer areaYPos = BufferUtils.createIntBuffer((int)1);
                IntBuffer areaWidth = BufferUtils.createIntBuffer((int)1);
                IntBuffer areaHeight = BufferUtils.createIntBuffer((int)1);
                GLFW.glfwGetMonitorWorkarea((long)monitorHandle, (IntBuffer)areaXPos, (IntBuffer)areaYPos, (IntBuffer)areaWidth, (IntBuffer)areaHeight);
                GLFW.glfwSetWindowPos((long)windowHandle, (int)Math.max(0, areaXPos.get(0) + areaWidth.get(0) / 2 - windowWidth / 2), (int)Math.max(0, areaYPos.get(0) + areaHeight.get(0) / 2 - windowHeight / 2));
            } else {
                GLFW.glfwSetWindowPos((long)windowHandle, (int)config.windowX, (int)config.windowY);
            }
            if (config.windowMaximized) {
                GLFW.glfwMaximizeWindow((long)windowHandle);
            }
        }
        if (config.windowIconPaths != null) {
            Lwjgl3Window.setIcon((long)windowHandle, (String[])config.windowIconPaths, (Files.FileType)config.windowIconFileType);
        }
        GLFW.glfwMakeContextCurrent((long)windowHandle);
        GLFW.glfwSwapInterval((int)(config.vSyncEnabled ? 1 : 0));
        if (config.glEmulation == Lwjgl3ApplicationConfiguration.GLEmulation.ANGLE_GLES20) {
            try {
                Class<?> gles = Class.forName("org.lwjgl.opengles.GLES");
                gles.getMethod("createCapabilities", new Class[0]).invoke(gles, new Object[0]);
            }
            catch (Throwable e) {
                throw new GdxRuntimeException("Couldn't initialize GLES", e);
            }
        } else {
            GL.createCapabilities();
        }
        Lwjgl3AppShiv.initiateGL(config.glEmulation == Lwjgl3ApplicationConfiguration.GLEmulation.ANGLE_GLES20);
        if (!glVersion.isVersionEqualToOrHigher(2, 0)) {
            throw new GdxRuntimeException("OpenGL 2.0 or higher with the FBO extension is required. OpenGL version: " + GL11.glGetString((int)7938) + "\n" + glVersion.getDebugVersionString());
        }
        if (config.glEmulation != Lwjgl3ApplicationConfiguration.GLEmulation.ANGLE_GLES20 && !Lwjgl3AppShiv.supportsFBO()) {
            throw new GdxRuntimeException("OpenGL 2.0 or higher with the FBO extension is required. OpenGL version: " + GL11.glGetString((int)7938) + ", FBO extension: false\n" + glVersion.getDebugVersionString());
        }
        if (config.debug) {
            glDebugCallback = GLUtil.setupDebugMessageCallback((PrintStream)config.debugStream);
            Lwjgl3AppShiv.setGLDebugMessageControl(GLDebugMessageSeverity.NOTIFICATION, false);
        }
        return windowHandle;
    }

    private static void initiateGL(boolean useGLES20) {
        if (!useGLES20) {
            String versionString = GL11.glGetString((int)7938);
            String vendorString = GL11.glGetString((int)7936);
            String rendererString = GL11.glGetString((int)7937);
            glVersion = new GLVersion(Application.ApplicationType.Desktop, versionString, vendorString, rendererString);
        } else {
            try {
                Class<?> gles = Class.forName("org.lwjgl.opengles.GLES20");
                Method getString = gles.getMethod("glGetString", Integer.TYPE);
                String versionString = (String)getString.invoke(gles, 7938);
                String vendorString = (String)getString.invoke(gles, 7936);
                String rendererString = (String)getString.invoke(gles, 7937);
                glVersion = new GLVersion(Application.ApplicationType.Desktop, versionString, vendorString, rendererString);
            }
            catch (Throwable e) {
                throw new GdxRuntimeException("Couldn't get GLES version string.", e);
            }
        }
    }

    private static boolean supportsFBO() {
        return glVersion.isVersionEqualToOrHigher(3, 0) || GLFW.glfwExtensionSupported((CharSequence)"GL_EXT_framebuffer_object") || GLFW.glfwExtensionSupported((CharSequence)"GL_ARB_framebuffer_object");
    }

    public static boolean setGLDebugMessageControl(GLDebugMessageSeverity severity, boolean enabled) {
        GLCapabilities caps = GL.getCapabilities();
        int GL_DONT_CARE = 4352;
        if (caps.OpenGL43) {
            GL43.glDebugMessageControl((int)4352, (int)4352, (int)severity.gl43, (IntBuffer)null, (boolean)enabled);
            return true;
        }
        if (caps.GL_KHR_debug) {
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)severity.khr, (IntBuffer)null, (boolean)enabled);
            return true;
        }
        if (caps.GL_ARB_debug_output && severity.arb != -1) {
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)severity.arb, (IntBuffer)null, (boolean)enabled);
            return true;
        }
        if (caps.GL_AMD_debug_output && severity.amd != -1) {
            AMDDebugOutput.glDebugMessageEnableAMD((int)4352, (int)severity.amd, (IntBuffer)null, (boolean)enabled);
            return true;
        }
        return false;
    }

    public static enum GLDebugMessageSeverity {
        HIGH(37190, 37190, 37190, 37190),
        MEDIUM(37191, 37191, 37191, 37191),
        LOW(37192, 37192, 37192, 37192),
        NOTIFICATION(33387, 33387, -1, -1);

        final int gl43;
        final int khr;
        final int arb;
        final int amd;

        private GLDebugMessageSeverity(int gl43, int khr, int arb, int amd) {
            this.gl43 = gl43;
            this.khr = khr;
            this.arb = arb;
            this.amd = amd;
        }
    }
}

