/*
 * Door.java
 *
 * This is a refactored version of the Box class from Lab 2. This time we read/
 * compute the physics units from the JSON file rather than passing them as a
 * separate parameter.
 *
 * Based on the original PhysicsDemo Lab by Don Holden, 2007
 *
 * Author:  Walker M. White
 * Version: 3/1/2025
 */
 package edu.cornell.cis3152.cube;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.ParserUtils;
import edu.cornell.gdiac.physics2.BoxObstacle;
import edu.cornell.gdiac.physics2.ObstacleSprite;

/**
 * A crate obstacle for the physics demo
 *
 * An ObstacleSprite is a sprite (specifically a textured mesh) that is
 * connected to a obstacle. It is designed to be the same size as the physics
 * object, and it tracks the physics object, matching its positionand angle at
 * all times.
 *
 * The reason we use a textured mesh instead of a image is because it allows
 * us more control over the size and shape of the image. We will talk about
 * how to use these later in class. For now, just notice how we create meshes.
 */
public class Crate extends ObstacleSprite {

    /**
     * Creates a box with the given position and settings
     *
     * All crates will have the same physics attributes.
     *
     * @param x         The crate x-position
     * @param y         The crate y-position
     * @param settings  The physics constants
     */
    public Crate(float x, float y, JsonValue settings) {
        super();

        float sceneHeight = settings.get("scene_size").getFloat(1);
        float worldHeight = settings.get("world_size").getFloat(1);
        float units = sceneHeight/worldHeight;
        float side = 2;
        float size = side*units;

        obstacle = new BoxObstacle(x, y, side, side);

        obstacle.setDensity( settings.getFloat( "density", 0 ) );
        obstacle.setFriction( settings.getFloat( "friction", 0 ) );
        obstacle.setRestitution( settings.getFloat( "restitution", 0 ) );
        obstacle.setPhysicsUnits( units );
        debug = ParserUtils.parseColor( settings.get("debug"),  Color.WHITE);

        // Create a rectangular mesh with a standard texture
        mesh.set(-size/2.0f,-size/2.0f,size,size);
    }

}
