/*
 * Rest.java
 *
 * This class represents a sleeping dog.  Note that it NEVER fails. It has to
 * be grouped with another task to wake the dog up. It is adapted from the GDX
 * AI example written by davebaol.
 *
 * @author: David Kim and James Liu
 * @version: 3/10/2025
 */
package edu.cornell.cis3152.behavior.tasks;

import com.badlogic.gdx.ai.btree.LeafTask;
import com.badlogic.gdx.ai.btree.Task;
import edu.cornell.cis3152.behavior.Dog;

/**
 * A task representing sleeping.
 *
 * This task NEVER fails. It has to be grouped with another task (typically
 * a timer) to force it to finish. Otherwise, the dog will sleep forever.
 */
public class RestTask extends LeafTask<Dog> {

	/**
	 * Initiates the rest task.
	 *
	 * This will switch the dog animation.
	 */
	@Override
	public void start () {
        Dog dog = getObject();
		dog.brainLog("YAWN - So tired...");
		dog.sleep();
	}

	/**
	 * Executes the rest task.
	 *
	 * This will run forever; it never fails. This task has to be aborted.
	 *
	 * @return The status of this task
     */
	@Override
	public Status execute () {
		Dog dog = getObject();
		dog.brainLog("zz zz zz");
		return Status.RUNNING;
	}

    /**
     * Completes this task
     *
     * This is called when the task is aborted
     */
	@Override
	public void end () {
        Dog dog = getObject();
        dog.brainLog("STRETCH - Time to wake up");
	}

	/**
	 * Copies the state of this task to another
	 *
	 * @param task  The task to copy into
	 */
	@Override
	protected Task<Dog> copyTo (Task<Dog> task) {
	    // No task attributes
		return task;
	}

}
