/*
 * Mark.java
 *
 * This class represents marking a tree. It the last part of the "pee sequence".
 * It is adapted from the GDX AI example written by davebaol.
 *
 * @author: David Kim and James Liu
 * @version: 3/10/2025
 */
package edu.cornell.cis3152.behavior.tasks;

import com.badlogic.gdx.ai.btree.LeafTask;
import com.badlogic.gdx.ai.btree.Task;
import edu.cornell.cis3152.behavior.Dog;

/**
 * A task representing peeing on a tree.
 *
 * Unlike barking, the duration of this activity is not controlled by the
 * behavior tree; it is controlled by the Dog. That makes sense, because this
 * is not a thought process.
 */
public class MarkTask extends LeafTask<Dog> {

    /** How many turns we have been peeing */
	int turn;

	/**
	 * Initiates the marking task
	 */
	@Override
	public void start () {
	    Dog dog = getObject();
		turn = 0;
		dog.log("Lifts a leg to pee!");
	}

	/**
	 * Executes one step of the barking task
	 *
	 * This task will continue until the dog indicates that it is done.
	 *
	 * @return The status of this task
	 */
	@Override
	public Status execute () {
		Dog dog = getObject();
		boolean result = dog.markTree(turn++);
		if (!result) {
			return Status.RUNNING;
		} else {
		    // Relief!
		    dog.setUrgent(false);
		}
		return result ? Status.SUCCEEDED : Status.FAILED;
	}

	/**
	 * Copies the state of this task to another
	 *
	 * @param task  The task to copy into
	 */
	@Override
	protected Task<Dog> copyTo (Task<Dog> task) {
	    // No task attributes
		return task;
	}

	/**
     * Resets this task to start over
     */
	@Override
	public void reset() {
		turn = 0;
		super.reset();
	}
}
