/*
 * Bark.java
 *
 * This class represents a barking task. It is adapted from the GDX AI example
 * written by davebaol.
 *
 * @author: David Kim and James Liu
 * @version: 3/10/2025
 */
package edu.cornell.cis3152.behavior.tasks;

import com.badlogic.gdx.ai.btree.LeafTask;
import com.badlogic.gdx.ai.btree.Task;
import com.badlogic.gdx.ai.btree.annotation.TaskAttribute;
import com.badlogic.gdx.ai.utils.random.ConstantIntegerDistribution;
import com.badlogic.gdx.ai.utils.random.IntegerDistribution;
import com.badlogic.gdx.ai.utils.random.UniformIntegerDistribution;
import edu.cornell.cis3152.behavior.Dog;

/**
 * A barking task
 *
 * The number of times to bark is set by the task attribute times. This value
 * can be redefined in the behavior tree "source code".
 */
public class BarkTask extends LeafTask<Dog> {

    /** A task attribute for the number of times to bark */
	@TaskAttribute
	public IntegerDistribution times =  ConstantIntegerDistribution.ONE;

    /** The number of times barked so far */
	private int t;

	/**
	 * Initiates the barking task
	 */
	@Override
	public void start () {
		super.start();
        Dog dog = (Dog) getObject();
		t = times.nextInt();
	}

	/**
	 * Executes one step of the barking task
	 *
	 * This task will continue until we have finished barking the correct
	 * number of times.
	 *
	 * @return The status of this task
	 */
	@Override
	public Status execute () {
		Dog dog = getObject();
        if (t > 0) {
            dog.bark();
            t--;
            return Status.RUNNING;
        }
		return Status.SUCCEEDED;
	}

	/**
	 * Copies the state of this task to another
	 *
	 * @param task  The task to copy into
	 */
	@Override
	protected Task<Dog> copyTo (Task<Dog> task) {
		BarkTask bark = (BarkTask)task;
		bark.times = times;

		return task;
	}

    /**
     * Resets this task to start over
     */
	@Override
	public void reset() {
        times = ConstantIntegerDistribution.ONE;
		t = 0;
		super.reset();
	}

}
