/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.graphics.SpriteMesh;
import edu.cornell.gdiac.graphics.Stencil;
import edu.cornell.gdiac.math.Path2;
import edu.cornell.gdiac.math.PathExtruder;
import edu.cornell.gdiac.math.Poly2;
import edu.cornell.gdiac.scene2.TexturedNode;

public class PathNode
extends TexturedNode {
    protected Path2 path = new Path2();
    protected Poly2 polygon = new Poly2();
    protected float stroke;
    protected PathExtruder.Joint joint;
    protected PathExtruder.EndCap endcap;
    protected Rectangle extrabounds;
    protected float fringe;
    protected boolean stencil;
    protected PathExtruder extruder = new PathExtruder();
    protected SpriteMesh border = new SpriteMesh();
    private final Vector2 vectorCache = new Vector2();

    private void init() {
        this.stroke = 1.0f;
        this.fringe = 0.0f;
        this.stencil = false;
        this.joint = PathExtruder.Joint.SQUARE;
        this.endcap = PathExtruder.EndCap.BUTT;
        this.classname = "PathNode";
    }

    public PathNode(float[] vertices, float stroke, PathExtruder.Joint joint, PathExtruder.EndCap cap, boolean closed) {
        super((TextureRegion)null);
        this.init();
        this.path.set(vertices);
        this.path.closed = closed;
        this.joint = joint;
        this.endcap = cap;
        this.stroke = stroke;
        this.setContentSize(this.path.getBounds().getWidth(), this.path.getBounds().getHeight());
        this.updateExtrusion();
    }

    public PathNode(Path2 path, float stroke, PathExtruder.Joint joint, PathExtruder.EndCap cap) {
        super((TextureRegion)null);
        this.init();
        this.path = path;
        this.joint = joint;
        this.endcap = cap;
        this.stroke = stroke;
        this.setContentSize(this.path.getBounds().getWidth(), this.path.getBounds().getHeight());
        this.updateExtrusion();
    }

    public PathNode(String filename, Path2 path) {
        super(filename);
        this.init();
        this.initWithPath(path);
    }

    public PathNode(String filename, Rectangle rect) {
        super(filename);
        this.init();
        this.initWithPath(rect);
    }

    public PathNode(Texture texture, Path2 path) {
        super(texture);
        this.init();
        this.initWithPath(path);
    }

    public PathNode(TextureRegion texture, Path2 path) {
        super(texture);
        this.init();
        this.initWithPath(path);
    }

    public PathNode(Texture texture, Rectangle rect) {
        super(texture);
        this.init();
        this.initWithPath(rect);
    }

    public PathNode(TextureRegion texture, Rectangle rect) {
        super(texture);
        this.init();
        this.initWithPath(rect);
    }

    private void initWithPath(Path2 path) {
        this.setAnchor(new Vector2(0.5f, 0.5f));
        this.path = path;
        this.setContentSize(this.path.getBounds().getWidth(), this.path.getBounds().getHeight());
        this.updateExtrusion();
    }

    private void initWithPath(Rectangle rect) {
        this.setAnchor(new Vector2(0.5f, 0.5f));
        this.path = new Path2(rect);
        this.setContentSize(this.path.getBounds().getWidth(), this.path.getBounds().getHeight());
        this.updateExtrusion();
    }

    public PathNode(AssetDirectory manager, JsonValue data) {
        super(manager, data);
        String endcapStr;
        String jointStr;
        this.init();
        Vector2 coord = this.getPosition();
        boolean sizeFit = data.has("size");
        Vector2 size = this.getSize();
        if (data.has("path")) {
            this.path = new Path2(data.get("path").asFloatArray());
        } else {
            Rectangle bounds = new Rectangle();
            bounds.width = this.getContentWidth();
            bounds.height = this.getContentHeight();
            this.path = new Path2(bounds);
        }
        this.setContentSize(this.path.getBounds().getWidth(), this.path.getBounds().getHeight());
        this.stroke = data.getFloat("stroke", 1.0f);
        switch (jointStr = data.getString("joint", "UNKNOWN")) {
            case "mitre": {
                this.joint = PathExtruder.Joint.MITRE;
                break;
            }
            case "round": {
                this.joint = PathExtruder.Joint.ROUND;
                break;
            }
            default: {
                this.joint = PathExtruder.Joint.SQUARE;
            }
        }
        switch (endcapStr = data.getString("endcap", "UNKNOWN")) {
            case "square": {
                this.endcap = PathExtruder.EndCap.SQUARE;
                break;
            }
            case "round": {
                this.endcap = PathExtruder.EndCap.ROUND;
                break;
            }
            default: {
                this.endcap = PathExtruder.EndCap.BUTT;
            }
        }
        this.fringe = data.getFloat("fringe", 0.0f);
        this.stencil = data.getBoolean("stencil", false);
        if (sizeFit) {
            this.setContentSize(size);
        }
        this.setPosition(coord);
    }

    public void setStroke(float stroke) {
        if (stroke < 0.0f) {
            throw new IllegalArgumentException("Stroke width is invalid");
        }
        boolean changed = stroke != this.stroke;
        this.stroke = stroke;
        if (changed) {
            this.clearRenderData();
        }
    }

    public float getStroke() {
        return this.stroke;
    }

    public void setClosed(boolean closed) {
        boolean changed = closed != this.path.closed;
        this.path.closed = closed;
        if (changed) {
            this.clearRenderData();
        }
    }

    public boolean getClosed() {
        return this.path.closed;
    }

    public void setJoint(PathExtruder.Joint joint) {
        boolean changed = joint != this.joint;
        this.joint = joint;
        if (changed && this.stroke > 0.0f) {
            this.clearRenderData();
        }
    }

    public PathExtruder.Joint getJoint() {
        return this.joint;
    }

    public void setCap(PathExtruder.EndCap cap) {
        boolean changed = cap != this.endcap;
        this.endcap = cap;
        if (changed && this.stroke > 0.0f) {
            this.clearRenderData();
        }
    }

    public PathExtruder.EndCap getCap() {
        return this.endcap;
    }

    public float getFringe() {
        return this.fringe;
    }

    public void setFringe(float fringe) {
        this.fringe = fringe;
        this.clearRenderData();
    }

    public boolean hasStencil() {
        return this.stencil;
    }

    public void setStencil(boolean stencil) {
        this.stencil = stencil;
    }

    public void setPath(float[] vertices, boolean closed) {
        if (vertices.length <= 3) {
            throw new IllegalArgumentException("Path must have at least two vertices");
        }
        this.path.set(vertices);
        this.path.closed = closed;
        this.setContentSize(this.path.getBounds().getWidth(), this.path.getBounds().getHeight());
        this.clearRenderData();
    }

    public void setPath(Path2 path) {
        if (path.getVertices().length <= 3) {
            throw new IllegalArgumentException("Path must have at least two vertices");
        }
        this.path = path;
        this.setContentSize(this.path.getBounds().getWidth(), this.path.getBounds().getHeight());
        this.clearRenderData();
    }

    public void setPath(Rectangle rect) {
        this.path.set(rect);
        this.setContentSize(this.path.getBounds().getWidth(), this.path.getBounds().getHeight());
        this.clearRenderData();
    }

    public Path2 getPath() {
        return this.path;
    }

    public Poly2 getExtrusion() {
        return this.polygon;
    }

    public Rectangle getBoundingRect() {
        return this.path.getBounds();
    }

    public float getExtrudedContentWidth() {
        return this.extrabounds.width;
    }

    public float getExtrudedContentHeight() {
        return this.extrabounds.height;
    }

    public Vector2 getExtrudedContentSize() {
        return new Vector2(this.extrabounds.width, this.extrabounds.height);
    }

    public Rectangle getExtrudedContentBounds() {
        return this.extrabounds;
    }

    @Override
    public void draw(SpriteBatch batch, Affine2 transform, Color tint) {
        if (!this.rendered) {
            this.generateRenderData();
        }
        batch.setColor(tint);
        batch.setTexture(this.texture.getTexture());
        if (this.gradient != null) {
            batch.setGradient(this.gradient);
        }
        batch.setBlendEquation(this.blendEquation);
        batch.setBlendSrcFunc(this.srcFactor);
        batch.setBlendDstFunc(this.dstFactor);
        if (this.stencil) {
            batch.setStencilEffect(Stencil.Effect.CLAMP_NONE);
        }
        batch.drawMesh(this.mesh, transform, true);
        if (this.fringe > 0.0f) {
            if (this.stencil) {
                batch.setStencilEffect(Stencil.Effect.MASK_NONE);
            }
            batch.drawMesh(this.border, transform, true);
        }
        if (this.stencil) {
            batch.clearStencil();
        }
        batch.setGradient(null);
    }

    @Override
    protected void generateRenderData() {
        if (this.rendered) {
            throw new IllegalStateException("Render data is already present");
        }
        if (this.texture == null) {
            return;
        }
        this.updateExtrusion();
        Vector2 nsize = this.getContentSize();
        Vector2 bsize = this.path.getBounds().getSize(this.vectorCache);
        Affine2 shift = new Affine2();
        boolean adjust = false;
        if (!nsize.equals((Object)bsize)) {
            adjust = true;
            shift.scale(bsize.x > 0.0f ? nsize.x / bsize.x : 0.0f, bsize.y > 0.0f ? nsize.y / bsize.y : 0.0f);
        }
        Vector2 offset = this.path.getBounds().getPosition(this.vectorCache);
        if (!this.absolute && !offset.isZero()) {
            adjust = true;
            shift.translate(-offset.x, -offset.y);
        }
        this.rendered = true;
        this.updateTextureCoords();
        if (adjust) {
            this.mesh.transform(shift);
            this.border.transform(shift);
        }
    }

    @Override
    protected void updateTextureCoords() {
        float t;
        float s;
        int i;
        if (!this.rendered) {
            return;
        }
        float width = this.texture.getRegionWidth();
        float height = this.texture.getRegionHeight();
        Vector2 off = this.offset.add(this.path.getBounds().x, this.path.getBounds().y);
        for (i = 0; i < this.mesh.vertexCount(); ++i) {
            s = (this.mesh.getPositionX(i) + off.x) / width;
            t = (this.mesh.getPositionY(i) + off.y) / height;
            if (this.flipHorizontal) {
                s = 1.0f - s;
            }
            if (!this.flipVertical) {
                t = 1.0f - t;
            }
            this.mesh.setColor(i, Color.WHITE);
            this.mesh.setTextureCoord(i, s * this.texture.getU2() + (1.0f - s) * this.texture.getU(), t * this.texture.getV2() + (1.0f - t) * this.texture.getV());
            if (this.gradient == null) continue;
            s = (this.mesh.getPositionX(i) + off.x) / this.path.getBounds().width;
            t = (this.mesh.getPositionY(i) + off.y) / this.path.getBounds().height;
            if (this.flipHorizontal) {
                s = 1.0f - s;
            }
            if (!this.flipVertical) {
                t = 1.0f - t;
            }
            this.mesh.setGradientCoord(i, s, t);
        }
        for (i = 0; i < this.border.vertexCount(); ++i) {
            s = (this.border.getPositionX(i) + off.x) / width;
            t = (this.border.getPositionY(i) + off.y) / height;
            if (this.flipHorizontal) {
                s = 1.0f - s;
            }
            if (!this.flipVertical) {
                t = 1.0f - t;
            }
            this.border.setTextureCoord(i, s * this.texture.getU2() + (1.0f - s) * this.texture.getU(), t * this.texture.getV2() + (1.0f - t) * this.texture.getV());
            if (this.gradient == null) continue;
            s = (this.border.getPositionX(i) + off.x) / this.path.getBounds().width;
            t = (this.border.getPositionY(i) + off.y) / this.path.getBounds().height;
            if (this.flipHorizontal) {
                s = 1.0f - s;
            }
            if (!this.flipVertical) {
                t = 1.0f - t;
            }
            this.border.setGradientCoord(i, s, t);
        }
    }

    private void updateExtrusion() {
        this.border.clear();
        this.mesh.clear();
        this.polygon.clear();
        Color clear = new Color(255.0f, 255.0f, 255.0f, 0.0f);
        if (this.stroke > 0.0f) {
            this.extruder.clear();
            this.extruder.set(this.path);
            this.extruder.setJoint(this.joint);
            this.extruder.setEndCap(this.endcap);
            this.extruder.calculate(this.stroke);
            this.extruder.getPolygon(this.polygon);
            this.extrabounds = this.polygon.getBounds();
            this.extrabounds.x += this.path.getBounds().x;
            this.extrabounds.y += this.path.getBounds().y;
            this.mesh.set(this.polygon);
        } else {
            int i;
            for (i = 0; i < this.path.size(); ++i) {
                this.mesh.push(this.path.getPositionX(i), this.path.getPositionY(i), Color.WHITE, 0.0f, 0.0f);
            }
            for (i = 0; i < this.path.size() - 1; ++i) {
                this.mesh.indices.add(i);
                this.mesh.indices.add(i + 1);
            }
            if (this.path.closed) {
                this.mesh.indices.add(this.path.size() - 1);
                this.mesh.indices.add(0);
            }
            this.extrabounds = this.path.getBounds();
        }
    }
}

