/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.math;

import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntSet;
import com.badlogic.gdx.utils.ShortArray;
import java.util.ArrayList;
import java.util.HashMap;

public class Poly2 {
    public FloatArray vertices;
    public ShortArray indices;
    private static Vector2 temp1 = new Vector2();
    private static Vector2 temp2 = new Vector2();
    private static Vector2 temp3 = new Vector2();
    private static Vector3 bary3 = new Vector3();

    private static boolean colinear(float vx, float vy, float wx, float wy, float px, float py, float err) {
        float l2 = (wx - vx) * (wx - vx) + (wy - vy) * (wy - vy);
        double distance = 0.0;
        if (l2 == 0.0f) {
            distance = Math.sqrt((px - vx) * (px - vx) + (py - vy) + (py - vy));
        } else {
            float dot = (px - vx) * (wx - vx) + (py - vy) * (wy - vy);
            float t = Math.max(0.0f, Math.min(1.0f, dot / l2));
            float proX = vx + t * (wx - vx);
            float proY = vy + t * (wy - vy);
            distance = Math.sqrt((px - proX) * (px - proX) + (py - proY) + (py - proY));
        }
        return distance <= (double)err;
    }

    public Poly2() {
        this.vertices = new FloatArray(8);
        this.indices = new ShortArray(6);
    }

    public Poly2(float[] vertices) {
        this.vertices = new FloatArray(vertices);
        this.indices = new ShortArray();
    }

    public Poly2(float[] vertices, int voffset, int vlength) {
        this.vertices = new FloatArray(vlength);
        this.vertices.addAll(vertices, voffset, vlength);
        this.indices = new ShortArray(3 * vlength / 2);
    }

    public Poly2(float[] vertices, short[] indices) {
        this.vertices = new FloatArray(vertices);
        this.indices = new ShortArray(indices);
    }

    public Poly2(Poly2 poly) {
        this.vertices = new FloatArray(poly.vertices);
        this.indices = new ShortArray(poly.indices);
    }

    public Poly2(Rectangle rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public Poly2(float x, float y, float w, float h) {
        this.vertices = new FloatArray(8);
        this.indices = new ShortArray(6);
        this.vertices.items[0] = x;
        this.vertices.items[1] = y;
        this.vertices.items[2] = x + w;
        this.vertices.items[3] = y;
        this.vertices.items[4] = x + w;
        this.vertices.items[5] = y + h;
        this.vertices.items[6] = x;
        this.vertices.items[7] = y + h;
        this.indices.items[0] = 0;
        this.indices.items[1] = 1;
        this.indices.items[2] = 2;
        this.indices.items[3] = 0;
        this.indices.items[4] = 2;
        this.indices.items[5] = 3;
        this.vertices.size = 8;
        this.indices.size = 6;
    }

    public Poly2 set(float[] vertices) {
        this.vertices.clear();
        this.vertices.addAll(vertices);
        this.indices.clear();
        return this;
    }

    public Poly2 set(float[] vertices, int voffset, int vlength) {
        this.vertices.clear();
        this.vertices.addAll(vertices, voffset, vlength);
        this.indices.clear();
        return this;
    }

    public Poly2 set(Poly2 poly) {
        this.vertices.clear();
        this.vertices.addAll(poly.vertices);
        this.indices.clear();
        this.indices.addAll(poly.indices);
        return this;
    }

    public Poly2 set(Rectangle rect) {
        return this.set(rect.x, rect.y, rect.width, rect.height);
    }

    public Poly2 set(float x, float y, float w, float h) {
        this.vertices.clear();
        this.vertices.ensureCapacity(8);
        this.vertices.items[0] = x;
        this.vertices.items[1] = y;
        this.vertices.items[2] = x + w;
        this.vertices.items[3] = y;
        this.vertices.items[4] = x + w;
        this.vertices.items[5] = y + h;
        this.vertices.items[6] = x;
        this.vertices.items[7] = y + h;
        this.vertices.size = 8;
        this.indices.clear();
        this.indices.ensureCapacity(6);
        this.indices.items[0] = 0;
        this.indices.items[1] = 1;
        this.indices.items[2] = 2;
        this.indices.items[3] = 0;
        this.indices.items[4] = 2;
        this.indices.items[5] = 3;
        this.indices.size = 6;
        return this;
    }

    public void push(Vector2 point) {
        this.push(point.x, point.y);
    }

    public void push(float x, float y) {
        this.vertices.ensureCapacity(2);
        int idx = this.vertices.size;
        this.vertices.items[idx++] = x;
        this.vertices.items[idx++] = y;
        this.vertices.size += 2;
    }

    Poly2 setIndices(short[] indices) {
        this.indices.clear();
        this.indices.addAll(indices);
        return this;
    }

    Poly2 setIndices(short[] indices, int ioffset, int ilength) {
        this.indices.clear();
        this.indices.addAll(indices, ioffset, ilength);
        return this;
    }

    public void clear() {
        this.vertices.clear();
        this.indices.clear();
    }

    public PolygonRegion makePolyRegion(TextureRegion region) {
        float[] v = new float[this.vertices.size];
        System.arraycopy(this.vertices.items, 0, v, 0, this.vertices.size);
        short[] i = new short[this.indices.size];
        System.arraycopy(this.indices.items, 0, i, 0, this.vertices.size);
        return new PolygonRegion(region, v, i);
    }

    public Poly2 scl(float scale) {
        int i = 0;
        while (i < this.vertices.size) {
            int n = i++;
            this.vertices.items[n] = this.vertices.items[n] * scale;
        }
        return this;
    }

    public Poly2 scl(Vector2 scale) {
        for (int i = 0; i < this.vertices.size; i += 2) {
            int n = i;
            this.vertices.items[n] = this.vertices.items[n] * scale.x;
            int n2 = i + 1;
            this.vertices.items[n2] = this.vertices.items[n2] * scale.y;
        }
        return this;
    }

    public Poly2 div(float scale) {
        if (scale == 0.0f) {
            throw new ArithmeticException("Divided by zero operation cannot possible");
        }
        return this.scl(1.0f / scale);
    }

    public Poly2 div(Vector2 scale) {
        if (scale.x == 0.0f || scale.y == 0.0f) {
            throw new ArithmeticException("Divided by zero operation cannot possible");
        }
        temp1.set(1.0f / scale.x, 1.0f / scale.y);
        return this.scl(temp1);
    }

    public Poly2 add(float offset) {
        int i = 0;
        while (i < this.vertices.size) {
            int n = i++;
            this.vertices.items[n] = this.vertices.items[n] + offset;
        }
        return this;
    }

    public Poly2 add(Vector2 offset) {
        for (int i = 0; i < this.vertices.size; i += 2) {
            int n = i;
            this.vertices.items[n] = this.vertices.items[n] + offset.x;
            int n2 = i + 1;
            this.vertices.items[n2] = this.vertices.items[n2] + offset.y;
        }
        return this;
    }

    public Poly2 sub(float offset) {
        int i = 0;
        while (i < this.vertices.size) {
            int n = i++;
            this.vertices.items[n] = this.vertices.items[n] - offset;
        }
        return this;
    }

    public Poly2 sub(Vector2 offset) {
        for (int i = 0; i < this.vertices.size; i += 2) {
            int n = i;
            this.vertices.items[n] = this.vertices.items[n] - offset.x;
            int n2 = i + 1;
            this.vertices.items[n2] = this.vertices.items[n2] - offset.y;
        }
        return this;
    }

    public Poly2 transform(Affine2 transform) {
        for (int i = 0; i < this.vertices.size; i += 2) {
            temp1.set(this.vertices.items[i], this.vertices.items[i + 1]);
            transform.applyTo(temp1);
            this.vertices.items[i] = Poly2.temp1.x;
            this.vertices.items[i + 1] = Poly2.temp1.y;
        }
        return this;
    }

    public int size() {
        return this.vertices == null ? 0 : this.vertices.size / 2;
    }

    public int indexSize() {
        return this.indices == null ? 0 : this.indices.size;
    }

    public Vector2 vertexAt(int index) {
        if (index < 0 || index > (this.vertices.size - 2) / 2) {
            throw new IndexOutOfBoundsException();
        }
        return new Vector2(this.vertices.items[2 * index], this.vertices.items[2 * index + 1]);
    }

    public Vector2 vertexAt(int index, Vector2 point) {
        if (index < 0 || index > (this.vertices.size - 2) / 2) {
            throw new IndexOutOfBoundsException();
        }
        if (point == null) {
            point = new Vector2(this.vertices.items[2 * index], this.vertices.items[2 * index + 1]);
        } else {
            point.set(this.vertices.items[2 * index], this.vertices.items[2 * index + 1]);
        }
        return point;
    }

    public Vector2[] getVertices() {
        if (this.vertices == null) {
            return null;
        }
        Vector2[] result = new Vector2[this.vertices.size / 2];
        for (int ii = 0; ii < result.length; ++ii) {
            result[ii] = new Vector2(this.vertices.items[2 * ii], this.vertices.items[2 * ii + 1]);
        }
        return result;
    }

    short[] getIndices() {
        short[] result = new short[this.indices.size];
        System.arraycopy(this.indices.items, 0, result, 0, this.indices.size);
        return result;
    }

    public Rectangle getBounds() {
        if (this.vertices.size == 0) {
            return null;
        }
        float minX = this.vertices.items[0];
        float minY = this.vertices.items[1];
        float maxX = minX;
        float maxY = minY;
        for (int i = 0; i < this.vertices.size; i += 2) {
            float x = this.vertices.items[i];
            float y = this.vertices.items[i + 1];
            if (x < minX) {
                minX = x;
            } else if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
                continue;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    public Rectangle getBounds(Rectangle rect) {
        if (this.vertices.size == 0) {
            return null;
        }
        float minX = this.vertices.items[0];
        float minY = this.vertices.items[1];
        float maxX = minX;
        float maxY = minY;
        for (int i = 0; i < this.vertices.size; i += 2) {
            float x = this.vertices.items[i];
            float y = this.vertices.items[i + 1];
            if (x < minX) {
                minX = x;
            } else if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
                continue;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        if (rect == null) {
            return new Rectangle(minX, minY, maxX - minX, maxY - minY);
        }
        rect.set(minX, minY, maxX - minX, maxY - minY);
        return rect;
    }

    public boolean contains(float x, float y) {
        boolean inside = false;
        temp2.set(x, y);
        int i = 0;
        while (!inside && 3 * i < this.indices.size) {
            this.getBarycentric(temp2, i, bary3);
            inside = 0.0f <= Poly2.bary3.x && Poly2.bary3.x <= 1.0f && 0.0f <= Poly2.bary3.y && Poly2.bary3.y <= 1.0f && 0.0f <= Poly2.bary3.z && Poly2.bary3.z <= 1.0f;
            ++i;
        }
        return inside;
    }

    public boolean contains(Vector2 point) {
        return this.contains(point.x, point.y);
    }

    public boolean incident(float x, float y, float err) {
        short[][] bound;
        for (short[] sl : bound = this.boundaries()) {
            for (int ii = 0; ii < sl.length; ii += 2) {
                float vx = this.vertices.items[ii * 2];
                float vy = this.vertices.items[ii * 2 + 1];
                float wx = this.vertices.items[ii * 2 + 2];
                float wy = this.vertices.items[ii * 2 + 3];
                if (!Poly2.colinear(vx, vy, wx, wy, x, y, err)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean incident(Vector2 point, float err) {
        return this.incident(point.x, point.y, err);
    }

    public short[] exterior() {
        HashMap<Integer, ArrayList<Short>> neighbors = new HashMap<Integer, ArrayList<Short>>();
        HashMap<Integer, Integer> count = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.indices.size; i += 3) {
            for (int j = 0; j < 3; ++j) {
                ArrayList<Short> slot;
                short ind = this.indices.items[i + j];
                ArrayList<Short> search = (ArrayList<Short>)neighbors.get(ind);
                if (search == null) {
                    slot = new ArrayList<Short>();
                    neighbors.put(Integer.valueOf(ind), slot);
                    count.put(Integer.valueOf(ind), 0);
                } else {
                    slot = search;
                }
                slot.add(this.indices.items[i + (j + 1) % 3]);
                slot.add(this.indices.items[i + (j + 2) % 3]);
                count.put(Integer.valueOf(ind), (Integer)count.get(ind) + 1);
                neighbors.put(Integer.valueOf(ind), slot);
            }
        }
        ArrayList<Short> res = new ArrayList<Short>();
        for (int i = 0; i < this.vertices.size; i += 2) {
            if (((ArrayList)neighbors.get(i / 2)).size() <= (Integer)count.get(i / 2)) continue;
            res.add((short)(i / 2));
        }
        short[] resC = new short[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            resC[i] = (Short)res.get(i);
        }
        return resC;
    }

    public short[][] boundaries() {
        HashMap<String, TreeNode> decomp = new HashMap<String, TreeNode>();
        for (int ii = 0; ii < this.indices.size; ii += 3) {
            TreeNode current = new TreeNode(this.indices.items[ii], this.indices.items[ii + 1], this.indices.items[ii + 2]);
            String key = current.toString();
            if (decomp.containsKey(key)) continue;
            for (TreeNode node : decomp.values()) {
                if (!node.adjacent(current)) continue;
                node.neighbors.add(current);
                current.neighbors.add(node);
            }
            decomp.put(key, current);
        }
        IntSet total = new IntSet();
        IntSet inuse = new IntSet();
        for (int ii = 0; ii < this.indices.size; ++ii) {
            total.add((int)this.indices.items[ii]);
        }
        boolean abort = false;
        ArrayList res = new ArrayList();
        while (inuse.size != total.size && !abort) {
            ArrayList<Short> array = new ArrayList<Short>();
            TreeNode current = null;
            int start = -1;
            for (TreeNode node : decomp.values()) {
                start = node.pick(inuse);
                if (start == -1) continue;
                current = node;
            }
            IntSet visited = new IntSet();
            if (start != -1) {
                int index = start;
                for (current = current.follow(index); current != null; current = current.follow(index)) {
                    visited.add(index);
                    array.add((short)index);
                    index = current.pick(visited);
                }
                IntSet.IntSetIterator it = new IntSet.IntSetIterator(visited);
                while (it.hasNext) {
                    inuse.add(it.next());
                }
                res.add(array);
                if (inuse.size == total.size) continue;
                for (TreeNode node : decomp.values()) {
                    node.previous = null;
                }
                continue;
            }
            abort = true;
        }
        short[][] result = new short[res.size()][];
        for (int i = 0; i < res.size(); ++i) {
            short[] n = new short[((ArrayList)res.get(res.size() - 1 - i)).size()];
            for (int m = 0; m < ((ArrayList)res.get(res.size() - 1 - i)).size(); ++m) {
                n[m] = (Short)((ArrayList)res.get(res.size() - 1 - i)).get(m);
            }
            result[i] = n;
        }
        return result;
    }

    public String toString(boolean verbose) {
        Object ss = verbose ? "Poly2[" : "[";
        for (int i = 0; i < this.indices.size; i += 3) {
            ss = (String)ss + "(" + this.indices.items[i] + ", " + this.indices.items[i + 1] + ", " + this.indices.items[i + 2] + ")";
            if (i == this.vertices.size - 3) continue;
            ss = (String)ss + "; ";
        }
        ss = (String)ss + "]";
        return ss;
    }

    public String toString() {
        return this.toString(true);
    }

    private Vector3 getBarycentric(Vector2 point, int index, Vector3 result) {
        Vector2 a = temp1.set(this.vertices.items[2 * this.indices.items[3 * index]], this.vertices.items[2 * this.indices.items[3 * index] + 1]);
        Vector2 b = temp2.set(this.vertices.items[2 * this.indices.items[3 * index + 1]], this.vertices.items[2 * this.indices.items[3 * index + 1] + 1]);
        Vector2 c = temp2.set(this.vertices.items[2 * this.indices.items[3 * index + 2]], this.vertices.items[2 * this.indices.items[3 * index + 2] + 1]);
        float det = (b.y - c.y) * (a.x - c.x) + (c.x - b.x) * (a.y - c.y);
        result.x = (b.y - c.y) * (point.x - c.x) + (c.x - b.x) * (point.y - c.y);
        result.y = (c.y - a.y) * (point.x - c.x) + (a.x - c.x) * (point.y - c.y);
        result.x /= det;
        result.y /= det;
        result.z = 1.0f - result.x - result.y;
        return result;
    }

    private class TreeNode {
        float hashCode;
        short[] elements = new short[3];
        ArrayList<TreeNode> neighbors = new ArrayList();
        TreeNode previous;

        public TreeNode(short a, short b, short c) {
            this.elements[0] = (short)Math.min(a, Math.min(b, c));
            this.elements[2] = (short)Math.max(a, Math.max(b, c));
            this.elements[1] = a;
            if (this.elements[0] == this.elements[1] || this.elements[2] == this.elements[1]) {
                this.elements[1] = b;
            }
            if (this.elements[0] == this.elements[1] || this.elements[2] == this.elements[1]) {
                this.elements[1] = c;
            }
            this.hashCode = a + 37 * b + 1369 * c;
        }

        public boolean equals(TreeNode o) {
            return this.elements[0] == o.elements[0] && this.elements[1] == o.elements[1] && this.elements[2] == o.elements[2];
        }

        public String toString() {
            return String.valueOf(this.elements[0]) + " " + String.valueOf(this.elements[1]) + " " + String.valueOf(this.elements[2]);
        }

        public String toString(short a, short b, short c) {
            short indx1 = (short)Math.min(a, Math.min(b, c));
            short indx3 = (short)Math.max(a, Math.max(b, c));
            short indx2 = a;
            if (indx1 == indx2 || indx3 == indx2) {
                indx2 = b;
            }
            if (indx1 == indx2 || indx3 == indx2) {
                indx2 = c;
            }
            return String.valueOf(indx1) + " " + String.valueOf(indx2) + " " + String.valueOf(indx3);
        }

        public boolean contains(int x) {
            return x >= 0 && (this.elements[0] == x || this.elements[1] == x || this.elements[2] == x);
        }

        public boolean adjacent(TreeNode node) {
            int count = 0;
            for (int i = 0; i < 3; ++i) {
                count += this.contains(node.elements[i]) ? 1 : 0;
            }
            return count == 2;
        }

        public int pick(IntSet inuse) {
            int[] count = new int[]{0, 0, 0};
            for (TreeNode node : this.neighbors) {
                for (int i = 0; i < 3; ++i) {
                    if (!node.contains(this.elements[i])) continue;
                    int n = i;
                    count[n] = count[n] + 1;
                }
            }
            int ptr = -1;
            for (int ii = 0; ii < 3; ++ii) {
                if (count[ii] != 0 && count[ii] != 1 || inuse.contains((int)this.elements[ii])) continue;
                if (ptr == -1) {
                    ptr = ii;
                    continue;
                }
                if (count[ii] >= count[ptr]) continue;
                ptr = ii;
            }
            return ptr != -1 ? this.elements[ptr] : -1;
        }

        public TreeNode follow(int index) {
            this.previous = null;
            return this.crawl(index);
        }

        public TreeNode crawl(int index) {
            if (!this.contains(index)) {
                return null;
            }
            TreeNode next = null;
            for (TreeNode node : this.neighbors) {
                if (node == this.previous || !node.contains(index)) continue;
                next = node;
            }
            if (next == null) {
                return this;
            }
            if (next.previous == this) {
                return null;
            }
            next.previous = this;
            return next.crawl(index);
        }
    }
}

