/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics.obj;

import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ShortArray;
import edu.cornell.gdiac.graphics.obj.MaterialInfo;
import edu.cornell.gdiac.graphics.obj.MaterialLib;
import edu.cornell.gdiac.graphics.obj.ModelInfo;
import java.io.BufferedReader;
import java.io.IOException;

public class ObjParser {
    public boolean debug = false;
    private FileHandleResolver resolver;
    public ObjectMap<String, MaterialInfo.LightMap> textures;
    public ObjectMap<String, MaterialLib> materials;
    public ObjectMap<String, ModelInfo> models;

    public ObjParser() {
        this.resolver = new InternalFileHandleResolver();
    }

    public ObjParser(FileHandleResolver resolver) {
        this.resolver = resolver;
    }

    public ModelInfo parseObj(String source, boolean recurse) {
        return this.parseObj(source, source, recurse);
    }

    public ModelInfo parseJson(JsonValue json) {
        ModelInfo result;
        if (json.isString()) {
            return this.parseObj(json.asString(), true);
        }
        if (!json.has("file")) {
            return null;
        }
        String key = json.name;
        String source = json.getString("file");
        int pos = source.lastIndexOf("/");
        String prefix = "";
        if (pos != -1) {
            prefix = source.substring(0, pos + 1);
        }
        if ((result = this.parseObj(key, source, false)) == null) {
            return null;
        }
        JsonValue mtljson = null;
        if (json.has("mtls")) {
            mtljson = json.get("mtls");
        }
        for (ObjectMap.Entry e : result.libraries.entries()) {
            JsonValue child = null;
            Object path = prefix + (String)e.key;
            if (mtljson != null && mtljson.has((String)e.key)) {
                child = mtljson.get((String)e.key);
                path = child.getString("file", (String)e.key);
            }
            MaterialLib lib = this.parseMtl((String)e.key, (String)path);
            e.value = lib;
            if (lib == null || child == null || !child.has("textures")) continue;
            child = child.get("textures");
            for (ObjectMap.Entry f : lib.infos.entries()) {
                JsonValue sub;
                MaterialInfo mtlinfo = (MaterialInfo)f.value;
                if (mtlinfo.map_Ka != null && child.has(mtlinfo.map_Ka.name)) {
                    sub = child.get(mtlinfo.map_Ka.name);
                    String string = mtlinfo.map_Ka.path = sub.isString() ? sub.asString() : sub.getString("file", mtlinfo.map_Ka.path);
                }
                if (mtlinfo.map_Kd != null && child.has(mtlinfo.map_Kd.name)) {
                    sub = child.get(mtlinfo.map_Kd.name);
                    String string = mtlinfo.map_Kd.path = sub.isString() ? sub.asString() : sub.getString("file", mtlinfo.map_Kd.path);
                }
                if (mtlinfo.map_Ks != null && child.has(mtlinfo.map_Ks.name)) {
                    sub = child.get(mtlinfo.map_Ks.name);
                    String string = mtlinfo.map_Ks.path = sub.isString() ? sub.asString() : sub.getString("file", mtlinfo.map_Ks.path);
                }
                if (mtlinfo.map_Kn == null || !child.has(mtlinfo.map_Kn.name)) continue;
                sub = child.get(mtlinfo.map_Kn.name);
                mtlinfo.map_Kn.path = sub.isString() ? sub.asString() : sub.getString("file", mtlinfo.map_Kn.path);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModelInfo parseObj(String key, String source, boolean recurse) {
        BufferedReader reader = this.resolver.resolve(source).reader(1024);
        ModelInfo model = new ModelInfo();
        model.name = key;
        model.path = source;
        try {
            block14: while (reader.ready()) {
                int begin;
                String line = reader.readLine();
                int end = line.length();
                for (begin = 0; begin != end && ObjParser.isSkippable(line.charAt(begin)); ++begin) {
                }
                if (begin == end) continue;
                char c = line.charAt(begin);
                switch (c) {
                    case 'o': {
                        this.processObject(line, begin, end, model);
                        continue block14;
                    }
                    case 'm': {
                        this.processImport(line, begin, end, model);
                        continue block14;
                    }
                    case 'g': {
                        this.processGroup(line, begin, end, model);
                        continue block14;
                    }
                    case 's': {
                        this.processSmooth(line, begin, end, model);
                        continue block14;
                    }
                    case 'v': {
                        this.processVertex(line, begin, end, model);
                        continue block14;
                    }
                    case 'f': {
                        this.processFace(line, begin, end, model);
                        continue block14;
                    }
                    case 'l': {
                        this.processLine(line, begin, end, model);
                        continue block14;
                    }
                    case 'p': {
                        this.processPoints(line, begin, end, model);
                        continue block14;
                    }
                    case 'u': {
                        this.processUsage(line, begin, end, model);
                        continue block14;
                    }
                    case '#': {
                        continue block14;
                    }
                }
                if (!this.debug) continue;
                System.err.println("Unsupported OBJ command: " + line);
            }
            reader.close();
        }
        catch (IOException line) {
            // empty catch block
        }
        if (recurse) {
            int pos = source.lastIndexOf(47);
            String root = "";
            if (pos != -1) {
                root = source.substring(0, pos + 1);
            }
            for (ObjectMap.Entry e : model.libraries) {
                if (e.value != null) continue;
                String path = root + (String)e.key;
                model.libraries.put((Object)((String)e.key), (Object)this.parseMtl((String)e.key, path));
            }
        }
        return model;
    }

    public ModelInfo getObj(String key) {
        if (this.models.containsKey((Object)key)) {
            return (ModelInfo)this.models.get((Object)key);
        }
        return null;
    }

    public MaterialLib parseMtl(String source) {
        return this.parseMtl(source, source);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MaterialLib parseMtl(String key, String source) {
        BufferedReader reader = this.resolver.resolve(source).reader(1024);
        MaterialLib lib = new MaterialLib();
        lib.name = key;
        lib.path = source;
        String root = "";
        int pos = source.lastIndexOf(47);
        if (pos != -1) {
            root = source.substring(0, pos + 1);
        }
        try {
            block10: while (true) {
                int begin;
                if (!reader.ready()) {
                    reader.close();
                    return lib;
                }
                String line = reader.readLine();
                int end = line.length();
                for (begin = 0; begin != end && ObjParser.isSkippable(line.charAt(begin)); ++begin) {
                }
                if (begin == end) continue;
                char c = line.charAt(begin);
                switch (c) {
                    case 'n': {
                        this.processMaterial(line, begin, end, lib);
                        continue block10;
                    }
                    case 'i': {
                        this.processIllum(line, begin, end, lib);
                        continue block10;
                    }
                    case 'N': {
                        this.processShininess(line, begin, end, lib);
                        continue block10;
                    }
                    case 'K': {
                        this.processColor(line, begin, end, lib);
                        continue block10;
                    }
                    case 'b': 
                    case 'm': {
                        MaterialInfo.LightMap texture = this.processTexture(line, begin, end, lib);
                        if (texture == null) continue block10;
                        texture.path = root + texture.name;
                        continue block10;
                    }
                    case '#': {
                        continue block10;
                    }
                }
                if (!this.debug) continue;
                System.err.println("Unsupported MTL command: " + line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lib;
    }

    public MaterialLib getMtl(String key) {
        if (this.materials.containsKey((Object)key)) {
            return (MaterialLib)this.materials.get((Object)key);
        }
        return null;
    }

    public void clear() {
        this.textures.clear();
        this.materials.clear();
        this.models.clear();
    }

    private void processObject(String line, int begin, int end, ModelInfo obj) {
        int right;
        int left;
        if (begin + 1 == end || !ObjParser.isSkippable(line.charAt(begin + 1))) {
            if (this.debug) {
                System.err.println("Unrecognized OBJ command: " + line.substring(begin, end));
            }
            return;
        }
        for (left = begin + 1; left != end && ObjParser.isSkippable(line.charAt(left)); ++left) {
        }
        for (right = left; right != end && !ObjParser.isSkippable(line.charAt(right)) && line.charAt(right) != '#'; ++right) {
        }
        if (left == right) {
            if (this.debug) {
                System.err.println("Invalid object name: " + line.substring(begin, end));
            }
            return;
        }
        String name = line.substring(left, right);
        ModelInfo.Group group = obj.acquireGroup();
        group.object = name;
    }

    private void processImport(String line, int begin, int end, ModelInfo obj) {
        int right;
        int left;
        String key = "mtllib";
        int len = key.length();
        if (begin + len + 1 >= end) {
            if (this.debug) {
                System.err.println("Unrecognized OBJ command: " + line.substring(begin, end));
            }
            return;
        }
        String command = line.substring(begin, begin + len);
        if (!command.equals(key) && this.debug) {
            System.err.println("Unrecognized OBJ command: " + command);
        }
        for (left = begin + len; left != end && ObjParser.isSkippable(line.charAt(left)); ++left) {
        }
        for (right = left; right != end && !ObjParser.isSkippable(line.charAt(right)) && line.charAt(right) != '#'; ++right) {
        }
        if (left == right) {
            if (this.debug) {
                System.err.println("Invalid library name: %s" + line.substring(begin, end));
            }
            return;
        }
        String lib = line.substring(left, right);
        obj.libraries.put((Object)lib, null);
    }

    private void processVertex(String line, int begin, int end, ModelInfo obj) {
        if (begin + 1 == end) {
            if (this.debug) {
                System.err.println("Unrecognized vertex command: " + line.substring(begin, end));
            }
            return;
        }
        char c = line.charAt(begin + 1);
        if (!ObjParser.isSkippable(c)) {
            switch (c) {
                case 'n': {
                    this.processNormal(line, begin, end, obj);
                    break;
                }
                case 't': {
                    this.processTexCoord(line, begin, end, obj);
                    break;
                }
                default: {
                    if (!this.debug) break;
                    System.err.println("Unsupported vertex command: " + line.substring(begin, end));
                }
            }
            return;
        }
        float[] data = new float[3];
        int index = ObjParser.fillFloatArray(data, line, begin + 1, end);
        if (index == 4) {
            if (this.debug) {
                System.err.println("Could not parse command: " + line.substring(begin, end));
            }
            return;
        }
        obj.positions.ensureCapacity(3);
        obj.positions.addAll(data);
    }

    private void processTexCoord(String line, int begin, int end, ModelInfo obj) {
        if (begin + 2 >= end || !ObjParser.isSkippable(line.charAt(begin + 2))) {
            if (this.debug) {
                System.err.println("Unrecognized tex coord command: " + line.substring(begin, end));
            }
            return;
        }
        float[] data = new float[2];
        int index = ObjParser.fillFloatArray(data, line, begin + 2, end);
        if (index == 3) {
            if (this.debug) {
                System.err.println("Could not parse command: " + line.substring(begin, end));
            }
            return;
        }
        data[1] = 1.0f - data[1];
        obj.texcoords.ensureCapacity(2);
        obj.texcoords.addAll(data);
    }

    private void processNormal(String line, int begin, int end, ModelInfo obj) {
        if (begin + 2 >= end || !ObjParser.isSkippable(line.charAt(begin + 2))) {
            if (this.debug) {
                System.err.println("Unrecognized normal command: " + line.substring(begin, end));
            }
            return;
        }
        float[] data = new float[3];
        int index = ObjParser.fillFloatArray(data, line, begin + 2, end);
        if (index == 4) {
            if (this.debug) {
                System.err.println("Could not parse command: " + line.substring(begin, end));
            }
            return;
        }
        obj.normals.ensureCapacity(3);
        obj.normals.addAll(data);
    }

    private void processUsage(String line, int begin, int end, ModelInfo obj) {
        int right;
        int left;
        String key = "usemtl";
        int len = key.length();
        if (begin + len + 1 >= end) {
            if (this.debug) {
                System.err.println("Unrecognized OBJ command: " + line.substring(begin, end));
            }
            return;
        }
        String command = line.substring(begin, begin + len);
        if (!command.equals(key) && this.debug) {
            System.err.println("Unrecognized OBJ command: " + command);
        }
        for (left = begin + len; left != end && ObjParser.isSkippable(line.charAt(left)); ++left) {
        }
        for (right = left; right != end && !ObjParser.isSkippable(line.charAt(right)) && line.charAt(right) != '#'; ++right) {
        }
        if (left == right) {
            if (this.debug) {
                System.err.println("Invalid material name: %s" + line.substring(begin, end));
            }
            return;
        }
        String name = line.substring(left, right);
        ModelInfo.Group group = obj.currentGroup();
        if (group == null || group.touched || !group.material.equals("")) {
            group = obj.acquireGroup();
        }
        obj.material = name;
        group.material = name;
    }

    private void processGroup(String line, int begin, int end, ModelInfo obj) {
        if (begin + 1 == end || !ObjParser.isSkippable(line.charAt(begin + 1))) {
            if (this.debug) {
                System.err.println("Unrecognized OBJ command: " + line.substring(begin, end));
            }
            return;
        }
        ModelInfo.Group group = obj.currentGroup();
        int curr = begin + 1;
        while (curr < end) {
            int right;
            int left;
            for (left = curr; left != end && ObjParser.isSkippable(line.charAt(left)); ++left) {
            }
            for (right = left; right != end && !ObjParser.isSkippable(line.charAt(right)) && line.charAt(right) != '#'; ++right) {
            }
            if (left != right) {
                if (group == null || group.touched) {
                    group = obj.acquireGroup();
                }
                group.tags.add((Object)line.substring(left, right));
                curr = right + 1;
                continue;
            }
            curr = end;
        }
    }

    private void processSmooth(String line, int begin, int end, ModelInfo obj) {
        if (begin + 1 == end || !ObjParser.isSkippable(line.charAt(begin + 1))) {
            if (this.debug) {
                System.err.println("Unrecognized OBJ command: " + line.substring(begin, end));
            }
            return;
        }
        int index = ObjParser.parseInt(line, begin + 2, end);
        if (index == -1) {
            if (this.debug) {
                System.err.println("Unrecognized index: " + line.substring(begin, end));
            }
            return;
        }
        ModelInfo.Group group = obj.acquireGroup();
        group.index = index;
    }

    private void processFace(String line, int begin, int end, ModelInfo obj) {
        if (begin + 1 == end || !ObjParser.isSkippable(line.charAt(begin + 1))) {
            if (this.debug) {
                System.err.println("Unrecognized OBJ command: " + line.substring(begin, end));
            }
            return;
        }
        ModelInfo.Group group = obj.currentGroup();
        if (group == null || group.command != 0 && group.command != 4) {
            group = obj.acquireGroup();
        }
        int curr = begin + 2;
        int count = group.vertCache.size;
        ShortArray indices = new ShortArray();
        while (curr < end) {
            ModelInfo.Vertex vert = obj.acquireVertex();
            curr = this.parseVertex(line, curr, end, vert);
            if (vert.pindex == -1) continue;
            if (group.vertCache.containsKey((Object)vert)) {
                int index = group.vertCache.get((Object)vert, -1);
                indices.add(index);
                continue;
            }
            indices.add(count);
            group.vertices.add((Object)vert);
            group.vertCache.put((Object)vert, count++);
        }
        group.command = 4;
        group.touched = false;
        short base = indices.items[0];
        short left = indices.items[1];
        for (int ii = 2; ii < indices.size; ++ii) {
            short right = indices.items[ii];
            group.indices.ensureCapacity(3);
            group.indices.add((int)base);
            group.indices.add((int)left);
            group.indices.add((int)right);
            left = right;
        }
    }

    private void processLine(String line, int begin, int end, ModelInfo obj) {
        if (begin + 1 == end || !ObjParser.isSkippable(line.charAt(begin + 1))) {
            if (this.debug) {
                System.err.println("Unrecognized OBJ command: " + line.substring(begin, end));
            }
            return;
        }
        ModelInfo.Group group = obj.currentGroup();
        if (group == null || group.command != 0 && group.command != 1) {
            group = obj.acquireGroup();
        }
        int curr = begin + 2;
        int count = group.vertCache.size;
        ShortArray indices = new ShortArray();
        while (curr < end) {
            ModelInfo.Vertex vert = obj.acquireVertex();
            curr = this.parseVertex(line, curr, end, vert);
            if (vert.pindex == -1) continue;
            if (group.vertCache.containsKey((Object)vert)) {
                int index = group.vertCache.get((Object)vert, -1);
                indices.add(index);
                continue;
            }
            indices.add(count);
            group.vertices.add((Object)vert);
            group.vertCache.put((Object)vert, count++);
        }
        group.command = 1;
        group.touched = false;
        short left = indices.items[0];
        for (int ii = 2; ii < indices.size; ++ii) {
            short right = indices.items[ii];
            group.indices.ensureCapacity(2);
            group.indices.add((int)left);
            group.indices.add((int)right);
            left = right;
        }
    }

    private void processPoints(String line, int begin, int end, ModelInfo obj) {
        if (begin + 1 == end || !ObjParser.isSkippable(line.charAt(begin + 1))) {
            if (this.debug) {
                System.err.println("Unrecognized OBJ command: " + line.substring(begin, end));
            }
            return;
        }
        ModelInfo.Group group = obj.currentGroup();
        if (group == null || group.command != 0 && group.command != 0) {
            group = obj.acquireGroup();
        }
        int curr = begin + 2;
        int count = group.vertCache.size;
        ShortArray indices = new ShortArray();
        while (curr < end) {
            ModelInfo.Vertex vert = obj.acquireVertex();
            curr = this.parseVertex(line, curr, end, vert);
            if (vert.pindex == -1) continue;
            if (group.vertCache.containsKey((Object)vert)) {
                int index = group.vertCache.get((Object)vert, -1);
                indices.add(index);
                continue;
            }
            indices.add(count);
            group.vertices.add((Object)vert);
            group.vertCache.put((Object)vert, count++);
        }
        group.command = 0;
        group.touched = false;
        group.indices.addAll(indices.items, 0, indices.size);
    }

    private void processMaterial(String line, int begin, int end, MaterialLib mtl) {
        int right;
        int left;
        String key = "newmtl";
        int len = key.length();
        if (begin + len + 1 >= end) {
            if (this.debug) {
                System.err.println("Unrecognized MTL command: " + line.substring(begin, end));
            }
            return;
        }
        String command = line.substring(begin, begin + len);
        if (!command.equals(key) && this.debug) {
            System.err.println("Unrecognized MTL command: " + line.substring(begin, end));
        }
        for (left = begin + len; left != end && ObjParser.isSkippable(line.charAt(left)); ++left) {
        }
        for (right = left; right != end && !ObjParser.isSkippable(line.charAt(right)) && line.charAt(right) != '#'; ++right) {
        }
        if (left == right) {
            if (this.debug) {
                System.err.println("Invalid material name: " + line.substring(begin, end));
            }
            return;
        }
        String name = line.substring(left, right);
        MaterialInfo material = mtl.acquireInfo(name);
        material.name = name;
    }

    private void processIllum(String line, int begin, int end, MaterialLib mtl) {
        int illum;
        String key = "illum";
        int len = key.length();
        if (begin + len + 1 >= end) {
            if (this.debug) {
                System.err.println("Unrecognized MTL command: " + line.substring(begin, end));
            }
            return;
        }
        String command = line.substring(begin, begin + len);
        if (!command.equals(key) && this.debug) {
            System.err.println("Unrecognized MTL command: " + line.substring(begin, end));
        }
        if ((illum = ObjParser.parseInt(line, begin + len + 1, end)) == -1) {
            if (this.debug) {
                System.err.println("Unrecognized illum: " + line.substring(begin, end));
            }
            return;
        }
        MaterialInfo material = mtl.currentInfo();
        if (material == null) {
            if (this.debug) {
                System.err.println("MTL command on undefined material");
            }
            return;
        }
        material.illum = illum;
    }

    private void processShininess(String line, int begin, int end, MaterialLib mtl) {
        float ns;
        String key = "Ns";
        int len = key.length();
        if (begin + len + 1 >= end) {
            if (this.debug) {
                System.err.println("Unrecognized MTL command: " + line.substring(begin, end));
            }
            return;
        }
        String command = line.substring(begin, begin + len);
        if (!command.equals(key) && this.debug) {
            System.err.println("Unrecognized MTL command: " + line.substring(begin, end));
        }
        if ((ns = ObjParser.parseFloat(line, begin + len + 1, end)) == Float.NEGATIVE_INFINITY) {
            if (this.debug) {
                System.err.println("Unrecognized shininess: " + line.substring(begin, end));
            }
            return;
        }
        MaterialInfo material = mtl.currentInfo();
        if (material == null) {
            if (this.debug) {
                System.out.println("MTL command on undefined material");
            }
            return;
        }
        material.Ns = ns;
    }

    private void processColor(String line, int begin, int end, MaterialLib mtl) {
        char suff = line.charAt(begin + 1);
        MaterialInfo material = mtl.currentInfo();
        if (material == null) {
            if (this.debug) {
                System.out.println("MTL command on undefined material");
            }
            return;
        }
        switch (suff) {
            case 'a': {
                if (material.Ka == null) {
                    material.Ka = new Color();
                }
                Color color = material.Ka;
                break;
            }
            case 'd': {
                if (material.Kd == null) {
                    material.Kd = new Color();
                }
                Color color = material.Kd;
                break;
            }
            case 's': {
                if (material.Ks == null) {
                    material.Ks = new Color();
                }
                Color color = material.Ks;
                break;
            }
            default: {
                if (this.debug) {
                    System.err.println("Unrecognized MTL command: " + line.substring(begin, end));
                }
                return;
            }
        }
        suff = line.charAt(begin + 2);
        if (!ObjParser.isSkippable(suff)) {
            if (this.debug) {
                System.err.println("Unrecognized MTL command: " + line.substring(begin, end));
            }
            return;
        }
        float[] data = new float[3];
        int index = ObjParser.fillFloatArray(data, line, begin + 2, end);
        if (index == 4) {
            if (this.debug) {
                System.err.println("Could not parse command: " + line.substring(begin, end));
            }
            return;
        }
        color.r = data[0];
        color.g = data[1];
        color.b = data[2];
        color.a = 1.0f;
    }

    private MaterialInfo.LightMap processTexture(String line, int begin, int end, MaterialLib mtl) {
        Array tokens = new Array();
        int left = begin;
        while (left != end) {
            int right;
            while (left != end && ObjParser.isSkippable(line.charAt(left))) {
                ++left;
            }
            for (right = left; right != end && !ObjParser.isSkippable(line.charAt(right)); ++right) {
            }
            if (left != right) {
                tokens.add((Object)line.substring(left, right));
            }
            left = right;
        }
        if (tokens.size < 2) {
            return null;
        }
        MaterialInfo material = mtl.currentInfo();
        if (material == null) {
            if (this.debug) {
                System.out.println("MTL command on undefined material");
            }
            return null;
        }
        MaterialInfo.LightMap texture = material.acquireLightMap();
        if (((String)tokens.get(0)).equals("map_Ka")) {
            material.map_Ka = texture;
        } else if (((String)tokens.get(0)).equals("map_Kd")) {
            material.map_Kd = texture;
        } else if (((String)tokens.get(0)).equals("map_Ks")) {
            material.map_Ks = texture;
        } else if (((String)tokens.get(0)).equals("map_Kn") || ((String)tokens.get(0)).equals("bump")) {
            material.map_Kn = texture;
        } else {
            return null;
        }
        texture.name = (String)tokens.get(tokens.size - 1);
        if (tokens.size > 2) {
            for (int ii = 1; ii < tokens.size - 1; ++ii) {
                String tk = (String)tokens.get(ii);
                if (tk.charAt(0) != '-') {
                    if (!this.debug) continue;
                    System.out.println("Unrecognized texture command: " + tk);
                    continue;
                }
                if (tk.equals("-blendu") || tk.equals("-blendv") || tk.equals("-cc") || tk.equals("-texres") || tk.equals("-imfchan")) {
                    if (this.debug) {
                        System.out.println("Unsupported texture option: " + tk);
                    }
                    ++ii;
                    continue;
                }
                if (tk.equals("-mm")) {
                    if (this.debug) {
                        System.out.println("Unsupported texture option: " + tk);
                    }
                    ii += 2;
                    continue;
                }
                if (tk.equals("-o") || tk.equals("-s") || tk.equals("-t")) {
                    if (this.debug) {
                        System.out.println("Unsupported texture option: " + tk);
                    }
                    ii += 3;
                    continue;
                }
                if (!tk.equals("-clamp") || ++ii >= tokens.size - 1) continue;
                tk = (String)tokens.get(ii);
                if (tk.equals("on")) {
                    texture.wrapU = Texture.TextureWrap.ClampToEdge;
                    texture.wrapV = Texture.TextureWrap.ClampToEdge;
                    continue;
                }
                if (tk.equals("off")) {
                    texture.wrapU = Texture.TextureWrap.Repeat;
                    texture.wrapV = Texture.TextureWrap.Repeat;
                    continue;
                }
                if (!this.debug) continue;
                System.err.println("Unrecognized clamp option: " + tk);
            }
        }
        return texture;
    }

    private int parseVertex(String line, int begin, int end, ModelInfo.Vertex vtx) {
        int left;
        for (left = begin; left != end && ObjParser.isSkippable(line.charAt(left)); ++left) {
        }
        int right = ObjParser.findEnd(line, left, " /#");
        if (right == -1) {
            right = end;
        }
        try {
            vtx.pindex = Integer.parseInt(line.substring(left, right)) - 1;
        }
        catch (NumberFormatException e) {
            vtx.pindex = -1;
        }
        left = right;
        if (left != end && line.charAt(left) == '/') {
            if ((right = ObjParser.findEnd(line, ++left, " /#")) == -1) {
                right = end;
            }
            try {
                vtx.tindex = Integer.parseInt(line.substring(left, right)) - 1;
            }
            catch (NumberFormatException e) {
                vtx.tindex = -1;
            }
        }
        if ((left = right) != end && line.charAt(left) == '/') {
            if ((right = ObjParser.findEnd(line, ++left, " /#")) == -1) {
                right = end;
            }
            try {
                vtx.nindex = Integer.parseInt(line.substring(left, right)) - 1;
            }
            catch (NumberFormatException e) {
                vtx.nindex = -1;
            }
        }
        return right;
    }

    private static boolean isSkippable(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c <= '\u0000';
    }

    private static int fillFloatArray(float[] data, String line, int begin, int end) {
        int index = 0;
        int curr = begin;
        while (index < data.length) {
            int right;
            while (curr != end && ObjParser.isSkippable(line.charAt(curr)) && line.charAt(curr) != '#') {
                ++curr;
            }
            if (curr == end || line.charAt(curr) == '#') {
                index = data.length + 1;
            }
            if ((right = ObjParser.findEnd(line, curr, " #")) == -1) {
                right = end;
            }
            try {
                data[index++] = Float.parseFloat(line.substring(curr, right));
                curr = right;
            }
            catch (NumberFormatException e) {
                return data.length + 1;
            }
        }
        return index;
    }

    private static int parseInt(String line, int begin, int end) {
        int right = ObjParser.findEnd(line, begin, " #");
        if (right == -1) {
            right = end;
        }
        try {
            return Integer.parseInt(line.substring(begin, right));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static float parseFloat(String line, int begin, int end) {
        int right = ObjParser.findEnd(line, begin, " #");
        if (right == -1) {
            right = end;
        }
        try {
            return Float.parseFloat(line.substring(begin, right));
        }
        catch (NumberFormatException e) {
            return Float.NEGATIVE_INFINITY;
        }
    }

    private static int findEnd(String line, int begin, String markers) {
        int result = -1;
        for (int ii = 0; ii < markers.length(); ++ii) {
            int pos = line.indexOf(markers.charAt(ii), begin);
            if (result == -1) {
                result = pos;
                continue;
            }
            if (pos == -1 || pos >= result) continue;
            result = pos;
        }
        return result;
    }
}

