/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.g2d.freetype.FreetypeFontLoader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.assets.AssetParser;
import edu.cornell.gdiac.assets.ParserUtils;

public class FreetypeFontParser
implements AssetParser<BitmapFont> {
    private JsonValue root;

    @Override
    public Class<BitmapFont> getType() {
        return BitmapFont.class;
    }

    @Override
    public void reset(JsonValue directory) {
        this.root = directory;
        this.root = this.root.getChild("fonts");
    }

    @Override
    public boolean hasNext() {
        return this.root != null;
    }

    @Override
    public void processNext(AssetManager manager, ObjectMap<String, String> keymap) {
        FreetypeFontLoader.FreeTypeFontLoaderParameter params = new FreetypeFontLoader.FreeTypeFontLoaderParameter();
        if (this.root.isString()) {
            params.fontParameters.size = 16;
            params.fontParameters.mono = false;
            params.fontParameters.hinting = FreeTypeFontGenerator.Hinting.AutoMedium;
            params.fontParameters.color = Color.WHITE;
            params.fontParameters.gamma = 1.8f;
            params.fontParameters.renderCount = 2;
            params.fontParameters.borderWidth = 0.0f;
            params.fontParameters.borderColor = Color.BLACK;
            params.fontParameters.borderStraight = false;
            params.fontParameters.borderGamma = 1.8f;
            params.fontParameters.shadowOffsetX = 0;
            params.fontParameters.shadowOffsetY = 0;
            params.fontParameters.shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.75f);
            params.fontParameters.spaceX = 0;
            params.fontParameters.spaceY = 0;
            params.fontParameters.padTop = 0;
            params.fontParameters.padLeft = 0;
            params.fontParameters.padBottom = 0;
            params.fontParameters.padRight = 0;
            params.fontParameters.characters = "\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890\"!`?'.,;:()[]{}<>|/@\\^$\u20ac-%+=#_&~*\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff";
            params.fontParameters.kerning = true;
            params.fontParameters.flip = false;
            params.fontParameters.genMipMaps = false;
            params.fontParameters.minFilter = Texture.TextureFilter.Linear;
            params.fontParameters.magFilter = Texture.TextureFilter.Linear;
            params.fontFileName = this.root.toString();
            Object uid = params.fontFileName;
            if (params.fontFileName.toLowerCase().endsWith(".ttf")) {
                uid = ((String)uid).substring(0, ((String)uid).length() - 4) + ":" + params.fontParameters.size + ".ttf";
            }
            keymap.put((Object)this.root.name(), uid);
            manager.load((String)uid, BitmapFont.class, (AssetLoaderParameters)params);
        } else {
            params.fontParameters.size = this.root.getInt("size", 16);
            params.fontParameters.mono = this.root.getBoolean("mono", false);
            params.fontParameters.hinting = ParserUtils.parseHinting(this.root.get("hinting"), FreeTypeFontGenerator.Hinting.AutoMedium);
            params.fontParameters.color = ParserUtils.parseColor(this.root.get("color"), Color.WHITE);
            params.fontParameters.gamma = this.root.getFloat("gamma", 1.8f);
            params.fontParameters.renderCount = this.root.getInt("renderCount", 2);
            params.fontParameters.borderWidth = this.root.getInt("borderWidth", 0);
            params.fontParameters.borderColor = ParserUtils.parseColor(this.root.get("borderColor"), Color.BLACK);
            params.fontParameters.borderStraight = this.root.getBoolean("borderStraight", false);
            params.fontParameters.borderGamma = this.root.getFloat("borderGamma", 1.8f);
            params.fontParameters.shadowOffsetX = this.root.getInt("shadowOffsetX", 0);
            params.fontParameters.shadowOffsetY = this.root.getInt("shadowOffsetY", 0);
            params.fontParameters.shadowColor = ParserUtils.parseColor(this.root.get("shadowColor"), new Color(0.0f, 0.0f, 0.0f, 0.75f));
            params.fontParameters.spaceX = this.root.getInt("spaceX", 0);
            params.fontParameters.spaceY = this.root.getInt("spaceY", 0);
            params.fontParameters.padTop = this.root.getInt("padTop", 1);
            params.fontParameters.padLeft = this.root.getInt("padLeft", 1);
            params.fontParameters.padBottom = this.root.getInt("padBottom", 1);
            params.fontParameters.padRight = this.root.getInt("padRight", 1);
            params.fontParameters.characters = this.root.getString("characters", "\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890\"!`?'.,;:()[]{}<>|/@\\^$\u20ac-%+=#_&~*\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff");
            params.fontParameters.kerning = this.root.getBoolean("kerning", true);
            params.fontParameters.flip = this.root.getBoolean("flip", false);
            params.fontParameters.genMipMaps = this.root.getBoolean("mipmaps", false);
            params.fontParameters.minFilter = ParserUtils.parseFilter(this.root.get("minFilter"), Texture.TextureFilter.Linear);
            params.fontParameters.magFilter = ParserUtils.parseFilter(this.root.get("magFilter"), Texture.TextureFilter.Linear);
            params.fontFileName = this.root.getString("file", null);
            if (params.fontFileName != null) {
                Object uid = params.fontFileName;
                if (params.fontFileName.toLowerCase().endsWith(".ttf")) {
                    uid = ((String)uid).substring(0, ((String)uid).length() - 4) + ":" + params.fontParameters.size + ".ttf";
                }
                keymap.put((Object)this.root.name(), uid);
                manager.load((String)uid, BitmapFont.class, (AssetLoaderParameters)params);
            }
        }
        this.root = this.root.next();
    }

    public boolean equals(Object o) {
        return o instanceof FreetypeFontParser;
    }
}

