/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.util;

import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.ControllerMapping;
import com.badlogic.gdx.controllers.ControllerPowerLevel;

public class XBoxController
implements Controller,
ControllerListener {
    private ControllerMapping mapping;
    public Controller controller;
    private float deadZone = 0.01f;

    public XBoxController(Controller controller) {
        if (controller == null) {
            throw new NullPointerException();
        }
        this.controller = controller;
        this.mapping = controller.getMapping();
        if (this.mapping == null) {
            throw new IllegalStateException("Controller does not have a supported mapping");
        }
    }

    public float getDeadZone() {
        return this.deadZone;
    }

    public void setDeadZone(float tol) {
        this.deadZone = tol;
    }

    public boolean getStart() {
        if (this.controller != null) {
            this.controller.getButton(this.mapping.buttonStart);
        }
        return false;
    }

    public boolean getBack() {
        if (this.controller != null) {
            return this.controller.getButton(this.mapping.buttonBack);
        }
        return false;
    }

    public boolean getX() {
        if (this.controller != null) {
            return this.controller.getButton(this.mapping.buttonX);
        }
        return false;
    }

    public boolean getY() {
        if (this.controller != null) {
            return this.controller.getButton(this.mapping.buttonY);
        }
        return false;
    }

    public boolean getA() {
        if (this.controller != null) {
            return this.controller.getButton(this.mapping.buttonA);
        }
        return false;
    }

    public boolean getB() {
        if (this.controller != null) {
            return this.controller.getButton(this.mapping.buttonB);
        }
        return false;
    }

    public boolean getLBumper() {
        if (this.controller != null) {
            return this.controller.getButton(this.mapping.buttonL1);
        }
        return false;
    }

    public boolean getLStick() {
        if (this.controller != null) {
            return this.controller.getButton(this.mapping.buttonLeftStick);
        }
        return false;
    }

    public boolean getRBumper() {
        if (this.controller != null) {
            return this.controller.getButton(this.mapping.buttonR1);
        }
        return false;
    }

    public boolean getRStick() {
        if (this.controller != null) {
            return this.controller.getButton(this.mapping.buttonRightStick);
        }
        return false;
    }

    public boolean getDPadUp() {
        if (this.controller != null) {
            return this.controller.getButton(this.mapping.buttonDpadUp) && !this.controller.getButton(this.mapping.buttonDpadLeft) && !this.controller.getButton(this.mapping.buttonDpadRight);
        }
        return false;
    }

    public boolean getDPadDown() {
        if (this.controller != null) {
            return this.controller.getButton(this.mapping.buttonDpadDown) && !this.controller.getButton(this.mapping.buttonDpadLeft) && !this.controller.getButton(this.mapping.buttonDpadRight);
        }
        return false;
    }

    public boolean getDPadLeft() {
        if (this.controller != null) {
            return this.controller.getButton(this.mapping.buttonDpadLeft) && !this.controller.getButton(this.mapping.buttonDpadUp) && !this.controller.getButton(this.mapping.buttonDpadDown);
        }
        return false;
    }

    public boolean getDPadRight() {
        if (this.controller != null) {
            return this.controller.getButton(this.mapping.buttonDpadRight) && !this.controller.getButton(this.mapping.buttonDpadUp) && !this.controller.getButton(this.mapping.buttonDpadDown);
        }
        return false;
    }

    public Direction getDPadDirection() {
        if (this.controller != null) {
            int x = 0;
            int y = 0;
            if (this.controller.getButton(this.mapping.buttonDpadLeft)) {
                --x;
            }
            if (this.controller.getButton(this.mapping.buttonDpadRight)) {
                ++x;
            }
            if (this.controller.getButton(this.mapping.buttonDpadUp)) {
                ++y;
            }
            if (this.controller.getButton(this.mapping.buttonDpadDown)) {
                --y;
            }
            if (x == 0) {
                if (y == 0) {
                    return Direction.NEUTRAL;
                }
                if (y < 0) {
                    return Direction.SOUTH;
                }
                return Direction.NORTH;
            }
            if (x < 0) {
                if (y == 0) {
                    return Direction.WEST;
                }
                if (y < 0) {
                    return Direction.SOUTHWEST;
                }
                return Direction.NORTHWEST;
            }
            if (y == 0) {
                return Direction.EAST;
            }
            if (y < 0) {
                return Direction.SOUTHEAST;
            }
            return Direction.NORTHEAST;
        }
        return Direction.NEUTRAL;
    }

    public float getLeftX() {
        float value;
        if (this.controller != null && Math.abs(value = this.controller.getAxis(this.mapping.axisLeftX)) > this.deadZone) {
            return value < -1.0f ? -1.0f : (value > 1.0f ? 1.0f : value);
        }
        return 0.0f;
    }

    public float getLeftY() {
        float value;
        if (this.controller != null && Math.abs(value = this.controller.getAxis(this.mapping.axisLeftY)) > this.deadZone) {
            return value < -1.0f ? -1.0f : (value > 1.0f ? 1.0f : value);
        }
        return 0.0f;
    }

    public float getLeftTrigger() {
        if (this.controller != null) {
            float value = this.controller.getAxis(this.controller.getAxisCount() - 2);
            return value < 0.0f ? 0.0f : (value > 1.0f ? 1.0f : value);
        }
        return 0.0f;
    }

    public float getRightX() {
        float value;
        if (this.controller != null && Math.abs(value = this.controller.getAxis(this.mapping.axisRightX)) > this.deadZone) {
            return value < -1.0f ? -1.0f : (value > 1.0f ? 1.0f : value);
        }
        return 0.0f;
    }

    public float getRightY() {
        float value;
        if (this.controller != null && Math.abs(value = this.controller.getAxis(this.mapping.axisRightY)) > this.deadZone) {
            return value < -1.0f ? -1.0f : (value > 1.0f ? 1.0f : value);
        }
        return 0.0f;
    }

    public float getRightTrigger() {
        if (this.controller != null) {
            float value = this.controller.getAxis(this.controller.getAxisCount() - 1);
            return value < 0.0f ? 0.0f : (value > 1.0f ? 1.0f : value);
        }
        return 0.0f;
    }

    public boolean getButton(int buttonCode) {
        if (this.controller != null) {
            return this.controller.getButton(buttonCode);
        }
        return false;
    }

    public float getAxis(int axisCode) {
        if (this.controller != null) {
            return this.getAxis(axisCode);
        }
        return 0.0f;
    }

    public String getName() {
        if (this.controller != null) {
            return this.getName();
        }
        return null;
    }

    public String getUniqueId() {
        if (this.controller != null) {
            return this.getUniqueId();
        }
        return null;
    }

    public int getMinButtonIndex() {
        if (this.controller != null) {
            return this.getMinButtonIndex();
        }
        return 0;
    }

    public int getMaxButtonIndex() {
        if (this.controller != null) {
            return this.getMaxButtonIndex();
        }
        return 0;
    }

    public int getAxisCount() {
        if (this.controller != null) {
            return this.getAxisCount();
        }
        return 0;
    }

    public boolean isConnected() {
        return this.controller != null && this.controller.isConnected();
    }

    public boolean canVibrate() {
        if (this.controller != null) {
            return this.canVibrate();
        }
        return false;
    }

    public boolean isVibrating() {
        if (this.controller != null) {
            return this.isVibrating();
        }
        return false;
    }

    public void startVibration(int duration, float strength) {
        if (this.controller != null) {
            this.startVibration(duration, strength);
        }
    }

    public void cancelVibration() {
        if (this.controller != null) {
            this.cancelVibration();
        }
    }

    public boolean supportsPlayerIndex() {
        if (this.controller != null) {
            return this.supportsPlayerIndex();
        }
        return false;
    }

    public int getPlayerIndex() {
        if (this.controller != null) {
            return this.getPlayerIndex();
        }
        return -1;
    }

    public void setPlayerIndex(int index) {
        if (this.controller != null) {
            this.setPlayerIndex(index);
        }
    }

    public ControllerMapping getMapping() {
        return this.mapping;
    }

    public ControllerPowerLevel getPowerLevel() {
        if (this.controller != null) {
            return this.getPowerLevel();
        }
        return null;
    }

    public void addListener(ControllerListener listener) {
        if (this.controller != null) {
            this.controller.addListener(listener);
        }
    }

    public void removeListener(ControllerListener listener) {
        if (this.controller != null) {
            this.controller.removeListener(listener);
        }
    }

    public void connected(Controller controller) {
    }

    public void disconnected(Controller controller) {
        if (this.controller == controller) {
            this.controller = null;
            this.mapping = null;
        }
    }

    public boolean buttonDown(Controller controller, int buttonCode) {
        return true;
    }

    public boolean buttonUp(Controller controller, int buttonCode) {
        return true;
    }

    public boolean axisMoved(Controller controller, int axisCode, float value) {
        return true;
    }

    public static enum Direction {
        NEUTRAL,
        EAST,
        SOUTHEAST,
        SOUTH,
        SOUTHWEST,
        WEST,
        NORTHWEST,
        NORTH,
        NORTHEAST;

    }
}

