/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics.obj;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.ShortArray;

public class ObjMesh {
    public final int STRIDE = 11;
    public int command;
    public FloatArray vertices;
    public ShortArray indices;
    Vector3 temp1 = new Vector3();
    private Vector3 vectorCache = new Vector3();

    public ObjMesh() {
        this.vertices = new FloatArray();
        this.indices = new ShortArray();
        this.command = 4;
    }

    public ObjMesh(float[] vertices) {
        this.vertices = new FloatArray(vertices);
        this.indices = new ShortArray();
        this.command = 4;
    }

    public ObjMesh(float[] vertices, int voffset, int vlength) {
        this.vertices = new FloatArray(vlength);
        this.vertices.addAll(vertices, voffset, vlength);
        this.indices = new ShortArray();
        this.command = 4;
    }

    public ObjMesh(float[] vertices, short[] indices) {
        this.vertices = new FloatArray(vertices);
        this.indices = new ShortArray(indices);
        this.command = 4;
    }

    public ObjMesh(ObjMesh mesh) {
        this.vertices = new FloatArray();
        this.indices = new ShortArray();
        this.vertices.addAll(mesh.vertices);
        this.indices.addAll(mesh.indices);
        this.command = 4;
    }

    public ObjMesh set(float[] vertices) {
        this.vertices.clear();
        this.vertices.addAll(vertices);
        this.indices.clear();
        return this;
    }

    public ObjMesh set(float[] vertices, int voffset, int vlength) {
        this.vertices.clear();
        this.vertices.addAll(vertices, voffset, vlength);
        this.indices.clear();
        return this;
    }

    public ObjMesh set(ObjMesh mesh) {
        this.vertices.clear();
        this.vertices.addAll(mesh.vertices);
        this.indices.clear();
        this.indices.addAll(mesh.indices);
        return this;
    }

    public ObjMesh setIndices(short[] indices) {
        this.indices.clear();
        this.indices.addAll(indices);
        return this;
    }

    public ObjMesh setIndices(short[] indices, int ioffset, int ilength) {
        this.indices.clear();
        this.indices.addAll(indices, ioffset, ilength);
        return this;
    }

    public void clear() {
        this.vertices.clear();
        this.indices.clear();
    }

    public int vertexCount() {
        return this.vertices.size / 11;
    }

    public int indexCount() {
        return this.indices.size;
    }

    public float getPositionX(int idx) {
        return this.vertices.items[idx * 11];
    }

    public float getPositionY(int idx) {
        return this.vertices.items[idx * 11 + 1];
    }

    public float getPositionZ(int idx) {
        return this.vertices.items[idx * 11 + 3];
    }

    public Vector3 getPosition(int idx) {
        int pos = idx * 11;
        return new Vector3(this.vertices.items[pos], this.vertices.items[pos + 1], this.vertices.items[pos + 2]);
    }

    public Vector3 getPosition(int idx, Vector3 v) {
        int pos = idx * 11;
        if (v == null) {
            return new Vector3(this.vertices.items[pos], this.vertices.items[pos + 1], this.vertices.items[pos + 2]);
        }
        v.set(this.vertices.items[pos], this.vertices.items[pos + 1], this.vertices.items[pos + 2]);
        return v;
    }

    public void setPosition(int idx, Vector3 v) {
        this.setPosition(idx, v.x, v.y, v.z);
    }

    public void setPosition(int idx, float x, float y, float z) {
        int pos = idx * 11;
        this.vertices.items[pos] = x;
        this.vertices.items[pos + 1] = y;
        this.vertices.items[pos + 2] = z;
    }

    public float getNormalX(int idx) {
        return this.vertices.items[idx * 11 + 3];
    }

    public float getNormalY(int idx) {
        return this.vertices.items[idx * 11 + 4];
    }

    public float getNormalZ(int idx) {
        return this.vertices.items[idx * 11 + 5];
    }

    public Vector3 getNormal(int idx) {
        int pos = idx * 11;
        return new Vector3(this.vertices.items[pos + 3], this.vertices.items[pos + 4], this.vertices.items[pos + 5]);
    }

    public Vector3 getNormal(int idx, Vector3 v) {
        int pos = idx * 11;
        if (v == null) {
            return new Vector3(this.vertices.items[pos + 3], this.vertices.items[pos + 4], this.vertices.items[pos + 5]);
        }
        v.set(this.vertices.items[pos + 3], this.vertices.items[pos + 4], this.vertices.items[pos + 5]);
        return v;
    }

    public void setNormal(int idx, Vector3 v) {
        this.setNormal(idx, v.x, v.y, v.z);
    }

    public void setNormal(int idx, float x, float y, float z) {
        int pos = idx * 11;
        this.vertices.items[pos + 3] = x;
        this.vertices.items[pos + 4] = y;
        this.vertices.items[pos + 5] = z;
    }

    public float geTangentX(int idx) {
        return this.vertices.items[idx * 11 + 6];
    }

    public float getTangentY(int idx) {
        return this.vertices.items[idx * 11 + 7];
    }

    public float getTangentZ(int idx) {
        return this.vertices.items[idx * 11 + 8];
    }

    public Vector3 getTangent(int idx) {
        int pos = idx * 11;
        return new Vector3(this.vertices.items[pos + 6], this.vertices.items[pos + 7], this.vertices.items[pos + 8]);
    }

    public Vector3 getTangent(int idx, Vector3 v) {
        int pos = idx * 11;
        if (v == null) {
            return new Vector3(this.vertices.items[pos + 6], this.vertices.items[pos + 7], this.vertices.items[pos + 8]);
        }
        v.set(this.vertices.items[pos + 6], this.vertices.items[pos + 7], this.vertices.items[pos + 8]);
        return v;
    }

    public void setTangent(int idx, Vector3 v) {
        this.setTangent(idx, v.x, v.y, v.z);
    }

    public void setTangent(int idx, float x, float y, float z) {
        int pos = idx * 11;
        this.vertices.items[pos + 6] = x;
        this.vertices.items[pos + 7] = y;
        this.vertices.items[pos + 8] = z;
    }

    public float geTexCoordX(int idx) {
        return this.vertices.items[idx * 11 + 9];
    }

    public float getTexCoordY(int idx) {
        return this.vertices.items[idx * 11 + 10];
    }

    public Vector2 getTexCoord(int idx) {
        int pos = idx * 11;
        return new Vector2(this.vertices.items[pos + 9], this.vertices.items[pos + 10]);
    }

    public Vector2 getTexCoord(int idx, Vector2 v) {
        int pos = idx * 11;
        if (v == null) {
            return new Vector2(this.vertices.items[pos + 9], this.vertices.items[pos + 10]);
        }
        v.set(this.vertices.items[pos + 9], this.vertices.items[pos + 10]);
        return v;
    }

    public void setTexCoord(int idx, Vector2 v) {
        this.setTexCoord(idx, v.x, v.y);
    }

    public void setTexCoord(int idx, float x, float y) {
        int pos = idx * 11;
        this.vertices.items[pos + 9] = x;
        this.vertices.items[pos + 10] = y;
    }

    public ObjMesh scl(float scale) {
        for (int ii = 0; ii < this.vertices.size; ii += 11) {
            int n = ii;
            this.vertices.items[n] = this.vertices.items[n] * scale;
            int n2 = ii + 1;
            this.vertices.items[n2] = this.vertices.items[n2] * scale;
            int n3 = ii + 2;
            this.vertices.items[n3] = this.vertices.items[n3] * scale;
        }
        return this;
    }

    public ObjMesh scl(Vector3 scale) {
        for (int ii = 0; ii < this.vertices.size; ii += 11) {
            int n = ii;
            this.vertices.items[n] = this.vertices.items[n] * scale.x;
            int n2 = ii + 1;
            this.vertices.items[n2] = this.vertices.items[n2] * scale.y;
            int n3 = ii + 2;
            this.vertices.items[n3] = this.vertices.items[n3] * scale.z;
        }
        return this;
    }

    public ObjMesh div(float scale) {
        if (scale == 0.0f) {
            throw new ArithmeticException("Divided by zero operation cannot possible");
        }
        return this.scl(1.0f / scale);
    }

    public ObjMesh div(Vector3 scale) {
        if (scale.x == 0.0f || scale.y == 0.0f) {
            throw new ArithmeticException("Divided by zero operation cannot possible");
        }
        this.temp1.set(1.0f / scale.x, 1.0f / scale.y, 1.0f / scale.z);
        return this.scl(this.temp1);
    }

    public ObjMesh add(float offset) {
        for (int ii = 0; ii < this.vertices.size; ii += 11) {
            int n = ii;
            this.vertices.items[n] = this.vertices.items[n] + offset;
            int n2 = ii + 1;
            this.vertices.items[n2] = this.vertices.items[n2] + offset;
            int n3 = ii + 2;
            this.vertices.items[n3] = this.vertices.items[n3] + offset;
        }
        return this;
    }

    public ObjMesh add(Vector3 offset) {
        for (int ii = 0; ii < this.vertices.size; ii += 11) {
            int n = ii;
            this.vertices.items[n] = this.vertices.items[n] + offset.x;
            int n2 = ii + 1;
            this.vertices.items[n2] = this.vertices.items[n2] + offset.y;
            int n3 = ii + 1;
            this.vertices.items[n3] = this.vertices.items[n3] + offset.z;
        }
        return this;
    }

    public ObjMesh add(float x, float y, float z) {
        for (int ii = 0; ii < this.vertices.size; ii += 11) {
            int n = ii;
            this.vertices.items[n] = this.vertices.items[n] + x;
            int n2 = ii + 1;
            this.vertices.items[n2] = this.vertices.items[n2] + y;
            int n3 = ii + 1;
            this.vertices.items[n3] = this.vertices.items[n3] + z;
        }
        return this;
    }

    public ObjMesh sub(float offset) {
        for (int ii = 0; ii < this.vertices.size; ii += 11) {
            int n = ii;
            this.vertices.items[n] = this.vertices.items[n] - offset;
            int n2 = ii + 1;
            this.vertices.items[n2] = this.vertices.items[n2] - offset;
            int n3 = ii + 2;
            this.vertices.items[n3] = this.vertices.items[n3] - offset;
        }
        return this;
    }

    public ObjMesh sub(Vector3 offset) {
        for (int ii = 0; ii < this.vertices.size; ii += 11) {
            int n = ii;
            this.vertices.items[n] = this.vertices.items[n] - offset.x;
            int n2 = ii + 1;
            this.vertices.items[n2] = this.vertices.items[n2] - offset.y;
            int n3 = ii + 2;
            this.vertices.items[n3] = this.vertices.items[n3] - offset.z;
        }
        return this;
    }

    public ObjMesh sub(float x, float y, float z) {
        for (int ii = 0; ii < this.vertices.size; ii += 11) {
            int n = ii;
            this.vertices.items[n] = this.vertices.items[n] - x;
            int n2 = ii + 1;
            this.vertices.items[n2] = this.vertices.items[n2] - y;
            int n3 = ii + 2;
            this.vertices.items[n3] = this.vertices.items[n3] - z;
        }
        return this;
    }

    public ObjMesh transform(Matrix4 matrix) {
        for (int ii = 0; ii < this.vertices.size; ii += 11) {
            this.vectorCache.set(this.vertices.items[ii], this.vertices.items[ii + 1], this.vertices.items[ii * 11 + 2]);
            this.vectorCache.mul(matrix);
            this.vertices.items[ii] = this.vectorCache.x;
            this.vertices.items[ii + 1] = this.vectorCache.y;
            this.vertices.items[ii + 2] = this.vectorCache.z;
        }
        return this;
    }

    public ObjMesh transform(Matrix4 matrix, int offset, int count) {
        if (offset + count > this.vertexCount()) {
            throw new IndexOutOfBoundsException("offset+count exceeds number of vertices");
        }
        for (int ii = offset * 11; ii < count * 11; ii += 11) {
            this.vectorCache.set(this.vertices.items[ii], this.vertices.items[ii + 1], this.vertices.items[ii + 2]);
            this.vectorCache.mul(matrix);
            this.vertices.items[ii] = this.vectorCache.x;
            this.vertices.items[ii + 1] = this.vectorCache.y;
            this.vertices.items[ii + 2] = this.vectorCache.z;
        }
        return this;
    }

    public void push(Vector3 position) {
        this.push(position.x, position.y, position.z);
    }

    public void push(float x, float y, float z) {
        this.vertices.ensureCapacity(11);
        int idx = this.vertices.size;
        this.vertices.items[idx++] = x;
        this.vertices.items[idx++] = y;
        this.vertices.items[idx++] = z;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.size += 11;
    }

    public void push(Vector3 position, Vector3 normal) {
        this.push(position.x, position.y, position.z, normal.x, normal.y, normal.z);
    }

    public void push(float x, float y, float z, float nx, float ny, float nz) {
        this.vertices.ensureCapacity(11);
        int idx = this.vertices.size;
        this.vertices.items[idx++] = x;
        this.vertices.items[idx++] = y;
        this.vertices.items[idx++] = z;
        this.vertices.items[idx++] = nx;
        this.vertices.items[idx++] = ny;
        this.vertices.items[idx++] = nz;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.size += 11;
    }

    public void push(Vector3 position, Vector3 normal, Vector2 texcoord) {
        this.push(position.x, position.y, position.z, normal.x, normal.y, normal.z, texcoord.x, texcoord.y);
    }

    public void push(float x, float y, float z, float nx, float ny, float nz, float tx, float ty) {
        this.vertices.ensureCapacity(11);
        int idx = this.vertices.size;
        this.vertices.items[idx++] = x;
        this.vertices.items[idx++] = y;
        this.vertices.items[idx++] = z;
        this.vertices.items[idx++] = nx;
        this.vertices.items[idx++] = ny;
        this.vertices.items[idx++] = nz;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.items[idx++] = tx;
        this.vertices.items[idx++] = ty;
        this.vertices.size += 11;
    }
}

