/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntMap;
import edu.cornell.gdiac.graphics.GLDebug;
import edu.cornell.gdiac.graphics.Texture2D;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class RenderTarget {
    public int framebo;
    private int renderbo;
    private int width;
    private int height;
    private final IntBuffer viewport = BufferUtils.newByteBuffer((int)64).asIntBuffer();
    private final IntBuffer query = BufferUtils.newByteBuffer((int)64).asIntBuffer();
    private Texture2D depthst;
    private Texture2D[] outputs;
    private int[] bindpoints;
    private Color clearcol;

    private boolean prepareBuffer() {
        Gdx.gl30.glGetIntegerv(2978, this.viewport);
        Gdx.gl30.glGenFramebuffers(1, this.query);
        this.framebo = this.query.get();
        this.query.clear();
        if (this.framebo == 0) {
            int error = Gdx.gl30.glGetError();
            Gdx.app.error("OPENGL", String.format("Could not create frame buffer. %s", GLDebug.errorName(error)));
            return false;
        }
        Gdx.gl30.glBindFramebuffer(36160, this.framebo);
        try {
            this.depthst = new Texture2D(this.width, this.height, Texture2D.PixelFormat.DEPTH_STENCIL);
        }
        catch (Exception e) {
            this.dispose();
            Gdx.gl30.glBindFramebuffer(36160, 0);
            return false;
        }
        Gdx.gl30.glFramebufferTexture2D(36160, 33306, 3553, this.depthst.getBuffer(), 0);
        Gdx.gl30.glGenRenderbuffers(1, this.query);
        this.renderbo = this.query.get();
        this.query.clear();
        if (this.renderbo == 0) {
            int error = Gdx.gl30.glGetError();
            this.dispose();
            Gdx.gl30.glBindFramebuffer(36160, 0);
            Gdx.app.error("OPENGL", String.format("Could not create render buffer. %s", GLDebug.errorName(error)));
            return false;
        }
        Gdx.gl30.glBindRenderbuffer(36161, this.renderbo);
        int error = Gdx.gl30.glGetError();
        Gdx.gl30.glRenderbufferStorage(36161, 35056, this.width, this.height);
        Gdx.gl30.glFramebufferRenderbuffer(36160, 33306, 36161, this.renderbo);
        error = Gdx.gl30.glGetError();
        if (error != 0) {
            this.dispose();
            Gdx.gl30.glBindFramebuffer(36160, 0);
            Gdx.app.error("OPENGL", String.format("Could not attach render buffer to frame buffer. %s", GLDebug.errorName(error)));
            return false;
        }
        return true;
    }

    private boolean attachTexture(int index, int bpoint, Texture2D.PixelFormat format) {
        Texture2D texture;
        if (format == Texture2D.PixelFormat.RED_GREEN) {
            Gdx.app.error("OPENGL", "RED_GREEN is not an accepted frame buffer format");
            return false;
        }
        try {
            texture = new Texture2D(this.width, this.height, format);
        }
        catch (Exception e) {
            this.dispose();
            Gdx.gl30.glBindFramebuffer(36160, 0);
            return false;
        }
        this.outputs[index] = texture;
        texture.setBindPoint(bpoint, false);
        this.bindpoints[index] = 36064 + bpoint;
        Gdx.gl30.glFramebufferTexture2D(36160, 36064 + bpoint, 3553, texture.getBuffer(), 0);
        int error = Gdx.gl30.glGetError();
        if (error != 0) {
            this.dispose();
            Gdx.gl30.glBindFramebuffer(36160, 0);
            Gdx.app.error("OPENGL", String.format("Could not attach output textures to frame buffer. %s", GLDebug.errorName(error)));
            return false;
        }
        return true;
    }

    private boolean completeBuffer() {
        IntBuffer data = BufferUtils.newByteBuffer((int)(4 * this.bindpoints.length)).asIntBuffer();
        BufferUtils.copy((int[])this.bindpoints, (int)0, (Buffer)data, (int)this.bindpoints.length);
        Gdx.gl30.glDrawBuffers(this.outputs.length, data);
        int status = Gdx.gl30.glCheckFramebufferStatus(36160);
        if (status != 36053) {
            this.dispose();
            Gdx.gl30.glBindFramebuffer(36160, 0);
            Gdx.app.error("OPENGL", String.format("Could not bind frame buffer. %s", GLDebug.errorName(status)));
            return false;
        }
        Gdx.gl30.glBindFramebuffer(36160, 0);
        return true;
    }

    public RenderTarget(int width, int height) {
        this(width, height, 1);
    }

    public RenderTarget(int width, int height, int outputs) {
        this.width = width;
        this.height = height;
        this.outputs = new Texture2D[outputs];
        this.bindpoints = new int[outputs];
        this.clearcol = new Color(Color.CLEAR);
        if (this.prepareBuffer()) {
            for (int ii = 0; ii < outputs; ++ii) {
                if (this.attachTexture(ii, ii, Texture2D.PixelFormat.RGBA)) continue;
                throw new GdxRuntimeException("Unable to construct frame buffer");
            }
            if (this.completeBuffer()) {
                return;
            }
        }
        throw new GdxRuntimeException("Unable to construct frame buffer");
    }

    public RenderTarget(int width, int height, IntMap<Texture2D.PixelFormat> outputs) {
        this.width = width;
        this.height = height;
        this.outputs = new Texture2D[outputs.size];
        this.bindpoints = new int[outputs.size];
        this.clearcol = new Color(Color.CLEAR);
        if (this.prepareBuffer()) {
            int ii = 0;
            for (IntMap.Entry it : outputs.entries()) {
                if (!this.attachTexture(ii, it.key, (Texture2D.PixelFormat)((Object)it.value))) {
                    throw new GdxRuntimeException("Unable to construct frame buffer");
                }
                ++ii;
            }
            if (this.completeBuffer()) {
                return;
            }
        }
        throw new GdxRuntimeException("Unable to construct frame buffer");
    }

    public RenderTarget(int width, int height, Array<Texture2D.PixelFormat> outputs) {
        this.width = width;
        this.height = height;
        this.outputs = new Texture2D[outputs.size];
        this.bindpoints = new int[outputs.size];
        this.clearcol = new Color(Color.CLEAR);
        if (this.prepareBuffer()) {
            int ii = 0;
            for (Texture2D.PixelFormat format : outputs) {
                if (!this.attachTexture(ii, ii, format)) {
                    throw new GdxRuntimeException("Unable to construct frame buffer");
                }
                ++ii;
            }
            if (this.completeBuffer()) {
                return;
            }
        }
        throw new GdxRuntimeException("Unable to construct frame buffer");
    }

    public RenderTarget(int width, int height, Texture2D.PixelFormat[] outputs) {
        this.width = width;
        this.height = height;
        this.outputs = new Texture2D[outputs.length];
        this.bindpoints = new int[outputs.length];
        this.clearcol = new Color(Color.CLEAR);
        if (this.prepareBuffer()) {
            int ii = 0;
            for (Texture2D.PixelFormat format : outputs) {
                if (!this.attachTexture(ii, ii, format)) {
                    throw new GdxRuntimeException("Unable to construct frame buffer");
                }
                ++ii;
            }
            if (this.completeBuffer()) {
                return;
            }
        }
        throw new GdxRuntimeException("Unable to construct frame buffer");
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this.framebo != 0) {
            this.query.put(this.framebo);
            this.query.flip();
            Gdx.gl30.glDeleteFramebuffers(1, this.query);
            this.query.clear();
            this.framebo = 0;
        }
        if (this.renderbo != 0) {
            this.query.put(this.renderbo);
            this.query.flip();
            Gdx.gl30.glDeleteRenderbuffers(1, this.query);
            this.query.clear();
            this.framebo = 0;
        }
        this.outputs = null;
        this.depthst = null;
        this.bindpoints = null;
        this.clearcol = null;
        this.width = 0;
        this.height = 0;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    Color getClearColor() {
        return this.clearcol;
    }

    public void setClearColor(Color color) {
        this.clearcol.set(color);
    }

    int getOutputSize() {
        return this.outputs.length;
    }

    public Texture2D getTexture() {
        return this.outputs[0];
    }

    public Texture getTexture(int index) {
        return this.outputs[index];
    }

    public Texture getDepthStencil() {
        return this.depthst;
    }

    public void begin() {
        Gdx.gl30.glGetIntegerv(2978, this.viewport);
        Gdx.gl30.glBindFramebuffer(36160, this.framebo);
        Gdx.gl30.glViewport(0, 0, this.width, this.height);
        Gdx.gl30.glClearColor(this.clearcol.r, this.clearcol.g, this.clearcol.b, this.clearcol.a);
        Gdx.gl30.glClear(17664);
    }

    public void end() {
        int[] vport = new int[4];
        Gdx.gl30.glBindFramebuffer(36160, 0);
        this.viewport.get(vport, 0, 4);
        Gdx.gl30.glViewport(vport[0], vport[1], vport[2], vport[3]);
        this.viewport.clear();
    }

    public boolean isBound() {
        Gdx.gl30.glGetIntegerv(36006, this.query);
        int orig = this.query.get();
        this.query.clear();
        return orig == this.framebo;
    }

    public Buffer getPixelData() {
        return this.getPixelData(0);
    }

    public Buffer getPixelData(int index) {
        ByteBuffer buffer = BufferUtils.newByteBuffer((int)(this.width * this.height * this.outputs[index].getByteSize()));
        return this.getPixelData(buffer, index);
    }

    public Buffer getPixelData(Buffer buffer) {
        return this.getPixelData(buffer, 0);
    }

    public Buffer getPixelData(Buffer buffer, int index) {
        Texture2D texture = this.outputs[index];
        int bpoint = this.bindpoints[index];
        Texture2D.PixelFormat format = texture.getFormat();
        Gdx.gl30.glReadBuffer(bpoint);
        Gdx.gl30.glReadPixels(0, 0, this.width, this.height, format.glFormat(), format.formatType(), buffer);
        return buffer;
    }

    public Pixmap getPixmap() {
        return this.getPixmap(0);
    }

    public Pixmap getPixmap(int index) {
        Texture2D texture = this.outputs[index];
        Pixmap.Format format = texture.getTextureData().getFormat();
        Texture2D.PixelFormat iformat = texture.getFormat();
        int size = this.width * this.height * texture.getByteSize();
        Gdx.gl30.glPixelStorei(3333, 1);
        Pixmap pixmap = new Pixmap(this.width, this.height, format);
        this.getPixelData(pixmap.getPixels(), index);
        int w = pixmap.getWidth();
        int h = pixmap.getHeight();
        pixmap.setBlending(Pixmap.Blending.None);
        for (int y = 0; y < h / 2; ++y) {
            for (int x = 0; x < w; ++x) {
                int temp = pixmap.getPixel(x, y);
                pixmap.drawPixel(x, y, pixmap.getPixel(x, h - y - 1));
                pixmap.drawPixel(x, h - y - 1, temp);
            }
        }
        pixmap.setBlending(Pixmap.Blending.SourceOver);
        return pixmap;
    }

    public String toString() {
        String result = "Framebuffer[" + this.width + "x" + this.height + "]";
        result = result + String.format("@%x", this.hashCode());
        return result;
    }
}

