/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.backend;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3AppShiv;
import edu.cornell.gdiac.backend.GDXAppSettings;
import edu.cornell.gdiac.backend.GDXAudio;

public class GDXApp
extends Lwjgl3AppShiv {
    protected GDXAppSettings config;
    protected GDXAudio audioEngine;
    private volatile boolean running = true;

    public GDXApp(ApplicationListener listener, GDXAppSettings config) {
        super(listener, config.getLwjgl3Configuration());
        String pckg = listener.getClass().getCanonicalName();
        int pos = pckg.lastIndexOf(46);
        pckg = pos == -1 ? "default" : pckg.substring(0, pos);
        String key = "libgdx.package";
        System.setProperty(key, pckg);
        this.config = config;
        if (config.useAudio) {
            try {
                this.audioEngine = new GDXAudio(config.audioDeviceSimultaneousSources, config.audioDeviceBufferCount, config.audioDeviceBufferSize);
                this.audio = this.audioEngine;
                Gdx.audio = this.audioEngine;
                config.useAudio = true;
            }
            catch (Throwable t) {
                this.log("GDXApp", "Couldn't initialize audio, disabling audio", t);
                config.useAudio = false;
            }
        }
        this.start();
    }

    @Override
    public Audio getAudio() {
        return this.audioEngine;
    }

    @Override
    public void exit() {
        this.running = false;
        super.exit();
    }
}

