/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.Scissor;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.scene2.CameraHelper;
import edu.cornell.gdiac.scene2.Scene;
import edu.cornell.gdiac.scene2.layout.Layout;
import java.util.ArrayList;
import java.util.List;

public class SceneNode {
    protected Vector2 position;
    protected Vector2 anchor;
    protected Vector2 contentSize;
    protected Color tintColor;
    protected boolean hasParentColor = true;
    protected boolean isVisible = true;
    protected Scissor scissor;
    protected Vector2 scale;
    protected float angle = 0.0f;
    protected Affine2 transform;
    protected boolean useTransform = false;
    protected Affine2 combined;
    protected List<SceneNode> children;
    protected SceneNode parent;
    protected Scene graph;
    protected Layout layout;
    protected int childOffset = -1;
    protected int tag;
    protected String name;
    protected int hashOfName;
    protected String classname;
    protected float priority;
    protected JsonValue json;
    private Color colorCache = new Color(Color.WHITE);
    private final Vector2 vectorCache = new Vector2();
    private final Vector2 vectorCache2 = new Vector2();
    private final Vector2 vectorCache3 = new Vector2();
    private final Vector2 vectorCache4 = new Vector2();
    private final Affine2 affineCache = new Affine2();
    private final Scissor scissorCache = new Scissor();
    private final Rectangle rectangleCache = new Rectangle();
    private final Vector3 cacheCoords = new Vector3();

    public SceneNode() {
        this.position = new Vector2();
        this.anchor = new Vector2();
        this.contentSize = new Vector2();
        this.tintColor = new Color(Color.WHITE);
        this.scale = new Vector2(1.0f, 1.0f);
        this.combined = new Affine2();
        this.children = new ArrayList<SceneNode>();
    }

    public SceneNode(Vector2 pos) {
        this();
        this.position = pos;
        this.combined.m02 = pos.x;
        this.combined.m12 = pos.y;
    }

    public SceneNode(float x, float y) {
        this(new Vector2(x, y));
    }

    public SceneNode set(Vector2 size) {
        assert (this.childOffset == -2) : "Attempting to reinitialize a Node";
        this.contentSize = size;
        this.combined = new Affine2();
        this.childOffset = -1;
        return this;
    }

    public SceneNode set(float width, float height) {
        return this.set(new Vector2(width, height));
    }

    public SceneNode(Rectangle rect) {
        this();
        rect.getPosition(this.position);
        rect.getSize(this.contentSize);
        this.combined.m02 = rect.getX();
        this.combined.m12 = rect.getY();
        this.childOffset = -1;
    }

    public SceneNode(float x, float y, float width, float height) {
        this(new Rectangle(x, y, width, height));
    }

    public SceneNode(AssetDirectory manager, JsonValue data) {
        this(0.0f, 0.0f);
        JsonValue pos;
        if (data == null) {
            return;
        }
        Vector2 value = new Vector2();
        if (data.has("anchor")) {
            pos = data.get("anchor");
            assert (pos.size >= 2) : "'anchor' must be a two-element number array";
            value.x = pos.getFloat(0);
            value.y = pos.getFloat(1);
            this.setAnchor(value);
        }
        if (data.has("position")) {
            pos = data.get("position");
            assert (pos.size >= 2) : "'position' must be a two-element number array";
            value.x = pos.getFloat(0);
            value.y = pos.getFloat(1);
            this.setPosition(value);
        }
        if (data.has("priority")) {
            this.priority = data.getFloat("priority", 0.0f);
        }
        if (data.has("color")) {
            JsonValue color = data.get("color");
            if (color.isString()) {
                String hex = color.asString();
                this.tintColor.set(Color.valueOf((String)(hex == null ? "#ffffff" : hex)));
            } else {
                assert (color.size >= 4) : "'color' must be a four-element number array";
                this.tintColor.r = (float)Math.max(Math.min(color.getInt(0), 255), 0) / 255.0f;
                this.tintColor.g = (float)Math.max(Math.min(color.getInt(1), 255), 0) / 255.0f;
                this.tintColor.b = (float)Math.max(Math.min(color.getInt(2), 255), 0) / 255.0f;
                this.tintColor.a = (float)Math.max(Math.min(color.getInt(3), 255), 0) / 255.0f;
            }
        }
        this.isVisible = data.getBoolean("visible", true);
        boolean transform = false;
        if (data.has("size")) {
            transform = true;
            JsonValue size = data.get("size");
            assert (size.size >= 2) : "'size' must be a two-element number array";
            this.contentSize.x = size.getFloat(0);
            this.contentSize.y = size.getFloat(1);
        }
        if (data.has("scale")) {
            transform = true;
            JsonValue scale = data.get("scale");
            if (scale.size > 0) {
                this.scale.x = scale.getFloat(0);
                this.scale.y = scale.getFloat(1);
            } else {
                this.scale.y = this.scale.x = scale.asFloat();
            }
        }
        if (data.has("angle")) {
            transform = true;
            this.angle = data.getFloat("angle", 0.0f);
            this.angle = (float)((double)this.angle * (Math.PI / 180));
        }
        if (transform && !this.useTransform) {
            this.updateTransform();
        }
        this.json = data;
    }

    public void dispose() {
        if (this.childOffset >= 0) {
            this.removeFromParent();
        }
        this.removeAllChildren();
        this.position.set(0.0f, 0.0f);
        this.anchor.set(0.5f, 0.5f);
        this.contentSize.set(0.0f, 0.0f);
        this.tintColor.set(Color.WHITE);
        this.hasParentColor = true;
        this.isVisible = true;
        this.scale.set(1.0f, 1.0f);
        this.angle = 0.0f;
        this.transform.set(new Affine2());
        this.useTransform = false;
        this.combined.set(new Affine2());
        this.parent = null;
        this.graph = null;
        this.childOffset = -2;
        this.tag = 0;
        this.name = "";
        this.hashOfName = 0;
        this.priority = 0.0f;
        this.json = null;
    }

    public SceneNode copy(SceneNode dst) {
        dst.position = this.position;
        dst.anchor = this.anchor;
        dst.contentSize = this.contentSize;
        dst.tintColor = this.tintColor;
        dst.hasParentColor = this.hasParentColor;
        dst.isVisible = this.isVisible;
        dst.scale = this.scale;
        dst.angle = this.angle;
        dst.transform = this.transform;
        dst.useTransform = this.useTransform;
        dst.combined = this.combined;
        dst.tag = this.tag;
        dst.name = this.name;
        dst.hashOfName = this.hashOfName;
        dst.priority = this.priority;
        dst.json = this.json;
        return dst;
    }

    public int getTag() {
        return this.tag;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.hashOfName = name.hashCode();
    }

    public String getClassName() {
        return this.classname;
    }

    public String toString(boolean verbose) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(verbose ? "libgdx::" + this.classname + "(tag:" : "(tag:")).append(this.tag).append(", name:").append(this.name).append(", children:").append(this.children.size()).append(")");
        if (verbose) {
            sb.append("\n");
            for (SceneNode child : this.children) {
                sb.append("  ").append(child.toString(true));
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public JsonValue getJSON() {
        return this.json;
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public void setPosition(Vector2 position) {
        this.setPosition(position.x, position.y);
    }

    public void setPosition(float x, float y) {
        this.position.set(x, y);
        this.updateTransform();
    }

    public float getPositionX() {
        return this.getPosition().x;
    }

    public void setPositionX(float x) {
        this.setPosition(x, this.getPositionY());
    }

    public float getPositionY() {
        return this.getPosition().y;
    }

    public void setPositionY(float y) {
        this.setPosition(this.getPositionX(), y);
    }

    public Vector2 getWorldPosition() {
        return this.nodeToWorldCoords(this.anchor.scl(this.getContentSize()));
    }

    public Vector2 getContentSize() {
        return this.contentSize;
    }

    public void setContentSize(Vector2 size) {
        this.vectorCache2.set(this.anchor);
        this.vectorCache3.set(size);
        this.position.add(this.vectorCache2.scl(this.vectorCache3.sub(this.contentSize)));
        this.contentSize.set(size);
        if (!this.useTransform) {
            this.updateTransform();
        }
        if (this.layout != null) {
            this.doLayout();
        }
    }

    public void setContentSize(float width, float height) {
        this.setContentSize(this.vectorCache.set(width, height));
    }

    public float getContentWidth() {
        return this.getContentSize().x;
    }

    public void setContentWidth(float width) {
        this.setContentSize(width, this.getContentHeight());
    }

    public float getContentHeight() {
        return this.getContentSize().y;
    }

    public void setContentHeight(float height) {
        this.setContentSize(this.getContentWidth(), height);
    }

    public Rectangle getLayoutBounds() {
        return new Rectangle(0.0f, 0.0f, this.contentSize.x, this.contentSize.y);
    }

    public Rectangle getLayoutBounds(Rectangle rectangle) {
        return rectangle.set(0.0f, 0.0f, this.contentSize.x, this.contentSize.y);
    }

    public Vector2 getSize() {
        Rectangle bounds = this.getBoundingBox(this.rectangleCache);
        return new Vector2(bounds.width, bounds.height);
    }

    public Vector2 getSize(Vector2 vector) {
        Rectangle bounds = this.getBoundingBox(this.rectangleCache);
        return vector.set(bounds.width, bounds.height);
    }

    public float getWidth() {
        return this.getSize((Vector2)this.vectorCache).x;
    }

    public float getHeight() {
        return this.getSize((Vector2)this.vectorCache).y;
    }

    public Rectangle getBoundingBox() {
        Rectangle result = new Rectangle();
        return this.getBoundingBox(result);
    }

    public Rectangle getBoundingBox(Rectangle rectangle) {
        Affine2 aff = this.getNodeToParentTransform();
        Rectangle rect = this.rectangleCache.set(0.0f, 0.0f, this.contentSize.x, this.contentSize.y);
        Vector2 point1 = this.vectorCache.set(rect.width < 0.0f ? rect.x + rect.width : rect.x, rect.height < 0.0f ? rect.y + rect.height : rect.y);
        Vector2 point2 = this.vectorCache2.set(rect.width < 0.0f ? rect.x + rect.width : rect.x, rect.height < 0.0f ? rect.y : rect.y + rect.height);
        Vector2 point3 = this.vectorCache3.set(rect.width < 0.0f ? rect.x : rect.x + rect.width, rect.height < 0.0f ? rect.y + rect.height : rect.y);
        Vector2 point4 = this.vectorCache4.set(rect.width < 0.0f ? rect.x : rect.x + rect.width, rect.height < 0.0f ? rect.y : rect.y + rect.height);
        aff.applyTo(point1);
        aff.applyTo(point2);
        aff.applyTo(point3);
        aff.applyTo(point4);
        float minx = Math.min(point1.x, Math.min(point2.x, Math.min(point3.x, point4.x)));
        float maxx = Math.max(point1.x, Math.max(point2.x, Math.max(point3.x, point4.x)));
        float miny = Math.min(point1.y, Math.min(point2.y, Math.min(point3.y, point4.y)));
        float maxy = Math.max(point1.y, Math.max(point2.y, Math.max(point3.y, point4.y)));
        rectangle.set(minx, miny, maxx - minx, maxy - miny);
        return rectangle;
    }

    public boolean inContentBounds(Vector2 point) {
        Vector2 local = this.screenToNodeCoords(point, this.vectorCache3);
        Rectangle contentBounds = this.rectangleCache.set(0.0f, 0.0f, this.contentSize.x, this.contentSize.y);
        if (contentBounds.contains(local)) {
            if (this.parent != null) {
                return this.parent.inContentBounds(point);
            }
            return true;
        }
        return false;
    }

    public boolean inContentBounds(float x, float y) {
        return this.inContentBounds(this.vectorCache.set(x, y));
    }

    public void setAnchor(Vector2 anchor) {
        if (!anchor.equals((Object)this.anchor)) {
            this.position.set(anchor.x * this.contentSize.x, anchor.y * this.contentSize.y);
            this.combined.applyTo(this.position);
            this.anchor = anchor;
            if (!this.useTransform) {
                this.updateTransform();
            }
        }
    }

    public void setAnchor(float x, float y) {
        this.setAnchor(new Vector2(x, y));
    }

    public Vector2 getAnchor() {
        return this.anchor;
    }

    public Vector2 getAnchorInPixels() {
        return this.anchor.scl(this.contentSize);
    }

    public Color getColor() {
        return this.tintColor;
    }

    public void setColor(Color color) {
        this.tintColor = color;
    }

    public Color getAbsoluteColor() {
        Color result = this.tintColor;
        if (this.parent != null && this.hasParentColor) {
            result.mul(this.parent.getAbsoluteColor());
        }
        return result;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean hasRelativeColor() {
        return this.hasParentColor;
    }

    public void setRelativeColor(boolean flag) {
        this.hasParentColor = flag;
    }

    public Scissor getScissor() {
        return this.scissor;
    }

    public void setScissor(Scissor scissor) {
        this.scissor = scissor;
    }

    public void setScissor() {
        this.scissor.set(new Rectangle(0.0f, 0.0f, this.contentSize.x, this.contentSize.y), 0.5f);
    }

    public Vector2 getScale() {
        return this.scale;
    }

    public float getScaleX() {
        return this.scale.x;
    }

    public float getScaleY() {
        return this.scale.y;
    }

    public void setScale(float scale) {
        this.scale.set(scale, scale);
        if (!this.useTransform) {
            this.updateTransform();
        }
    }

    public void setScale(Vector2 vec) {
        this.scale = vec;
        if (!this.useTransform) {
            this.updateTransform();
        }
    }

    public void setScale(float sx, float sy) {
        this.scale.set(sx, sy);
        if (!this.useTransform) {
            this.updateTransform();
        }
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
        if (!this.useTransform) {
            this.updateTransform();
        }
    }

    public Affine2 getTransform() {
        return this.combined;
    }

    public Affine2 getAlternateTransform() {
        return this.transform;
    }

    public void setAlternateTransform(Affine2 transform) {
        this.transform = transform;
        this.updateTransform();
    }

    public boolean withAlternateTransform() {
        return this.useTransform;
    }

    public void chooseAlternateTransform(boolean active) {
        this.useTransform = active;
        this.updateTransform();
    }

    public Affine2 getNodeToParentTransform() {
        return this.combined;
    }

    public Affine2 getParentToNodeTransform() {
        return this.combined.inv();
    }

    public Affine2 getNodeToWorldTransform() {
        Affine2 result = new Affine2();
        return this.getNodeToWorldTransform(result);
    }

    public Affine2 getNodeToWorldTransform(Affine2 result) {
        result.set(this.combined);
        if (this.parent != null) {
            result.preMul(this.parent.getNodeToWorldTransform());
        }
        return result;
    }

    public Affine2 getWorldToNodeTransform() {
        return this.getNodeToWorldTransform(new Affine2()).inv();
    }

    public Affine2 getWorldToNodeTransform(Affine2 result) {
        return this.getNodeToWorldTransform(result).inv();
    }

    public Vector2 screenToNodeCoords(Vector2 screenPoint) {
        return this.screenToNodeCoords(screenPoint, new Vector2());
    }

    public Vector2 screenToNodeCoords(Vector2 screenPoint, Vector2 result) {
        if (this.graph == null) {
            return screenPoint;
        }
        Vector3 wp = this.graph.getCamera().unproject(this.cacheCoords.set(screenPoint.x, screenPoint.y, 0.0f));
        Vector2 worldPoint = this.vectorCache4.set(wp.x, wp.y);
        return this.worldToNodeCoords(worldPoint, result);
    }

    public Vector2 worldToNodeCoords(Vector2 worldPoint) {
        return this.worldToNodeCoords(worldPoint, new Vector2());
    }

    public Vector2 worldToNodeCoords(Vector2 worldPoint, Vector2 result) {
        result.set(worldPoint);
        this.getWorldToNodeTransform().applyTo(result);
        return result;
    }

    public Vector2 nodeToScreenCoords(Vector2 nodePoint) {
        return this.nodeToScreenCoords(nodePoint, new Vector2());
    }

    public Vector2 nodeToScreenCoords(Vector2 nodePoint, Vector2 result) {
        if (this.graph == null) {
            return nodePoint;
        }
        Vector3 worldCoords = this.cacheCoords.set(this.nodeToWorldCoords(nodePoint, this.vectorCache4), 0.0f);
        Vector3 windowCoords = this.graph.getCamera().project(worldCoords);
        return CameraHelper.windowToScreenCoords(windowCoords, result);
    }

    public Vector2 nodeToWorldCoords(Vector2 nodePoint) {
        return this.nodeToWorldCoords(nodePoint, new Vector2());
    }

    public Vector2 nodeToWorldCoords(Vector2 nodePoint, Vector2 result) {
        result.set(nodePoint);
        this.getNodeToWorldTransform().applyTo(result);
        return result;
    }

    public Vector2 parentToNodeCoords(Vector2 parentPoint) {
        return this.parentToNodeCoords(parentPoint, new Vector2());
    }

    public Vector2 parentToNodeCoords(Vector2 parentPoint, Vector2 result) {
        result.set(parentPoint);
        this.getParentToNodeTransform().applyTo(result);
        return result;
    }

    public Vector2 nodeToParentCoords(Vector2 nodePoint) {
        return this.nodeToParentCoords(nodePoint, new Vector2());
    }

    public Vector2 nodeToParentCoords(Vector2 nodePoint, Vector2 result) {
        result.set(nodePoint);
        this.getNodeToParentTransform().applyTo(result);
        return result;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public SceneNode getChild(int pos) {
        assert (pos < this.children.size()) : "Position index out of bounds";
        return this.children.get(pos);
    }

    public SceneNode getChildByTag(int tag) {
        for (SceneNode child : this.children) {
            if (child.getTag() != tag) continue;
            return child;
        }
        return null;
    }

    public SceneNode getChildByName(String name) {
        for (SceneNode child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public List<SceneNode> getChildren() {
        return this.children;
    }

    public void addChild(SceneNode child) {
        assert (child.childOffset == -1) : "The child is already in a scene graph";
        assert (child.graph == null) : "The child is already in a scene graph";
        child.childOffset = this.children.size();
        this.children.add(child);
        child.setParent(this);
        child.pushScene(this.graph);
    }

    public void addChildWithTag(SceneNode child, int tag) {
        this.addChild(child);
        child.setTag(tag);
    }

    public void addChildWithName(SceneNode child, String name) {
        this.addChild(child);
        child.setName(name);
    }

    public void swapChild(SceneNode child1, SceneNode child2, boolean inherit) {
        this.children.set(child1.childOffset, child2);
        child2.childOffset = child1.childOffset;
        child2.setParent(this);
        child1.setParent(null);
        child2.pushScene(this.graph);
        child1.pushScene(null);
        if (inherit) {
            List<SceneNode> grandChildren = child1.children;
            child2.removeAllChildren();
            for (SceneNode grandChild : grandChildren) {
                child2.addChild(grandChild);
            }
        }
    }

    public SceneNode getParent() {
        return this.parent;
    }

    public Scene getScene() {
        return this.graph;
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.removeChild(this.childOffset);
        }
    }

    public void removeChild(int pos) {
        assert (pos < this.children.size()) : "Position index out of bounds";
        SceneNode child = this.children.get(pos);
        child.setParent(null);
        child.pushScene(null);
        child.childOffset = -1;
        for (int ii = pos; ii < this.children.size() - 1; ++ii) {
            this.children.set(ii, this.children.get(ii + 1));
            this.children.get((int)ii).childOffset = -1;
        }
        this.children.remove(this.children.size() - 1);
    }

    public void removeChild(SceneNode child) {
        assert (this.children.get(child.childOffset) == child) : "The child is not in this scene graph";
        this.children.remove(child.childOffset);
    }

    public void removeChildByTag(int tag) {
        SceneNode child = this.getChildByTag(tag);
        if (child != null) {
            this.removeChild(child.childOffset);
        }
    }

    public void removeChildByName(String name) {
        SceneNode child = this.getChildByName(name);
        if (child != null) {
            this.removeChild(child.childOffset);
        }
    }

    public void removeAllChildren() {
        for (SceneNode child : this.children) {
            child.setParent(null);
            child.childOffset = -1;
            child.pushScene(null);
        }
        this.children.clear();
    }

    public void setPriority(float priority) {
        this.priority = priority;
    }

    public float getPriority() {
        return this.priority;
    }

    public void render(SpriteBatch batch, Affine2 transform, Color tint) {
        if (!this.isVisible) {
            return;
        }
        Affine2 matrix = this.affineCache.set(this.combined).preMul(transform);
        this.colorCache.set(this.tintColor);
        if (this.hasParentColor) {
            this.colorCache.mul(tint);
        }
        Scissor active = batch.getScissor();
        if (this.scissor != null) {
            Scissor local = this.scissorCache.set(this.scissor);
            local.mul(matrix);
            if (active != null) {
                local.intersect(active);
            }
            batch.setScissor(local);
        }
        this.draw(batch, matrix, this.colorCache);
        for (SceneNode child : this.children) {
            child.render(batch, matrix, this.colorCache);
        }
        if (this.scissor != null) {
            batch.setScissor(active);
        }
    }

    public void draw(SpriteBatch batch, Affine2 transform, Color tint) {
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void doLayout() {
        if (this.layout != null) {
            this.layout.layout(this);
        }
        for (SceneNode child : this.children) {
            child.doLayout();
        }
    }

    protected void setParent(SceneNode parent) {
        this.parent = parent;
    }

    protected void setScene(Scene scene) {
        this.graph = scene;
    }

    protected void pushScene(Scene scene) {
        this.setScene(scene);
        for (SceneNode child : this.children) {
            child.pushScene(scene);
        }
    }

    protected void updateTransform() {
        Vector2 offset = this.vectorCache.set(this.anchor).scl(this.contentSize);
        if (this.useTransform) {
            this.combined.setToTranslation(this.position.x - offset.x, this.position.y - offset.y);
            this.combined.preMul(this.transform);
        } else {
            this.combined.setToTranslation(-offset.x, -offset.y).preScale(this.scale.x, this.scale.y).preRotateRad(this.angle).preTranslate(offset.x, offset.y);
            this.combined.m02 += this.position.x - offset.x;
            this.combined.m12 += this.position.y - offset.y;
        }
    }

    public boolean keyDown(int keycode) {
        return this.children.stream().anyMatch(child -> child.keyDown(keycode));
    }

    public boolean keyUp(int keycode) {
        return this.children.stream().anyMatch(child -> child.keyUp(keycode));
    }

    public boolean keyTyped(char character) {
        return this.children.stream().anyMatch(child -> child.keyTyped(character));
    }

    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return this.children.stream().anyMatch(child -> child.touchDown(screenX, screenY, pointer, button));
    }

    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return this.children.stream().anyMatch(child -> child.touchUp(screenX, screenY, pointer, button));
    }

    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return this.children.stream().anyMatch(child -> child.touchDragged(screenX, screenY, pointer));
    }

    public boolean touchCancelled(int screenX, int screenY, int pointer, int button) {
        return this.children.stream().anyMatch(child -> child.touchCancelled(screenX, screenY, pointer, button));
    }

    public boolean mouseMoved(int screenX, int screenY) {
        return this.children.stream().anyMatch(child -> child.mouseMoved(screenX, screenY));
    }

    public boolean scrolled(float amountX, float amountY) {
        return this.children.stream().anyMatch(child -> child.scrolled(amountX, amountY));
    }
}

