/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics.shaders;

import com.badlogic.gdx.Gdx;
import edu.cornell.gdiac.graphics.Shader;

public class ObjShader {
    public static final String POSITION_ATTRIBUTE = "a_position";
    public static final String NORMAL_ATTRIBUTE = "a_normal";
    public static final String TANGENT_ATTRIBUTE = "a_tangent";
    public static final String TEXCOORD_ATTRIBUTE = "a_texCoord";
    public static final String PERSPECTIVE_UNIFORM = "u_perspective";
    public static final String MODELVIEW_UNIFORM = "u_modelview";
    public static final String NORMALMAT_UNIFORM = "u_normalmatrix";
    public static final String LIGHTPOS_UNIFORM = "u_lightpos";
    public static final String ILLUM_UNIFORM = "u_illum";
    public static final String SHININESS_UNIFORM = "u_Ns";
    public static final String AMBIENT_GUARD_UNIFORM = "u_hasKa";
    public static final String AMBIENT_COLOR_UNIFORM = "u_Ka";
    public static final String AMBIENT_TEXTURE_UNIFORM = "u_mapKa";
    public static final String DIFFUSE_GUARD_UNIFORM = "u_hasKd";
    public static final String DIFFUSE_COLOR_UNIFORM = "u_Kd";
    public static final String DIFFUSE_TEXTURE_UNIFORM = "u_mapKd";
    public static final String SPECULAR_GUARD_UNIFORM = "u_hasKs";
    public static final String SPECULAR_COLOR_UNIFORM = "u_Ks";
    public static final String SPECULAR_TEXTURE_UNIFORM = "u_mapKs";
    public static final String BUMP_GUARD_UNIFORM = "u_hasKn";
    public static final String BUMP_TEXTURE_UNIFORM = "u_mapKn";
    public static final int[] ATTRIBUTE_OFFSET = new int[]{0, 12, 24, 36, 44};
    private static String[] vertex20 = new String[]{"////////// SHADER BEGIN /////////", "// Attributes", "attribute vec3 a_position;", "attribute vec3 a_normal;", "attribute vec3 a_tangent;", "attribute vec2 a_texCoord;", "", "// Outputs", "varying vec2 outTexCoord;", "varying vec3 outNormal;", "varying vec3 outView;", "varying vec3 outLight;", "", "// Matrices", "uniform mat4 u_perspective;", "uniform mat4 u_modelview;", "uniform mat4 u_normalmatrix;", "", "// Lighting (only one light supported)", "uniform vec3 u_lightpos;", "", "// Transform and pass through", "void main(void) {", "    // Tangent space vectors give the columns of the eye-to-tangent transform.", "    vec3 N = vec3(u_normalmatrix * vec4(a_normal,1.0));", "    vec3 T = vec3(u_normalmatrix * vec4(a_tangent,1.0));", "    vec3 B = cross(N, T);", "", "    // Manually transpose the matrix by constructing the columns as rows", "    mat3 M = mat3(", "         T.x, B.x, N.x,", "         T.y, B.y, N.y,", "         T.z, B.z, N.z", "    );", "", "\t vec4 vertPos = u_modelview * vec4(a_position,1.0);", "    outNormal =  N;", "    outView   =  M * vec3(vertPos);", "    outLight  =  M * vec3(u_modelview", " * vec4(u_lightpos,1.0));", "\t outTexCoord  = a_texCoord;", "    gl_Position  = u_perspective*vertPos;", "}", "/////////// SHADER END //////////"};
    private static String[] vertex30 = new String[]{"////////// SHADER BEGIN /////////", "// Attributes", "in vec3 a_position;", "in vec3 a_normal;", "in vec3 a_tangent;", "in vec2 a_texCoord;", "", "// Outputs", "out vec2 outTexCoord;", "out vec3 outNormal;", "out vec3 outView;", "out vec3 outLight;", "", "// Matrices", "uniform mat4 u_perspective;", "uniform mat4 u_modelview;", "uniform mat4 u_normalmatrix;", "", "// Lighting (only one light supported)", "uniform vec3 u_lightpos;", "", "// Transform and pass through", "void main(void) {", "    // Tangent space vectors give the columns of the eye-to-tangent transform.", "    vec3 N = vec3(u_normalmatrix * vec4(a_normal,1.0));", "    vec3 T = vec3(u_normalmatrix * vec4(a_tangent,1.0));", "    mat3 M = transpose(mat3(T, cross(N, T), N));", "", "\t vec4 vertPos = u_modelview * vec4(a_position,1.0);", "    outNormal =  N;", "    outView   =  M * vec3(vertPos);", "    outLight  =  M * vec3(u_modelview", " * vec4(u_lightpos,1.0));", "\t outTexCoord  = a_texCoord;", "    gl_Position  = u_perspective*vertPos;", "}", "/////////// SHADER END //////////"};
    private static String[] fragment20 = new String[]{"////////// SHADER BEGIN /////////", "#ifdef GL_ES", "\t// This one line is all the difference", "\tprecision mediump float;", "#endif", "", "// Interpolated normal from vertex shader", "varying vec3 outNormal;", "", "// Texture result from vertex shader", "varying vec2 outTexCoord;", "", "// Interpolated view from vertex shader", "varying vec3 outView;", "", "// Interpolated light vector", "varying vec3 outLight;", "", "// The draw settings", "uniform int u_illum;", "uniform int u_hasKa;", "uniform int u_hasKd;", "uniform int u_hasKs;", "uniform int u_hasKn;", "", "// The colors", "uniform vec4 u_Ka;", "uniform vec4 u_Kd;", "uniform vec4 u_Ks;", "uniform float u_Ns;", "", "// The textures", "uniform sampler2D u_mapKa;", "uniform sampler2D u_mapKd;", "uniform sampler2D u_mapKs;", "uniform sampler2D u_mapKn;", "", "/**", " * Performs the main fragment shading.", " */", "void main(void) {", "\t// Get the normal (using bump map if available)", "\tvec3 N = outNormal;", "\tif (u_hasKn > 0) {", "\t\tvec4 tN = texture2D(u_mapKn, outTexCoord);", "\t\tN = normalize(2.0 * tN.xyz - 1.0);", "\t}", "", "\tvec4 frag_color;", "\tif (u_illum == 0) {", "\t    frag_color = u_Kd;", "\t    if (u_hasKd > 0) {", "\t\t    frag_color *= texture2D(u_mapKd, outTexCoord);", "\t    }", "    } else {", "\t\t// Determine the per-fragment lighting value", "\t\tvec3 L = normalize(outLight);", "\t\tfloat lambertian = max(dot(L, N), 0.0);", "", "       // Most solutions fall back on illum 0 if lambertian is 0", "\t    frag_color = u_Ka;", "\t    if (u_hasKa > 0) {", "\t\t    frag_color *= texture2D(u_mapKa, outTexCoord);", "\t    } else if (u_hasKd > 0 && lambertian == 0.0) {", "\t\t    frag_color *= texture2D(u_mapKd, outTexCoord);", "\t    }", "", "\t    // Now do some actual lighting", "\t\tif (lambertian > 0.0) {", "\t\t    if (u_hasKd > 0) {", "\t\t\t    frag_color += u_Kd*lambertian*texture2D(u_mapKd, outTexCoord);", "\t\t    } else {", "\t\t\t    frag_color += u_Kd*lambertian;", "\t\t    }", "", "\t\t    if (u_illum > 1) {", "\t\t\t    vec3 R = reflect(L, N);", "\t\t\t    vec3 V = normalize(outView);", "\t\t\t    float angle = max(dot(V, R), 0.0);", "", "\t\t\t    float specular = pow(angle, u_Ns);", "\t\t\t    if (u_hasKs > 0) {", "\t\t\t\t    frag_color += u_Ks*specular*texture2D(u_mapKs, outTexCoord);", "\t\t\t    } else {", "\t\t\t\t    frag_color += u_Ks*specular;", "\t\t\t    }", "\t\t\t}", "\t\t}", "\t}", "   gl_FragColor = frag_color;", "}", "/////////// SHADER END //////////"};
    private static String[] fragment30 = new String[]{"////////// SHADER BEGIN /////////", "#ifdef GL_ES", "\t// This one line is all the difference", "\tprecision mediump float;", "#endif", "", "// The output color", "out vec4 frag_color;", "", "// Interpolated normal from vertex shader", "in vec3 outNormal;", "", "// Texture result from vertex shader", "in vec2 outTexCoord;", "", "// Interpolated view from vertex shader", "in vec3 outView;", "", "// Interpolated light vector", "in vec3 outLight;", "", "// The draw settings", "uniform int u_illum;", "uniform int u_hasKa;", "uniform int u_hasKd;", "uniform int u_hasKs;", "uniform int u_hasKn;", "", "// The colors", "uniform vec4 u_Ka;", "uniform vec4 u_Kd;", "uniform vec4 u_Ks;", "uniform float u_Ns;", "", "// The textures", "uniform sampler2D u_mapKa;", "uniform sampler2D u_mapKd;", "uniform sampler2D u_mapKs;", "uniform sampler2D u_mapKn;", "", "/**", " * Performs the main fragment shading.", " */", "void main(void) {", "\t// Get the normal (using bump map if available)", "\tvec3 N = outNormal;", "\tif (u_hasKn > 0) {", "\t\tvec4 tN = texture(u_mapKn, outTexCoord);", "\t\tN = normalize(2.0 * tN.xyz - 1.0);", "\t}", "", "\tif (u_illum == 0) {", "\t    frag_color = u_Kd;", "\t    if (u_hasKd > 0) {", "\t\t    frag_color *= texture(u_mapKd, outTexCoord);", "\t    }", "    } else {", "\t\t// Determine the per-fragment lighting value", "\t\tvec3 L = normalize(outLight);", "\t\tfloat lambertian = max(dot(L, N), 0.0);", "", "       // Most solutions fall back on illum 0 if lambertian is 0", "\t    frag_color = u_Ka;", "\t    if (u_hasKa > 0) {", "\t\t    frag_color *= texture(u_mapKa, outTexCoord);", "\t    } else if (u_hasKd > 0 && lambertian == 0.0) {", "\t\t    frag_color *= texture(u_mapKd, outTexCoord);", "\t    }", "", "\t    // Now do some actual lighting", "\t\tif (lambertian > 0.0) {", "\t\t    if (u_hasKd > 0) {", "\t\t\t    frag_color += u_Kd*lambertian*texture(u_mapKd, outTexCoord);", "\t\t    } else {", "\t\t\t    frag_color += u_Kd*lambertian;", "\t\t    }", "", "\t\t    if (u_illum > 1) {", "\t\t\t    vec3 R = reflect(L, N);", "\t\t\t    vec3 V = normalize(outView);", "\t\t\t    float angle = max(dot(V, R), 0.0);", "", "\t\t\t    float specular = pow(angle, u_Ns);", "\t\t\t    if (u_hasKs > 0) {", "\t\t\t\t    frag_color += u_Ks*specular*texture(u_mapKs, outTexCoord);", "\t\t\t    } else {", "\t\t\t\t    frag_color += u_Ks*specular;", "\t\t\t    }", "\t\t\t}", "\t\t}", "\t}", "}", "/////////// SHADER END //////////"};

    public static Shader createShader() {
        return ObjShader.createShader(Gdx.gl30 != null);
    }

    public static Shader createShader(boolean ogl3) {
        String[] vertSource = vertex20;
        String[] fragSource = fragment20;
        if (ogl3) {
            vertSource = vertex30;
            fragSource = fragment30;
        }
        StringBuilder vstr = new StringBuilder();
        for (String s : vertSource) {
            vstr.append(s);
            vstr.append("\n");
        }
        String vertexShader = vstr.toString();
        StringBuilder fstr = new StringBuilder();
        for (String s : fragSource) {
            fstr.append(s);
            fstr.append("\n");
        }
        String fragmentShader = fstr.toString();
        Shader.pedantic = false;
        String vertPrefix = Shader.prependVertexCode;
        String fragPrefix = Shader.prependFragmentCode;
        if (Gdx.gl30 != null) {
            Shader.prependVertexCode = "#version 330 core\n";
            Shader.prependFragmentCode = "#version 330 core\n";
        }
        Shader spriteShader = new Shader(vertexShader, fragmentShader);
        if (Gdx.gl30 != null) {
            Shader.prependVertexCode = vertPrefix;
            Shader.prependFragmentCode = fragPrefix;
        }
        if (!spriteShader.isCompiled()) {
            throw new IllegalArgumentException("Error compiling shader: " + spriteShader.getLog());
        }
        return spriteShader;
    }
}

