/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics.obj;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Disposable;
import edu.cornell.gdiac.graphics.GLDebug;
import edu.cornell.gdiac.graphics.Shader;
import edu.cornell.gdiac.graphics.Texture2D;
import edu.cornell.gdiac.graphics.VertexBuffer;
import edu.cornell.gdiac.graphics.obj.Material;
import edu.cornell.gdiac.graphics.obj.Model;
import edu.cornell.gdiac.graphics.obj.ModelRef;
import edu.cornell.gdiac.graphics.obj.ObjMesh;
import edu.cornell.gdiac.graphics.shaders.ObjShader;

public class ObjPipeline
implements Disposable {
    private GL20 gl;
    private Shader shader;
    private Vector3 lightSource;
    private Color tintColor;
    private Material defaultMaterial;
    private int perspectivePos;
    private int modelMatrixPos;
    private int normalMatrixPos;
    private int lightSourcePos;
    private int illumPos;
    private int KaPos;
    private int KdPos;
    private int KsPos;
    private int NsPos;
    private int hasKaPos;
    private int hasKdPos;
    private int hasKsPos;
    private int hasKnPos;
    private int mapKdPos;
    private int mapKaPos;
    private int mapKsPos;
    private int mapKnPos;
    private static Material BLANK = null;

    public ObjPipeline() {
        this(ObjShader.createShader(Gdx.gl30 != null));
    }

    public ObjPipeline(Shader shader) {
        this.shader = shader;
        this.gl = Gdx.gl30;
        if (this.gl == null) {
            this.gl = Gdx.gl20;
        }
        this.perspectivePos = shader.getUniformLocation("u_perspective");
        if (this.perspectivePos == -1) {
            throw new IllegalStateException("Shader missing perspective uniform");
        }
        this.modelMatrixPos = shader.getUniformLocation("u_modelview");
        if (this.modelMatrixPos == -1) {
            throw new IllegalStateException("Shader missing model matrix uniform");
        }
        this.normalMatrixPos = shader.getUniformLocation("u_normalmatrix");
        if (this.normalMatrixPos == -1) {
            throw new IllegalStateException("Shader missing normal matrix uniform");
        }
        this.illumPos = shader.getUniformLocation("u_illum");
        if (this.illumPos == -1) {
            throw new IllegalStateException("Shader missing illum uniform");
        }
        this.KaPos = shader.getUniformLocation("u_Ka");
        if (this.KaPos == -1) {
            throw new IllegalStateException("Shader missing ambient color uniform");
        }
        this.KdPos = shader.getUniformLocation("u_Kd");
        if (this.KdPos == -1) {
            throw new IllegalStateException("Shader missing diffuse color uniform");
        }
        this.KsPos = shader.getUniformLocation("u_Ks");
        if (this.KsPos == -1) {
            throw new IllegalStateException("Shader missing specular color uniform");
        }
        this.NsPos = shader.getUniformLocation("u_Ns");
        if (this.NsPos == -1) {
            throw new IllegalStateException("Shader missing specular exponent uniform");
        }
        this.hasKaPos = shader.getUniformLocation("u_hasKa");
        if (this.hasKaPos == -1) {
            throw new IllegalStateException("Shader missing ambient flag uniform");
        }
        this.mapKaPos = shader.getUniformLocation("u_mapKa");
        if (this.mapKaPos == -1) {
            throw new IllegalStateException("Shader missing ambient texture uniform");
        }
        this.hasKdPos = shader.getUniformLocation("u_hasKd");
        if (this.hasKdPos == -1) {
            throw new IllegalStateException("Shader missing diffuse flag uniform");
        }
        this.mapKdPos = shader.getUniformLocation("u_mapKd");
        if (this.mapKdPos == -1) {
            throw new IllegalStateException("Shader missing diffuse texture uniform");
        }
        this.hasKsPos = shader.getUniformLocation("u_hasKs");
        if (this.hasKsPos == -1) {
            throw new IllegalStateException("Shader missing specular flag uniform");
        }
        this.mapKsPos = shader.getUniformLocation("u_mapKs");
        if (this.mapKsPos == -1) {
            throw new IllegalStateException("Shader missing specular texture uniform");
        }
        this.hasKnPos = shader.getUniformLocation("u_hasKn");
        if (this.hasKnPos == -1) {
            throw new IllegalStateException("Shader missing bump flag uniform");
        }
        this.mapKnPos = shader.getUniformLocation("u_mapKn");
        if (this.mapKnPos == -1) {
            throw new IllegalStateException("Shader missing bump texture uniform");
        }
        this.lightSourcePos = shader.getUniformLocation("u_lightpos");
        if (this.lightSourcePos == -1) {
            throw new IllegalStateException("Shader missing light source uniform");
        }
        this.lightSource = new Vector3();
        this.tintColor = new Color(Color.WHITE);
    }

    public void dispose() {
        this.shader.dispose();
    }

    public void setPerspective(Matrix4 matrix) {
        this.shader.setUniformMatrix(this.perspectivePos, matrix);
    }

    public void setModelMatrix(Matrix4 matrix) {
        this.shader.setUniformMatrix(this.modelMatrixPos, matrix);
    }

    public void setNormalMatrix(Matrix4 matrix) {
        this.shader.setUniformMatrix(this.normalMatrixPos, matrix);
    }

    public Vector3 getLightSource() {
        return this.lightSource;
    }

    public void setLightSource(Vector3 source) {
        this.lightSource.set(source);
    }

    public void setLightSource(float x, float y, float z) {
        this.lightSource.set(x, y, z);
    }

    public Color getColor() {
        return this.tintColor;
    }

    public void setColor(Color color) {
        if (color == null) {
            this.tintColor.set(Color.WHITE);
        } else {
            this.tintColor.set(color);
        }
    }

    public Material getMaterial() {
        return this.defaultMaterial;
    }

    public void setMaterial(Material material) {
        this.defaultMaterial = material;
    }

    public void begin() {
        this.gl.glDepthMask(true);
        this.gl.glEnable(2929);
        this.gl.glEnable(2884);
        this.shader.bind();
    }

    public void begin(Camera camera) {
        this.begin();
        this.setPerspective(camera.combined);
    }

    public void end() {
        this.gl.glDisable(2929);
        this.gl.glDisable(2884);
    }

    public void draw(ModelRef model) {
        this.setModelMatrix(model.getModelView());
        this.setNormalMatrix(model.getNormals());
        if (model.getMaterial() != null) {
            this.setMaterial(model.getMaterial());
        }
        this.draw(model.getModel());
    }

    public void draw(Model model) {
        this.shader.setUniformf(this.lightSourcePos, this.lightSource);
        for (int ii = 0; ii < model.getSurfaces().size; ++ii) {
            Model.Surface surf = model.getSurface(ii);
            this.draw(surf);
        }
    }

    private void draw(Model.Surface surface) {
        if (surface.getBuffer() == null || this.shader == null) {
            return;
        }
        ObjMesh mesh = surface.getMesh();
        VertexBuffer vertbuff = surface.getBuffer();
        Material material = surface.getMaterial();
        if (material == null) {
            material = this.defaultMaterial;
        }
        if (material == null) {
            material = ObjPipeline.getBlank();
        }
        vertbuff.attach(this.shader);
        if (material != null) {
            if (this.tintColor.toIntBits() != Color.WHITE.toIntBits()) {
                this.bind(material, this.tintColor);
            } else {
                this.bind(material);
            }
        }
        vertbuff.bind();
        vertbuff.draw(mesh.command, mesh.indices.size, 0);
        vertbuff.unbind();
        if (material != null) {
            this.unbind();
        }
    }

    private void bind(Material material) {
        this.setIllum(material.getIllum());
        this.setSpecularExponent(material.getShininess());
        this.setAmbientColor(material.getAmbientTint());
        this.setDiffuseColor(material.getDiffuseTint());
        this.setSpecularColor(material.getSpecularTint());
        Texture2D.getBlank().bind();
        Texture texture = material.getAmbientMap();
        this.setAmbientTexture(texture);
        if (texture != null) {
            texture.bind(1);
        }
        texture = material.getDiffuseMap();
        this.setDiffuseTexture(texture);
        if (texture != null) {
            texture.bind(0);
        }
        texture = material.getSpecularMap();
        this.setSpecularTexture(texture);
        if (texture != null) {
            texture.bind(2);
        }
        texture = material.getBumpMap();
        this.setNormalTexture(texture);
        if (texture != null) {
            texture.bind(3);
        }
        this.gl.glActiveTexture(33984);
        int error = this.gl.glGetError();
        assert (error == 0) : "VertexBuffer: " + GLDebug.errorName(error);
    }

    private void bind(Material material, Color tint) {
        int bits = tint.toIntBits();
        Texture2D.getBlank().bind();
        this.setIllum(material.getIllum());
        this.setSpecularExponent(material.getShininess());
        tint.mul(material.getAmbientTint());
        this.setAmbientColor(tint);
        tint.set(bits);
        tint.mul(material.getDiffuseTint());
        this.setDiffuseColor(tint);
        tint.set(bits);
        tint.mul(material.getSpecularTint());
        this.setSpecularColor(tint);
        tint.set(bits);
        Texture texture = material.getAmbientMap();
        this.setAmbientTexture(texture);
        if (texture != null) {
            texture.bind(1);
        }
        texture = material.getDiffuseMap();
        this.setDiffuseTexture(texture);
        if (texture != null) {
            texture.bind(0);
        }
        texture = material.getSpecularMap();
        this.setSpecularTexture(texture);
        if (texture != null) {
            texture.bind(2);
        }
        texture = material.getBumpMap();
        this.setNormalTexture(texture);
        if (texture != null) {
            texture.bind(3);
        }
        this.gl.glActiveTexture(33984);
        int error = this.gl.glGetError();
        assert (error == 0) : "VertexBuffer: " + GLDebug.errorName(error);
    }

    public void unbind() {
        this.gl.glActiveTexture(33984 + 1);
        this.gl.glBindTexture(3553, 0);
        this.gl.glActiveTexture(33984 + 0);
        this.gl.glBindTexture(3553, 0);
        this.gl.glActiveTexture(33984 + 2);
        this.gl.glBindTexture(3553, 0);
        this.gl.glActiveTexture(33984 + 3);
        this.gl.glBindTexture(3553, 0);
    }

    public void setIllum(int value) {
        this.shader.setUniformi(this.illumPos, value);
    }

    public void setAmbientColor(Color color) {
        this.shader.setUniformf(this.KaPos, color);
    }

    public void setDiffuseColor(Color color) {
        this.shader.setUniformf(this.KdPos, color);
    }

    public void setSpecularColor(Color color) {
        this.shader.setUniformf(this.KsPos, color);
    }

    public void setSpecularExponent(float value) {
        this.shader.setUniformf(this.NsPos, value);
    }

    public void setAmbientTexture(Texture texture) {
        if (texture == null) {
            this.shader.setUniformi(this.hasKaPos, 0);
            this.shader.setUniformi(this.mapKaPos, 0);
        } else {
            this.shader.setUniformi(this.hasKaPos, 1);
            this.shader.setUniformi(this.mapKaPos, 1);
        }
    }

    public void setDiffuseTexture(Texture texture) {
        if (texture == null) {
            this.shader.setUniformi(this.hasKdPos, 0);
            this.shader.setUniformi(this.mapKdPos, 0);
        } else {
            this.shader.setUniformi(this.hasKdPos, 1);
            this.shader.setUniformi(this.mapKdPos, 0);
        }
    }

    public void setSpecularTexture(Texture texture) {
        if (texture == null) {
            this.shader.setUniformi(this.hasKsPos, 0);
            this.shader.setUniformi(this.mapKsPos, 0);
        } else {
            this.shader.setUniformi(this.hasKsPos, 1);
            this.shader.setUniformi(this.mapKsPos, 2);
        }
    }

    public void setNormalTexture(Texture texture) {
        if (texture == null) {
            this.shader.setUniformi(this.hasKnPos, 0);
            this.shader.setUniformi(this.mapKnPos, 0);
        } else {
            this.shader.setUniformi(this.hasKnPos, 1);
            this.shader.setUniformi(this.mapKnPos, 3);
        }
    }

    public static Material getBlank() {
        if (BLANK == null) {
            BLANK = new Material();
        }
        return BLANK;
    }
}

