/*
 * Decompiled with CFR 0.152.
 */
package box2dLight.shaders;

import box2dLight.RayHandler;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;

public class Gaussian {
    public static final String TEXTURE_UNIFORM = "u_texture";
    public static final String DIRECTION_UNIFORM = "u_dir";

    public static ShaderProgram createBlurShader(int width, int height) {
        String FBO_W = Integer.toString(width);
        String FBO_H = Integer.toString(height);
        String rgb = RayHandler.isDiffuse ? ".rgb" : "";
        String[] vertex20 = new String[]{"attribute vec4 a_position;", "attribute vec2 a_texCoord;", "uniform vec2  u_dir;", "varying vec2 v_texCoords0;", "varying vec2 v_texCoords1;", "varying vec2 v_texCoords2;", "varying vec2 v_texCoords3;", "varying vec2 v_texCoords4;", "#define FBO_W " + FBO_W + ".0", "#define FBO_H " + FBO_H + ".0", "const vec2 futher = vec2(3.2307692308 / FBO_W, 3.2307692308 / FBO_H );", "const vec2 closer = vec2(1.3846153846 / FBO_W, 1.3846153846 / FBO_H );", "void main() {", "    vec2 f = futher * u_dir;", "    vec2 c = closer * u_dir;", "    v_texCoords0 = a_texCoord - f;", "    v_texCoords1 = a_texCoord - c;", "    v_texCoords2 = a_texCoord;", "    v_texCoords3 = a_texCoord + c;", "    v_texCoords4 = a_texCoord + f;", "    gl_Position = a_position;", "}"};
        String[] vertex30 = new String[]{"in vec4 a_position;", "in vec2 a_texCoord;", "uniform vec2  u_dir;", "out vec2 v_texCoords0;", "out vec2 v_texCoords1;", "out vec2 v_texCoords2;", "out vec2 v_texCoords3;", "out vec2 v_texCoords4;", "#define FBO_W " + FBO_W + ".0", "#define FBO_H " + FBO_H + ".0", "const vec2 futher = vec2(3.2307692308 / FBO_W, 3.2307692308 / FBO_H );", "const vec2 closer = vec2(1.3846153846 / FBO_W, 1.3846153846 / FBO_H );", "void main() {", "    vec2 f = futher * u_dir;", "    vec2 c = closer * u_dir;", "    v_texCoords0 = a_texCoord - f;", "    v_texCoords1 = a_texCoord - c;", "    v_texCoords2 = a_texCoord;", "    v_texCoords3 = a_texCoord + c;", "    v_texCoords4 = a_texCoord + f;", "    gl_Position = a_position;", "}"};
        String[] fragment20 = new String[]{"#ifdef GL_ES", "    precision lowp float;", "    #define MED mediump", "#else", "    #define MED ", "#endif", "uniform sampler2D u_texture;", "varying MED vec2 v_texCoords0;", "varying MED vec2 v_texCoords1;", "varying MED vec2 v_texCoords2;", "varying MED vec2 v_texCoords3;", "varying MED vec2 v_texCoords4;", "const float center = 0.2270270270;", "const float close  = 0.3162162162;", "const float far    = 0.0702702703;", "void main() {", "    gl_FragColor" + rgb + " = far    * texture2D(u_texture, v_texCoords0)" + rgb, "\t      \t\t+ close  * texture2D(u_texture, v_texCoords1)" + rgb, "\t\t\t\t+ center * texture2D(u_texture, v_texCoords2)" + rgb, "\t\t\t\t+ close  * texture2D(u_texture, v_texCoords3)" + rgb, "\t\t\t\t+ far    * texture2D(u_texture, v_texCoords4)" + rgb + ";", "}"};
        String[] fragment30 = new String[]{"#ifdef GL_ES", "    precision lowp float;", "    #define MED mediump", "#else", "    #define MED ", "#endif", "uniform sampler2D u_texture;", "out vec4 frag_color;", "in MED vec2 v_texCoords0;", "in MED vec2 v_texCoords1;", "in MED vec2 v_texCoords2;", "in MED vec2 v_texCoords3;", "in MED vec2 v_texCoords4;", "const float center = 0.2270270270;", "const float close  = 0.3162162162;", "const float far    = 0.0702702703;", "void main() {", "    frag_color" + rgb + " = far    * texture(u_texture, v_texCoords0)" + rgb, "\t      \t\t+ close  * texture(u_texture, v_texCoords1)" + rgb, "\t\t\t\t+ center * texture(u_texture, v_texCoords2)" + rgb, "\t\t\t\t+ close  * texture(u_texture, v_texCoords3)" + rgb, "\t\t\t\t+ far    * texture(u_texture, v_texCoords4)" + rgb + ";", "    frag_color.a = 1.0;", "}"};
        String[] vertSource = vertex20;
        String[] fragSource = fragment20;
        if (Gdx.gl30 != null) {
            vertSource = vertex30;
            fragSource = fragment30;
        }
        StringBuilder vstr = new StringBuilder();
        for (String s : vertSource) {
            vstr.append(s);
            vstr.append("\n");
        }
        String vertexShader = vstr.toString();
        StringBuilder fstr = new StringBuilder();
        for (String s : fragSource) {
            fstr.append(s);
            fstr.append("\n");
        }
        String fragmentShader = fstr.toString();
        ShaderProgram.pedantic = false;
        String vertPrefix = ShaderProgram.prependVertexCode;
        String fragPrefix = ShaderProgram.prependFragmentCode;
        if (Gdx.gl30 != null) {
            ShaderProgram.prependVertexCode = "#version 330 core\n";
            ShaderProgram.prependFragmentCode = "#version 330 core\n";
        }
        ShaderProgram blurShader = new ShaderProgram(vertexShader, fragmentShader);
        if (Gdx.gl30 != null) {
            ShaderProgram.prependVertexCode = vertPrefix;
            ShaderProgram.prependFragmentCode = fragPrefix;
        }
        if (!blurShader.isCompiled()) {
            Gdx.app.error("Gaussian Shader Error", blurShader.getLog());
        }
        return blurShader;
    }
}

