/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.ailab;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.cis3152.ailab.Photon;
import edu.cornell.gdiac.assets.ParserUtils;
import edu.cornell.gdiac.graphics.obj.ModelRef;
import edu.cornell.gdiac.graphics.obj.ObjPipeline;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PhotonPool
implements Iterable<Photon> {
    protected Photon[] queue;
    protected int head;
    protected int tail;
    protected int size;
    private int capacity;
    private float diameter;
    private float offset;
    private float decay;
    private ModelRef photonModel;
    private Quaternion rotation;
    private Color normalColor = Color.CYAN;
    private Color powerColor = Color.RED;
    private float alphaFactor;
    private float alphaOffset;
    private PhotonIterator iterator = new PhotonIterator();

    public PhotonPool(JsonValue constants) {
        this.capacity = constants.getInt("capacity");
        this.offset = constants.getFloat("offset");
        this.decay = constants.getFloat("decay");
        this.diameter = constants.getFloat("diameter");
        this.alphaFactor = constants.get("alpha").getFloat(1);
        this.alphaOffset = constants.get("alpha").getFloat(0);
        this.normalColor = ParserUtils.parseColor((JsonValue)constants.get("base color"), (Color)Color.WHITE);
        this.powerColor = ParserUtils.parseColor((JsonValue)constants.get("power color"), (Color)Color.WHITE);
        this.queue = new Photon[this.capacity];
        Photon.setConstants(constants);
        this.head = 0;
        this.tail = -1;
        this.size = 0;
        for (int ii = 0; ii < this.queue.length; ++ii) {
            this.queue[ii] = new Photon();
        }
        this.rotation = new Quaternion();
    }

    public void update() {
        for (Photon p : this) {
            p.age();
            p.getPosition().add(p.getVelocity());
        }
        while (this.size > 0 && !this.queue[this.head].isAlive()) {
            if (!this.queue[this.head].isDirty()) {
                --this.size;
            }
            this.head = (this.head + 1) % this.queue.length;
        }
    }

    public ModelRef getPhotonModel() {
        return this.photonModel;
    }

    public void setPhotonModel(ModelRef model) {
        this.photonModel = model;
    }

    public void draw(ObjPipeline pipeline) {
        Gdx.gl20.glBlendFuncSeparate(770, 1, 1, 0);
        for (Photon p : this) {
            p.getColor().a = p.getLifeRatio() * this.alphaFactor + this.alphaOffset;
            this.photonModel.getMaterial().setDiffuseTint(p.getColor());
            float angle = (float)Math.toDegrees(Math.atan2(p.getVY(), p.getVX()));
            this.rotation.set(Vector3.Z, angle);
            float scale = this.diameter + this.decay * p.getLifeRatio();
            this.photonModel.setPosition(p.getX(), p.getY(), this.offset);
            this.photonModel.setRotation(this.rotation);
            this.photonModel.setScale(scale, scale, scale);
            pipeline.draw(this.photonModel);
        }
    }

    public void allocate(int id, float x, float y, float vx, float vy, boolean power) {
        if (this.size == this.queue.length) {
            this.head = (this.head + 1) % this.queue.length;
            --this.size;
        }
        Color c = power ? this.powerColor : this.normalColor;
        this.tail = (this.tail + 1) % this.queue.length;
        this.queue[this.tail].set(id, x, y, vx, vy, c);
        ++this.size;
    }

    public void destroy(Photon p) {
        p.destroy();
        --this.size;
    }

    @Override
    public Iterator<Photon> iterator() {
        this.iterator.limit = this.size;
        this.iterator.pos = this.head;
        this.iterator.cnt = 0;
        return this.iterator;
    }

    private class PhotonIterator
    implements Iterator<Photon> {
        public int pos = 0;
        public int cnt = 0;
        public int limit = 0;

        private PhotonIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cnt < this.limit;
        }

        @Override
        public Photon next() {
            if (this.cnt > this.limit) {
                throw new NoSuchElementException();
            }
            int idx = this.pos;
            do {
                this.pos = (this.pos + 1) % PhotonPool.this.queue.length;
            } while (!PhotonPool.this.queue[this.pos].isAlive());
            ++this.cnt;
            return PhotonPool.this.queue[idx];
        }
    }
}

