/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.ailab;

import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.cis3152.ailab.CollisionController;
import edu.cornell.cis3152.ailab.GameSession;
import edu.cornell.cis3152.ailab.GameplayController;
import edu.cornell.cis3152.ailab.GraphicsPipeline;
import edu.cornell.cis3152.ailab.ShipList;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.audio.SoundEffect;
import edu.cornell.gdiac.audio.SoundEffectManager;

public class GameScene
implements Screen {
    private static final String MESSG_LOAD = "Loading...";
    private AssetDirectory assets;
    private JsonValue strings;
    private CollisionController physicsController;
    private GameplayController gameplayController;
    private GameSession session;
    private GraphicsPipeline pipeline;
    private GameState gameState = GameState.LOAD;
    private float gameLoad = 0.0f;

    public GameScene() {
        this.pipeline = new GraphicsPipeline();
    }

    public void dispose() {
        this.unload();
    }

    public void resetGame() {
        this.session = new GameSession(this.assets);
        this.gameplayController = new GameplayController(this.session);
        this.physicsController = new CollisionController(this.session);
        this.pipeline.setSession(this.session);
        this.gameState = GameState.PLAY;
    }

    public void updateLoad() {
        if (this.assets.update()) {
            if (this.session == null) {
                this.resetGame();
                this.strings = (JsonValue)this.assets.getEntry("strings", JsonValue.class);
                this.gameState = GameState.LOAD;
            }
            if (this.gameLoad < 1.0f) {
                this.gameLoad += 0.01f;
            } else {
                this.gameState = GameState.BEFORE;
            }
        }
    }

    public void updateGame() {
        this.gameplayController.update();
        this.physicsController.update();
        ShipList ships = this.session.getShips();
        if (this.gameState == GameState.PLAY) {
            if (!ships.getPlayer().isActive()) {
                this.gameState = GameState.FINISH;
                SoundEffect s = (SoundEffect)this.assets.getEntry("over", SoundEffect.class);
                SoundEffectManager sounds = SoundEffectManager.getInstance();
                sounds.play("over", s);
            } else if (ships.numActive() <= 1) {
                this.gameState = GameState.FINISH;
            }
        } else if (!(this.gameState != GameState.FINISH || ships.getPlayer().isAlive() && ships.numAlive() > 1)) {
            this.gameState = GameState.AFTER;
        }
    }

    public void drawLoad() {
        this.pipeline.setEyePan(this.gameLoad);
        if (this.session != null) {
            ShipList ships = this.session.getShips();
            this.pipeline.setTarget(ships.getPlayer().getX(), ships.getPlayer().getY());
        }
        this.pipeline.render(MESSG_LOAD);
    }

    public void drawGame() {
        this.pipeline.setEyePan(1.0f);
        ShipList ships = this.session.getShips();
        Object message = null;
        switch (this.gameState) {
            case BEFORE: {
                message = this.strings.getString("start");
                break;
            }
            case FINISH: 
            case AFTER: {
                if (!ships.getPlayer().isActive()) {
                    message = this.strings.getString("lost") + "\n" + this.strings.getString("restart");
                    break;
                }
                message = this.strings.getString("won") + "\n" + this.strings.getString("restart");
                break;
            }
            case LOAD: {
                message = this.strings.getString("load") + "\n" + this.strings.getString("restart");
                break;
            }
        }
        this.pipeline.setTarget(ships.getPlayer().getX(), ships.getPlayer().getY());
        this.pipeline.render((String)message);
    }

    public void show() {
        this.load();
    }

    public void hide() {
        this.unload();
    }

    public void render(float delta) {
        int selection = 0;
        if (this.gameplayController != null) {
            selection = this.gameplayController.getPlayerSelection();
        }
        if (this.gameState == GameState.BEFORE) {
            if ((selection & 1) != 0) {
                this.gameState = GameState.PLAY;
            }
        } else if ((this.gameState == GameState.PLAY || this.gameState == GameState.FINISH || this.gameState == GameState.AFTER) && (selection & 2) != 0) {
            this.resetGame();
            this.gameState = GameState.PLAY;
        }
        switch (this.gameState) {
            case LOAD: {
                this.updateLoad();
                this.drawLoad();
                break;
            }
            case FINISH: 
            case PLAY: {
                this.updateGame();
            }
            case BEFORE: 
            case AFTER: {
                this.drawGame();
            }
        }
    }

    public void resize(int width, int height) {
        this.pipeline.resize(width, height);
    }

    public void pause() {
    }

    public void resume() {
    }

    private void load() {
        AssetDirectory boot = new AssetDirectory("jsons/loading.json");
        boot.loadAssets();
        boot.finishLoading();
        Texture stars = (Texture)boot.getEntry("stars", Texture.class);
        this.pipeline.setBackground(stars);
        BitmapFont font = (BitmapFont)boot.getEntry("amyn", BitmapFont.class);
        this.pipeline.setFont(font);
        this.assets = new AssetDirectory("jsons/assets.json");
        this.assets.loadAssets();
    }

    private void unload() {
        this.pipeline.setBackground(null);
        this.pipeline.setFont(null);
        this.assets.unloadAssets();
    }

    public static enum GameState {
        LOAD,
        BEFORE,
        PLAY,
        FINISH,
        AFTER;

    }
}

