/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.ailab;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.ParserUtils;
import edu.cornell.gdiac.graphics.obj.ModelRef;
import edu.cornell.gdiac.graphics.obj.ObjPipeline;

public class Board {
    private JsonValue constants;
    private int width;
    private int height;
    private float tileSize;
    private float tileDepth;
    private float tileSpace;
    private float minFall;
    private float maxFall;
    private float fallRate;
    private TileState[] tiles;
    private ModelRef tileModel;
    private Color tileColor;
    private Color powerColor;
    private Quaternion rotation;

    public Board(JsonValue constants) {
        this.constants = constants;
        this.width = constants.get("size").getInt(0);
        this.height = constants.get("size").getInt(1);
        this.tileSize = constants.getFloat("tile size");
        this.tileDepth = constants.getFloat("tile depth");
        this.tileSpace = constants.getFloat("tile space");
        this.minFall = constants.get("fall range").getInt(0);
        this.maxFall = constants.get("fall range").getInt(1);
        this.fallRate = constants.getFloat("fall rate");
        this.tileColor = ParserUtils.parseColor((JsonValue)constants.get("basic color"), (Color)Color.WHITE);
        this.powerColor = ParserUtils.parseColor((JsonValue)constants.get("power color"), (Color)Color.WHITE);
        this.tiles = new TileState[this.width * this.height];
        for (int ii = 0; ii < this.tiles.length; ++ii) {
            this.tiles[ii] = new TileState();
        }
        this.rotation = new Quaternion();
        this.resetTiles();
    }

    public void resetTiles() {
        int interval = this.constants.getInt("power interval");
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                TileState tile = this.getTileState(x, y);
                tile.power = x % interval == 0 || y % interval == 0;
                tile.goal = false;
                tile.visited = false;
                tile.fallAmount = 0.0f;
                tile.falling = false;
            }
        }
    }

    private TileState getTileState(int x, int y) {
        if (!this.inBounds(x, y)) {
            return null;
        }
        return this.tiles[x * this.height + y];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getTileSize() {
        return this.tileSize;
    }

    public float getTileSpacing() {
        return this.tileSpace;
    }

    public void setTile(ModelRef model) {
        this.tileModel = model;
    }

    public ModelRef getTile() {
        return this.tileModel;
    }

    public boolean isSafeAtScreen(float x, float y) {
        int bx = this.screenToBoard(x);
        int by = this.screenToBoard(y);
        return x >= 0.0f && y >= 0.0f && x < (float)this.width * (this.tileSize + this.tileSpace) - this.tileSpace && y < (float)this.height * (this.tileSize + this.tileSpace) - this.tileSpace && !this.getTileState((int)bx, (int)by).falling;
    }

    public boolean isSafeAt(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height && !this.getTileState((int)x, (int)y).falling;
    }

    public void destroyTileAt(int x, int y) {
        if (!this.inBounds(x, y)) {
            return;
        }
        this.getTileState((int)x, (int)y).falling = true;
    }

    public boolean isDestroyedAt(int x, int y) {
        if (!this.inBounds(x, y)) {
            return true;
        }
        return this.getTileState((int)x, (int)y).fallAmount >= this.minFall;
    }

    public boolean isPowerTileAtScreen(float x, float y) {
        int ty;
        int tx = this.screenToBoard(x);
        if (!this.inBounds(tx, ty = this.screenToBoard(y))) {
            return false;
        }
        return this.getTileState((int)tx, (int)ty).power;
    }

    public boolean isPowerTileAt(int x, int y) {
        if (!this.inBounds(x, y)) {
            return false;
        }
        return this.getTileState((int)x, (int)y).power;
    }

    public void update() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                TileState tile = this.getTileState(x, y);
                if (!tile.falling || !(tile.fallAmount <= this.maxFall)) continue;
                tile.fallAmount += this.fallRate;
            }
        }
    }

    public void draw(ObjPipeline pipeline) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.drawTile(x, y, pipeline);
            }
        }
    }

    private void drawTile(int x, int y, ObjPipeline pipeline) {
        TileState tile = this.getTileState(x, y);
        if (tile.fallAmount >= this.maxFall) {
            return;
        }
        float sx = this.boardToScreen(x);
        float sy = this.boardToScreen(y);
        float sz = tile.fallAmount;
        float a = 0.1f * tile.fallAmount;
        this.rotation.set(Vector3.Z, (float)Math.toDegrees(a));
        this.tileModel.setPosition(sx, sy, sz);
        this.tileModel.setRotation(this.rotation);
        this.tileModel.setScale(this.tileSize / 2.0f, this.tileSize / 2.0f, this.tileDepth);
        this.tileModel.getMaterial().setDiffuseTint(this.tileColor);
        if (tile.power) {
            this.tileModel.getMaterial().setDiffuseTint(this.powerColor);
        }
        pipeline.draw(this.tileModel);
    }

    public int screenToBoard(float f) {
        return (int)(f / (this.tileSize + this.tileSpace));
    }

    public float boardToScreen(int n) {
        return ((float)n + 0.5f) * (this.tileSize + this.tileSpace);
    }

    public float centerOffset(float f) {
        float paddedTileSize = this.tileSize + this.tileSpace;
        int cell = this.screenToBoard(f);
        float nearestCenter = ((float)cell + 0.5f) * paddedTileSize;
        return f - nearestCenter;
    }

    public boolean inBounds(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height;
    }

    public boolean isVisited(int x, int y) {
        if (!this.inBounds(x, y)) {
            return false;
        }
        return this.getTileState((int)x, (int)y).visited;
    }

    public void setVisited(int x, int y) {
        if (!this.inBounds(x, y)) {
            Gdx.app.error("Board", "Illegal tile " + x + "," + y, (Throwable)new IndexOutOfBoundsException());
            return;
        }
        this.getTileState((int)x, (int)y).visited = true;
    }

    public boolean isGoal(int x, int y) {
        if (!this.inBounds(x, y)) {
            return false;
        }
        return this.getTileState((int)x, (int)y).goal;
    }

    public void setGoal(int x, int y) {
        if (!this.inBounds(x, y)) {
            Gdx.app.error("Board", "Illegal tile " + x + "," + y, (Throwable)new IndexOutOfBoundsException());
            return;
        }
        this.getTileState((int)x, (int)y).goal = true;
    }

    public void clearMarks() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                TileState state = this.getTileState(x, y);
                state.visited = false;
                state.goal = false;
            }
        }
    }

    private static class TileState {
        public boolean power = false;
        public boolean goal = false;
        public boolean visited = false;
        public boolean falling = false;
        public float fallAmount = 0.0f;

        private TileState() {
        }
    }
}

