/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.ailab;

import edu.cornell.cis3152.ailab.Board;
import edu.cornell.cis3152.ailab.GameSession;
import edu.cornell.cis3152.ailab.InputController;
import edu.cornell.cis3152.ailab.Ship;

public class AIController
implements InputController {
    private static final int CHASE_DIST = 9;
    private static final int ATTACK_DIST = 4;
    private int id;
    private Ship ship;
    private Ship target;
    private GameSession session;
    private FSMState state;
    private int move;
    private long ticks;

    public AIController(int id) {
        this.id = id;
        this.state = FSMState.SPAWN;
        this.move = 0;
        this.ticks = 0L;
        this.target = null;
    }

    public AIController(int id, GameSession session) {
        this(id);
        this.setSession(session);
    }

    public void setSession(GameSession session) {
        this.session = session;
        this.ship = session.getShips().get(this.id);
        this.selectTarget();
    }

    @Override
    public int getSelection() {
        return 0;
    }

    @Override
    public int getAction() {
        ++this.ticks;
        if (((long)this.ship.getId() + this.ticks) % 10L == 0L) {
            this.changeStateIfApplicable();
            this.markGoalTiles();
            this.move = this.getMoveAlongPathToGoalTile();
        }
        int action = this.move;
        if (this.state == FSMState.ATTACK && this.canShootTarget()) {
            action |= 0x10;
        }
        return action;
    }

    private void changeStateIfApplicable() {
        switch (this.state) {
            case SPAWN: {
                break;
            }
            case WANDER: {
                break;
            }
            case CHASE: {
                break;
            }
            case ATTACK: {
                break;
            }
            default: {
                assert (false);
                this.state = FSMState.WANDER;
            }
        }
    }

    private void selectTarget() {
    }

    private boolean canShootTargetFrom(int x, int y) {
        return false;
    }

    private boolean canShootTarget() {
        return false;
    }

    private void markGoalTiles() {
        Board board = this.session.getBoard();
        board.clearMarks();
        boolean setGoal = false;
        switch (this.state) {
            case SPAWN: {
                break;
            }
            case WANDER: {
                break;
            }
            case CHASE: {
                break;
            }
        }
        if (!setGoal) {
            int sx = board.screenToBoard(this.ship.getX());
            int sy = board.screenToBoard(this.ship.getY());
            board.setGoal(sx, sy);
        }
    }

    private int getMoveAlongPathToGoalTile() {
        return 0;
    }

    private static enum FSMState {
        SPAWN,
        WANDER,
        CHASE,
        ATTACK;

    }
}

