/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.util;

import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.math.Vector3;

public class Gimbal {
    public static float DEFAULT_MIN_ZOOM = 0.1f;
    public static float DEFAULT_MAX_ZOOM = 10.0f;
    private PerspectiveCamera camera;
    private Vector3 eye = new Vector3();
    private Vector3 up = new Vector3();
    private Vector3 target = new Vector3();
    private float distance;
    private float minZoom;
    private float maxZoom;
    private Vector3 origPos = new Vector3();
    private Vector3 origUp = new Vector3();
    private boolean dirty;
    private Vector3 temp0 = new Vector3();
    private Vector3 temp1 = new Vector3();

    public Gimbal() {
        this.minZoom = DEFAULT_MIN_ZOOM;
        this.maxZoom = DEFAULT_MAX_ZOOM;
    }

    public Gimbal(PerspectiveCamera camera) {
        this();
        this.setCamera(camera);
    }

    public PerspectiveCamera getCamera() {
        return this.camera;
    }

    public void setCamera(PerspectiveCamera camera) {
        if (camera == null) {
            this.camera = null;
            this.eye.setZero();
            this.distance = 0.0f;
            return;
        }
        this.camera = camera;
        this.eye.set(camera.position);
        this.up.set(camera.up);
        this.distance = this.eye.len();
        this.origPos.set(this.eye);
        this.origUp.set(camera.up);
    }

    public Vector3 getEye() {
        return this.eye;
    }

    public Vector3 getTarget() {
        return this.target;
    }

    public Vector3 getUp() {
        return this.up;
    }

    public float getZoom() {
        return this.distance;
    }

    public float getMinimumZoom() {
        return this.minZoom;
    }

    public void setMinimumZoom(float min) {
        if (min <= 0.0f) {
            throw new IllegalArgumentException();
        }
        this.minZoom = min;
    }

    public float getMaximumZoom() {
        return this.maxZoom;
    }

    public void setMaximumZoom(float max) {
        if (max <= 0.0f) {
            throw new IllegalArgumentException();
        }
        this.maxZoom = max;
    }

    public void rotateY(float angle) {
        if (!this.dirty) {
            this.up.set(this.camera.up);
        }
        this.temp0.set(this.camera.direction);
        this.temp1.set(this.up);
        this.temp1.crs(this.temp0);
        this.temp1.nor();
        this.temp1.scl(this.distance);
        this.eye.sub(this.target);
        Gimbal.traverseGreatCircle(this.eye, this.temp1, angle);
        this.eye.nor();
        this.eye.scl(this.distance);
        this.eye.add(this.target);
        this.dirty = true;
    }

    public void rotateX(float angle) {
        if (!this.dirty) {
            this.up.set(this.camera.up);
        }
        this.temp1.set(this.up).scl(this.distance);
        this.eye.sub(this.target);
        Gimbal.traverseGreatCircle(this.eye, this.temp1, angle);
        this.eye.nor();
        this.eye.scl(this.distance);
        this.eye.add(this.target);
        this.dirty = true;
    }

    public void rotateZ(float angle) {
        if (!this.dirty) {
            this.up.set(this.camera.up);
        }
        this.temp0.set(this.camera.direction);
        Gimbal.rotateAbout(this.up, this.temp0, angle);
        this.dirty = true;
    }

    public void adjustZoom(float dt) {
        this.distance += dt;
        if (this.distance < this.minZoom) {
            this.distance = this.minZoom;
        } else if (this.distance > this.maxZoom) {
            this.distance = this.maxZoom;
        }
        this.eye.sub(this.target);
        this.eye.nor();
        this.eye.scl(this.distance);
        this.eye.add(this.target);
        this.dirty = true;
    }

    public void pan(Vector3 delta) {
        this.pan(delta.x, delta.y, delta.z);
    }

    public void pan(float dx, float dy, float dz) {
        this.up.set(this.camera.up);
        this.temp0.set(this.camera.direction);
        this.temp1.set(this.temp0).crs(this.up);
        float px = this.temp1.x * dx + this.up.x * dy + this.temp0.x * dz;
        float py = this.temp1.y * dx + this.up.y * dy + this.temp0.y * dz;
        float pz = this.temp1.z * dx + this.up.z * dy + this.temp0.z * dz;
        this.target.add(px, py, pz);
        this.eye.add(px, py, pz);
        this.dirty = true;
    }

    public void reset() {
        this.camera.position.set(this.origPos);
        this.camera.up.set(this.origUp);
        this.camera.lookAt(0.0f, 0.0f, 0.0f);
        this.camera.update();
        this.eye.set(this.origPos);
        this.up.set(this.origUp);
        this.target.set(0.0f, 0.0f, 0.0f);
        this.distance = this.origPos.len();
        this.dirty = false;
    }

    public void update() {
        if (this.dirty) {
            this.camera.position.set(this.eye);
            this.camera.up.set(this.up);
            this.camera.lookAt(this.target.x, this.target.y, this.target.z);
            this.camera.update();
            this.dirty = false;
        }
    }

    private static Vector3 traverseGreatCircle(Vector3 current, Vector3 target, float angle) {
        float x = target.x;
        float y = target.y;
        float z = target.z;
        target.crs(current);
        target.nor();
        float ca = (float)Math.cos(angle);
        float sa = (float)Math.sin(angle);
        float tx = (target.x * target.x + ca * (1.0f - target.x * target.x)) * current.x + (target.x * target.y * (1.0f - ca) - target.z * sa) * current.y + (target.z * target.x * (1.0f - ca) + target.y * sa) * current.z;
        float ty = (target.x * target.y * (1.0f - ca) + target.z * sa) * current.x + (target.y * target.y + ca * (1.0f - target.y * target.y)) * current.y + (target.y * target.z * (1.0f - ca) - target.x * sa) * current.z;
        float tz = (target.z * target.x * (1.0f - ca) - target.y * sa) * current.x + (target.y * target.z * (1.0f - ca) + target.x * sa) * current.y + (target.z * target.z + ca * (1.0f - target.z * target.z)) * current.z;
        target.set(x, y, z);
        return current.set(tx, ty, tz);
    }

    private static Vector3 rotateAbout(Vector3 v, Vector3 axis, float angle) {
        float x = axis.x;
        float y = axis.y;
        float z = axis.z;
        axis.nor();
        float ca = (float)Math.cos(angle);
        float sa = (float)Math.sin(angle);
        float da = axis.dot(v) * (1.0f - ca);
        axis.crs(v).scl(sa);
        v.scl(ca).add(axis);
        axis.set(x, y, z).nor().scl(da);
        v.add(axis);
        axis.set(x, y, z);
        return v;
    }
}

