/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.backend;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.HdpiMode;

public class GDXAppSettings {
    public String title;
    public int width = 1280;
    public int height = 720;
    public int x = -1;
    public int y = -1;
    public boolean fullscreen = false;
    public boolean rawHDPI = true;
    public boolean useGL30 = true;
    public boolean debugGL = false;
    public boolean vSyncEnabled = true;
    public int samples = 2;
    public boolean resizable = true;
    public boolean useAudio = true;
    public int audioDeviceSimultaneousSources = 24;
    public int audioDeviceBufferSize = 512;
    public int audioDeviceBufferCount = 9;
    public Color initialBackgroundColor = Color.BLACK;
    public int foregroundFPS = 60;
    public int backgroundFPS = 60;
    public String iconList = "";
    public boolean pauseWhenMinimized = true;
    public boolean pauseWhenBackground = false;

    public static int getRefreshRate() {
        return Lwjgl3ApplicationConfiguration.getDisplayMode().refreshRate;
    }

    public static int getRefreshRate(Graphics.Monitor monitor) {
        return Lwjgl3ApplicationConfiguration.getDisplayMode((Graphics.Monitor)monitor).refreshRate;
    }

    Lwjgl3ApplicationConfiguration getLwjgl3Configuration() {
        Lwjgl3ApplicationConfiguration config = new Lwjgl3ApplicationConfiguration();
        config.setTitle(this.title);
        if (this.fullscreen) {
            config.setFullscreenMode(Lwjgl3ApplicationConfiguration.getDisplayMode());
        } else {
            config.setWindowedMode(this.width, this.height);
        }
        config.setWindowPosition(this.x, this.y);
        config.setBackBufferConfig(8, 8, 8, 8, 24, 8, this.samples);
        if (this.useGL30) {
            config.setOpenGLEmulation(Lwjgl3ApplicationConfiguration.GLEmulation.GL30, 3, 2);
        } else {
            config.setOpenGLEmulation(Lwjgl3ApplicationConfiguration.GLEmulation.GL20, 3, 2);
        }
        if (this.debugGL) {
            config.enableGLDebugOutput(true, System.err);
        }
        config.setHdpiMode(this.rawHDPI ? HdpiMode.Pixels : HdpiMode.Logical);
        config.setResizable(this.resizable);
        config.setAudioConfig(this.audioDeviceSimultaneousSources, this.audioDeviceBufferSize, this.audioDeviceBufferCount);
        config.setInitialBackgroundColor(this.initialBackgroundColor);
        config.setForegroundFPS(this.foregroundFPS);
        config.setIdleFPS(this.backgroundFPS);
        config.disableAudio(true);
        if (this.iconList != "") {
            Lwjgl3FileHandle handle = new Lwjgl3FileHandle(this.iconList, Files.FileType.Classpath);
            String contents = handle.readString();
            String[] files = contents.split("\\r?\\n");
            config.setWindowIcon(files);
        }
        return config;
    }
}

