/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.design;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.design.GameCanvas;
import java.util.ArrayList;
import java.util.Objects;

public class TileMapConfigModel {
    protected int width;
    protected int height;
    protected int rows;
    protected int cols;
    private String layout = "00990102020399129999999999999999999999999999\n99129999999999282903990107039999013115999999\n99249912999901404199129936991299993739991315\n99060246039999992499060399011999999999993039\n99249936999901071799369912993699999912992499\n99369999999999249999990118039999991343992815\n99999901059904179912999999999999993739993739\n12999999369936990117999999131599999999999999\n16039999999999999999999913452799999999132903\n99999999131599999913159937384231141599373999\n99999999372003990108420599999937113999999999\n99129999993699999936992499999999369999999999\n13439999999999999999991631159999999999131599\n25442903991315999912999925100399999901232799\n25323999133439990109159937399999999999373999\n37419999373999999937399999999999129999999999\n99249999999999999999999999999913221599999999\n01460399131415991314159999129937383999131599\n99369999252627993733279913210399999999373515\n99999999373839999937399937399999999999993739";

    public void draw(GameCanvas canvas, ArrayList<ArrayList<Integer>> map, ArrayList<TextureRegion> tiles) {
        canvas.clear();
        canvas.begin();
        if (tiles.size() == 0 || tiles.get(0) == null || map.size() == 0) {
            return;
        }
        int otw = tiles.get(0).getRegionWidth();
        int oth = tiles.get(0).getRegionHeight();
        float scalewidth = (float)this.width / (float)otw;
        float scaleheight = (float)this.height / (float)oth;
        int maxy = map.size();
        for (int y = 0; y < maxy; ++y) {
            ArrayList<Integer> row = map.get(y);
            if (row == null) continue;
            int maxx = row.size();
            for (int x = 0; x < maxx; ++x) {
                Integer ind = row.get(x);
                if (ind == null) continue;
                TextureRegion im = tiles.get(ind);
                int xcord = x * this.width + this.width * 2;
                int ycord = (maxy - y - 1) * this.height;
                canvas.draw(im, Color.WHITE, 0.0f, 0.0f, (float)xcord, (float)ycord, 0.0f, scalewidth, scaleheight);
            }
        }
        canvas.end();
    }

    public ArrayList<TextureRegion> tilize(TextureRegion image) {
        int originalWidth = image.getRegionWidth();
        int originalHeight = image.getRegionHeight();
        int tileWidth = originalWidth / this.cols;
        int tileHeight = originalHeight / this.rows;
        ArrayList<TextureRegion> result = new ArrayList<TextureRegion>();
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.cols; ++x) {
                TextureRegion piece = new TextureRegion(image, x * tileWidth, y * tileHeight, tileWidth, tileHeight);
                result.add(piece);
            }
        }
        return result;
    }

    public void populate(AssetDirectory directory, JsonValue configJson) {
        this.width = configJson.getInt("width");
        this.height = configJson.getInt("height");
        this.cols = configJson.getInt("cols");
        this.rows = configJson.getInt("rows");
    }

    public ArrayList<ArrayList<Integer>> decodeLayout() {
        String[] lines = this.layout.split("\n");
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
        for (String code : lines) {
            if (Objects.equals(code.trim(), "")) continue;
            ArrayList<Integer> row = new ArrayList<Integer>();
            int pref = -1;
            for (char c : code.toCharArray()) {
                if (pref == -1) {
                    pref = Character.getNumericValue(c);
                    continue;
                }
                Integer value = pref * 10 + Character.getNumericValue(c);
                if (value == 99) {
                    value = null;
                }
                row.add(value);
                pref = -1;
            }
            result.add(row);
        }
        return result;
    }

    public void dispose() {
        this.width = -1;
        this.height = -1;
        this.cols = -1;
        this.rows = -1;
    }
}

