/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.design;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.design.GameCanvas;
import edu.cornell.gdiac.util.ScreenListener;

public class LoadingMode
implements Screen,
InputProcessor {
    private AssetDirectory internal;
    private AssetDirectory assets;
    private Texture background;
    private Texture playButton;
    private final Texture statusBar;
    private TextureRegion statusBkgLeft;
    private TextureRegion statusBkgMiddle;
    private TextureRegion statusBkgRight;
    private TextureRegion statusFrgLeft;
    private TextureRegion statusFrgMiddle;
    private TextureRegion statusFrgRight;
    private static int DEFAULT_BUDGET = 15;
    private static int STANDARD_WIDTH = 800;
    private static int STANDARD_HEIGHT = 700;
    private static float BAR_WIDTH_RATIO = 0.66f;
    private static float BAR_HEIGHT_RATIO = 0.25f;
    private static float BUTTON_SCALE = 0.75f;
    private GameCanvas canvas;
    private ScreenListener listener;
    private int width;
    private int centerY;
    private int centerX;
    private int heightY;
    private float scale;
    private float progress;
    private int pressState;
    private int budget;
    private boolean active;

    public int getBudget() {
        return this.budget;
    }

    public void setBudget(int millis) {
        this.budget = millis;
    }

    public boolean isReady() {
        return this.pressState == 2;
    }

    public AssetDirectory getAssets() {
        return this.assets;
    }

    public LoadingMode(String file, GameCanvas canvas) {
        this(file, canvas, DEFAULT_BUDGET);
    }

    public LoadingMode(String file, GameCanvas canvas, int millis) {
        this.canvas = canvas;
        this.budget = millis;
        this.resize(canvas.getWidth(), canvas.getHeight());
        this.internal = new AssetDirectory("jsons/loading.json");
        this.internal.loadAssets();
        this.internal.finishLoading();
        this.playButton = null;
        this.background = this.internal.getEntry("background", Texture.class);
        this.background.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        this.statusBar = this.internal.getEntry("progress", Texture.class);
        this.statusBkgLeft = this.internal.getEntry("progress.backleft", TextureRegion.class);
        this.statusBkgRight = this.internal.getEntry("progress.backright", TextureRegion.class);
        this.statusBkgMiddle = this.internal.getEntry("progress.background", TextureRegion.class);
        this.statusFrgLeft = this.internal.getEntry("progress.foreleft", TextureRegion.class);
        this.statusFrgRight = this.internal.getEntry("progress.foreright", TextureRegion.class);
        this.statusFrgMiddle = this.internal.getEntry("progress.foreground", TextureRegion.class);
        this.progress = 0.0f;
        this.pressState = 0;
        Gdx.input.setInputProcessor(this);
        this.assets = new AssetDirectory(file);
        this.assets.loadAssets();
        this.active = true;
    }

    @Override
    public void dispose() {
        this.internal.unloadAssets();
        this.internal.dispose();
    }

    private void update(float delta) {
        if (this.playButton == null) {
            this.assets.update(this.budget);
            this.progress = this.assets.getProgress();
            if (this.progress >= 1.0f) {
                this.progress = 1.0f;
                this.playButton = this.internal.getEntry("play", Texture.class);
            }
        }
    }

    private void draw() {
        this.canvas.begin();
        this.canvas.draw(this.background, 0.0f, 0.0f);
        if (this.playButton == null) {
            this.drawProgress(this.canvas);
        } else {
            Color tint = this.pressState == 1 ? Color.GRAY : Color.WHITE;
            this.canvas.draw(this.playButton, tint, (float)(this.playButton.getWidth() / 2), (float)(this.playButton.getHeight() / 2), (float)this.centerX, (float)this.centerY, 0.0f, BUTTON_SCALE * this.scale, BUTTON_SCALE * this.scale);
        }
        this.canvas.end();
    }

    private void drawProgress(GameCanvas canvas) {
        canvas.draw(this.statusBkgLeft, Color.WHITE, (float)(this.centerX - this.width / 2), (float)this.centerY, this.scale * (float)this.statusBkgLeft.getRegionWidth(), this.scale * (float)this.statusBkgLeft.getRegionHeight());
        canvas.draw(this.statusBkgRight, Color.WHITE, (float)(this.centerX + this.width / 2) - this.scale * (float)this.statusBkgRight.getRegionWidth(), (float)this.centerY, this.scale * (float)this.statusBkgRight.getRegionWidth(), this.scale * (float)this.statusBkgRight.getRegionHeight());
        canvas.draw(this.statusBkgMiddle, Color.WHITE, (float)(this.centerX - this.width / 2) + this.scale * (float)this.statusBkgLeft.getRegionWidth(), (float)this.centerY, (float)this.width - this.scale * (float)(this.statusBkgRight.getRegionWidth() + this.statusBkgLeft.getRegionWidth()), this.scale * (float)this.statusBkgMiddle.getRegionHeight());
        canvas.draw(this.statusFrgLeft, Color.WHITE, (float)(this.centerX - this.width / 2), (float)this.centerY, this.scale * (float)this.statusFrgLeft.getRegionWidth(), this.scale * (float)this.statusFrgLeft.getRegionHeight());
        if (this.progress > 0.0f) {
            float span = this.progress * ((float)this.width - this.scale * (float)(this.statusFrgLeft.getRegionWidth() + this.statusFrgRight.getRegionWidth())) / 2.0f;
            canvas.draw(this.statusFrgRight, Color.WHITE, (float)(this.centerX - this.width / 2) + this.scale * (float)this.statusFrgLeft.getRegionWidth() + span, (float)this.centerY, this.scale * (float)this.statusFrgRight.getRegionWidth(), this.scale * (float)this.statusFrgRight.getRegionHeight());
            canvas.draw(this.statusFrgMiddle, Color.WHITE, (float)(this.centerX - this.width / 2) + this.scale * (float)this.statusFrgLeft.getRegionWidth(), (float)this.centerY, span, this.scale * (float)this.statusFrgMiddle.getRegionHeight());
        } else {
            canvas.draw(this.statusFrgRight, Color.WHITE, (float)(this.centerX - this.width / 2) + this.scale * (float)this.statusFrgLeft.getRegionWidth(), (float)this.centerY, this.scale * (float)this.statusFrgRight.getRegionWidth(), this.scale * (float)this.statusFrgRight.getRegionHeight());
        }
    }

    @Override
    public void render(float delta) {
        if (this.active) {
            this.update(delta);
            this.draw();
            if (this.isReady() && this.listener != null) {
                this.listener.exitScreen(this, 0);
            }
        }
    }

    @Override
    public void resize(int width, int height) {
        float sx = (float)width / (float)STANDARD_WIDTH;
        float sy = (float)height / (float)STANDARD_HEIGHT;
        this.scale = sx < sy ? sx : sy;
        this.width = (int)(BAR_WIDTH_RATIO * (float)width);
        this.centerY = (int)(BAR_HEIGHT_RATIO * (float)height);
        this.centerX = width / 2;
        this.heightY = height;
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void show() {
        this.active = true;
    }

    @Override
    public void hide() {
        this.active = false;
    }

    public void setScreenListener(ScreenListener listener) {
        this.listener = listener;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (this.playButton == null || this.pressState == 2) {
            return true;
        }
        float dist = (screenX - this.centerX) * (screenX - this.centerX) + ((screenY = this.heightY - screenY) - this.centerY) * (screenY - this.centerY);
        float radius = BUTTON_SCALE * this.scale * (float)this.playButton.getWidth() / 2.0f;
        if (dist < radius * radius) {
            this.pressState = 1;
        }
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (this.pressState == 1) {
            this.pressState = 2;
            return false;
        }
        return true;
    }

    @Override
    public boolean keyDown(int keycode) {
        return true;
    }

    @Override
    public boolean keyTyped(char character) {
        return true;
    }

    @Override
    public boolean keyUp(int keycode) {
        return true;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return true;
    }

    @Override
    public boolean scrolled(float dx, float dy) {
        return true;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return true;
    }
}

