/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.design;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.design.GameCanvas;
import edu.cornell.gdiac.design.TileMapConfigModel;
import edu.cornell.gdiac.util.ScreenListener;
import java.util.ArrayList;

public class GameController
implements Screen {
    protected AssetDirectory directory;
    protected TextureRegion tileTexture;
    private JsonValue configJson;
    public static final int EXIT_QUIT = 0;
    public static final int EXIT_COUNT = 120;
    protected GameCanvas canvas;
    private ScreenListener listener;
    protected TileMapConfigModel config = new TileMapConfigModel();
    private boolean active = false;

    public boolean isActive() {
        return this.active;
    }

    public GameCanvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(GameCanvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void dispose() {
        this.config.dispose();
        this.config = null;
        this.canvas = null;
    }

    public void gatherAssets(AssetDirectory directory) {
        this.directory = directory;
        directory.finishLoading();
        try {
            FileHandle file = Gdx.files.local("tiles.png");
            Texture texture = new Texture(file);
            this.tileTexture = new TextureRegion(texture);
        }
        catch (Exception e) {
            System.out.println("Could not find file 'tiles.png'");
            this.tileTexture = new TextureRegion(directory.getEntry("template", Texture.class));
        }
        this.configJson = directory.getEntry("config", JsonValue.class);
    }

    public void update(float dt) {
    }

    public void draw(float delta) {
        this.canvas.clear();
        ArrayList<ArrayList<Integer>> mapEnc = this.config.decodeLayout();
        ArrayList<TextureRegion> tiles = this.config.tilize(this.tileTexture);
        this.config.draw(this.canvas, mapEnc, tiles);
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void render(float delta) {
        if (this.active) {
            this.update(delta);
            this.draw(delta);
        }
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void show() {
        this.active = true;
    }

    @Override
    public void hide() {
        this.active = false;
    }

    public void setScreenListener(ScreenListener listener) {
        this.listener = listener;
    }

    public void reset() {
        this.config.dispose();
        this.config.populate(this.directory, this.configJson);
    }
}

