/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.assets.AssetParser;
import edu.cornell.gdiac.assets.ParserUtils;

public class TextureParser
implements AssetParser<Texture> {
    private JsonValue root;

    @Override
    public Class<Texture> getType() {
        return Texture.class;
    }

    @Override
    public void reset(JsonValue directory) {
        this.root = directory;
        this.root = this.root.getChild("textures");
    }

    @Override
    public boolean hasNext() {
        return this.root != null;
    }

    @Override
    public void processNext(AssetManager manager, ObjectMap<String, String> keymap) {
        TextureLoader.TextureParameter params = new TextureLoader.TextureParameter();
        if (this.root.isString()) {
            params.genMipMaps = false;
            params.minFilter = Texture.TextureFilter.Linear;
            params.magFilter = Texture.TextureFilter.Linear;
            params.wrapU = Texture.TextureWrap.ClampToEdge;
            params.wrapV = Texture.TextureWrap.ClampToEdge;
            params.format = Pixmap.Format.RGBA8888;
            String file = this.root.asString();
            keymap.put(this.root.name(), file);
            manager.load(file, Texture.class, params);
        } else {
            params.genMipMaps = this.root.getBoolean("mipmaps", false);
            params.minFilter = ParserUtils.parseFilter(this.root.get("minFilter"), Texture.TextureFilter.Linear);
            params.magFilter = ParserUtils.parseFilter(this.root.get("magFilter"), Texture.TextureFilter.Linear);
            params.wrapU = ParserUtils.parseWrap(this.root.get("wrapU"), Texture.TextureWrap.ClampToEdge);
            params.wrapV = ParserUtils.parseWrap(this.root.get("wrapV"), Texture.TextureWrap.ClampToEdge);
            params.format = this.root.getBoolean("alpha", true) ? Pixmap.Format.RGBA8888 : Pixmap.Format.RGB888;
            String file = this.root.getString("file", null);
            if (file != null) {
                keymap.put(this.root.name(), file);
                manager.load(file, Texture.class, params);
            }
        }
        this.root = this.root.next();
    }

    public boolean equals(Object o) {
        return o instanceof TextureParser;
    }
}

