/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.assets.AssetParser;
import edu.cornell.gdiac.assets.FilmStripLoader;
import edu.cornell.gdiac.assets.ParserUtils;
import edu.cornell.gdiac.util.FilmStrip;

public class FilmStripParser
implements AssetParser<FilmStrip> {
    private JsonValue root;
    private JsonValue sprite;
    public static char ALIAS_SEP = (char)58;
    private static char ALIAS_MASK = (char)8704;

    @Override
    public Class<FilmStrip> getType() {
        return FilmStrip.class;
    }

    @Override
    public void reset(JsonValue directory) {
        this.root = directory;
        this.root = this.root.getChild("textures");
        this.sprite = null;
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.sprite != null;
    }

    @Override
    public void processNext(AssetManager manager, ObjectMap<String, String> keymap) {
        Object region;
        String file = this.root.getString("file", null);
        if (file == null) {
            this.advance();
            return;
        }
        FilmStripLoader.FilmStripParameters params = new FilmStripLoader.FilmStripParameters(file);
        params.rows = this.sprite.getInt("rows", 1);
        params.cols = this.sprite.getInt("cols", 1);
        params.size = this.sprite.getInt("size", params.rows * params.cols);
        if (this.sprite.hasChild("region")) {
            region = this.sprite.get("region");
            if (((JsonValue)region).size < 4) {
                throw new GdxRuntimeException("Rectangle " + region + " is not valid");
            }
            params.x = ((JsonValue)region).getInt(0);
            params.y = ((JsonValue)region).getInt(1);
            params.width = ((JsonValue)region).getInt(2);
            params.height = ((JsonValue)region).getInt(3);
            params.width = params.width == -1 ? -1 : params.width - params.x;
            params.height = params.height == -1 ? -1 : params.height - params.y;
        }
        region = ParserUtils.safeConcatenate(file, this.sprite.name(), ALIAS_SEP, ALIAS_MASK);
        keymap.put(this.root.name() + "." + this.sprite.name(), (String)region);
        manager.load((String)region, FilmStrip.class, params);
        this.advance();
    }

    public boolean equals(Object o) {
        return o instanceof FilmStripParser;
    }

    private void advance() {
        if (this.sprite != null) {
            this.sprite = this.sprite.next();
            if (this.sprite == null) {
                this.root = this.root.next();
            }
        }
        while (this.sprite == null && this.root != null) {
            if (this.root.hasChild("sprites")) {
                this.sprite = this.root.getChild("sprites");
                continue;
            }
            this.root = this.root.next();
        }
    }
}

