/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.assets.AssetParser;

public class DirectoryLoader
extends AsynchronousAssetLoader<AssetDirectory.Index, DirectoryLoaderParameters> {
    protected AssetDirectory.Index cachedData;
    protected Array<AssetParser<?>> parsers = new Array(false, 16);

    public DirectoryLoader() {
        this(new InternalFileHandleResolver());
    }

    public DirectoryLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public Array<AssetParser<?>> getParsers() {
        return this.parsers;
    }

    public void addParser(AssetParser<?> parser) {
        this.parsers.add(parser);
    }

    public void removeParser(AssetParser<?> parser) {
        this.parsers.removeValue(parser, false);
    }

    protected AssetDirectory.Index getLoadedDirectory() {
        return this.cachedData;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, DirectoryLoaderParameters params) {
        JsonReader reader = new JsonReader();
        this.cachedData = new AssetDirectory.Index();
        this.cachedData.directory = reader.parse(file);
        for (AssetParser assetParser : this.parsers) {
            ObjectMap<String, String> keys = this.cachedData.keymap.get(assetParser.getType(), null);
            if (keys == null) {
                keys = new ObjectMap<String, String>();
                this.cachedData.keymap.put(assetParser.getType(), keys);
            }
            assetParser.reset(this.cachedData.directory);
            while (assetParser.hasNext()) {
                assetParser.processNext(manager, keys);
            }
        }
    }

    @Override
    public AssetDirectory.Index loadSync(AssetManager manager, String fileName, FileHandle file, DirectoryLoaderParameters params) {
        AssetDirectory.Index directory = this.cachedData;
        this.cachedData = null;
        return directory;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, DirectoryLoaderParameters params) {
        return null;
    }

    public static class DirectoryLoaderParameters
    extends AssetLoaderParameters<AssetDirectory.Index> {
    }
}

