/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.MusicLoader;
import com.badlogic.gdx.assets.loaders.ParticleEffectLoader;
import com.badlogic.gdx.assets.loaders.PixmapLoader;
import com.badlogic.gdx.assets.loaders.SkinLoader;
import com.badlogic.gdx.assets.loaders.SoundLoader;
import com.badlogic.gdx.assets.loaders.TextureAtlasLoader;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.PolygonRegionLoader;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGeneratorLoader;
import com.badlogic.gdx.graphics.g2d.freetype.FreetypeFontLoader;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.assets.AssetParser;
import edu.cornell.gdiac.assets.DirectoryLoader;
import edu.cornell.gdiac.assets.FreetypeFontParser;
import edu.cornell.gdiac.assets.JsonValueLoader;
import edu.cornell.gdiac.assets.JsonValueParser;
import edu.cornell.gdiac.assets.TextureParser;
import edu.cornell.gdiac.assets.TextureRegionLoader;
import edu.cornell.gdiac.assets.TextureRegionParser;

public class AssetDirectory
extends AssetManager {
    protected FileHandleResolver resolver;
    protected String filename;
    protected Index contents;
    protected DirectoryLoader topLoader;
    private AssetLoaderParameters.LoadedCallback callback = new AssetLoaderParameters.LoadedCallback(){

        @Override
        public void finishedLoading(AssetManager manager, String fileName, Class type) {
            AssetDirectory.this.contents = manager.get(fileName, Index.class);
        }
    };

    public AssetDirectory(String directory) {
        this(directory, new InternalFileHandleResolver());
    }

    public AssetDirectory(String directory, FileHandleResolver resolver) {
        super(resolver, false);
        this.filename = directory;
        this.resolver = resolver;
        this.topLoader = new DirectoryLoader(resolver);
        this.setLoader(Index.class, this.topLoader);
        this.setLoader(FreeTypeFontGenerator.class, new FreeTypeFontGeneratorLoader(resolver));
        this.setLoader(BitmapFont.class, ".ttf", new FreetypeFontLoader(resolver));
        this.setLoader(Sound.class, new SoundLoader(resolver));
        this.setLoader(Music.class, new MusicLoader(resolver));
        this.setLoader(Pixmap.class, new PixmapLoader(resolver));
        this.setLoader(Texture.class, new TextureLoader(resolver));
        this.setLoader(TextureAtlas.class, new TextureAtlasLoader(resolver));
        this.setLoader(TextureRegion.class, new TextureRegionLoader(resolver));
        this.setLoader(JsonValue.class, new JsonValueLoader(resolver));
        this.setLoader(Skin.class, new SkinLoader(resolver));
        this.setLoader(ParticleEffect.class, new ParticleEffectLoader(resolver));
        this.setLoader(PolygonRegion.class, new PolygonRegionLoader(resolver));
        this.topLoader.addParser(new JsonValueParser());
        this.topLoader.addParser(new TextureParser());
        this.topLoader.addParser(new TextureRegionParser());
        this.topLoader.addParser(new FreetypeFontParser());
    }

    public String getDirectory() {
        return this.filename;
    }

    public void loadAssets() {
        DirectoryLoader.DirectoryLoaderParameters params = new DirectoryLoader.DirectoryLoaderParameters();
        params.loadedCallback = this.callback;
        this.load(this.filename, Index.class, params);
    }

    public void unloadAssets() {
        if (this.contents == null) {
            return;
        }
        for (ObjectMap objectMap : this.contents.keymap.values()) {
            for (String filename : objectMap.values()) {
                this.unload(filename);
            }
        }
        this.contents = null;
    }

    public Array<AssetParser<?>> getParsers() {
        return this.topLoader.getParsers();
    }

    public void addParser(AssetParser<?> parser) {
        this.topLoader.addParser(parser);
    }

    public void removeParser(AssetParser<?> parser) {
        this.topLoader.removeParser(parser);
    }

    public <T> T getEntry(String key, Class<T> type) {
        ObjectMap keys = this.contents.keymap.get(type, null);
        if (keys == null) {
            return null;
        }
        String filename = keys.get(key, null);
        if (filename == null) {
            return null;
        }
        return this.get(filename, type);
    }

    public <T> boolean hasEntry(String key, Class<T> type) {
        ObjectMap keys = this.contents.keymap.get(type, null);
        if (keys == null) {
            return false;
        }
        String filename = keys.get(key, null);
        if (filename == null) {
            return false;
        }
        return this.contains(filename, type);
    }

    public static class Index {
        ObjectMap<Class<?>, ObjectMap<String, String>> keymap = new ObjectMap();
        JsonValue directory;
    }
}

