/*
 * Decompiled with CFR 0.152.
 */
package com.badlogicgames.packr;

import com.badlogicgames.packr.ArchiveUtils;
import com.badlogicgames.packr.Packr;
import com.badlogicgames.packr.PackrConfig;
import com.badlogicgames.packr.PackrFileUtils;
import com.badlogicgames.packr.PackrOutput;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.compressors.CompressorException;

class PackrReduce {
    PackrReduce() {
    }

    static void minimizeJre(File output, PackrConfig config) throws IOException, CompressorException, ArchiveException {
        if (config.minimizeJre == null) {
            return;
        }
        System.out.println("Minimizing JRE ...");
        JsonObject minimizeJson = PackrReduce.readMinimizeProfile(config);
        if (minimizeJson != null) {
            if (config.verbose) {
                System.out.println("  # Removing files and directories in profile '" + config.minimizeJre + "' ...");
            }
            JsonArray reduceArray = minimizeJson.get("reduce").asArray();
            for (JsonValue reduce : reduceArray) {
                File fileNoExt;
                boolean needsUnpack;
                String path = reduce.asObject().get("archive").asString();
                File file = new File(output, path);
                if (!file.exists()) {
                    if (!config.verbose) continue;
                    System.out.println("  # No file or directory '" + file.getPath() + "' found, skipping");
                    continue;
                }
                boolean bl = needsUnpack = !file.isDirectory();
                File file2 = needsUnpack ? new File(output, path.contains(".") ? path.substring(0, path.lastIndexOf(46)) : path) : (fileNoExt = file);
                if (needsUnpack) {
                    if (config.verbose) {
                        System.out.println("  # Unpacking '" + file.getPath() + "' ...");
                    }
                    ArchiveUtils.extractArchive(file.toPath(), fileNoExt.toPath());
                }
                JsonArray removeArray = reduce.asObject().get("paths").asArray();
                for (JsonValue remove : removeArray) {
                    File removeFile = new File(fileNoExt, remove.asString());
                    if (removeFile.exists()) {
                        if (removeFile.isDirectory()) {
                            PackrFileUtils.deleteDirectory(removeFile);
                            continue;
                        }
                        Files.deleteIfExists(removeFile.toPath());
                        continue;
                    }
                    if (!config.verbose) continue;
                    System.out.println("  # No file or directory '" + removeFile.getPath() + "' found");
                }
                if (!needsUnpack) continue;
                if (config.verbose) {
                    System.out.println("  # Repacking '" + file.getPath() + "' ...");
                }
                PackrReduce.createZipFileFromDirectory(config, file, fileNoExt);
            }
            JsonArray removeArray = minimizeJson.get("remove").asArray();
            for (JsonValue remove : removeArray) {
                String platform = remove.asObject().get("platform").asString();
                if (!PackrReduce.matchPlatformString(platform, config)) continue;
                JsonArray removeFilesArray = remove.asObject().get("paths").asArray();
                for (JsonValue removeFile : removeFilesArray) {
                    PackrReduce.removeFileWildcard(output, removeFile.asString(), config);
                }
            }
        }
    }

    private static void createZipFileFromDirectory(PackrConfig config, File zipFileOutput, File directoryToZipAndThenDelete) throws IOException, ArchiveException {
        long beforeLen = zipFileOutput.length();
        Files.deleteIfExists(zipFileOutput.toPath());
        ArchiveUtils.createArchive(ArchiveUtils.ArchiveType.ZIP, directoryToZipAndThenDelete.toPath(), zipFileOutput.toPath());
        PackrFileUtils.deleteDirectory(directoryToZipAndThenDelete);
        long afterLen = zipFileOutput.length();
        if (config.verbose) {
            System.out.println("  # " + beforeLen / 1024L + " kb -> " + afterLen / 1024L + " kb");
        }
    }

    private static boolean matchPlatformString(String platform, PackrConfig config) {
        return "*".equals(platform) || config.platform.desc.contains(platform);
    }

    private static void removeFileWildcard(File output, String removeFileWildcard, PackrConfig config) throws IOException {
        if (removeFileWildcard.contains("*")) {
            String removePath = removeFileWildcard.substring(0, removeFileWildcard.indexOf(42) - 1);
            String removeSuffix = removeFileWildcard.substring(removeFileWildcard.indexOf(42) + 1);
            File[] files = new File(output, removePath).listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!removeSuffix.isEmpty() && !file.getName().endsWith(removeSuffix)) continue;
                    PackrReduce.removeFile(file, config);
                }
            } else if (config.verbose) {
                System.out.println("  # No matching files found in '" + removeFileWildcard + "'");
            }
        } else {
            PackrReduce.removeFile(new File(output, removeFileWildcard), config);
        }
    }

    private static void removeFile(File file, PackrConfig config) throws IOException {
        if (!file.exists()) {
            if (config.verbose) {
                System.out.println("  # No file or directory '" + file.getPath() + "' found");
            }
            return;
        }
        if (config.verbose) {
            System.out.println("  # Removing '" + file.getPath() + "'");
        }
        if (file.isDirectory()) {
            PackrFileUtils.deleteDirectory(file);
        } else {
            Files.deleteIfExists(file.toPath());
        }
    }

    private static JsonObject readMinimizeProfile(PackrConfig config) throws IOException {
        JsonObject json = null;
        if (new File(config.minimizeJre).exists()) {
            json = JsonObject.readFrom(new String(Files.readAllBytes(Paths.get(config.minimizeJre, new String[0])), StandardCharsets.UTF_8));
        } else {
            InputStream in = Packr.class.getResourceAsStream("/minimize/" + config.minimizeJre);
            if (in != null) {
                json = JsonObject.readFrom(new InputStreamReader(in));
            }
        }
        if (json == null && config.verbose) {
            System.out.println("  # No minimize profile '" + config.minimizeJre + "' found");
        }
        return json;
    }

    static void removePlatformLibs(PackrOutput output, PackrConfig config, Predicate<File> removePlatformLibsFileFilter) throws IOException, CompressorException, ArchiveException {
        String libExtension;
        if (config.removePlatformLibs == null || config.removePlatformLibs.isEmpty()) {
            return;
        }
        boolean extractLibs = config.platformLibsOutDir != null;
        File libsOutputDir = null;
        if (extractLibs) {
            libsOutputDir = new File(output.executableFolder, config.platformLibsOutDir.getPath());
            Files.createDirectories(libsOutputDir.toPath(), new FileAttribute[0]);
        }
        System.out.println("Removing foreign platform libs ...");
        HashSet<String> extensions = new HashSet<String>();
        switch (config.platform) {
            case Windows64: {
                extensions.add(".dylib");
                extensions.add(".dylib.git");
                extensions.add(".dylib.sha1");
                extensions.add(".so");
                extensions.add(".so.git");
                extensions.add(".so.sha1");
                libExtension = ".dll";
                break;
            }
            case Linux64: {
                extensions.add(".dll");
                extensions.add(".dll.git");
                extensions.add(".dll.sha1");
                extensions.add(".dylib");
                extensions.add(".dylib.git");
                extensions.add(".dylib.sha1");
                libExtension = ".so";
                break;
            }
            case MacOS: {
                extensions.add(".dll");
                extensions.add(".dll.git");
                extensions.add(".dll.sha1");
                extensions.add(".so");
                extensions.add(".so.git");
                extensions.add(".so.sha1");
                libExtension = ".dylib";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        for (String classpath : config.removePlatformLibs) {
            File jar = new File(output.resourcesFolder, new File(classpath).getName());
            File jarDir = new File(output.resourcesFolder, jar.getName() + ".tmp");
            if (config.verbose) {
                if (jar.isDirectory()) {
                    System.out.println("  # JAR '" + jar.getName() + "' is a directory");
                } else {
                    System.out.println("  # Unpacking '" + jar.getName() + "' ...");
                }
            }
            if (!jar.isDirectory()) {
                ArchiveUtils.extractArchive(jar.toPath(), jarDir.toPath());
            } else {
                jarDir = jar;
            }
            File[] files = jarDir.listFiles();
            if (files != null) {
                for (File file : files) {
                    boolean removed = false;
                    if (removePlatformLibsFileFilter.test(file)) {
                        if (config.verbose) {
                            System.out.println("  # Removing '" + file.getPath() + "' (filtered)");
                        }
                        Files.deleteIfExists(file.toPath());
                        removed = true;
                    }
                    if (!removed) {
                        for (String extension : extensions) {
                            if (!file.getName().endsWith(extension)) continue;
                            if (config.verbose) {
                                System.out.println("  # Removing '" + file.getPath() + "'");
                            }
                            Files.deleteIfExists(file.toPath());
                            removed = true;
                            break;
                        }
                    }
                    if (removed || !extractLibs || !file.getName().endsWith(libExtension)) continue;
                    if (config.verbose) {
                        System.out.println("  # Extracting '" + file.getPath() + "'");
                    }
                    File target = new File(libsOutputDir, file.getName());
                    Files.copy(file.toPath(), target.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
                    Files.deleteIfExists(file.toPath());
                }
            }
            if (jar.isDirectory()) continue;
            if (config.verbose) {
                System.out.println("  # Repacking '" + jar.getName() + "' ...");
            }
            PackrReduce.createZipFileFromDirectory(config, jar, jarDir);
        }
    }
}

