/*
 * Decompiled with CFR 0.152.
 */
package com.badlogicgames.packr;

import com.badlogicgames.packr.PackrCommandLine;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

public class PackrConfig {
    public Platform platform;
    public String jdk;
    public String executable;
    public List<String> classpath;
    public List<String> removePlatformLibs;
    public String mainClass;
    public List<String> vmArgs;
    public String minimizeJre;
    public File cacheJre;
    public List<File> resources;
    public File outDir;
    public File platformLibsOutDir;
    public File iconResource;
    public String bundleIdentifier;
    public boolean verbose;
    public boolean useZgcIfSupportedOs;
    public String jrePath;

    public PackrConfig() {
    }

    public PackrConfig(Platform platform, String jdk, String executable, List<String> classpath, String mainClass, File outDir) {
        this.platform = platform;
        this.jdk = jdk;
        this.executable = executable;
        this.classpath = classpath;
        this.mainClass = mainClass;
        this.outDir = outDir;
    }

    public PackrConfig(PackrCommandLine commandLine) throws IOException {
        this.verbose = commandLine.verbose();
        if (commandLine.isConfig()) {
            this.readConfigJson(commandLine.config());
        }
        if (commandLine.platform() != null) {
            this.platform = Platform.byDesc(commandLine.platform());
        }
        if (commandLine.jdk() != null) {
            this.jdk = commandLine.jdk();
        }
        if (commandLine.executable() != null) {
            this.executable = commandLine.executable();
        }
        this.classpath = this.appendTo(this.classpath, commandLine.classpath());
        this.removePlatformLibs = this.appendTo(this.removePlatformLibs, commandLine.removePlatformLibs());
        if (commandLine.mainClass() != null) {
            this.mainClass = commandLine.mainClass();
        }
        this.vmArgs = this.appendTo(this.vmArgs, commandLine.vmArgs());
        if (commandLine.minimizeJre() != null) {
            this.minimizeJre = commandLine.minimizeJre();
        }
        if (commandLine.cacheJre() != null) {
            this.cacheJre = commandLine.cacheJre();
        }
        this.resources = this.appendTo(this.resources, commandLine.resources());
        if (commandLine.outDir() != null) {
            this.outDir = commandLine.outDir();
        }
        if (commandLine.platformLibsOutDir() != null) {
            this.platformLibsOutDir = commandLine.platformLibsOutDir();
        }
        if (commandLine.iconResource() != null) {
            this.iconResource = commandLine.iconResource();
        }
        if (commandLine.bundleIdentifier() != null) {
            this.bundleIdentifier = commandLine.bundleIdentifier();
        }
        if (commandLine.useZgcIfSupportedOs()) {
            this.useZgcIfSupportedOs = true;
        }
        this.jrePath = commandLine.jrePath();
    }

    private void readConfigJson(File configJson) throws IOException {
        JsonObject json = JsonObject.readFrom(new String(Files.readAllBytes(configJson.toPath()), StandardCharsets.UTF_8));
        if (json.get("platform") != null) {
            this.platform = Platform.byDesc(json.get("platform").asString());
        }
        if (json.get("jdk") != null) {
            this.jdk = json.get("jdk").asString();
        }
        if (json.get("executable") != null) {
            this.executable = json.get("executable").asString();
        }
        if (json.get("classpath") != null) {
            this.classpath = this.toStringArray(json.get("classpath").asArray());
        }
        if (json.get("jrePath") != null) {
            this.jrePath = json.get("jrePath").asString();
        }
        if (json.get("removelibs") != null) {
            this.removePlatformLibs = this.toStringArray(json.get("removelibs").asArray());
        }
        if (json.get("mainclass") != null) {
            this.mainClass = json.get("mainclass").asString();
        }
        if (json.get("vmargs") != null) {
            List<String> vmArgs = this.toStringArray(json.get("vmargs").asArray());
            this.vmArgs = new ArrayList<String>();
            for (String vmArg : vmArgs) {
                if (vmArg.startsWith("-")) {
                    this.vmArgs.add(vmArg.substring(1));
                    continue;
                }
                this.vmArgs.add(vmArg);
            }
        }
        if (json.get("minimizejre") != null) {
            this.minimizeJre = json.get("minimizejre").asString();
        }
        if (json.get("cachejre") != null) {
            this.cacheJre = new File(json.get("cachejre").asString());
        }
        if (json.get("resources") != null) {
            this.resources = this.toFileArray(json.get("resources").asArray());
        }
        if (json.get("output") != null) {
            this.outDir = new File(json.get("output").asString());
        }
        if (json.get("libs") != null) {
            this.platformLibsOutDir = new File(json.get("libs").asString());
        }
        if (json.get("icon") != null) {
            this.iconResource = new File(json.get("icon").asString());
        }
        if (json.get("bundle") != null) {
            this.bundleIdentifier = json.get("bundle").asString();
        }
        if (json.get("useZgcIfSupportedOs") != null) {
            this.useZgcIfSupportedOs = json.get("useZgcIfSupportedOs").asBoolean();
        }
    }

    private <T> List<T> appendTo(List<T> list, List<T> append) {
        if (list == null) {
            return append != null ? append : new ArrayList();
        }
        if (append != null) {
            for (Object item : append) {
                boolean duplicate = false;
                for (T cmp : list) {
                    if (!cmp.equals(item)) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                list.add(item);
            }
        }
        return list;
    }

    private List<String> toStringArray(JsonArray array) {
        ArrayList<String> result = new ArrayList<String>();
        for (JsonValue value : array) {
            result.add(value.asString());
        }
        return result;
    }

    private List<File> toFileArray(JsonArray array) {
        ArrayList<File> result = new ArrayList<File>();
        for (JsonValue value : array) {
            result.add(new File(value.asString()));
        }
        return result;
    }

    void validate() throws IOException {
        this.validate(this.platform, "platform");
        this.validate(this.jdk, "JDK");
        this.validate(this.executable, "executable name");
        this.validate(this.mainClass, "main class");
        this.validate(this.outDir, "output folder");
        if (this.outDir.exists()) {
            if (new File(".").equals(this.outDir)) {
                throw new IOException("Output directory equals working directory, aborting");
            }
            if (new File("/").equals(this.outDir)) {
                throw new IOException("Output directory points to root folder.");
            }
        }
        if (this.classpath.isEmpty()) {
            throw new IOException("Empty class path. Please check your commandline or configuration.");
        }
    }

    private <T> void validate(T parameter, String name) throws IOException {
        if (parameter == null) {
            throw new IOException("No " + name + " specified. Please check your commandline or configuration.");
        }
    }

    public static enum Platform {
        Windows64("windows64"),
        Linux64("linux64"),
        MacOS("mac");

        final String desc;

        private Platform(String desc) {
            this.desc = desc;
        }

        static Platform byDesc(String desc) throws IOException {
            for (Platform value : Platform.values()) {
                if (!value.desc.equalsIgnoreCase(desc)) continue;
                return value;
            }
            throw new IOException("Invalid platform '" + desc + "'");
        }
    }
}

