/*
 * Decompiled with CFR 0.152.
 */
package com.badlogicgames.packr;

import com.lexicalscope.jewel.cli.Option;
import com.lexicalscope.jewel.cli.Unparsed;
import java.io.File;
import java.util.List;

public interface PackrCommandLine {
    @Option(helpRequest=true, description="display help", shortName={"h"}, longName={"help"})
    public boolean help();

    @Option(description="print additional information to console", shortName={"v"}, longName={"verbose"})
    public boolean verbose();

    @Unparsed
    public File config();

    public boolean isConfig();

    @Option(description="target operating system", longName={"platform"}, defaultToNull=true)
    public String platform();

    @Option(description="file path or URL to a JDK to be bundled", longName={"jdk"}, defaultToNull=true)
    public String jdk();

    @Option(description="name of native executable, without extension", longName={"executable"}, defaultToNull=true)
    public String executable();

    @Option(description="JAR file(s) containing code and assets to be packed", longName={"classpath"}, defaultToNull=true)
    public List<String> classpath();

    @Option(description="JAR file(s) to remove platform libs", longName={"removelibs"}, defaultToNull=true)
    public List<String> removePlatformLibs();

    @Option(description="fully qualified main class name, e.g. com.badlogic.MyApp", longName={"mainclass"}, defaultToNull=true)
    public String mainClass();

    @Option(description="arguments passed to the JVM, e.g. Xmx1G, without dashes", longName={"vmargs"}, defaultToNull=true)
    public List<String> vmArgs();

    @Option(description="minimize JRE by removing folders and files specified in config file", longName={"minimizejre"}, defaultToNull=true)
    public String minimizeJre();

    @Option(description="folder to cache bundled JRE, to speedup builds", longName={"cachejre"}, defaultToNull=true)
    public File cacheJre();

    @Option(description="additional files and folders to be packed next to the executable", longName={"resources"}, defaultToNull=true)
    public List<File> resources();

    @Option(description="output directory", longName={"output"}, defaultToNull=true)
    public File outDir();

    @Option(description="platform libs output directory", longName={"libs"}, defaultToNull=true)
    public File platformLibsOutDir();

    @Option(description="file containing icon resources (needs to fit platform, OS X only)", longName={"icon"}, defaultToNull=true)
    public File iconResource();

    @Option(description="bundle identifier, e.g. com.badlogic (used for Info.plist on OS X)", longName={"bundle"}, defaultToNull=true)
    public String bundleIdentifier();

    @Option(description="use ZGC if the operating system supports it", longName={"useZgcIfSupportedOs"})
    public boolean useZgcIfSupportedOs();

    @Option(description="path to bundled JRE (path separator must be forward slash /)", longName={"jrePath"}, defaultValue={"jre"})
    public String jrePath();
}

