/*
 * Decompiled with CFR 0.152.
 */
package com.badlogicgames.packr;

import com.badlogicgames.packr.ArchiveUtils;
import com.badlogicgames.packr.PackrCommandLine;
import com.badlogicgames.packr.PackrConfig;
import com.badlogicgames.packr.PackrFileUtils;
import com.badlogicgames.packr.PackrOutput;
import com.badlogicgames.packr.PackrReduce;
import com.lexicalscope.jewel.cli.ArgumentValidationException;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.ValidationFailure;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.utils.FileNameUtils;
import org.apache.commons.compress.utils.IOUtils;

public class Packr {
    private PackrConfig config;
    private Predicate<File> removePlatformLibsFileFilter = f -> false;

    public static void main(String[] args) {
        try {
            String[] stringArray;
            if (args.length > 0) {
                stringArray = args;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "-h";
            }
            PackrCommandLine commandLine = CliFactory.parseArguments(PackrCommandLine.class, stringArray);
            if (commandLine.help()) {
                return;
            }
            new Packr().pack(new PackrConfig(commandLine));
        }
        catch (ArgumentValidationException argumentException) {
            for (ValidationFailure failure : argumentException.getValidationFailures()) {
                System.err.println(failure.getMessage());
            }
            System.exit(-1);
        }
        catch (IOException | ArchiveException | CompressorException exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    private static byte[] readResource(String resource) throws IOException {
        try (InputStream inputStream = Packr.class.getResourceAsStream(resource);){
            if (inputStream == null) {
                throw new IllegalArgumentException("Couldn't find resource " + resource + " relative to class " + Packr.class.getName());
            }
            byte[] byArray = IOUtils.toByteArray(inputStream);
            return byArray;
        }
    }

    private static String readResourceAsString(String resource, Map<String, String> values) throws IOException {
        return Packr.replace(new String(Packr.readResource(resource), StandardCharsets.UTF_8), values);
    }

    private static String replace(String txt, Map<String, String> values) {
        for (String key : values.keySet()) {
            String value = values.get(key);
            txt = txt.replace(key, value);
        }
        return txt;
    }

    public Packr setRemovePlatformLibsFileFilter(Predicate<File> filter) {
        this.removePlatformLibsFileFilter = filter;
        return this;
    }

    public void pack(PackrConfig config) throws IOException, CompressorException, ArchiveException {
        config.validate();
        this.config = config;
        PackrOutput output = new PackrOutput(config.outDir, config.outDir);
        this.verifyEmptyOrCreateOutputFolder(output);
        output = this.buildMacBundle(output);
        this.copyExecutableAndClasspath(output);
        this.writeConfig(output);
        this.copyAndMinimizeJRE(output, config);
        this.copyResources(output);
        PackrReduce.removePlatformLibs(output, config, this.removePlatformLibsFileFilter);
        System.out.println("Done!");
    }

    void verifyEmptyOrCreateOutputFolder(PackrOutput output) throws IOException {
        Path outputPath = output.executableFolder.toPath();
        if (Files.exists(outputPath, new LinkOption[0])) {
            if (!Files.isDirectory(outputPath, new LinkOption[0])) {
                System.err.println("Output directory \"" + outputPath + "\" must be a directory.");
                throw new IOException("Output directory \"" + outputPath + "\" is not a directory.");
            }
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(outputPath);){
                if (dirStream.iterator().hasNext()) {
                    System.err.println("Output directory \"" + outputPath + "\" must be empty.");
                    throw new IOException("Output directory \"" + outputPath + "\" is not empty.");
                }
            }
        }
        Files.createDirectories(outputPath, new FileAttribute[0]);
    }

    private PackrOutput buildMacBundle(PackrOutput output) throws IOException {
        if (this.config.platform != PackrConfig.Platform.MacOS) {
            return output;
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("${executable}", this.config.executable);
        if (this.config.bundleIdentifier != null) {
            values.put("${bundleIdentifier}", this.config.bundleIdentifier);
        } else {
            int lastDotIndex = this.config.mainClass.lastIndexOf(46);
            int classIndex = lastDotIndex >= 0 ? lastDotIndex : this.config.mainClass.length();
            values.put("${bundleIdentifier}", this.config.mainClass.substring(0, classIndex));
        }
        File root = output.executableFolder;
        Files.createDirectories(root.toPath().resolve("Contents"), new FileAttribute[0]);
        try (FileWriter info = new FileWriter(new File(root, "Contents/Info.plist"));){
            String plist = Packr.readResourceAsString("/Info.plist", values);
            info.write(plist);
        }
        File target = new File(root, "Contents/MacOS");
        Files.createDirectories(target.toPath(), new FileAttribute[0]);
        File resources = new File(root, "Contents/Resources");
        Files.createDirectories(resources.toPath(), new FileAttribute[0]);
        if (this.config.iconResource != null && this.config.iconResource.exists()) {
            Files.copy(this.config.iconResource.toPath(), resources.toPath().resolve("icons.icns"), StandardCopyOption.COPY_ATTRIBUTES);
        }
        return new PackrOutput(target, resources);
    }

    private void copyExecutableAndClasspath(PackrOutput output) throws IOException {
        byte[] exe = null;
        String extension = "";
        switch (this.config.platform) {
            case Windows64: {
                exe = Packr.readResource("/packr-windows-x64.exe");
                extension = ".exe";
                break;
            }
            case Linux64: {
                exe = Packr.readResource("/packr-linux-x64");
                break;
            }
            case MacOS: {
                exe = Packr.readResource("/packr-mac");
            }
        }
        System.out.println("Copying executable ...");
        Files.write(output.executableFolder.toPath().resolve(this.config.executable + extension), exe, new OpenOption[0]);
        PackrFileUtils.chmodX(new File(output.executableFolder, this.config.executable + extension));
        System.out.println("Copying classpath(s) ...");
        for (String file : this.config.classpath) {
            File cpSrc = new File(file);
            File cpDst = new File(output.resourcesFolder, new File(file).getName());
            if (cpSrc.isFile()) {
                Files.copy(cpSrc.toPath(), cpDst.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
                continue;
            }
            if (cpSrc.isDirectory()) {
                PackrFileUtils.copyDirectory(cpSrc, cpDst);
                continue;
            }
            System.err.println("Warning! Classpath not found: " + cpSrc);
        }
    }

    private void writeConfig(PackrOutput output) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        builder.append("  \"jrePath\": \"").append(this.config.jrePath).append("\",\n");
        builder.append("  \"classPath\": [");
        String delimiter = "\n";
        for (String f : this.config.classpath) {
            builder.append(delimiter).append("    \"").append(new File(f).getName()).append("\"");
            delimiter = ",\n";
        }
        builder.append("\n  ],\n");
        builder.append("  \"mainClass\": \"").append(this.config.mainClass).append("\",\n");
        builder.append("  \"useZgcIfSupportedOs\": ").append(this.config.useZgcIfSupportedOs).append(",\n");
        builder.append("  \"vmArgs\": [\n");
        for (int i = 0; i < this.config.vmArgs.size(); ++i) {
            String vmArg = this.config.vmArgs.get(i);
            builder.append("    \"");
            if (!vmArg.startsWith("-")) {
                builder.append("-");
            }
            builder.append(vmArg).append("\"");
            if (i < this.config.vmArgs.size() - 1) {
                builder.append(",");
            }
            builder.append("\n");
        }
        builder.append("  ]\n");
        builder.append("}");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(output.resourcesFolder, this.config.executable + ".json")), StandardCharsets.UTF_8);){
            writer.write(builder.toString());
        }
    }

    private void copyAndMinimizeJRE(PackrOutput output, PackrConfig config) throws IOException, CompressorException, ArchiveException {
        File jreStoragePath;
        boolean extractToCache = config.cacheJre != null;
        boolean skipExtractToCache = false;
        if (extractToCache && config.cacheJre.exists()) {
            if (config.cacheJre.isDirectory()) {
                String[] files = config.cacheJre.list();
                skipExtractToCache = files != null && files.length > 0;
            } else {
                throw new IOException(config.cacheJre + " must be a directory");
            }
        }
        File file = jreStoragePath = extractToCache ? config.cacheJre : output.resourcesFolder;
        if (skipExtractToCache) {
            System.out.println("Using cached JRE in '" + config.cacheJre + "' ...");
        } else {
            File jdkFile;
            boolean fetchFromRemote = config.jdk.startsWith("http://") || config.jdk.startsWith("https://");
            File file2 = jdkFile = fetchFromRemote ? new File(jreStoragePath, "jdk.zip") : new File(config.jdk);
            if (fetchFromRemote) {
                System.out.println("Downloading JDK from '" + config.jdk + "' ...");
                try (InputStream remote = new URL(config.jdk).openStream();
                     FileOutputStream outJdk = new FileOutputStream(jdkFile);){
                    IOUtils.copy(remote, outJdk);
                }
            }
            System.out.println("Unpacking JRE ...");
            File tmp = new File(jreStoragePath, "tmp");
            if (tmp.exists()) {
                PackrFileUtils.deleteDirectory(tmp);
            }
            Files.createDirectories(tmp.toPath(), new FileAttribute[0]);
            if (jdkFile.isDirectory()) {
                PackrFileUtils.copyDirectory(jdkFile, tmp);
            } else {
                ArchiveUtils.extractArchive(jdkFile.toPath(), tmp.toPath());
            }
            File jre = this.findJvmDynamicLibraryBaseDirectory(tmp.toPath());
            if (jre == null) {
                throw new IOException("Couldn't find JRE in JDK, see '" + tmp.getAbsolutePath() + "'");
            }
            PackrFileUtils.copyDirectory(jre, new File(jreStoragePath, config.jrePath));
            PackrFileUtils.deleteDirectory(tmp);
            if (fetchFromRemote) {
                Files.deleteIfExists(jdkFile.toPath());
            }
            PackrReduce.minimizeJre(jreStoragePath, config);
        }
        if (extractToCache) {
            PackrFileUtils.copyDirectory(jreStoragePath, output.resourcesFolder);
        }
        Files.walkFileTree(output.resourcesFolder.toPath().resolve(config.jrePath), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                boolean isExecutableFile;
                String parentFilename = file.getParent().getFileName().toString();
                String filename = file.getFileName().toString();
                String filenameExtension = FileNameUtils.getExtension(filename);
                boolean isInBinOrLibDirectory = parentFilename.equalsIgnoreCase("bin") || parentFilename.equalsIgnoreCase("lib");
                boolean bl = isExecutableFile = filenameExtension.trim().length() == 0 || filenameExtension.equalsIgnoreCase("exe");
                if (isInBinOrLibDirectory && isExecutableFile) {
                    PackrFileUtils.chmodX(file.toFile());
                }
                return super.visitFile(file, attrs);
            }
        });
    }

    private File findJvmDynamicLibraryBaseDirectory(final Path directoryToSearch) throws IOException {
        final Path[] jvmBaseDirectory = new Path[]{null};
        Files.walkFileTree(directoryToSearch, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String filename = file.getFileName().toString();
                if (filename.equalsIgnoreCase("jvm.dll") || filename.startsWith("libjvm")) {
                    this.getParentLibOrBinDirectoryParent(file);
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }

            private void getParentLibOrBinDirectoryParent(Path jvmSharedLibrary) throws IOException {
                for (Path parentDirectory = jvmSharedLibrary.getParent(); parentDirectory != null && !Files.isSameFile(directoryToSearch, parentDirectory); parentDirectory = parentDirectory.getParent()) {
                    String parentDirectoryName = parentDirectory.getFileName().toString();
                    if (!parentDirectoryName.equalsIgnoreCase("lib") && !parentDirectoryName.equalsIgnoreCase("bin")) continue;
                    jvmBaseDirectory[0] = parentDirectory.getParent();
                    break;
                }
            }
        });
        return jvmBaseDirectory[0] == null ? null : jvmBaseDirectory[0].toFile();
    }

    private void copyResources(PackrOutput output) throws IOException {
        if (this.config.resources != null) {
            System.out.println("Copying resources ...");
            for (File file : this.config.resources) {
                if (!file.exists()) {
                    throw new IOException("Resource '" + file.getAbsolutePath() + "' doesn't exist");
                }
                if (file.isFile()) {
                    Files.copy(file.toPath(), output.resourcesFolder.toPath().resolve(file.getName()), StandardCopyOption.COPY_ATTRIBUTES);
                }
                if (!file.isDirectory()) continue;
                File target = new File(output.resourcesFolder, file.getName());
                Files.createDirectories(target.toPath(), new FileAttribute[0]);
                PackrFileUtils.copyDirectory(file, target);
            }
        }
    }
}

