/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.backend.audio;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import edu.cornell.gdiac.audio.AudioSource;
import edu.cornell.gdiac.audio.AudioStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.MP3Decoder;
import javazoom.jl.decoder.OutputBuffer;

public class Mp3Source
implements AudioSource {
    protected FileHandle source;
    protected int channels;
    protected int sampleRate;
    protected float duration;
    protected long byteSize;

    public Mp3Source(FileHandle file) {
        this.source = file;
        this.init();
    }

    private void init() {
        Bitstream bitstream = new Bitstream(this.source.read());
        MP3Decoder decoder = new MP3Decoder();
        try {
            Header header;
            OutputBuffer outputBuffer = null;
            this.sampleRate = -1;
            this.channels = -1;
            while ((header = bitstream.readFrame()) != null) {
                if (outputBuffer == null) {
                    this.channels = header.mode() == 3 ? 1 : 2;
                    outputBuffer = new OutputBuffer(this.channels, false);
                    decoder.setOutputBuffer(outputBuffer);
                    this.sampleRate = header.getSampleRate();
                }
                try {
                    decoder.decodeFrame(header, bitstream);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bitstream.closeFrame();
                this.byteSize += (long)outputBuffer.reset();
            }
            bitstream.closeFrame();
            long samples = this.byteSize / (long)(2 * this.channels);
            this.duration = (float)samples / (float)this.sampleRate;
        }
        catch (Throwable ex) {
            throw new GdxRuntimeException("Error reading audio data.", ex);
        }
    }

    public void dispose() {
        this.source = null;
        this.channels = 0;
        this.sampleRate = 0;
        this.duration = 0.0f;
        this.byteSize = 0L;
    }

    public FileHandle getFile() {
        return this.source;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public float getDuration() {
        return this.duration;
    }

    public AudioStream getStream() {
        return new Stream();
    }

    public ByteBuffer getData() {
        ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
        Bitstream bitstream = new Bitstream(this.source.read());
        MP3Decoder decoder = new MP3Decoder();
        ByteBuffer result = null;
        try {
            Header header;
            OutputBuffer outputBuffer = null;
            int channels = -1;
            while ((header = bitstream.readFrame()) != null) {
                if (outputBuffer == null) {
                    channels = header.mode() == 3 ? 1 : 2;
                    outputBuffer = new OutputBuffer(channels, false);
                    decoder.setOutputBuffer(outputBuffer);
                }
                try {
                    decoder.decodeFrame(header, bitstream);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bitstream.closeFrame();
                output.write(outputBuffer.getBuffer(), 0, outputBuffer.reset());
            }
            bitstream.close();
            result = ByteBuffer.allocateDirect((int)this.byteSize);
            result.order(ByteOrder.nativeOrder());
            result.put(output.toByteArray(), 0, (int)this.byteSize);
            result.flip();
        }
        catch (Throwable ex) {
            throw new GdxRuntimeException("Error reading audio data.", ex);
        }
        return result;
    }

    public String toString() {
        return "'" + this.getFile().toString() + " [" + String.format("@%x", this.hashCode()) + "]'";
    }

    public class Stream
    implements AudioStream {
        private Bitstream bitstream;
        private MP3Decoder decoder;
        private OutputBuffer outputBuffer;
        private long byteOffs;
        private byte[] tempBytes;

        public Stream() {
            this.bitstream = new Bitstream(Mp3Source.this.source.read());
            this.decoder = new MP3Decoder();
            try {
                Header header = this.bitstream.readFrame();
                if (header == null) {
                    throw new GdxRuntimeException("Empty MP3");
                }
                int channels = header.mode() == 3 ? 1 : 2;
                this.outputBuffer = new OutputBuffer(channels, false);
                this.decoder.setOutputBuffer(this.outputBuffer);
                this.byteOffs = 0L;
            }
            catch (BitstreamException e) {
                throw new GdxRuntimeException("error while preloading mp3", (Throwable)e);
            }
        }

        public AudioSource getSource() {
            return Mp3Source.this;
        }

        public long getByteSize() {
            return Mp3Source.this.byteSize;
        }

        public long getByteOffset() {
            return this.byteOffs;
        }

        public long getSampleSize() {
            return Mp3Source.this.byteSize / 2L;
        }

        public long getSampleOffset() {
            return this.byteOffs / 2L;
        }

        public int read(byte[] buffer) {
            try {
                Header header;
                boolean setup;
                boolean bl = setup = this.bitstream == null;
                if (setup) {
                    this.bitstream = new Bitstream(Mp3Source.this.source.read());
                    this.decoder = new MP3Decoder();
                }
                int totalLength = 0;
                int minRequiredLength = buffer.length - 4608;
                while (totalLength <= minRequiredLength && (header = this.bitstream.readFrame()) != null) {
                    if (setup) {
                        int channels = header.mode() == 3 ? 1 : 2;
                        this.outputBuffer = new OutputBuffer(channels, false);
                        this.decoder.setOutputBuffer(this.outputBuffer);
                        setup = false;
                    }
                    try {
                        this.decoder.decodeFrame(header, this.bitstream);
                    }
                    catch (Exception channels) {
                        // empty catch block
                    }
                    this.bitstream.closeFrame();
                    int length = this.outputBuffer.reset();
                    System.arraycopy(this.outputBuffer.getBuffer(), 0, buffer, totalLength, length);
                    totalLength += length;
                    this.byteOffs += (long)length;
                }
                return totalLength;
            }
            catch (Throwable ex) {
                this.reset();
                throw new GdxRuntimeException("Error reading audio data.", ex);
            }
        }

        public int read(short[] buffer) {
            if (this.tempBytes == null || this.tempBytes.length < 2 * buffer.length) {
                this.tempBytes = new byte[2 * buffer.length];
            }
            int length = this.read(this.tempBytes);
            for (int ii = 0; ii < length / 2; ++ii) {
                int lower = this.tempBytes[2 * ii] & 0xFF;
                int upper = this.tempBytes[2 * ii + 1] & 0xFF;
                buffer[ii] = (short)(upper << 8 | lower);
            }
            return length / 2;
        }

        public int read(float[] buffer) {
            if (this.tempBytes == null || this.tempBytes.length < 2 * buffer.length) {
                this.tempBytes = new byte[2 * buffer.length];
            }
            int length = this.read(this.tempBytes);
            for (int ii = 0; ii < length / 2; ++ii) {
                int lower = this.tempBytes[2 * ii] & 0xFF;
                int upper = this.tempBytes[2 * ii + 1] & 0xFF;
                short value = (short)(upper << 8 | lower);
                buffer[ii] = (float)value / 32767.0f;
            }
            return length / 2;
        }

        public int seek(long pos, byte[] buffer) {
            if (pos <= 0L || buffer.length <= 1) {
                throw new IllegalArgumentException("Illegal seek parameters");
            }
            byte[] temp = new byte[buffer.length / 2];
            if (pos < this.byteOffs) {
                this.reset();
            }
            try {
                Header header;
                boolean setup;
                boolean bl = setup = this.bitstream == null;
                if (setup) {
                    this.bitstream = new Bitstream(Mp3Source.this.source.read());
                    this.decoder = new MP3Decoder();
                }
                int chunk = 1;
                while (chunk > 0 && this.byteOffs < pos && (header = this.bitstream.readFrame()) != null) {
                    if (setup) {
                        int channels = header.mode() == 3 ? 1 : 2;
                        this.outputBuffer = new OutputBuffer(channels, false);
                        this.decoder.setOutputBuffer(this.outputBuffer);
                        setup = false;
                    }
                    try {
                        this.decoder.decodeFrame(header, this.bitstream);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.bitstream.closeFrame();
                    chunk = this.outputBuffer.reset();
                    this.byteOffs += (long)chunk;
                }
                if (this.byteOffs < pos) {
                    this.reset();
                    return 0;
                }
                System.arraycopy(this.outputBuffer.getBuffer(), 0, temp, 0, chunk);
                int mark = (int)(this.byteOffs - pos);
                System.arraycopy(temp, mark, buffer, 0, chunk - mark);
                mark = chunk - mark;
                chunk = this.read(temp);
                System.arraycopy(temp, 0, buffer, mark, chunk);
                return chunk + mark;
            }
            catch (Throwable ex) {
                this.reset();
                throw new GdxRuntimeException("Error reading audio data.", ex);
            }
        }

        public int seek(long pos, short[] buffer) {
            if (this.tempBytes == null || this.tempBytes.length < 2 * buffer.length) {
                this.tempBytes = new byte[2 * buffer.length];
            }
            int length = this.seek(pos, this.tempBytes);
            for (int ii = 0; ii < length / 2; ++ii) {
                int lower = this.tempBytes[2 * ii] & 0xFF;
                int upper = this.tempBytes[2 * ii + 1] & 0xFF;
                buffer[ii] = (short)(upper << 8 | lower);
            }
            return length / 2;
        }

        public int seek(long pos, float[] buffer) {
            if (this.tempBytes == null || this.tempBytes.length < 2 * buffer.length) {
                this.tempBytes = new byte[2 * buffer.length];
            }
            int length = this.seek(pos, this.tempBytes);
            for (int ii = 0; ii < length / 2; ++ii) {
                int lower = this.tempBytes[2 * ii] & 0xFF;
                int upper = this.tempBytes[2 * ii + 1] & 0xFF;
                short value = (short)(upper << 8 | lower);
                buffer[ii] = (float)value / 32767.0f;
            }
            return length / 2;
        }

        public void reset() {
            if (this.bitstream == null) {
                return;
            }
            try {
                this.bitstream.close();
            }
            catch (BitstreamException bitstreamException) {
                // empty catch block
            }
            this.bitstream = null;
            this.byteOffs = 0L;
        }

        public void loop() {
            this.reset();
        }
    }
}

